/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model.PLS;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import javax.swing.JPopupMenu;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.cleanup.CleanUpInterface;
import se.prediktera.map.common.cleanup.CleanUpVector;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.jama.MatrixExtensions;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.data.modeltable.AbstractTModel;
import se.prediktera.map.datasetcontainer.AbstractDataNode;
import se.prediktera.map.datasetcontainer.BasicTreeInterface;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeClass;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeMemoryClass;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.AbstractMVmatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.datasetcontainer.matrix.MatrixContainer;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;
import se.prediktera.map.main.Evince;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.StatusBar;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.AbstractPrediction;
import se.prediktera.map.register.RegisterKeyManager;
import se.prediktera.mda.model.AbstractCVResults;
import se.prediktera.mda.model.AbstractMDAModel;
import se.prediktera.mda.model.AbstractMDAResults;
import se.prediktera.mda.model.AnalysTableModel;
import se.prediktera.mda.model.CrossvalidationModel;
import se.prediktera.mda.model.ModelException;
import se.prediktera.mda.model.PLS.PLSpredictionNode;
import se.prediktera.mda.model.PLS.bias.BiasDialog;

public class PLSModel
extends CrossvalidationModel {
    public static final int T = 0;
    public static final int P = 1;
    public static final int C = 2;
    public static final int W = 3;
    public static final int U = 4;
    public static final int DMODX = 5;
    public static final int DMODY = 6;
    public static final int SSX_VAR = 7;
    public static final int SSX_VAR_CUM = 8;
    public static final int SSY_VAR = 9;
    public static final int SSY_VAR_CUM = 10;
    public static final int Q2Y_VAR = 11;
    public static final int Q2Y_VAR_CUM = 12;
    public static final int Q2Y = 13;
    public static final int Q2Y_CUM = 14;
    public static final int SSX = 15;
    public static final int SSX_CUM = 16;
    public static final int SSY = 17;
    public static final int SSY_CUM = 18;
    public static final int NIT = 19;
    public static final int S0X = 20;
    public static final int S0Y = 21;
    public static final int RMSECV_VAR = 22;
    public static final int RDPCV_VAR = 23;
    public static final int HOTELLINGT2 = 24;
    public static final int VIP = 25;
    public static final int RMSE_VAR = 26;
    public static final int TPRED = 0;
    public static final int DMODXPRED = 1;
    public static final int DMODYPRED = 2;
    public static final int RMSEP_VAR = 3;
    public static final int SEP_VAR = 4;
    public static final int BIAS_VAR = 5;
    public static final int HOTELLINGT2PRED = 6;
    public static final int RPDP_VAR = 7;
    public static final int SSXP_VAR_CUM = 8;
    public static final int SSYP_VAR_CUM = 9;
    private static final String[] resultNames = new String[]{"T", "P", "C", "W", "U", "ObsDMX", "ObsDMY", "R2X_var", "R2X_var_cum", "R2Y_var", "R2Y_var_cum", "Q2Y_var", "Q2Y_var_cum", "Q2Y", "Q2Y_cum", "R2X", "R2X_cum", "R2Y", "R2Y_cum", "Nit", "S0X", "S0Y", "RMSECV_var", "RDPCV_var", "Hotelling T2", "VIP", "RMSE_var"};
    private static final String[] htmlResultNames = new String[]{"<html><b>T</b></html>", "<html><b>P</b></html>", "<html><b>C</b></html>", "<html><b>W</b></html>", "<html><b>U</b></html>", "<html>ObsDM<b>X</b></html>", "<html>ObsDM<b>Y</b></html>", "<html>SS<b>X</b>_var</html>", "<html>SS<b>X</b>_var_cum</html>", "<html>SS<b>Y</b>_var</html>", "<html>SS<b>Y</b>_var_cum</html>", "<html>SS<b>Y</b>_CV_var</html>", "<html>SS<b>Y</b>_CV_var_cum</html>", "<html>SS<b>Y</b>_CV</html>", "<html>SS<b>Y</b>_CV_cum</html>", "<html>SS<b>X</b></html>", "<html>SS<b>X</b>_cum</html>", "<html>SS<b>Y</b></html>", "<html>SS<b>Y</b>_cum</html>", "Nit", "<html>S<sup>0</sup>X</html>", "<html>S<sup>0</sup>Y</html>", "<html>RMSECV_var</html>", "<html>RPDCV_var</html>", "<html>Hotelling T2</html>", "Variable importance, VIP", "RMSE_var"};
    private static final String[] post102LoadNames = new String[]{"T", "P", "C", "W", "U", "ObsDMX", "ObsDMY", "SSX_var", "SSX_var_cum", "SSY_var", "SSY_var_cum", "SSY_CV_var", "SSY_CV_var_cum", "SSY_CV", "SSY_CV_cum", "SSX", "SSX_cum", "SSY", "SSY_cum", "Nit", "S0X", "S0Y", "RMSECV_var", "RPDCV_var", "Hotelling T2", "VIP", "RMSE_var"};
    private static final String[] pre102LoadNames = new String[]{"T", "P", "C", "W", "U", "DModX", "DModY", "ssx_var", "ssx_var_cum", "ssy_var", "ssy_var_cum", "Q2y_var", "Q2y_var_cum", "Q2y", "Q2y_cum", "ssx", "ssx_cum", "ssy", "ssy_cum", "Nit", "s0x", "s0y", "RMSECV_var", "RDPCV_var"};
    private static final String[] resultInfo = new String[]{"Scores in <b>X</b>", "Loadings in <b>X</b>", "Loadings in <b>Y</b>", "Weights in <b>X</b>", "Scores in <b>Y</b>", "Observation Distance to Model in <b>X</b>", "Observation Distance to Model in <b>Y</b>", "Explained variance by model for <b>X</b> variables", "Cumulative explained variance by model for <b>X</b> variables", "Explained variance by model for <b>Y</b> variables", "Cumulative explained variance by model for <b>Y</b> variables", "Explained cross-validated variance by model for variables in <b>Y</b>", "Cumulative explained cross-validated variance by model for variables in <b>Y</b>", "Explained cross-validated variance by model for <b>Y</b>", "Cumulative explained cross-validated variance by model for <b>Y</b>", "Explained variance by model for <b>X</b>", "Cumulative explained variance by model for <b>X</b>", "Explained variance by model for <b>Y</b>", "Cumulative explained variance by model for <b>Y</b>", "Number of iterations", "S<sub>0</sub> constant for Distance to Model in <b>X</b>", "S<sub>0</sub> constant for Distance to Model in <b>Y</b>", "Root Mean Square Error Cross Validation for variables", "Ratio of standard deviation and Root Mean Square Error Cross Validation of prediction", "Hotelling T2", "Variable importance, VIP", "Root Mean Square Error"};
    private static String[] loadResultNames = post102LoadNames;
    private double ssx_orig;
    private double ssy_orig;
    private MVmatrix ssx_var_orig;
    private MVmatrix ssy_var_orig;
    private ModelMatrix w1;
    private double[] scalefactor;
    private double[] offset;
    private boolean concentration = false;
    private AbstractMVmatrix keepX;
    private AbstractMVmatrix keepY;
    private boolean usekeep = false;
    public boolean calcB = false;

    public static String[] getComponentNames() {
        return new String[]{"Model", "DataSet", "A", "R2X", "R2X_cum", "R2Y", "R2Y_cum", "Q2Y", "Q2Y_cum", "N", "K", "Pre-processing"};
    }

    public PLSModel(DataSet dataSet, MVmatrix mVmatrix, MVmatrix mVmatrix2) {
        super(dataSet, null, null, false);
        this.X = mVmatrix;
        this.Y = mVmatrix2;
        this.resetModelLocal(null);
        this.res = new PLSresults(dataSet.getCase(), this, (AbstractDataMatrix)mVmatrix, (AbstractDataMatrix)mVmatrix2);
        this.mr = this.res.getMR();
        this.transformedContainer.addTreeNode(this.createTransformed((byte)0));
        this.transformedContainer.addTreeNode(this.createTransformed((byte)1));
        this.transformedContainer.addTreeNode(this.createTransformed((byte)2));
        this.transformedContainer.addTreeNode(this.createTransformed((byte)3));
    }

    public PLSModel(ProgressManager progressManager, DataSet dataSet, int[] nArray, int[] nArray2, boolean bl) {
        super(dataSet, nArray, nArray2, bl);
        if (!this.resetModel(progressManager, true)) {
            throw new ModelException.ModelNoDataException("X and Y matrix dimensions cannot be zero");
        }
        this.addTreeNode(this.X);
        this.addTreeNode(this.Y);
        this.res = new PLSresults(dataSet.getCase(), this, (AbstractDataMatrix)this.X, (AbstractDataMatrix)this.Y);
        this.mr = this.res.getMR();
        this.ssx_var_orig.setName("R2X_var_Orig");
        this.ssx_var_orig.setHtmlName("<html>R2<b>X</b>_var_Orig<html>");
        this.ssx_var_orig.setMatrixInfo("Original variance of <b>X</b> variables");
        this.ssy_var_orig.setName("R2Y_var_Orig");
        this.ssy_var_orig.setHtmlName("<html>R2<b>Y</b>_var_Orig<html>");
        this.ssy_var_orig.setMatrixInfo("Original variance of <b>Y</b> variables");
        this.w1.setName("w1");
        this.addTreeNode(this.w1);
        this.w1.setVisibleInTree(false);
        if (bl) {
            this.addTreeNode(this.createPredictionLocal(progressManager, dataSet, null));
        }
        this.transformedContainer.addTreeNode(this.createTransformed((byte)0));
        this.transformedContainer.addTreeNode(this.createTransformed((byte)1));
        this.transformedContainer.addTreeNode(this.createTransformed((byte)2));
        this.transformedContainer.addTreeNode(this.createTransformed((byte)3));
    }

    public PLSModel(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        if (randomInputStream.getSaveVersion() < 102L) {
            loadResultNames = pre102LoadNames;
        }
        this.X = (AbstractMVmatrix)mapProperty.resolveNodeFromName(randomInputStream, "X");
        this.Y = (AbstractMVmatrix)mapProperty.resolveNodeFromName(randomInputStream, "Y");
        this.ssx_var_orig = (MVmatrix)mapProperty.resolveNodeFromName(randomInputStream, "ssx_var_orig");
        this.ssy_var_orig = (MVmatrix)mapProperty.resolveNodeFromName(randomInputStream, "ssy_var_orig");
        this.w1 = (ModelMatrix)mapProperty.resolveNodeFromName(randomInputStream, "w1_1");
        this.ssx_orig = mapProperty.getPropertyDouble("ssx_orig");
        this.ssy_orig = mapProperty.getPropertyDouble("ssy_orig");
        this.scalefactor = mapProperty.getPropertyDoubleArray("scalefactor", null);
        this.offset = mapProperty.getPropertyDoubleArray("offset", null);
        this.concentration = mapProperty.getPropertyBoolean("concentration");
        this.res = new PLSresults(randomInputStream, mapProperty, (AbstractDataMatrix)this.X, (AbstractDataMatrix)this.Y);
        this.mr = this.res.getMR();
    }

    @Override
    protected void setCVrules() {
        this.cvRules = new ArrayList();
        AbstractMDAModel.CVrule cVrule = new AbstractMDAModel.CVrule("R1");
        cVrule.addProperty("q2y", 0.05);
        this.cvRules.add(cVrule);
        AbstractMDAModel.CVrule cVrule2 = new AbstractMDAModel.CVrule("N4");
        cVrule2.addProperty("r2", 0.01);
        this.cvRules.add(cVrule2);
    }

    @Override
    public void addToPopupMenu(Project_GUI project_GUI, JPopupMenu jPopupMenu) {
        super.addToPopupMenu(project_GUI, jPopupMenu);
        this.addModelSpecificPopupMenu(project_GUI, jPopupMenu);
    }

    @Override
    public boolean calcModel(ProgressManager progressManager, int n) {
        return this.calcModel(progressManager, "", n);
    }

    public boolean calcModel(ProgressManager progressManager, String string, int n) {
        try {
            boolean bl = false;
            if (n < 0) {
                bl = true;
                n = this.indxVector == null ? 3 : 50;
            }
            n = Math.min(n, this.getMaxComponentCount());
            int n2 = this.getResults().getRound();
            DenseMatrix denseMatrix = null;
            boolean bl2 = this.res.getRound() == 0;
            progressManager.setAbortable(true);
            for (int i = 0; i < n && !progressManager.isAborted(); ++i) {
                AbstractDataMatrix abstractDataMatrix;
                Object object2;
                CleanUpInterface cleanUpInterface;
                int n3 = this.res.getRound() + 1;
                if (progressManager != null) {
                    if (bl) {
                        progressManager.setInfoText("Calculating component " + n3 + " with auto fit");
                    } else if (n3 > n) {
                        progressManager.setInfoText("Calculating component " + n3);
                    } else {
                        progressManager.setInfoText("Calculating component " + n3 + "/" + (n + n2));
                    }
                }
                this.calculateOneComponent(progressManager, this.X, this.Y, this.res);
                MatrixContainer matrixContainer = ((PLSresults)this.res).B_scaled;
                double d = this.mr[1].getLastRM().dot((Vector)this.mr[3].getLastRM());
                if (Double.compare(d, 0.0) == 0) {
                    d = Double.NaN;
                }
                DenseMatrix denseMatrix2 = MatrixExtensions.timesTransposeOf(this.mr[3].getLastRM(), this.mr[2].getLastRM());
                denseMatrix2.scale(1.0 / d);
                DenseMatrix denseMatrix3 = matrixContainer.getLastMatrix();
                if (denseMatrix3 != null) {
                    denseMatrix2.add((Matrix)denseMatrix3);
                }
                matrixContainer.addMatrix(denseMatrix2);
                boolean bl3 = false;
                if (this.indxVector != null) {
                    cleanUpInterface = (PLSresults)this.res;
                    this.crossValidate(progressManager, (PLSresults)cleanUpInterface, this.X, this.Y, this.indxVector);
                    if (bl && i > 1) {
                        for (Object object2 : this.cvRules) {
                            if (((AbstractMDAModel.CVrule)object2).test((PLSresults)cleanUpInterface)) continue;
                            bl3 = true;
                            break;
                        }
                    }
                }
                if (bl3 || progressManager.isAborted()) {
                    this.res.undoRow();
                    break;
                }
                cleanUpInterface = ((PLSresults)this.res).Ycalc;
                DenseMatrix denseMatrix4 = MatrixExtensions.timesTransposeOf(this.mr[0].getLastRM(), this.mr[2].getLastRM());
                MatrixExtensions.minusEqualsTimesTransposeOf(this.X, this.mr[0].getLastRM(), this.mr[1].getLastRM());
                this.Y.minusEqualsMV((Matrix)denseMatrix4);
                if (bl2) {
                    if (denseMatrix != null) {
                        denseMatrix4.add(1.0, (Matrix)denseMatrix);
                    }
                    denseMatrix = denseMatrix4.copy();
                } else {
                    for (int j = this.res.getRound() - 1; j >= 0; --j) {
                        denseMatrix = MatrixExtensions.timesTransposeOf(this.mr[0].getRM(j), this.mr[2].getRM(j));
                        denseMatrix4.add(1.0, (Matrix)denseMatrix);
                    }
                }
                this.reverseTransformationsY(denseMatrix4, this.Y.getKref(), ((MatrixContainer)cleanUpInterface).getLastMatrix() != null);
                ((MatrixContainer)cleanUpInterface).addMatrix(denseMatrix4);
                if (this.mr[26] != null) {
                    int n4 = this.getYindex();
                    abstractDataMatrix = this.dataSet.getMatrix(2);
                    if (n4 < 0) {
                        DenseVector denseVector = new DenseVector(abstractDataMatrix.getK());
                        for (int j = 0; j < abstractDataMatrix.getK(); ++j) {
                            this.calcRMSE(denseMatrix4, abstractDataMatrix, denseVector, j, j);
                        }
                        this.mr[26].addRow(denseVector);
                    } else {
                        DenseVector denseVector = new DenseVector(1);
                        this.calcRMSE(denseMatrix4, abstractDataMatrix, denseVector, 0, n4);
                        this.mr[26].addRow(denseVector);
                    }
                }
                if (this.calcDmodX) {
                    this.addDModXYandDcrit(this.mr[5], this.X, this.res.getRound() + 1);
                    object2 = this.getMatrix(20);
                    if (object2 != null) {
                        ((ModelMatrix)object2).addRow(this.getCalculatedS0());
                    }
                    this.addDModXYandDcrit(this.mr[6], this.Y, 0);
                    abstractDataMatrix = this.getMatrix(21);
                    if (abstractDataMatrix != null) {
                        ((ModelMatrix)abstractDataMatrix).addRow(this.getCalculatedS0());
                    }
                }
                object2 = this.X.SumSQ();
                abstractDataMatrix = this.Y.SumSQ();
                double d2 = this.mr[16].getLastScalar();
                double d3 = this.mr[18].getLastScalar();
                DenseVector denseVector = this.mr[8].getLastRM();
                DenseVector denseVector2 = this.mr[10].getLastRM();
                this.mr[8].addRow(new DenseVector(MatrixExtensions.arrayRightDivide(this.ssx_var_orig.minus((MVmatrix)object2), this.ssx_var_orig.getDoubleMatrix()).getData(), false));
                this.mr[10].addRow(new DenseVector(MatrixExtensions.arrayRightDivide(this.ssy_var_orig.minus((MVmatrix)abstractDataMatrix), this.ssy_var_orig.getDoubleMatrix()).getData(), false));
                ((DataTreeMemoryClass)object2).beginCalculations();
                abstractDataMatrix.beginCalculations();
                double d4 = ((AbstractMVmatrix)object2).SumScalar();
                double d5 = ((AbstractMVmatrix)abstractDataMatrix).SumScalar();
                ((DataTreeMemoryClass)object2).endCalculations();
                abstractDataMatrix.endCalculations();
                this.mr[16].addRow((this.ssx_orig - d4) / this.ssx_orig);
                this.mr[18].addRow((this.ssy_orig - d5) / this.ssy_orig);
                if (this.res.hasRounds()) {
                    this.mr[15].addRow(this.mr[16].getLastScalar() - d2);
                    this.mr[17].addRow(this.mr[18].getLastScalar() - d3);
                    this.mr[7].addRow((DenseVector)new DenseVector((Vector)this.mr[8].getLastRM()).add(-1.0, (Vector)denseVector));
                    this.mr[9].addRow((DenseVector)new DenseVector((Vector)this.mr[10].getLastRM()).add(-1.0, (Vector)denseVector2));
                } else {
                    this.mr[15].addRow(this.mr[16].getLastScalar());
                    this.mr[17].addRow(this.mr[18].getLastScalar());
                    this.mr[7].addRow(this.mr[8].getLastRM().copy());
                    this.mr[9].addRow(this.mr[10].getLastRM().copy());
                }
                this.res.IncRound();
                if (this.calcPred) {
                    this.calcPrediction(progressManager, true, false);
                }
                if (this.isTemporaryModelForCrossValidation()) continue;
                this.addHotellingT2(this.getMatrix(24), this.getMatrix(0), this.getMatrix(15));
                ModelMatrix modelMatrix = this.getMatrix(25);
                if (modelMatrix == null) continue;
                this.calculateVIP(modelMatrix, this.getMatrix(3), this.getMatrix(17));
                modelMatrix.setVisibleInTree(Evince.isVipFeature());
            }
            if (this.calcB && RegisterKeyManager.isPredikteraDevelopmentLicense()) {
                this.calcCumB();
            }
            this.finishPrediction(progressManager);
            this.updateOutput();
            return true;
        }
        catch (Exception exception) {
            ErrorHandler.logAndShowEvinceErrorDialogForException(exception);
            return false;
        }
    }

    private void calcRMSE(DenseMatrix denseMatrix, AbstractDataMatrix abstractDataMatrix, DenseVector denseVector, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < abstractDataMatrix.getN(); ++i) {
            if (abstractDataMatrix.isMissing(i, n2)) continue;
            double d = abstractDataMatrix.getValue(i, n2);
            double d2 = denseMatrix.get(i, n);
            denseVector.add(n, (d - d2) * (d - d2));
            ++n3;
        }
        if (n3 > 0) {
            denseVector.set(n, Math.sqrt(denseVector.get(n) / (double)n3));
        }
    }

    private void calculateVIP(ModelMatrix modelMatrix, ModelMatrix modelMatrix2, ModelMatrix modelMatrix3) {
        if (modelMatrix != null) {
            int n;
            DenseVector denseVector = new DenseVector(modelMatrix2.getK());
            int n2 = modelMatrix2.getN();
            double d = 0.0;
            for (n = 0; n < n2; ++n) {
                double d2 = modelMatrix3.getScalar(n);
                d += d2;
            }
            n = denseVector.size();
            for (int i = 0; i < n; ++i) {
                double d3 = 0.0;
                for (int j = 0; j < n2; ++j) {
                    double d4 = modelMatrix2.getValue(j, i);
                    double d5 = d4 * d4;
                    double d6 = modelMatrix3.getScalar(j);
                    d3 += d5 * d6;
                }
                denseVector.set(i, Math.sqrt(d3 * ((double)n / d)));
            }
            modelMatrix.addRow(denseVector);
        }
    }

    @Override
    public AbstractPrediction createPredictionLocal(ProgressManager progressManager, DataSet dataSet, Properties properties) {
        return new PLSpredictionNode(progressManager, this, dataSet, properties);
    }

    @Override
    public AbstractTModel createTableModel() {
        return new AnalysTableModel(this);
    }

    @Override
    public String[] getComponentNamesLocal() {
        return PLSModel.getComponentNames();
    }

    @Override
    public String getDescription() {
        String string = super.getDescription();
        if (string == null) {
            string = this.getVariablesDescription();
        }
        return string;
    }

    @Override
    public String getInformation() {
        StringBuilder stringBuilder = new StringBuilder(480);
        stringBuilder.append("<HTML><BODY>");
        stringBuilder.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">");
        stringBuilder.append("<TR><TD>Model:</TD><TD>").append(this.getModelName()).append("</TD></TR>");
        if (this.getCase() != null) {
            stringBuilder.append("<tr><td></td><td>").append(this.getCase()).append("</td></tr>");
        }
        stringBuilder.append("<TR><TD>DataSet:</TD><TD>").append(this.dataSet != null ? this.dataSet.toString() : "N/A").append("</TD></TR>");
        stringBuilder.append("<TR><TD width=\"60\">Y variables:</TD><TD>").append(this.getVariablesDescription()).append("</TD></TR>");
        if (this.X != null) {
            stringBuilder.append("<TR><TD>Pre-proc.:</TD><TD>").append(this.X.getTransformationInfo()).append("</TD></TR><TR></TR>");
            stringBuilder.append("<TR><TD>N:</TD><TD>").append(this.X.getN()).append("</TD></TR>");
            stringBuilder.append("<TR><TD>K:</TD><TD>").append(this.X.getK()).append("</TD></TR>");
            stringBuilder.append("<TR><TD>Comp:</TD><TD>").append(this.res.getRound()).append("</TD></TR>");
        }
        if (this.mr != null) {
            if (this.mr[16] != null) {
                stringBuilder.append("<TR><TD>R2X_cum:</TD><TD>").append(NiceDataFormat.toString(this.mr[16].getLastScalar())).append("</TD></TR>");
            }
            if (this.mr[18] != null) {
                stringBuilder.append("<TR><TD>R2Y_cum:</TD><TD>").append(NiceDataFormat.toString(this.mr[18].getLastScalar())).append("</TD></TR>");
            }
            if (this.mr[14] != null && this.mr[14].isVisibleInTree()) {
                stringBuilder.append("<TR><TD>Q2Y_cum:</TD><TD>").append(NiceDataFormat.toString(this.mr[14].getLastScalar())).append("</TD></TR>");
                stringBuilder.append("<TR><TD>Q2Y:</TD><TD>").append(NiceDataFormat.toString(this.mr[13].getLastScalar())).append("</TD></TR>");
            }
        }
        if (this.isUseDcrit()) {
            stringBuilder.append("<TR></TR><TR><TD>Dcrit:</TD><TD>").append(NiceDataFormat.toString(this.getDcritX())).append("</TD></TR>");
        }
        this.addCrossvalidationInfo(stringBuilder);
        stringBuilder.append("</TABLE></BODY></HTML>");
        return stringBuilder.toString();
    }

    public AbstractMVmatrix getKeepY() {
        return this.keepY;
    }

    @Override
    public String getModelName() {
        return "PLS";
    }

    public double[] getOffset() {
        return this.offset;
    }

    @Override
    public double[] getRating() {
        ModelMatrix modelMatrix = this.mr[12];
        if (modelMatrix != null) {
            double[] dArray = new double[modelMatrix.getK()];
            int n = modelMatrix.getN();
            for (int i = 0; i < modelMatrix.getK(); ++i) {
                dArray[i] = modelMatrix.getValue(n - 1, i) * 10.0;
            }
            return dArray;
        }
        return null;
    }

    public double[] getScalefactor() {
        return this.scalefactor;
    }

    @Override
    public ModelMatrix getScores() {
        return this.mr[0];
    }

    @Override
    public ModelMatrix getR2X() {
        return this.mr[15];
    }

    @Override
    public byte getTreeType() {
        return 1;
    }

    @Override
    public AbstractMVmatrix getXMatrix() {
        return this.X;
    }

    @Override
    public AbstractMVmatrix getYMatrix() {
        return this.Y;
    }

    @Override
    public boolean isConcentration() {
        return this.concentration;
    }

    @Override
    public void SaveModel(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveModel(randomOutputStream);
        randomOutputStream.writePropertyNode("X", this.X);
        randomOutputStream.writePropertyNode("Y", this.Y);
        randomOutputStream.writePropertyNode("ssx_var_orig", this.ssx_var_orig);
        randomOutputStream.writePropertyNode("ssy_var_orig", this.ssy_var_orig);
        randomOutputStream.writePropertyNode("w1_1", this.w1);
        randomOutputStream.writePropertyDouble("ssx_orig", this.ssx_orig);
        randomOutputStream.writePropertyDouble("ssy_orig", this.ssy_orig);
        randomOutputStream.writePropertyDoubleArray("scalefactor", this.scalefactor);
        randomOutputStream.writePropertyDoubleArray("offset", this.offset);
        randomOutputStream.writePropertyBoolean("concentration", this.concentration);
        this.res.Save(randomOutputStream);
    }

    public void setConcentration(boolean bl) {
        this.concentration = bl;
    }

    public void setKeep() {
        this.usekeep = true;
    }

    public void setOffset(double[] dArray) {
        this.offset = dArray;
    }

    public void setScalefactor(double[] dArray) {
        this.scalefactor = dArray;
    }

    protected void addModelSpecificPopupMenu(Project_GUI project_GUI, JPopupMenu jPopupMenu) {
        jPopupMenu.addSeparator();
        this.addCommonToMenu(project_GUI, jPopupMenu);
        if (RegisterKeyManager.isPredikteraDevelopmentLicense()) {
            CMenuItem cMenuItem = new CMenuItem("Show Bias-correction Dialog", false);
            cMenuItem.addActionListener(actionEvent -> BiasDialog.showDialog(IniManager.getMainFrame(), this));
            jPopupMenu.add(cMenuItem);
        }
    }

    protected DenseMatrix calcCumB() {
        DenseMatrix denseMatrix = this.mr[1].createDenseMatrix();
        DenseMatrix denseMatrix2 = this.mr[3].createDenseMatrix();
        DenseMatrix denseMatrix3 = this.mr[2].createDenseMatrix();
        DenseMatrix denseMatrix4 = new DenseMatrix(denseMatrix.numColumns(), denseMatrix2.numColumns());
        denseMatrix.transAmult((Matrix)denseMatrix2, (Matrix)denseMatrix4);
        DenseMatrix denseMatrix5 = Matrices.identity((int)denseMatrix.numColumns());
        DenseMatrix denseMatrix6 = denseMatrix5.copy();
        denseMatrix4.solve((Matrix)denseMatrix5, (Matrix)denseMatrix6);
        DenseMatrix denseMatrix7 = new DenseMatrix(denseMatrix2.numRows(), denseMatrix6.numColumns());
        denseMatrix2.mult((Matrix)denseMatrix6, (Matrix)denseMatrix7);
        DenseMatrix denseMatrix8 = new DenseMatrix(denseMatrix7.numRows(), denseMatrix3.numRows());
        denseMatrix7.transBmult((Matrix)denseMatrix3, (Matrix)denseMatrix8);
        return denseMatrix8;
    }

    protected void calculateOneComponent(ProgressManager progressManager, AbstractMVmatrix abstractMVmatrix, AbstractMVmatrix abstractMVmatrix2, AbstractMDAResults abstractMDAResults) throws Exception {
        int n;
        AbstractMatrix abstractMatrix = abstractMVmatrix.getMatrix();
        AbstractMatrix abstractMatrix2 = abstractMVmatrix2.getMatrix();
        DenseVector denseVector = new DenseVector(abstractMVmatrix.getK());
        DenseVector denseVector2 = new DenseVector(abstractMVmatrix2.getK());
        DenseVector denseVector3 = null;
        MVmatrix mVmatrix = this.ssy_var_orig;
        if (this.res.hasRounds()) {
            mVmatrix = abstractMVmatrix2.SumSQ();
        }
        DenseVector denseVector4 = null;
        DenseVector denseVector5 = abstractMVmatrix2.extractColVector(this.getMaxPos(mVmatrix));
        DenseVector denseVector6 = new DenseVector((Vector)denseVector5);
        denseVector6.scale(42.0);
        DenseVector denseVector7 = new DenseVector(denseVector6.size());
        int n2 = abstractMVmatrix.getN();
        double d = 42.0;
        for (n = 0; n < 200 && d > 1.0E-12 && (progressManager == null || !progressManager.isAborted()); ++n) {
            denseVector4 = denseVector7;
            denseVector7 = denseVector6;
            denseVector6 = denseVector4;
            abstractMatrix.transMult((Vector)denseVector5, (Vector)denseVector);
            if (this.res.firstRound() && this.res.equals(abstractMDAResults)) {
                denseVector3 = denseVector.copy();
            }
            if (abstractMVmatrix.hasMissing()) {
                PLSModel.nipalsColMv(abstractMVmatrix, denseVector5, denseVector);
            }
            denseVector.scale(1.0 / denseVector.norm(Vector.Norm.Two));
            MatrixExtensions.mult(denseVector6, (Matrix)abstractMatrix, denseVector);
            if (abstractMVmatrix.hasMissing()) {
                PLSModel.nipalsRowMv(abstractMVmatrix, denseVector, 1.0, denseVector6);
            }
            abstractMatrix2.transMult((Vector)denseVector6, (Vector)denseVector2);
            if (abstractMVmatrix2.hasMissing()) {
                PLSModel.nipalsColMv(abstractMVmatrix2, denseVector6, denseVector2);
            } else {
                denseVector2.scale(1.0 / denseVector6.dot((Vector)denseVector6));
            }
            MatrixExtensions.mult(denseVector5, (Matrix)abstractMatrix2, denseVector2);
            if (abstractMVmatrix2.hasMissing()) {
                PLSModel.nipalsRowMv(abstractMVmatrix2, denseVector2, denseVector5);
            } else {
                denseVector5.scale(1.0 / denseVector2.dot((Vector)denseVector2));
            }
            if (abstractMVmatrix2.getK() == 1) {
                d = 0.0;
                continue;
            }
            d = 0.0;
            double d2 = 0.0;
            double[] dArray = denseVector7.getData();
            double[] dArray2 = denseVector6.getData();
            for (int i = 0; i < n2 && !progressManager.isAborted(); ++i) {
                double d3 = dArray2[i];
                d2 += d3 * d3;
                d += (d3 -= dArray[i]) * d3;
            }
            d /= d2;
            if (progressManager == null) continue;
            progressManager.incStep((int)this.itmean);
        }
        DenseVector denseVector8 = new DenseVector(abstractMatrix.numColumns());
        abstractMatrix.transMult((Vector)denseVector6, (Vector)denseVector8);
        if (abstractMVmatrix.hasMissing()) {
            PLSModel.nipalsColMv(abstractMVmatrix, denseVector6, denseVector8);
        } else {
            denseVector8.scale(1.0 / denseVector6.dot((Vector)denseVector6));
        }
        ModelMatrix[] modelMatrixArray = abstractMDAResults.getMR();
        modelMatrixArray[0].addRow(denseVector6);
        modelMatrixArray[1].addRow(denseVector8);
        modelMatrixArray[2].addRow(denseVector2);
        modelMatrixArray[3].addRow(denseVector);
        modelMatrixArray[4].addRow(denseVector5);
        modelMatrixArray[19].addRow(n);
        if (this.res.firstRound() && this.res.equals(abstractMDAResults)) {
            this.w1.removeLastRow();
            this.w1.addRow(denseVector3);
        }
        if (progressManager != null && n > 0) {
            progressManager.subMaximum(200 - 200 * n);
            this.itmean = (this.itmean + (double)(200 / n)) / 2.0;
        }
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.ssx_var_orig != null) {
            this.ssx_var_orig.cleanUp();
            this.ssx_var_orig = null;
        }
        if (this.ssy_var_orig != null) {
            this.ssy_var_orig.cleanUp();
            this.ssy_var_orig = null;
        }
        this.w1 = null;
    }

    @Override
    protected AbstractMDAModel createModel(ProgressManager progressManager, DataSet dataSet, int[] nArray, int[] nArray2, boolean bl) throws Exception {
        return new PLSModel(progressManager, dataSet, nArray, nArray2, bl);
    }

    @Override
    protected AbstractCVResults createResults(Case case_, AbstractDataMatrix abstractDataMatrix, AbstractDataMatrix abstractDataMatrix2) throws Exception {
        return new PLSresults(case_, null, abstractDataMatrix, abstractDataMatrix2);
    }

    protected void crossValidate(ProgressManager progressManager, PLSresults pLSresults, AbstractMVmatrix abstractMVmatrix, AbstractMVmatrix abstractMVmatrix2, java.util.Vector<int[]> vector) throws Exception {
        int n;
        Object object;
        int n2;
        Object object2;
        progressManager.lockForChanges(true);
        DenseMatrix denseMatrix = null;
        int[] nArray = null;
        if (this.isTypeFull()) {
            abstractMVmatrix = this.getXorig(progressManager);
            abstractMVmatrix2 = this.getYorigReversibleOnly(progressManager);
            denseMatrix = new DenseMatrix(abstractMVmatrix2.getN(), abstractMVmatrix2.getK());
            nArray = new int[abstractMVmatrix2.getK()];
        }
        DenseVector denseVector = abstractMVmatrix2.sumSq();
        double d = denseVector.norm(Vector.Norm.One);
        DenseVector denseVector2 = new DenseVector(abstractMVmatrix2.getK());
        int n3 = this.getYindex();
        ArrayList<DenseVector[]> arrayList = null;
        if (this.calc_ci) {
            arrayList = new ArrayList<DenseVector[]>();
        }
        DataSet dataSet = null;
        if (this.isTypeFull()) {
            dataSet = this.dataSet.cloneDataSet(false);
        }
        int n4 = vector.size();
        for (int i = 0; i < n4; ++i) {
            Cloneable cloneable;
            BasicTreeInterface basicTreeInterface;
            DataTreeClass dataTreeClass;
            TemporaryPLSModelForCrossValidation temporaryPLSModelForCrossValidation = null;
            object2 = vector.elementAt(i);
            n2 = 0;
            for (int n5 : object2) {
                if (n5 < 0) continue;
                n2 = 1;
                break;
            }
            if (n2 == 0) continue;
            object = null;
            n = pLSresults.getRound();
            PLSresults pLSresults2 = null;
            DenseMatrix denseMatrix2 = null;
            if (this.isTypeFull()) {
                int n6;
                dataTreeClass = dataSet.getObsDataInfo();
                basicTreeInterface = (InnerColumnBoolean)((AbstractDataInfo)dataTreeClass).getPrimaryColumnByType(1);
                cloneable = (InnerColumnBoolean)((AbstractDataInfo)dataTreeClass).getPrimaryColumnByType(4);
                var27_38 = (InnerColumnBoolean)((AbstractDataInfo)dataTreeClass).getPrimaryColumnByType(5);
                var28_40 = abstractMVmatrix.getNref();
                ((InnerColumnBoolean)basicTreeInterface).fillColumn(false);
                for (int n7 : var28_40) {
                    ((InnerColumnBoolean)basicTreeInterface).setValueBool(n7, true);
                }
                ((InnerColumnBoolean)cloneable).fillColumn(true);
                var27_38.fillColumn(false);
                for (int n7 : object2) {
                    if (n7 < 0) continue;
                    n6 = var28_40[n7];
                    ((InnerColumnBoolean)cloneable).setValueBool(n6, false);
                    var27_38.setValueBool(n6, true);
                }
                dataSet.updateReferences();
                temporaryPLSModelForCrossValidation = new TemporaryPLSModelForCrossValidation(progressManager, dataSet, null, this.getYindx(), true);
                temporaryPLSModelForCrossValidation.setCrossvalidation((byte)0, 0, null, false);
                temporaryPLSModelForCrossValidation.setCalcDmodX(false);
                temporaryPLSModelForCrossValidation.calcModel(progressManager, n + 1);
                dataSet.addTreeNode(temporaryPLSModelForCrossValidation);
                var29_41 = (PLSpredictionNode)temporaryPLSModelForCrossValidation.getLocalPredictionNode();
                pLSresults2 = (PLSresults)temporaryPLSModelForCrossValidation.getResults();
                var30_42 = ((PLSpredictionNode)var29_41).getPredictions().getYpred();
                AbstractMVmatrix abstractMVmatrix3 = (AbstractMVmatrix)((MatrixContainer)var30_42).getLastAbstractMatrix();
                if (abstractMVmatrix3 != null) {
                    int n7;
                    for (n7 = 0; n7 < abstractMVmatrix3.getN(); ++n7) {
                        for (n6 = 0; n6 < abstractMVmatrix3.getK(); ++n6) {
                            if (abstractMVmatrix2.isMissing(object2[n7], n6)) continue;
                            denseMatrix.set(object2[n7], n6, abstractMVmatrix3.getValue(n7, n6));
                        }
                    }
                    this.Y.applyTransformations(abstractMVmatrix3, progressManager, false, true);
                    denseMatrix2 = abstractMVmatrix3.getInternalMatrixPublic();
                    for (n7 = 0; n7 < abstractMVmatrix3.getN(); ++n7) {
                        for (n6 = 0; n6 < abstractMVmatrix3.getK(); ++n6) {
                            if (abstractMVmatrix2.isMissing(object2[n7], n6)) continue;
                            double d2 = abstractMVmatrix3.getValue(n7, n6) - abstractMVmatrix2.getValue(object2[n7], n6);
                            denseVector2.add(n6, d2 * d2);
                            int n8 = n6;
                            nArray[n8] = nArray[n8] + 1;
                        }
                    }
                }
            } else {
                dataTreeClass = abstractMVmatrix.subMatrix_Exclude((int[])object2);
                basicTreeInterface = abstractMVmatrix2.subMatrix_Exclude((int[])object2);
                cloneable = abstractMVmatrix.subMatrix_Include_Only((int[])object2);
                pLSresults2 = (PLSresults)this.createResults(this.dataSet.getCase(), (AbstractDataMatrix)dataTreeClass, (AbstractDataMatrix)basicTreeInterface);
                this.calculateOneComponent(progressManager, (AbstractMVmatrix)dataTreeClass, (AbstractMVmatrix)basicTreeInterface, pLSresults2);
                var27_38 = pLSresults2.getW().getLastRM();
                var28_40 = ((AbstractMVmatrix)cloneable).times((DenseVector)var27_38);
                if (((AbstractDataMatrix)cloneable).hasMissing()) {
                    PLSModel.nipalsRowMv((AbstractDataMatrix)cloneable, (DenseVector)var27_38, (DenseVector)var28_40);
                }
                if (object == null) {
                    object = abstractMVmatrix2.subMatrix_Include_Only((int[])object2);
                }
                denseMatrix2 = MatrixExtensions.timesTransposeOf((DenseVector)var28_40, pLSresults2.getC().getLastRM());
                dataTreeClass.cleanUp();
                dataTreeClass = null;
                ((CleanUpVector)((Object)basicTreeInterface)).cleanUp();
                basicTreeInterface = null;
                if (cloneable != null) {
                    ((CleanUpVector)cloneable).cleanUp();
                    cloneable = null;
                }
                var29_41 = ((AbstractDataMatrix)object).minusMV((Matrix)denseMatrix2);
                var30_42 = ((AbstractMVmatrix)var29_41).sumSq();
                ((CleanUpVector)var29_41).cleanUp();
                denseVector2.add(1.0, (Vector)var30_42);
            }
            if (this.calc_ci && arrayList != null && !progressManager.isAborted()) {
                dataTreeClass = pLSresults2.getP().getLastRM();
                basicTreeInterface = pLSresults2.getW().getLastRM();
                cloneable = new DenseVector[]{dataTreeClass, basicTreeInterface};
                if (abstractMVmatrix.getK() != cloneable[0].size()) {
                    for (int j = 0; j < ((Cloneable)cloneable).length; ++j) {
                        cloneable[j] = this.createDenseVector(abstractMVmatrix.getKref(), pLSresults2.getP().getKref(), (DenseVector)cloneable[j]);
                    }
                }
                arrayList.add((DenseVector[])cloneable);
            }
            if (temporaryPLSModelForCrossValidation != null) {
                temporaryPLSModelForCrossValidation.cleanUp();
            }
            if (dataSet == null && object != null) {
                ((CleanUpVector)object).cleanUp();
                object = null;
            }
            pLSresults2.cleanUp();
            pLSresults2 = null;
        }
        if (dataSet != null) {
            dataSet.cleanUp();
        }
        DenseVector denseVector3 = new DenseVector(abstractMVmatrix2.getK());
        for (int i = 0; i < abstractMVmatrix2.getK(); ++i) {
            denseVector3.set(i, 1.0);
        }
        denseVector3.add(-1.0, (Vector)MatrixExtensions.arrayRightDivide(denseVector2, denseVector));
        DenseVector denseVector4 = new DenseVector(1);
        denseVector4.set(0, 1.0 - denseVector2.norm(Vector.Norm.One) / d);
        if (this.isTypeFull()) {
            object2 = new DenseVector(abstractMVmatrix2.getK());
            for (n2 = 0; n2 < object2.size(); ++n2) {
                if (nArray[n2] <= 0) continue;
                object2.set(n2, Math.sqrt(denseVector2.get(n2) / (double)nArray[n2]));
            }
            AbstractTransform abstractTransform = this.getYtransformationByType(1);
            if (abstractTransform != null) {
                object = new MVmatrix(1, object2.size());
                for (n = 0; n < object2.size(); ++n) {
                    ((AbstractMVmatrix)object).setValue(0, n, object2.get(n));
                }
                abstractTransform.reverseTransformation((AbstractDataMatrix)object, false);
                for (n = 0; n < object2.size(); ++n) {
                    object2.set(n, ((AbstractMVmatrix)object).getValue(0, n));
                }
            }
            pLSresults.getRMSECV_var().addRow((DenseVector)object2);
            object = new DenseVector(abstractMVmatrix2.getK());
            AbstractDataMatrix abstractDataMatrix = this.dataSet.getMatrix(2);
            abstractDataMatrix = abstractDataMatrix.subMatrix(progressManager, null, null, null);
            MVmatrix mVmatrix = abstractDataMatrix.getVariableStandardDeviation(progressManager, null);
            for (int n5 = 0; n5 < object2.size(); ++n5) {
                int n9 = n3 < 0 ? n5 : n3;
                double d3 = object2.get(n5);
                if (!(d3 > 0.0)) continue;
                object.set(n5, mVmatrix.getValue(n9, 0) / d3);
            }
            pLSresults.getRDPCV_var().addRow((DenseVector)object);
            if (pLSresults.YcalcCV != null) {
                pLSresults.YcalcCV.addMatrix(denseMatrix);
            }
            pLSresults.getQ2Y().addRow(this.calc_invert_cum(pLSresults.getQ2Y_CUM().getLastRM(), denseVector4));
            pLSresults.getQ2Y_VAR().addRow(this.calc_invert_cum(pLSresults.getQ2Y_VAR_CUM().getLastRM(), denseVector3));
            pLSresults.getQ2Y_CUM().addRow(denseVector4);
            pLSresults.getQ2Y_VAR_CUM().addRow(denseVector3);
        } else {
            pLSresults.getQ2Y_VAR().addRow(denseVector3);
            pLSresults.getQ2Y().addRow(denseVector4);
            pLSresults.getQ2Y_CUM().addRow(this.calc_cv_cum(pLSresults.getQ2Y()));
            object2 = new DenseVector(denseVector3.size());
            pLSresults.getQ2Y_VAR_CUM().addRow((DenseVector)object2);
            for (n2 = 0; n2 < pLSresults.getQ2Y_VAR().getK(); ++n2) {
                pLSresults.getQ2Y_VAR_CUM().setValue(pLSresults.getRound(), n2, this.calc_cv_var_cum(denseVector3, n2, pLSresults.getQ2Y_VAR()));
            }
        }
        if (this.isTypeFull()) {
            abstractMVmatrix.cleanUp();
            abstractMVmatrix2.cleanUp();
            denseMatrix = null;
            nArray = null;
        }
        if (this.calc_ci && arrayList != null && !arrayList.isEmpty()) {
            this.calcConfidenceInterval(arrayList, new ModelMatrix[]{pLSresults.getP(), pLSresults.getW()});
            arrayList.clear();
            arrayList = null;
        }
        progressManager.lockForChanges(false);
    }

    @Override
    protected AbstractMVmatrix getCvMatrix() {
        return this.Y;
    }

    @Override
    protected void removeComponentLocal(int n) throws Exception {
        MatrixExtensions.plusEqualsTimesTransposeOf(this.X, this.mr[0].getRM(n), this.mr[1].getRM(n));
        MatrixExtensions.plusEqualsTimesTransposeOf(this.Y, this.mr[0].getRM(n), this.mr[2].getRM(n));
    }

    @Override
    protected boolean resetModel(ProgressManager progressManager, boolean bl) {
        super.resetModel(progressManager, bl);
        if (!this.isTemporaryModelForCrossValidation()) {
            this.dataSet.excludeNonVarying(progressManager, true, this.minvariance);
        }
        AbstractDataMatrix abstractDataMatrix = this.dataSet.getMatrix(0);
        AbstractDataMatrix abstractDataMatrix2 = this.dataSet.getMatrix(2);
        if (abstractDataMatrix.getK() <= 0 || abstractDataMatrix2.getK() <= 0) {
            Main_GUI.setStatusMessage(StatusBar.MessageType.WARNING, "Cannot recalculate model \"" + String.valueOf(this) + "\": X and Y matrix dimensions cannot be zero", 10);
            return false;
        }
        if (!this.usekeep || this.keepX == null) {
            this.X = abstractDataMatrix.subMatrix(progressManager, this.X, this.Xindx, null, IniManager.getModelDataType());
            this.X.setName("Xres");
            this.X.setHtmlName("<html><b>X</b><sub>res</sub></html>");
            this.X.setMatrixInfo("Residual <b>X</b> matrix");
        }
        if (!this.usekeep || this.keepY == null) {
            this.Y = abstractDataMatrix2.subMatrix(this.Y, this.Xindx, this.Yindx, IniManager.getModelDataType());
            this.Y.setName("Yres");
            this.Y.setHtmlName("<html><b>Y</b><sub>res</sub></html>");
            this.Y.setMatrixInfo("Residual <b>Y</b> matrix");
        }
        this.resetModelLocal(progressManager);
        return true;
    }

    protected boolean isTemporaryModelForCrossValidation() {
        return false;
    }

    @Override
    protected boolean supportInterface(DataTreeInterface dataTreeInterface, AbstractModel.SaveType saveType) {
        if (!saveType.isComplete()) {
            PLSresults pLSresults = (PLSresults)this.res;
            if (saveType.equals((Object)AbstractModel.SaveType.REDUCED) && (dataTreeInterface.equals(pLSresults.getMR()[0]) || dataTreeInterface.equals(pLSresults.getMR()[5]))) {
                return true;
            }
            if (dataTreeInterface.equals(pLSresults.getMR()[3]) || dataTreeInterface.equals(pLSresults.getMR()[1]) || dataTreeInterface.equals(pLSresults.getMR()[2]) || dataTreeInterface.equals(pLSresults.B_scaled) || pLSresults.B_scaled.equals(dataTreeInterface.getTreeParent())) {
                return true;
            }
        }
        return super.supportInterface(dataTreeInterface, saveType);
    }

    private DenseVector createDenseVector(int[] nArray, int[] nArray2, DenseVector denseVector) {
        DenseVector denseVector2 = new DenseVector(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            int n = Arrays.binarySearch(nArray2, nArray[i]);
            if (n < 0) continue;
            denseVector2.set(i, denseVector.get(n));
        }
        return denseVector2;
    }

    private String getVariablesDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.mr != null) {
            ModelMatrix modelMatrix = this.mr[2];
            if (modelMatrix != null) {
                for (int i = 0; i < modelMatrix.getK(); ++i) {
                    int n;
                    if (i > 0) {
                        stringBuilder.append(", ");
                    }
                    String string = modelMatrix.getColumnDescription(i, 0);
                    if (this.getModelName().equals("PLS-DA") && (n = string.indexOf(":")) >= 0) {
                        string = string.substring(n + 1);
                    }
                    stringBuilder.append(string.trim());
                }
            }
            return stringBuilder.toString();
        }
        return "";
    }

    private void resetModelLocal(ProgressManager progressManager) {
        if (progressManager != null) {
            progressManager.setInfoText("Applying transformations");
        }
        this.X.beginCalculations();
        this.Y.beginCalculations();
        if (!this.usekeep || this.keepX == null) {
            this.dataSet.getMatrix(0).applyTransformations(this.X, progressManager);
            this.keepX = this.X.cloneTo(progressManager, this.keepX, IniManager.getModelDataType());
        } else {
            this.keepX.cloneTo(progressManager, this.X, IniManager.getModelDataType());
        }
        if (!this.usekeep || this.keepY == null) {
            this.dataSet.getMatrix(2).applyTransformations(this.Y, progressManager);
            this.keepY = this.Y.cloneTo(progressManager, this.keepY, IniManager.getModelDataType());
        } else {
            this.keepY.cloneTo(progressManager, this.Y, IniManager.getModelDataType());
        }
        if (this.res != null) {
            this.res.resetResults(this, this.X, this.Y);
            this.mr = this.res.getMR();
        }
        this.ssx_var_orig = this.X.SumSQ(this.ssx_var_orig);
        this.ssy_var_orig = this.Y.SumSQ(this.ssy_var_orig);
        this.ssx_var_orig.beginCalculations();
        this.ssy_var_orig.beginCalculations();
        this.ssx_orig = this.ssx_var_orig.SumScalar();
        this.ssy_orig = this.ssy_var_orig.SumScalar();
        if (this.w1 == null) {
            this.w1 = new ModelMatrix(this.dataSet.getDataInfo()[1], this.X.getKref());
            this.w1.setVector(false);
        } else {
            this.w1.resize(this.X);
        }
        this.ssx_var_orig.endCalculations();
        this.ssy_var_orig.endCalculations();
        this.X.endCalculations();
        this.Y.endCalculations();
    }

    public class PLSresults
    extends AbstractCVResults {
        public MatrixContainer B_scaled;
        public MatrixContainer Ycalc;
        public MatrixContainer YcalcCV;
        public MatrixContainer jackknife;

        public PLSresults(Case case_, AbstractDataNode abstractDataNode, AbstractDataMatrix abstractDataMatrix, AbstractDataMatrix abstractDataMatrix2) {
            int n;
            boolean bl;
            super(abstractDataNode, PLSModel.this.dataSet, loadResultNames.length);
            this.jackknife = null;
            this.mr[0] = new ModelMatrix(this.obs, abstractDataMatrix);
            this.mr[1] = new ModelMatrix(this.var, abstractDataMatrix);
            this.mr[2] = new ModelMatrix(this.var, abstractDataMatrix2);
            this.mr[3] = new ModelMatrix(this.var, abstractDataMatrix);
            this.mr[4] = new ModelMatrix(this.obs, abstractDataMatrix);
            boolean bl2 = bl = abstractDataNode != null;
            if (bl) {
                this.mr[5] = new ModelMatrix(this.obs, abstractDataMatrix);
                this.mr[6] = new ModelMatrix(this.obs, abstractDataMatrix);
                this.mr[7] = new ModelMatrix(this.var, abstractDataMatrix);
                this.mr[8] = new ModelMatrix(this.var, abstractDataMatrix);
                this.mr[9] = new ModelMatrix(this.var, abstractDataMatrix2);
                this.mr[10] = new ModelMatrix(this.var, abstractDataMatrix2);
                this.mr[11] = new ModelMatrix(this.var, abstractDataMatrix2);
                this.mr[12] = new ModelMatrix(this.var, abstractDataMatrix2);
                this.mr[22] = new ModelMatrix(this.var, abstractDataMatrix2);
                this.mr[23] = new ModelMatrix(this.var, abstractDataMatrix2);
                this.mr[24] = new ModelMatrix(this.obs, abstractDataMatrix);
                this.mr[25] = new ModelMatrix(this.var, abstractDataMatrix);
                this.mr[26] = new ModelMatrix(this.var, abstractDataMatrix2);
                this.B_scaled = new MatrixContainer("B_scaled", case_, this.var, abstractDataMatrix, this.var, abstractDataMatrix2, false);
                this.B_scaled.setHtmlName("<html><b>B</b>_scaled</html>");
                this.B_scaled.setMatrixInfo("Scaled PLS regression coefficients");
                this.B_scaled.setColumnType(16);
                this.Ycalc = new MatrixContainer("Ycalc", case_, this.obs, abstractDataMatrix, this.var, abstractDataMatrix2, false);
                this.Ycalc.setHtmlName("<html><b>Y</b>_calc</html>");
                this.Ycalc.setMatrixInfo("Calculated <b>Y</b>");
                this.Ycalc.setColumnType(16);
                this.YcalcCV = new MatrixContainer("YcalcCV", case_, this.obs, abstractDataMatrix, this.var, abstractDataMatrix2, false);
                this.YcalcCV.setHtmlName("<html><b>Y</b>calcCV</html>");
                this.YcalcCV.setMatrixInfo("Calculated <b>Y</b> from cross validation");
                this.YcalcCV.setColumnType(16);
            }
            int n2 = n = bl ? 13 : 19;
            while (n < this.mr.length) {
                if (n != 22 && n != 23 && n != 24 && n != 25 && n != 26) {
                    this.mr[n] = new ModelMatrix(null, new int[0]);
                    this.mr[n].setColumnType(4);
                    this.mr[n].setRowType(8);
                }
                ++n;
            }
            if (bl) {
                this.mr[20].setVisibleInTree(false);
                this.mr[21].setVisibleInTree(false);
            }
            this.initVectors();
            DataContainer dataContainer = new DataContainer("Explained variances", -1);
            for (int i = this.mr.length - 1; i >= 0; --i) {
                if (this.mr[i] == null) continue;
                this.mr[i].setName(resultNames[i]);
                this.mr[i].setHtmlName(htmlResultNames[i]);
                this.mr[i].setMatrixInfo(resultInfo[i]);
                if (abstractDataNode == null) continue;
                String string = this.mr[i].toString();
                if (string.startsWith("R2") || string.startsWith("Q2") || string.startsWith("RMSE") || string.startsWith("RDPCV")) {
                    dataContainer.insertTreeNode(this.mr[i]);
                    continue;
                }
                abstractDataNode.insertTreeNode(this.mr[i]);
            }
            if (abstractDataNode != null) {
                PLSModel.this.ssx_var_orig.setVisibleInTree(false);
                PLSModel.this.ssy_var_orig.setVisibleInTree(false);
                dataContainer.addTreeNode(PLSModel.this.ssx_var_orig);
                dataContainer.addTreeNode(PLSModel.this.ssy_var_orig);
                this.sortExplainedVariances(dataContainer);
                abstractDataNode.addTreeNode(dataContainer);
                abstractDataNode.addTreeNode(this.B_scaled);
                abstractDataNode.addTreeNode(this.Ycalc);
                abstractDataNode.addTreeNode(this.YcalcCV);
            }
        }

        public PLSresults(RandomInputStream randomInputStream, MapProperty mapProperty, AbstractDataMatrix abstractDataMatrix, AbstractDataMatrix abstractDataMatrix2) throws IOException {
            super(randomInputStream, mapProperty, loadResultNames);
            this.jackknife = null;
            if (this.mr[22] == null) {
                this.mr[22] = new ModelMatrix(this.var, abstractDataMatrix2);
            }
            if (this.mr[23] == null) {
                this.mr[23] = new ModelMatrix(this.var, abstractDataMatrix2);
            }
            this.initVectors();
            this.B_scaled = (MatrixContainer)mapProperty.resolveNodeFromName(randomInputStream, "B_scaled");
            this.Ycalc = (MatrixContainer)mapProperty.resolveNodeFromName(randomInputStream, "Ycalc");
            this.YcalcCV = (MatrixContainer)mapProperty.resolveNodeFromName(randomInputStream, "YpredCV");
            this.jackknife = (MatrixContainer)mapProperty.resolveNodeFromName(randomInputStream, "jack");
            for (int i = 0; i < this.mr.length; ++i) {
                if (this.mr[i] == null) continue;
                this.mr[i].setName(resultNames[i]);
                this.mr[i].setHtmlName(htmlResultNames[i]);
            }
        }

        @Override
        public ModelMatrix getC() {
            return this.mr[2];
        }

        @Override
        public Object[] getCompData(int n, boolean bl) {
            Object[] objectArray = new Object[]{this, "", "", "", "", "", "", "", "", "", "", ""};
            objectArray[0] = this.getCompData(n, 0);
            if (bl) {
                objectArray[1] = this.getCompData(n, 1);
            }
            objectArray[2] = this.getCompData(n, 2);
            objectArray[3] = this.getCompData(n, 3);
            objectArray[4] = this.getCompData(n, 4);
            objectArray[5] = this.getCompData(n, 5);
            objectArray[6] = this.getCompData(n, 6);
            objectArray[7] = this.getCompData(n, 7);
            objectArray[8] = this.getCompData(n, 8);
            if (bl) {
                objectArray[9] = this.getCompData(n, 9);
                objectArray[10] = this.getCompData(n, 10);
                objectArray[11] = this.getCompData(n, 11);
            }
            return objectArray;
        }

        @Override
        public Object getCompData(int n, int n2) {
            return switch (n2) {
                case 0 -> new AbstractMDAModel.ComponentResult(PLSModel.this, n);
                case 1 -> {
                    if (PLSModel.this.dataSet != null) {
                        yield PLSModel.this.dataSet.toString();
                    }
                    yield "N/A";
                }
                case 2 -> String.valueOf(n + 1);
                case 3, 4, 5, 6 -> this.getCompString(this.mr[15 + n2 - 3], n);
                case 7, 8 -> this.getCompString(this.mr[13 + n2 - 7], n);
                case 9 -> String.valueOf(PLSModel.this.X.getN());
                case 10 -> String.valueOf(PLSModel.this.X.getK());
                case 11 -> PLSModel.this.X.getTransformationInfo();
                default -> "";
            };
        }

        @Override
        public ModelMatrix getDModX() {
            return this.mr[5];
        }

        @Override
        public ModelMatrix getHotellingT2() {
            return this.mr[24];
        }

        public ModelMatrix getDModY() {
            return this.mr[6];
        }

        public ModelMatrix getJackknifeMatrix(int n) {
            if (this.jackknife == null) {
                try {
                    this.jackknife = new MatrixContainer("Jackknife", this.B_scaled);
                }
                catch (IOException iOException) {
                    this.jackknife = new MatrixContainer("Jackknife");
                }
                PLSModel.this.addTreeNode(this.jackknife);
            }
            while (n >= this.jackknife.getMatrixCount()) {
                this.jackknife.addMatrix(new ModelMatrix(this.jackknife.getDataInfo(0), new int[0]));
            }
            return (ModelMatrix)this.jackknife.getMatrixAt(n);
        }

        public String getModelName() {
            return PLSModel.this.toString();
        }

        @Override
        public ModelMatrix getP() {
            return this.mr[1];
        }

        @Override
        public ModelMatrix getQ2Y() {
            return this.mr[13];
        }

        @Override
        public ModelMatrix getQ2Y_CUM() {
            return this.mr[14];
        }

        @Override
        public ModelMatrix getQ2Y_VAR() {
            return this.mr[11];
        }

        @Override
        public ModelMatrix getQ2Y_VAR_CUM() {
            return this.mr[12];
        }

        public ModelMatrix getRDPCV_var() {
            return this.mr[23];
        }

        public ModelMatrix getRMSECV_var() {
            return this.mr[22];
        }

        public int getRowCount() {
            return 1;
        }

        public ModelMatrix getScores() {
            return this.mr[0];
        }

        @Override
        public ModelMatrix getSSX() {
            return this.mr[15];
        }

        @Override
        public ModelMatrix getSSXY_CUM() {
            return this.mr[18];
        }

        @Override
        public ModelMatrix getSSXY() {
            return this.mr[17];
        }

        @Override
        public ModelMatrix getT() {
            return this.mr[0];
        }

        @Override
        public ModelMatrix getW() {
            return this.mr[3];
        }

        public boolean hasJackknifeMatrix() {
            return this.jackknife != null && this.jackknife.getMatrixCount() > 0;
        }

        @Override
        public void removeLastRow() {
            this.B_scaled.removeLastMatrix();
            this.Ycalc.removeLastMatrix();
            if (this.YcalcCV != null) {
                this.YcalcCV.removeLastMatrix();
            }
            super.removeLastRow();
        }

        @Override
        public void resetResults(AbstractDataNode abstractDataNode, AbstractDataMatrix abstractDataMatrix, AbstractDataMatrix abstractDataMatrix2) {
            super.resetResults(abstractDataNode, abstractDataMatrix, abstractDataMatrix2);
            this.mr[2].resize(abstractDataMatrix2);
            this.mr[9].resize(abstractDataMatrix2);
            this.mr[10].resize(abstractDataMatrix2);
            this.mr[11].resize(abstractDataMatrix2);
            this.mr[12].resize(abstractDataMatrix2);
            if (this.mr[26] != null) {
                this.mr[26].resize(abstractDataMatrix2);
            }
            if (PLSModel.this.isTypeFull()) {
                this.mr[22].resize(abstractDataMatrix2);
                this.mr[23].resize(abstractDataMatrix2);
            }
            this.B_scaled.resize(abstractDataMatrix, abstractDataMatrix2);
            this.Ycalc.resize(abstractDataMatrix, abstractDataMatrix2);
            if (this.YcalcCV != null) {
                this.YcalcCV.resize(abstractDataMatrix, abstractDataMatrix2);
            }
            if (this.jackknife != null) {
                this.jackknife.resize(abstractDataMatrix, abstractDataMatrix2);
            }
        }

        @Override
        public void Save(RandomOutputStream randomOutputStream) throws IOException {
            this.save(randomOutputStream, loadResultNames);
            randomOutputStream.writePropertyNode("B_scaled", this.B_scaled);
            randomOutputStream.writePropertyNode("Ycalc", this.Ycalc);
            randomOutputStream.writePropertyNode("YpredCV", this.YcalcCV);
            randomOutputStream.writePropertyNode("jack", this.jackknife);
        }

        @Override
        public void setSize(int n) {
            this.B_scaled.setSize(n);
            this.Ycalc.setSize(n);
            if (this.YcalcCV != null) {
                this.YcalcCV.setSize(n);
            }
            super.setSize(n);
        }

        @Override
        public void undoRow() {
            super.undoRow();
            this.B_scaled.removeLastMatrix();
            if (this.YcalcCV != null) {
                this.YcalcCV.removeLastMatrix();
            }
            if (this.jackknife != null) {
                int n = this.jackknife.getMatrixCount();
                for (int i = 0; i < n; ++i) {
                    ((ModelMatrix)this.jackknife.getMatrixAt(i)).removeLastRow();
                }
            }
        }

        @Override
        protected void cleanUpChild() {
            super.cleanUpChild();
            if (this.B_scaled != null) {
                this.B_scaled.cleanUp();
                this.B_scaled = null;
            }
            if (this.Ycalc != null) {
                this.Ycalc.cleanUp();
                this.Ycalc = null;
            }
            if (this.YcalcCV != null) {
                this.YcalcCV.cleanUp();
                this.YcalcCV = null;
            }
        }

        private void initVectors() {
            for (int i = 5; i < this.mr.length; ++i) {
                if (this.mr[i] == null) continue;
                this.mr[i].setVector(false);
            }
        }
    }

    public static class TemporaryPLSModelForCrossValidation
    extends PLSModel {
        public TemporaryPLSModelForCrossValidation(ProgressManager progressManager, DataSet dataSet, int[] nArray, int[] nArray2, boolean bl) {
            super(progressManager, dataSet, nArray, nArray2, bl);
        }

        @Override
        protected boolean isTemporaryModelForCrossValidation() {
            return true;
        }
    }
}

