/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model.PLS;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.model.modelgenerator.ModelInit;
import se.prediktera.mda.model.AbstractCVModelInfo;
import se.prediktera.mda.model.AbstractMDAModel;
import se.prediktera.mda.model.ModelException;
import se.prediktera.mda.model.PLS.PLSModel;

public class PLSModelInfo
extends AbstractCVModelInfo {
    private final JComboBox boxMultiSingleY = new JComboBox();

    @Override
    public boolean checkCurrentDataSet(DataSet dataSet) {
        if (super.checkCurrentDataSet(dataSet)) {
            AbstractDataMatrix abstractDataMatrix = dataSet.getMatrix(2);
            int n = abstractDataMatrix.getK();
            if (n == 0) {
                Window window = IniManager.getMainFrame();
                if (ProgressManagerImpl.getProgressManager() != null) {
                    window = ProgressManagerImpl.getProgressManager().getWindow();
                }
                JOptionPane.showConfirmDialog(window, "Y matrix dimension cannot be Zero", "Cannot calculate " + String.valueOf(this), -1, 0, null);
                return false;
            }
            if (this.hasYClass(dataSet)) {
                JOptionPane.showMessageDialog(null, "Warning! Please exclude Y-variables belonging to a class before calculating PLS model.", "Warning", 2);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Vector<JComponent> createWizard() {
        super.createWizard();
        this.boxMultiSingleY.removeAllItems();
        this.boxMultiSingleY.addItem("Multi Y PLS");
        this.boxMultiSingleY.addItem("Single Y PLS");
        this.commonPanel.add((Component)new JLabel("Model type:"), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 18, 0, 0), 0, 0));
        this.commonPanel.add((Component)this.boxMultiSingleY, new GridBagConstraints(1, 5, 2, 1, 1.0, 0.0, 18, 2, new Insets(6, 6, 0, 12), 0, 0));
        return this.wizard;
    }

    @Override
    public String getType() {
        return "pls";
    }

    @Override
    public ImageIcon getWizardImage() {
        return null;
    }

    @Override
    public String getWizardInfo() {
        return "Create new PLS Model";
    }

    @Override
    public boolean supportData(DataTreeInterface dataTreeInterface) {
        if (!super.supportData(dataTreeInterface)) {
            return false;
        }
        DataSet dataSet = this.getDataSet(dataTreeInterface);
        return dataSet != null && this.hasYData(dataSet);
    }

    @Override
    public String toString() {
        return "PLS Model";
    }

    @Override
    protected AbstractMDAModel createNewModel(ProgressManager progressManager, ModelInit modelInit, int[] nArray, int[] nArray2, int n, String string) {
        DataSet dataSet = modelInit.getDataSet();
        try {
            PLSModel pLSModel = modelInit.getDataTreeInterface() instanceof PLSModel ? (PLSModel)modelInit.getDataTreeInterface() : new PLSModel(progressManager, dataSet, nArray, nArray2, true);
            pLSModel.setConcentration(true);
            String string2 = modelInit.getModelName();
            if (nArray2 != null) {
                AbstractDataMatrix abstractDataMatrix = dataSet.getMatrix(2);
                string2 = abstractDataMatrix.getColumnDescription(n, 0);
            }
            if (nArray != null) {
                string2 = string;
            }
            pLSModel.setName(string2);
            pLSModel.setType(modelInit.typeisfull);
            pLSModel.setRandomSeed(modelInit.randomSeed);
            pLSModel.setCrossvalidation(modelInit.crossvalidationType, modelInit.nr_groups, modelInit.cvCategoryName, modelInit.hasConfidenceInterval());
            return pLSModel;
        }
        catch (ModelException modelException) {
            if (UpdateHelper.Product.isRunningProductEvince()) {
                JOptionPane.showConfirmDialog(ProgressManagerImpl.getParentComponent(), modelException.getMessage(), "Cannot calculate " + String.valueOf(this), -1, 0, null);
            }
            throw modelException;
        }
        catch (Exception exception) {
            ErrorHandler.logAndShowEvinceErrorDialogForException(exception);
            return null;
        }
    }

    @Override
    protected void setModelInitFromPanel(ModelInit modelInit, DataSet dataSet) {
        super.setModelInitFromPanel(modelInit, dataSet);
        modelInit.singleY = this.boxMultiSingleY.getSelectedIndex() == 1;
    }
}

