/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model.PLS;

import java.util.LinkedList;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import se.prediktera.map.common.cleanup.CleanUpInterface;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractMVmatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.main.Plot_GUI;
import se.prediktera.map.model.modelgenerator.AbstractModelInfo;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.LeafList;
import se.prediktera.map.plot.axisplot.PlotAxisLayerPanel;
import se.prediktera.map.plot.axisplot.plot2D.scatter.Scatter2D;
import se.prediktera.map.plot.axisplot.settings.Color.PerfectSpread;
import se.prediktera.map.register.RegisterKeyManager;
import se.prediktera.mda.model.AbstractMDAContainerWindow;
import se.prediktera.mda.model.AbstractMDAModel;
import se.prediktera.mda.model.PLS.PLSModel;
import se.prediktera.mda.model.PLS.PLSModelInfo;
import se.prediktera.mda.model.PLS.ValidatePLSDialog;
import se.prediktera.mda.model.PLSDA.PLSDAModelInfo;

public class PLSModelInformation
extends AbstractMDAContainerWindow {
    private final JButton buttonValidatePLS = new JButton("Validate");
    private ValidatePLSDialog vplsd;

    private static int[][] generatePerm(int n, int n2) {
        int[][] nArray = new int[n][n2];
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        Random random = new Random(System.currentTimeMillis());
        for (int i = 0; i < n; ++i) {
            int n3;
            for (n3 = 0; n3 < n2; ++n3) {
                linkedList.add(n3);
            }
            n3 = 0;
            while (!linkedList.isEmpty()) {
                int n4 = Math.abs(random.nextInt() % linkedList.size());
                nArray[i][n3++] = (Integer)linkedList.get(n4);
                linkedList.remove(n4);
            }
        }
        return nArray;
    }

    public PLSModelInformation(Case case_, DataContainer dataContainer) {
        super("PLS-Models", case_, PLSModel.getComponentNames(), dataContainer);
        this.informationToolbar.addSeparator();
        if (RegisterKeyManager.isPredikteraLicense()) {
            this.informationToolbar.add(this.buttonValidatePLS);
        }
        this.buttonValidatePLS.setToolTipText("Validate the current PLS Model");
        this.buttonValidatePLS.addActionListener(actionEvent -> this.validatePLS());
    }

    @Override
    public AbstractModelInfo createModelInfo() {
        return new PLSModelInfo();
    }

    @Override
    public boolean supportInfo(AbstractModelInfo abstractModelInfo) {
        return abstractModelInfo instanceof PLSModelInfo || abstractModelInfo instanceof PLSDAModelInfo;
    }

    public void validatePLS() {
        AbstractMDAModel abstractMDAModel = (AbstractMDAModel)this.currentInformation;
        if (abstractMDAModel != null) {
            this.vplsd = new ValidatePLSDialog(abstractMDAModel.getYMatrix());
            if (this.vplsd.showModal()) {
                CleanUpInterface cleanUpInterface;
                for (int i = abstractMDAModel.getTreeNodeCount() - 1; i >= 0; --i) {
                    cleanUpInterface = abstractMDAModel.getTreeNodeAt(i);
                    if (!cleanUpInterface.toString().equals("Validation")) continue;
                    cleanUpInterface.cleanUp();
                }
                DataContainer dataContainer = new DataContainer("Validation", -1);
                abstractMDAModel.addTreeNode(dataContainer);
                cleanUpInterface = new ProgressManagerImpl(){

                    @Override
                    public Object doWork() {
                        DataContainer dataContainer = (DataContainer)this.arguments[0];
                        try {
                            AbstractMDAModel abstractMDAModel = (AbstractMDAModel)PLSModelInformation.this.currentInformation;
                            DataSet dataSet = (DataSet)abstractMDAModel.getTreeParent();
                            MVmatrix mVmatrix = dataSet.getMatrix(0).subMatrix(abstractMDAModel.getXindx(), null);
                            MVmatrix mVmatrix2 = dataSet.getMatrix(2).subMatrix(abstractMDAModel.getXindx(), abstractMDAModel.getYindx());
                            abstractMDAModel.getXMatrix().applyTransformations(mVmatrix, null);
                            AbstractMVmatrix abstractMVmatrix = abstractMDAModel.getYMatrix();
                            abstractMVmatrix.applyTransformations(mVmatrix2, null);
                            int n = PLSModelInformation.this.vplsd.getNrPerm();
                            int[] nArray = PLSModelInformation.this.vplsd.getYindex();
                            int n2 = abstractMDAModel.getResults().getRound();
                            double d = mVmatrix2.getN();
                            int[][] nArray2 = PLSModelInformation.generatePerm(n, (int)d);
                            for (int n3 : nArray) {
                                double d2;
                                double d3;
                                MVmatrix mVmatrix3 = new MVmatrix((int)d, 1);
                                int n4 = 0;
                                while ((double)n4 < d) {
                                    double d4 = mVmatrix2.getValue(n4, n3);
                                    boolean bl = mVmatrix2.isMissing(n4, n3);
                                    mVmatrix3.setValue(n4, 0, d4, bl);
                                    ++n4;
                                }
                                PLSModel pLSModel = new PLSModel(dataSet, mVmatrix, mVmatrix3);
                                pLSModel.setCrossvalidation((byte)1, 7, null, false);
                                MVmatrix mVmatrix4 = new MVmatrix(n + 1, 1, abstractMVmatrix.getColumnDescription(n3, 0));
                                MVmatrix mVmatrix5 = new MVmatrix(n + 1, 1, "SSY_CV_var_cum");
                                MVmatrix mVmatrix6 = new MVmatrix(n + 1, 1, "SSY_var_cum");
                                int n5 = this.setGroupMaximumAndReset(n);
                                this.setMaximumAndReset(pLSModel.getNitmax() * n2 * n);
                                for (int i = 0; i < n; ++i) {
                                    int n6 = 0;
                                    while ((double)n6 < d) {
                                        d3 = mVmatrix2.getValue(n6, n3);
                                        boolean bl = mVmatrix2.isMissing(n6, n3);
                                        mVmatrix3.setValue(nArray2[i][n6], 0, d3, bl);
                                        ++n6;
                                    }
                                    double d5 = 0.0;
                                    double d6 = 0.0;
                                    d2 = 0.0;
                                    double d7 = 0.0;
                                    double d8 = 0.0;
                                    int n7 = 0;
                                    while ((double)n7 < d) {
                                        double d9 = mVmatrix2.getValue(n7, n3);
                                        double d10 = mVmatrix3.getValue(n7, 0);
                                        d5 += d9 * d10;
                                        d6 += d9;
                                        d2 += d10;
                                        d7 += d9 * d9;
                                        d8 += d10 * d10;
                                        ++n7;
                                    }
                                    double d11 = d6 * d2;
                                    double d12 = Math.abs(d5 - d11 / d) / Math.sqrt((d7 - d6 * d6 / d) * (d8 - d2 * d2 / d));
                                    mVmatrix4.setValue(i, 0, d12);
                                    pLSModel.calcModel(this, "Permutation " + (i + 1) + ": ", n2);
                                    PLSModel.PLSresults pLSresults = (PLSModel.PLSresults)pLSModel.getResults();
                                    ModelMatrix modelMatrix = pLSresults.getMR()[12];
                                    double d13 = modelMatrix.getLastScalar();
                                    mVmatrix5.setValue(i, 0, d13);
                                    ModelMatrix modelMatrix2 = pLSresults.getMR()[10];
                                    double d14 = modelMatrix2.getLastScalar();
                                    mVmatrix6.setValue(i, 0, d14);
                                    pLSModel.removeAllComp(this);
                                    this.incStepGroup(n5);
                                }
                                PLSModel.PLSresults pLSresults = (PLSModel.PLSresults)abstractMDAModel.getResults();
                                ModelMatrix modelMatrix = pLSresults.getMR()[12];
                                d3 = modelMatrix.getLastScalar();
                                ModelMatrix modelMatrix3 = pLSresults.getMR()[10];
                                d2 = modelMatrix3.getLastScalar();
                                mVmatrix4.setValue(n, 0, 1.0);
                                mVmatrix5.setValue(n, 0, d3);
                                mVmatrix6.setValue(n, 0, d2);
                                dataContainer.addTreeNode(mVmatrix4);
                                dataContainer.addTreeNode(mVmatrix5);
                                dataContainer.addTreeNode(mVmatrix6);
                                pLSModel.cleanUp();
                                mVmatrix3.cleanUp();
                                this.setInfoText("Creating validation plot");
                                PLSModelInformation.this.generateValidationPlot(mVmatrix4, mVmatrix5, mVmatrix6);
                            }
                            PLSModelInformation.this.project_GUI.updateDataTree(abstractMDAModel);
                            mVmatrix.cleanUp();
                            mVmatrix2.cleanUp();
                        }
                        catch (Exception exception) {
                            ErrorHandler.logAndShowEvinceErrorDialogForException(exception);
                        }
                        if (PLSModelInformation.this.vplsd != null) {
                            PLSModelInformation.this.vplsd.cleanUp();
                            PLSModelInformation.this.vplsd = null;
                        }
                        return null;
                    }
                };
                cleanUpInterface.setArguments(new Object[]{dataContainer});
                SwingUtilities.invokeLater((Runnable)((Object)cleanUpInterface));
            } else {
                this.vplsd.cleanUp();
                this.vplsd = null;
            }
        }
    }

    @Override
    protected String getModeltype() {
        return "PLS";
    }

    private void generateValidationPlot(MVmatrix mVmatrix, MVmatrix mVmatrix2, MVmatrix mVmatrix3) {
        Plot_GUI plot_GUI = this.getProject_GUI().getPlot_GUI();
        AbstractMDAModel abstractMDAModel = (AbstractMDAModel)this.currentInformation;
        PlotInit plotInit = new PlotInit(mVmatrix);
        plotInit.autoCreateLayer = false;
        plotInit.title = "Validation Model\n$model ($matrix)";
        plotInit.axislable[0] = mVmatrix.getN() - 1 + " permutations, " + abstractMDAModel.getResults().getRound() + " components";
        plotInit.axislable[1] = "";
        Scatter2D scatter2D = new Scatter2D(plot_GUI, plotInit);
        PlotAxisLayerPanel plotAxisLayerPanel = (PlotAxisLayerPanel)scatter2D.getSettingsPanel();
        plotAxisLayerPanel.setCreated(plot_GUI, false);
        PlotInit plotInit2 = new PlotInit(mVmatrix);
        plotInit2.setMatrix(0, mVmatrix);
        plotInit2.setMatrix(1, mVmatrix2);
        plotInit2.minmax[0][0] = 0.0;
        plotInit2.minmax[0][1] = 1.0;
        plotInit2.filterRoot = this.dataSetContainer;
        plotInit2.initshape = 4;
        plotInit2.initcolor = PerfectSpread.generateColor(0);
        AbstractAxisLayer abstractAxisLayer = plotAxisLayerPanel.addLayer(true, plotInit2, mVmatrix2.toString());
        LeafList leafList = abstractAxisLayer.getSubList(mVmatrix.getN() - 1, mVmatrix.getN() - 1);
        plotInit2.initshape = 9;
        AbstractAxisLayer abstractAxisLayer2 = abstractAxisLayer.createSubLayer(leafList, 1, plotInit2);
        plotAxisLayerPanel.addSubLayer(abstractAxisLayer, abstractAxisLayer2, true, true);
        abstractAxisLayer2.setLayerName("Original");
        PlotInit plotInit3 = new PlotInit(null);
        plotInit3.setMatrix(0, mVmatrix);
        plotInit3.setMatrix(1, mVmatrix3);
        plotInit2.minmax[0][0] = 0.0;
        plotInit2.minmax[0][1] = 1.0;
        plotInit3.filterRoot = this.dataSetContainer;
        plotInit3.initshape = 3;
        plotInit3.initcolor = PerfectSpread.generateColor(2);
        AbstractAxisLayer abstractAxisLayer3 = plotAxisLayerPanel.addLayer(true, plotInit3, mVmatrix3.toString());
        LeafList leafList2 = abstractAxisLayer3.getSubList(mVmatrix.getN() - 1, mVmatrix.getN() - 1);
        plotInit3.initshape = 8;
        AbstractAxisLayer abstractAxisLayer4 = abstractAxisLayer3.createSubLayer(leafList2, 1, plotInit3);
        plotAxisLayerPanel.addSubLayer(abstractAxisLayer3, abstractAxisLayer4, true, true);
        abstractAxisLayer4.setLayerName("Original");
        plot_GUI.addWindow(scatter2D, false);
    }
}

