/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model.PLS;

import java.awt.Color;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.jama.MatrixExtensions;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.AbstractDataNode;
import se.prediktera.map.datasetcontainer.BasicTreeInterface;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataTreeClass;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.classes.ClassSettings;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.classes.prediction.InnerColumnPredClass;
import se.prediktera.map.datasetcontainer.classes.prediction.PredictionClasses;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.Description;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.AbstractMVmatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.datasetcontainer.matrix.MatrixContainer;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.datasetcontainer.transform.category.DataInfoClassEvent;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Plot_GUI;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.model.ModelWrapper;
import se.prediktera.map.model.output.OutputClass;
import se.prediktera.map.plot.axisplot.settings.Color.PerfectSpread;
import se.prediktera.map.plot.axisplot.settings.Color.PlotContinuousColor;
import se.prediktera.mda.model.AbstractMDAModel;
import se.prediktera.mda.model.AbstractMDAResults;
import se.prediktera.mda.model.AnalysPredictionNode;
import se.prediktera.mda.model.PCA.PCAModel;
import se.prediktera.mda.model.PCA.PCApredictionNode;
import se.prediktera.mda.model.PLS.PLSModel;
import se.prediktera.mda.model.PLSDA.PLSDAModel;

public class PLSpredictionNode
extends AnalysPredictionNode {
    private MVmatrix ssxp_var_orig;
    private MVmatrix ssyp_var_orig;
    private static final String[] resultNames = new String[]{"Tpred", "ObsDMXpred", "ObsDMYpred", "RMSEP_var", "SEP_var", "bias", "Hotelling T2 pred", "RPDP_var", "R2XP_var_cum", "R2YP_var_cum"};
    private static final String[] pre102ResultNames = new String[]{"Tpred", "DModXpred", "DModYpred", "RMSEP_var", "SEP_var", "bias", "Hotelling T2 pred", "RPDP_var", "R2P_var_cum", "R2P_var_cum"};
    private static final String[] htmlResultNames = new String[]{"<html><b>T</b>pred</html>", "<html>ObsDM<b>X</b>pred</html>", "<html>ObsDM<b>Y</b>pred</html>", "RMSEP_var", "SEP_var", "bias", "Hotelling T2 pred", "RPDP_var", "R2XP_var_cum", "R2YP_var_cum"};
    private static final String[] resultInfo = new String[]{"Predicted Scores in <b>X</b>", "Predicted Observation Distance to Model in <b>X</b>", "Predicted Observation Distance to Model in <b>Y</b>", "RMSEP_var", "SEP_var", "bias", "Hotelling T2 pred", "RPDP_var", "R2XP_var_cum", "R2YP_var_cum"};
    private static String[] loadResultNames = resultNames;
    private static final byte MEAN = 0;
    private static final byte MIN = 1;
    private static final byte MAX = 2;
    private static final byte COUNT = 3;
    private static final byte SD = 4;
    private PLSpredictions pred;
    private AbstractMVmatrix predX;
    private AbstractMVmatrix predY;
    private AbstractMVmatrix yTeOrig;
    private boolean scaled = false;

    public PLSpredictionNode(ProgressManager progressManager, AbstractMDAModel abstractMDAModel, DataSet dataSet) throws Exception {
        this(progressManager, abstractMDAModel, dataSet, null);
    }

    public PLSpredictionNode(ProgressManager progressManager, AbstractMDAModel abstractMDAModel, DataSet dataSet, Properties properties) {
        super(abstractMDAModel, dataSet, properties, true);
        if (properties != null) {
            int n;
            double[] dArray;
            int n2;
            if (properties.containsKey("scalefactor")) {
                n2 = ((AbstractDataMatrix)abstractMDAModel.get("C")).getK();
                dArray = new double[n2];
                for (n = 0; n < dArray.length; ++n) {
                    dArray[n] = properties.containsKey("sf" + (n + 1)) ? ScriptHelper.getPropertyDouble(properties, "sf" + (n + 1)) : 1.0;
                }
                ((PLSModel)abstractMDAModel).setScalefactor(dArray);
            }
            if (properties.containsKey("offset")) {
                n2 = ((AbstractDataMatrix)abstractMDAModel.get("C")).getK();
                dArray = new double[n2];
                for (n = 0; n < dArray.length; ++n) {
                    dArray[n] = properties.containsKey("offset" + (n + 1)) ? ScriptHelper.getPropertyDouble(properties, "offset" + (n + 1)) : 1.0;
                }
                ((PLSModel)abstractMDAModel).setOffset(dArray);
            }
            if (ScriptHelper.hasKey(properties, "keep_predclass")) {
                this.keep_predclass = ScriptHelper.getPropertyBool(properties, "keep_predclass");
            }
        }
        this.resetPrediction();
        this.predX.setName("Xres Test");
        this.predX.setHtmlName("<html><b>X</b>res Test</html>");
        this.addTreeNode(this.predX, abstractMDAModel);
        this.predY.setName("Yres Test");
        this.predY.setHtmlName("<html><b>Y</b>res Test</html>");
        this.addTreeNode(this.predY, abstractMDAModel);
        this.pred = new PLSpredictions(dataSet.getCase(), this, this.predX, this.predY, this.getCMatrix());
        this.predMR = this.pred.getMR();
        this.calcAllPredictions(progressManager);
    }

    public PLSpredictionNode(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        if (randomInputStream.getSaveVersion() < 102L) {
            loadResultNames = pre102ResultNames;
        }
        this.predX = (AbstractMVmatrix)mapProperty.resolveNodeFromName(randomInputStream, "xTe");
        this.predY = (AbstractMVmatrix)mapProperty.resolveNodeFromName(randomInputStream, "yTe");
        this.yTeOrig = (AbstractMVmatrix)mapProperty.resolveNodeFromName(randomInputStream, "yTeOrig");
        this.ssxp_var_orig = (MVmatrix)mapProperty.resolveNodeFromName(randomInputStream, "ssxp_var_orig");
        this.ssyp_var_orig = (MVmatrix)mapProperty.resolveNodeFromName(randomInputStream, "ssyp_var_orig");
        this.scaled = mapProperty.getPropertyBoolean("scaled");
        this.pred = new PLSpredictions(randomInputStream, mapProperty);
        this.predMR = this.pred.getMR();
    }

    @Override
    public boolean canCalculate() {
        if (this.predX == null || this.yTeOrig == null) {
            return false;
        }
        return this.predX.getMatrixSize() > 0;
    }

    @Override
    public void cleanUpChild() {
        super.cleanUpChild();
        if (this.pred != null) {
            this.pred.cleanUp();
            this.pred = null;
        }
        this.predX = null;
        this.predY = null;
        this.yTeOrig = null;
    }

    public void createPredictionClasses() {
        Object object;
        PLSDAModel pLSDAModel;
        DataTreeClass dataTreeClass;
        AbstractMVmatrix abstractMVmatrix;
        block13: {
            block12: {
                abstractMVmatrix = this.getYpredLastMatrix();
                dataTreeClass = this.model;
                if (!(dataTreeClass instanceof PLSDAModel)) break block12;
                pLSDAModel = (PLSDAModel)dataTreeClass;
                if (abstractMVmatrix != null) break block13;
            }
            return;
        }
        abstractMVmatrix.beginCalculations();
        dataTreeClass = this.dataSet.getObsDataInfo();
        PredictionClasses predictionClasses = (PredictionClasses)((AbstractDataInfo)dataTreeClass).getGroupColumnByType(11);
        if (predictionClasses == null) {
            predictionClasses = new PredictionClasses(((AbstractDataInfo)dataTreeClass).getRowCount());
            ((AbstractDataInfo)dataTreeClass).addTreeNode(predictionClasses);
        }
        String string = "Pred. " + this.model.toString();
        InnerColumnPredClass innerColumnPredClass = predictionClasses.getPredictionClass(this.model, string);
        OutputClass outputClass = this.model.getOutput();
        innerColumnPredClass.beginUpdate();
        int n = abstractMVmatrix.getK();
        int n2 = abstractMVmatrix.getN();
        int n3 = n;
        ClassTypes classTypes = new ClassTypes(innerColumnPredClass);
        for (int i = 0; i < n3; ++i) {
            String string2 = abstractMVmatrix.getColumnDescription(i, 0);
            string2 = string2.substring(string2.indexOf(":") + 2);
            string2 = string2.substring(0, string2.lastIndexOf("."));
            object = null;
            if (outputClass != null) {
                object = outputClass.getColor(i);
            }
            if (outputClass != null && object != null) {
                ClassSettings classSettings = new ClassSettings(string2, i, (Color)object);
                classTypes.add(classSettings);
                continue;
            }
            classTypes.addStringNoEvent(string2);
        }
        innerColumnPredClass.holdObject(classTypes);
        double d = pLSDAModel.getDcritX();
        object = null;
        if (pLSDAModel.isUseDcrit() && this.predMR[1] != null) {
            object = this.predMR[1].getLastRM();
        }
        double d2 = pLSDAModel.getHotellingt2();
        DenseVector denseVector = null;
        if (pLSDAModel.isUseHotelling() && this.predMR[6] != null) {
            denseVector = this.predMR[6].getLastRM();
        }
        double d3 = pLSDAModel.getCutOffLow();
        double d4 = pLSDAModel.getCutOffHigh();
        int[] nArray = this.predX.getNref();
        for (int i = 0; i < n2; ++i) {
            short s = 0;
            if (object != null && object.get(i) > d || denseVector != null && denseVector.get(i) > d2) {
                innerColumnPredClass.setValueShort(nArray != null ? nArray[i] : i, s);
                continue;
            }
            double d5 = d3;
            for (int n4 = 0; n4 < n3; n4 = (int)((short)(n4 + 1))) {
                double d6 = abstractMVmatrix.getValue(i, n4);
                if (!(d6 > d5) || !(d6 < d4)) continue;
                d5 = d6;
                s = (short)(n4 + 1);
            }
            innerColumnPredClass.setValueShort(nArray != null ? nArray[i] : i, s);
        }
        abstractMVmatrix.endCalculations();
        innerColumnPredClass.endUpdate();
        ((AbstractDataInfo)dataTreeClass).triggerGlobalEvent(new DataInfoClassEvent((AbstractDataInfo)dataTreeClass, 7, null, classTypes, 3));
    }

    @Override
    public void finishPrediction(ProgressManager progressManager) {
        if (this.predClasses) {
            this.createPredictionClasses();
        }
    }

    @Override
    public BasicTreeInterface get(String string) {
        if (string.equalsIgnoreCase("quantification")) {
            double d;
            int n;
            int n2;
            AbstractMVmatrix abstractMVmatrix = this.getYpredLastMatrix();
            abstractMVmatrix.beginCalculations();
            int n3 = abstractMVmatrix.getK();
            int n4 = abstractMVmatrix.getN();
            int n5 = n3;
            boolean bl = this.model.isUseDcrit();
            double d2 = this.model.getDcritX();
            DenseVector denseVector = null;
            if (bl && this.getDModX() != null) {
                denseVector = this.getDModX().getLastRM();
            }
            double[][] dArray = new double[5][n5];
            for (n2 = 0; n2 < n5; ++n2) {
                dArray[1][n2] = 2.147483647E9;
                dArray[2][n2] = -2.147483647E9;
            }
            for (n2 = 0; n2 < n4; ++n2) {
                if (denseVector != null && !(denseVector.get(n2) < d2)) continue;
                n = 0;
                while (n < n5) {
                    d = abstractMVmatrix.getValue(n2, n);
                    double[] dArray2 = dArray[0];
                    int n6 = n;
                    dArray2[n6] = dArray2[n6] + d;
                    if (dArray[1][n] > d) {
                        dArray[1][n] = d;
                    }
                    if (dArray[2][n] < d) {
                        dArray[2][n] = d;
                    }
                    double[] dArray3 = dArray[3];
                    int n7 = n++;
                    dArray3[n7] = dArray3[n7] + 1.0;
                }
            }
            for (n2 = 0; n2 < n5; ++n2) {
                if (!(dArray[3][n2] > 0.0)) continue;
                double[] dArray4 = dArray[0];
                int n8 = n2;
                dArray4[n8] = dArray4[n8] / dArray[3][n2];
            }
            for (n2 = 0; n2 < n4; ++n2) {
                if (denseVector != null && !(denseVector.get(n2) < d2)) continue;
                n = 0;
                while (n < n5) {
                    d = abstractMVmatrix.getValue(n2, n) - dArray[0][n];
                    double[] dArray5 = dArray[4];
                    int n9 = n++;
                    dArray5[n9] = dArray5[n9] + d * d;
                }
            }
            for (n2 = 0; n2 < n5; ++n2) {
                if (!(dArray[3][n2] > 0.0)) continue;
                dArray[4][n2] = Math.sqrt(dArray[4][n2] / (dArray[3][n2] - 1.0));
            }
            abstractMVmatrix.endCalculations();
            return new MVmatrix(dArray, 3, dArray.length);
        }
        if (string.equalsIgnoreCase("classification")) {
            ObservationInfo observationInfo = this.dataSet.getObsDataInfo();
            PredictionClasses predictionClasses = (PredictionClasses)observationInfo.getGroupColumnByType(11);
            if (predictionClasses != null) {
                int n;
                int n10;
                int n11;
                String string2 = "Pred. " + this.model.toString();
                InnerColumnPredClass innerColumnPredClass = predictionClasses.getPredictionClass(this.model, string2);
                InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)observationInfo.getPrimaryColumnByType(1);
                ClassTypes classTypes = innerColumnPredClass.getObject();
                int n12 = -1;
                for (n11 = 0; n11 < classTypes.size(); ++n11) {
                    if (!classTypes.getTypeDescription(n11).equals("-")) continue;
                    n12 = n11;
                    break;
                }
                n11 = 0;
                int[] nArray = new int[classTypes.size()];
                int n13 = 0;
                for (int i = 0; i < innerColumnPredClass.getSize(); ++i) {
                    if (!innerColumnBoolean.getValueBool(i)) continue;
                    int n14 = innerColumnPredClass.getValueShort(i);
                    if (nArray[n14] == 0) {
                        ++n13;
                        if (n14 == n12) {
                            n11 = 1;
                        }
                    }
                    int n15 = n14;
                    nArray[n15] = nArray[n15] + 1;
                }
                if (n11 == 0) {
                    ++n13;
                }
                List<PlotContinuousColor> list = Plot_GUI.getColorScales();
                PlotContinuousColor plotContinuousColor = new PlotContinuousColor("Classification");
                list.remove(plotContinuousColor);
                list.add(plotContinuousColor);
                MVmatrix mVmatrix = (MVmatrix)this.getMatrixByName("Classification");
                if (mVmatrix != null) {
                    mVmatrix.resize(1, n13);
                } else {
                    mVmatrix = new MVmatrix(1, n13, "Classification");
                }
                mVmatrix.setRowType(16);
                mVmatrix.setColumnType(16);
                Description description = new Description(1);
                description.addColumn("Number");
                description.setValue(0, 0, "Number");
                mVmatrix.setRowDescription(description);
                Description description2 = new Description(n13);
                description2.addColumn("Class");
                mVmatrix.setColumnDescription(description2);
                int n16 = 1;
                int[] nArray2 = (int[])nArray.clone();
                for (n10 = 0; n10 < nArray2.length; ++n10) {
                    n = 0;
                    int n17 = 0;
                    for (int i = 0; i < nArray2.length; ++i) {
                        if (nArray2[i] <= n) continue;
                        n = nArray2[i];
                        n17 = i;
                    }
                    if (n <= 0) break;
                    if (n17 != n12) {
                        ClassSettings classSettings = classTypes.getClassSettings(n17);
                        classSettings.setColor(PerfectSpread.generateColor(n16++));
                    }
                    nArray2[n17] = 0;
                }
                n10 = 0;
                for (n = 0; n < nArray.length; ++n) {
                    ClassSettings classSettings = classTypes.getClassSettings(n);
                    if (nArray[n] <= 0 && !classSettings.getName().equals("-")) continue;
                    plotContinuousColor.addColor(classSettings.getColor());
                    String string3 = classSettings.getName();
                    if (n == n12) {
                        string3 = "Ok\u00e4nd";
                    }
                    description2.setValue(n10, 0, string3);
                    mVmatrix.setValue(0, n10++, nArray[n]);
                }
                this.addTreeNode(mVmatrix);
                return mVmatrix;
            }
            throw new RuntimeException("Classification is not available");
        }
        if (string.equalsIgnoreCase("classification_column")) {
            ObservationInfo observationInfo = this.dataSet.getObsDataInfo();
            PredictionClasses predictionClasses = (PredictionClasses)observationInfo.getGroupColumnByType(11);
            if (predictionClasses != null) {
                String string4 = "Pred. " + this.model.toString();
                return predictionClasses.getPredictionClass(this.model, string4);
            }
            return null;
        }
        return super.get(string);
    }

    @Override
    public ModelMatrix getDModX() {
        return this.getPredMR(1);
    }

    @Override
    public ModelMatrix getHotellingT2() {
        return this.getPredMR(6);
    }

    @Override
    public PLSpredictions getPredictions() {
        return this.pred;
    }

    @Override
    public byte getTreeType() {
        return 3;
    }

    @Override
    public AbstractMVmatrix getXMatrix() {
        return this.predX;
    }

    @Override
    public AbstractMVmatrix getYMatrix() {
        return this.predY;
    }

    public AbstractMVmatrix getYpredLastMatrix() {
        MatrixContainer matrixContainer;
        if (this.pred != null && (matrixContainer = this.pred.getYpred()) != null) {
            return (MVmatrix)matrixContainer.getLastAbstractMatrix();
        }
        return null;
    }

    public boolean isPlsDaModel() {
        return this.model instanceof PLSDAModel;
    }

    public boolean isScaled() {
        return this.scaled;
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyNode("xTe", this.predX);
        randomOutputStream.writePropertyNode("yTe", this.predY);
        randomOutputStream.writePropertyNode("yTeOrig", this.yTeOrig);
        randomOutputStream.writePropertyBoolean("scaled", this.scaled);
        this.pred.Save(randomOutputStream);
    }

    @Override
    protected AbstractMDAResults calcOnePrediction(ProgressManager progressManager) {
        double d;
        this.beginCalculations();
        AbstractMDAResults abstractMDAResults = (AbstractMDAResults)this.model.getResults();
        int n = this.pred.getRound();
        DenseVector denseVector = abstractMDAResults.getMR()[3].getRM(n);
        DenseVector denseVector2 = abstractMDAResults.getMR()[1].getRM(n);
        DenseVector denseVector3 = abstractMDAResults.getMR()[2].getRM(n);
        DenseVector denseVector4 = denseVector;
        double d2 = denseVector2.dot((Vector)denseVector);
        if (Double.compare(d2, 0.0) == 0) {
            d2 = Double.NaN;
        }
        denseVector4 = denseVector.copy();
        denseVector4.scale(1.0 / d2);
        DenseVector denseVector5 = this.predX.times(denseVector4);
        if (this.predX.hasMissing()) {
            AbstractMDAModel.nipalsRowMv(this.predX, denseVector4, denseVector5);
        }
        DenseMatrix denseMatrix = MatrixExtensions.timesTransposeOf(denseVector5, denseVector3);
        for (int i = this.pred.getRound() - 1; i >= 0; --i) {
            DenseMatrix denseMatrix2 = MatrixExtensions.timesTransposeOf(this.predMR[0].getRM(i), abstractMDAResults.getMR()[2].getRM(i));
            denseMatrix.add((Matrix)denseMatrix2);
        }
        int[] nArray = this.yTeOrig.getKref();
        if (nArray == null) {
            nArray = new int[denseMatrix.numColumns()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = i;
            }
        }
        this.model.reverseTransformationsY(denseMatrix, nArray, this.pred.Ypred.getLastMatrix() != null);
        PLSModel pLSModel = (PLSModel)this.model;
        boolean bl = pLSModel.isConcentration();
        double[] dArray = pLSModel.getScalefactor();
        double[] dArray2 = pLSModel.getOffset();
        if (bl && dArray != null) {
            int n2 = denseMatrix.numColumns();
            int n3 = denseMatrix.numRows();
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    d = denseMatrix.get(j, i);
                    if (dArray != null) {
                        d *= dArray[i];
                    }
                    if (dArray2 != null) {
                        d += dArray2[i];
                    }
                    denseMatrix.set(j, i, d);
                }
            }
            this.scaled = dArray != null;
        } else {
            this.scaled = false;
        }
        this.pred.Ypred.addMatrix(denseMatrix);
        MatrixExtensions.minusEqualsTimesTransposeOf(this.predX, denseVector5, denseVector2);
        if (this.predY != null) {
            MatrixExtensions.minusEqualsTimesTransposeOf(this.predY, denseVector5, denseVector3);
        }
        this.predMR[0].addRow(denseVector5);
        if (this.calcDModXY && (!this.optimize || n == abstractMDAResults.getRound() - 1)) {
            ModelMatrix modelMatrix = abstractMDAResults.getMR(20);
            double d3 = modelMatrix != null ? modelMatrix.getScalar(n) : 1.0;
            this.predMR[1].addRow(this.model.predictDModXY(this.predX, n + 1, d3));
            if (this.predY != null) {
                ModelMatrix modelMatrix2 = abstractMDAResults.getMR(21);
                d = modelMatrix2 != null ? modelMatrix2.getScalar(n) : 1.0;
                this.predMR[2].addRow(this.model.predictDModXY(this.predY, 0, d));
            }
            this.model.calculateHotellingT2(this.predMR[6], this.predMR[0], this.model.getResults().getMatrix(15));
        }
        this.predMR[1].setVisibleInTree(this.calcDModXY);
        this.predMR[2].setVisibleInTree(this.calcDModXY);
        if (this.yTeOrig.getMatrixSize() > 0) {
            if (this.ssxp_var_orig != null) {
                MVmatrix mVmatrix = this.predX.SumSQ();
                this.predMR[8].addRow(new DenseVector(MatrixExtensions.arrayRightDivide(this.ssxp_var_orig.minus(mVmatrix), this.ssxp_var_orig.getDoubleMatrix()).getData(), false));
            }
            if (this.ssyp_var_orig != null) {
                MVmatrix mVmatrix = this.predY.SumSQ();
                this.predMR[9].addRow(new DenseVector(MatrixExtensions.arrayRightDivide(this.ssyp_var_orig.minus(mVmatrix), this.ssyp_var_orig.getDoubleMatrix()).getData(), false));
            }
            DenseMatrix denseMatrix3 = new DenseMatrix((Matrix)denseMatrix);
            if (this.yTeOrig.getMatrixSize() > 0) {
                denseMatrix3.add(-1.0, (Matrix)this.yTeOrig.getMatrix());
            }
            MVmatrix mVmatrix = new MVmatrix(this.yTeOrig.getK(), 1);
            MVmatrix mVmatrix2 = this.yTeOrig.getVariableStandardDeviation(progressManager, null);
            MVmatrix mVmatrix3 = new MVmatrix(this.yTeOrig.getK(), 1);
            MVmatrix mVmatrix4 = new MVmatrix(this.yTeOrig.getK(), 1);
            MVmatrix mVmatrix5 = new MVmatrix(this.yTeOrig.getK(), 1);
            for (int i = 0; i < this.yTeOrig.getK(); ++i) {
                double d4 = 0.0;
                double d5 = 0.0;
                for (int j = 0; j < this.yTeOrig.getN(); ++j) {
                    if (this.yTeOrig.isMissing(j, i)) continue;
                    d4 += denseMatrix3.get(j, i);
                    d5 += 1.0;
                }
                double d6 = d4 / d5;
                mVmatrix5.setValue(i, 0, d6);
                double d7 = 0.0;
                for (int j = 0; j < this.yTeOrig.getN(); ++j) {
                    if (this.yTeOrig.isMissing(j, i)) continue;
                    double d8 = denseMatrix3.get(j, i) - d6;
                    d7 += d8 * d8;
                }
                mVmatrix4.setValue(i, 0, Math.sqrt(d7 / (d5 - 1.0)));
                double d9 = Math.sqrt(d7 / d5 + d6 * d6);
                mVmatrix.setValue(i, 0, d9);
                if (!(d9 > 0.0)) continue;
                mVmatrix3.setValue(i, 0, mVmatrix2.getValue(i, 0) / d9);
            }
            this.predMR[3].addRow(new DenseVector(mVmatrix.getDoubleMatrix().getData(), false));
            this.predMR[4].addRow(new DenseVector(mVmatrix4.getDoubleMatrix().getData(), false));
            this.predMR[5].addRow(new DenseVector(mVmatrix5.getDoubleMatrix().getData(), false));
            if (this.predMR[7] != null) {
                this.predMR[7].addRow(new DenseVector(mVmatrix3.getDoubleMatrix().getData(), false));
            }
        }
        this.predMR[3].setVisibleInTree(this.yTeOrig.getMatrixSize() > 0);
        this.predMR[4].setVisibleInTree(this.yTeOrig.getMatrixSize() > 0);
        this.predMR[5].setVisibleInTree(this.yTeOrig.getMatrixSize() > 0);
        if (this.predMR[7] != null) {
            this.predMR[7].setVisibleInTree(this.yTeOrig.getMatrixSize() > 0);
        }
        if (this.predMR[8] != null) {
            this.predMR[8].setVisibleInTree(this.yTeOrig.getMatrixSize() > 0);
            this.predMR[8].setVisibleInTree(false);
        }
        if (this.predMR[9] != null) {
            this.predMR[9].setVisibleInTree(this.yTeOrig.getMatrixSize() > 0);
        }
        this.pred.IncRound();
        this.endCalculations();
        return this.pred;
    }

    @Override
    protected void removeOnePrediction() throws Exception {
        this.beginCalculations();
        AbstractMDAResults abstractMDAResults = (AbstractMDAResults)this.model.getResults();
        DenseVector denseVector = this.predMR[0].getLastRM();
        DenseVector denseVector2 = abstractMDAResults.getMR()[1].getLastRM();
        DenseVector denseVector3 = abstractMDAResults.getMR()[2].getLastRM();
        this.predX.plusEqualsMV((Matrix)MatrixExtensions.timesTransposeOf(denseVector, denseVector2));
        if (this.predY != null) {
            this.predY.plusEqualsMV((Matrix)MatrixExtensions.timesTransposeOf(denseVector, denseVector3));
        }
        this.pred.removeLastRow();
        this.endCalculations();
    }

    @Override
    protected void resetPrediction() {
        int n;
        int n2;
        this.checkDimensions();
        AbstractDataMatrix abstractDataMatrix = this.getDataSetMatrixToPredictInX();
        AbstractDataMatrix abstractDataMatrix2 = this.getDataSetMatrixToPredictInY();
        AbstractMVmatrix abstractMVmatrix = this.yTeOrig;
        this.predX = abstractDataMatrix.subMatrix(this.predX, null, null, IniManager.getPredictionDataType());
        this.predY = !this.dataSet.isExternal() && !this.model.isReduced() && !this.model.isExternal() && this.equalDataSet() ? abstractDataMatrix2.subMatrix(this.predY, null, this.model.getYindx(), IniManager.getPredictionDataType()) : new MVmatrix(0, 0, "none");
        if (this.yTeOrig != null && this.yTeOrig.getMatrixSize() == 0) {
            this.yTeOrig = null;
        }
        this.yTeOrig = !this.dataSet.isExternal() && !this.model.isReduced() && !this.model.isExternal() && this.equalDataSet() ? abstractDataMatrix2.subMatrix(this.yTeOrig, null, this.model.getYindx(), IniManager.getPredictionDataType()) : new MVmatrix(0, 0, "none");
        this.predX.beginCalculations();
        this.predY.beginCalculations();
        this.yTeOrig.beginCalculations();
        if (this.yTeOrig.getMatrixSize() > 0) {
            double d = 0.0;
            for (int i = 0; i < this.yTeOrig.getK(); ++i) {
                for (n2 = 0; n2 < this.yTeOrig.getN(); ++n2) {
                    d += this.yTeOrig.getValue(n2, i);
                }
            }
            d /= (double)this.yTeOrig.getMatrixSize();
            double d2 = 0.0;
            for (n = 0; n < this.yTeOrig.getK(); ++n) {
                for (int i = 0; i < this.yTeOrig.getN(); ++i) {
                    double d3 = this.yTeOrig.getValue(i, n) - d;
                    d2 += d3 * d3;
                }
            }
            if ((d2 = Math.sqrt(d2 / (double)(this.yTeOrig.getMatrixSize() - 1))) < 0.0) {
                this.yTeOrig = new MVmatrix(0, 0, "yTeOrig");
            }
        }
        if (abstractMVmatrix != this.yTeOrig) {
            this.replaceNode(abstractMVmatrix, this.yTeOrig);
        }
        this.yTeOrig.setVisibleInTree(false);
        Case case_ = this.dataSet.getCase();
        for (int i = 0; i < case_.getNrOfSubModels(); ++i) {
            ModelWrapper modelWrapper = case_.getSubModelAt(i);
            n2 = modelWrapper.getStartIndex();
            n = modelWrapper.getEndIndex();
            PCAModel pCAModel = (PCAModel)modelWrapper.getModelInterface();
            for (int j = 0; j < pCAModel.getTreeNodeCount(); ++j) {
                PCApredictionNode pCApredictionNode;
                ModelMatrix modelMatrix;
                DataTreeInterface dataTreeInterface = pCAModel.getTreeNodeAt(j);
                if (!dataTreeInterface.isNode() || (modelMatrix = (pCApredictionNode = (PCApredictionNode)dataTreeInterface).getPredictions().getMR()[0]) == null) continue;
                int[] nArray = this.predX.getNref();
                int n3 = 0;
                int n4 = n2;
                while (n4 < n) {
                    int n5 = this.predX.getKrefOrig(n4);
                    if (n5 >= 0) {
                        for (int k = 0; k < this.predX.getN(); ++k) {
                            int n6 = modelMatrix.getKrefOrig(nArray[k]);
                            if (n6 >= 0) {
                                this.predX.setValue(k, n5, modelMatrix.getValue(n3, n6), modelMatrix.isMissing(n3, n6));
                                continue;
                            }
                            this.predX.setValue(k, n5, 0.0, true);
                        }
                    }
                    ++n4;
                    ++n3;
                }
            }
        }
        this.model.applyTransformationX(this.predX);
        this.model.applyTransformationY(this.predY);
        this.ssxp_var_orig = this.predX.SumSQ(this.ssxp_var_orig);
        if (this.predY != null) {
            this.ssyp_var_orig = this.predY.SumSQ(this.ssyp_var_orig);
        }
        if (this.pred != null) {
            this.pred.resetResults(this, this.predX, this.predY);
        }
        this.predX.endCalculations();
        this.predY.endCalculations();
        this.yTeOrig.endCalculations();
    }

    private AbstractDataMatrix getCMatrix() {
        AbstractMDAResults abstractMDAResults = (AbstractMDAResults)this.model.getResults();
        return abstractMDAResults.getMR()[2];
    }

    public class PLSpredictions
    extends AbstractMDAResults {
        public MatrixContainer Ypred;

        public PLSpredictions(Case case_, AbstractDataNode abstractDataNode, AbstractDataMatrix abstractDataMatrix, AbstractDataMatrix abstractDataMatrix2, AbstractDataMatrix abstractDataMatrix3) {
            int n;
            super(abstractDataNode, PLSpredictionNode.this.dataSet, resultNames.length);
            this.Ypred = new MatrixContainer("Ypred", case_, this.obs, abstractDataMatrix, this.var, abstractDataMatrix3, false);
            this.Ypred.setHtmlName("<html><b>Y</b>pred</html>");
            for (n = 0; n < 3; ++n) {
                this.mr[n] = new ModelMatrix(this.obs, abstractDataMatrix);
            }
            this.mr[3] = new ModelMatrix(this.var, abstractDataMatrix2);
            this.mr[7] = new ModelMatrix(this.var, abstractDataMatrix2);
            this.mr[8] = new ModelMatrix(this.var, abstractDataMatrix);
            this.mr[9] = new ModelMatrix(this.var, abstractDataMatrix2);
            this.mr[4] = new ModelMatrix(this.var, abstractDataMatrix2);
            this.mr[5] = new ModelMatrix(this.var, abstractDataMatrix2);
            this.mr[6] = new ModelMatrix(this.obs, abstractDataMatrix);
            for (n = 0; n < this.mr.length; ++n) {
                this.initMatrix(abstractDataNode, n);
            }
            if (abstractDataNode != null) {
                abstractDataNode.addTreeNode(this.Ypred);
            }
        }

        private void initMatrix(AbstractDataNode abstractDataNode, int n) {
            this.mr[n].setName(resultNames[n]);
            this.mr[n].setHtmlName(htmlResultNames[n]);
            this.mr[n].setMatrixInfo(resultInfo[n]);
            if (n > 0) {
                this.mr[n].setVector(false);
            }
            abstractDataNode.addTreeNode(this.mr[n]);
        }

        public PLSpredictions(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
            super(randomInputStream, mapProperty, loadResultNames);
            this.Ypred = (MatrixContainer)mapProperty.resolveNodeFromName(randomInputStream, "Ypred");
        }

        @Override
        public Object[] getCompData(int n, boolean bl) {
            return null;
        }

        @Override
        public ModelMatrix getDModX() {
            return null;
        }

        @Override
        public ModelMatrix getHotellingT2() {
            return null;
        }

        public String getModelName() {
            return null;
        }

        public MatrixContainer getYpred() {
            return this.Ypred;
        }

        @Override
        public void removeLastRow() {
            this.Ypred.removeLastMatrix();
            super.removeLastRow();
        }

        @Override
        public void resetResults(AbstractDataNode abstractDataNode, AbstractDataMatrix abstractDataMatrix, AbstractDataMatrix abstractDataMatrix2) {
            super.resetResults(abstractDataNode, abstractDataMatrix, abstractDataMatrix2);
            this.mr[3].resize(abstractDataMatrix2);
            if (this.mr[7] != null) {
                this.mr[7].resize(abstractDataMatrix2);
            } else {
                this.mr[7] = new ModelMatrix(this.var, abstractDataMatrix2);
                this.initMatrix(abstractDataNode, 7);
            }
            if (this.mr[8] != null) {
                this.mr[8].resize(abstractDataMatrix2);
            } else {
                this.mr[8] = new ModelMatrix(this.var, abstractDataMatrix2);
                this.initMatrix(abstractDataNode, 8);
            }
            if (this.mr[9] != null) {
                this.mr[9].resize(abstractDataMatrix2);
            } else {
                this.mr[9] = new ModelMatrix(this.var, abstractDataMatrix2);
                this.initMatrix(abstractDataNode, 9);
            }
            this.mr[4].resize(abstractDataMatrix2);
            this.mr[5].resize(abstractDataMatrix2);
            this.Ypred.resize(abstractDataMatrix, PLSpredictionNode.this.getCMatrix());
        }

        @Override
        public void Save(RandomOutputStream randomOutputStream) throws IOException {
            this.save(randomOutputStream, resultNames);
            randomOutputStream.writePropertyNode("Ypred", this.Ypred);
        }

        @Override
        public void setSize(int n) {
            this.Ypred.setSize(n);
            super.setSize(n);
        }
    }
}

