/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model.PLS.bias;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import no.uib.cipr.matrix.DenseVector;
import se.prediktera.map.common.JTextFieldButtonUppDown;
import se.prediktera.map.common.JValidateNumberField;
import se.prediktera.map.common.cleanup.CleanUpDialog;
import se.prediktera.map.common.swing.JBoldLabel;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.MatrixContainer;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.model.AbstractPrediction;
import se.prediktera.mda.model.AnalysPredictionNode;
import se.prediktera.mda.model.PLS.PLSModel;

public class BiasDialog
extends CleanUpDialog {
    private static final double CONVCRITSQ = 1.0E-12;
    private static final int NITMAX = 200;
    private PLSModel plsModel;
    private final ArrayList<JTextFieldButtonUppDown> offsetArray = new ArrayList();
    private final ArrayList<JTextFieldButtonUppDown> scalefactorArray = new ArrayList();
    private final NumberChangedListener numberChanged = new NumberChangedListener();
    private JButton applyButton;
    private JPanel bottomPanel;
    private JButton calcBiasButton;
    private JButton closeButton;
    private JScrollPane jScrollPane1;
    private JButton okButton;
    private JButton resetButton;
    private JButton setBiasButton;
    private JPanel setPanel;
    private JPanel valuePanel;

    public static boolean showDialog(Window window, PLSModel pLSModel) {
        BiasDialog biasDialog = new BiasDialog(window, pLSModel);
        biasDialog.pack();
        biasDialog.setLocationRelativeTo(null);
        biasDialog.setVisible(true);
        return true;
    }

    public BiasDialog(Window window, PLSModel pLSModel) {
        super(window, "Bias-correction dialog");
        this.plsModel = pLSModel;
        this.setModal(true);
        this.initComponents();
        this.setPreferredSize(new Dimension(400, 350));
        this.updateBiasPanel();
        this.hasChanged(false);
    }

    public void setBiasValues() {
        ModelMatrix modelMatrix = (ModelMatrix)this.plsModel.getMatrixByName("C");
        double[] dArray = new double[modelMatrix.getK()];
        double[] dArray2 = new double[modelMatrix.getK()];
        for (int i = 0; i < dArray.length; ++i) {
            JTextFieldButtonUppDown jTextFieldButtonUppDown = this.offsetArray.get(i);
            dArray[i] = jTextFieldButtonUppDown.getNumber();
            JTextFieldButtonUppDown jTextFieldButtonUppDown2 = this.scalefactorArray.get(i);
            dArray2[i] = jTextFieldButtonUppDown2.getNumber();
        }
        this.plsModel.setOffset(dArray);
        this.plsModel.setScalefactor(dArray2);
        this.plsModel.setChanged();
        this.hasChanged(false);
    }

    @Override
    protected void cleanUpChild() {
        this.plsModel = null;
    }

    private void applyButtonActionPerformed(ActionEvent actionEvent) {
        this.setBiasValues();
    }

    private void calcBiasButtonActionPerformed(ActionEvent actionEvent) {
        AnalysPredictionNode analysPredictionNode = this.plsModel.getLocalPredictionNode();
        if (analysPredictionNode != null) {
            int n = this.plsModel.getYindex();
            MatrixContainer matrixContainer = (MatrixContainer)((AbstractPrediction)analysPredictionNode).getMatrixByName("Ypred");
            AbstractDataMatrix abstractDataMatrix = matrixContainer.getLastAbstractMatrix();
            DataSet dataSet = this.plsModel.getDataSet();
            AbstractDataMatrix abstractDataMatrix2 = dataSet.getMatrix(3);
            double[] dArray = this.plsModel.getOffset();
            double[] dArray2 = this.plsModel.getScalefactor();
            for (int i = 0; i < abstractDataMatrix.getK(); ++i) {
                int n2 = n < 0 ? i : n;
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                for (int j = 0; j < abstractDataMatrix.getN(); ++j) {
                    if (abstractDataMatrix2.isMissing(j, n2)) continue;
                    double d4 = abstractDataMatrix.getValue(j, i);
                    if (dArray != null) {
                        d4 -= dArray[i];
                    }
                    if (dArray2 != null) {
                        d4 /= dArray2[i];
                    }
                    double d5 = abstractDataMatrix2.getValue(j, n2);
                    d += d4;
                    d2 += d5;
                    d3 += 1.0;
                }
                d /= d3;
                d2 /= d3;
                double d6 = 0.0;
                double d7 = 0.0;
                for (int j = 0; j < abstractDataMatrix.getN(); ++j) {
                    if (abstractDataMatrix2.isMissing(j, n2)) continue;
                    double d8 = abstractDataMatrix.getValue(j, i);
                    if (dArray != null) {
                        d8 -= dArray[i];
                    }
                    if (dArray2 != null) {
                        d8 /= dArray2[i];
                    }
                    double d9 = abstractDataMatrix2.getValue(j, n2);
                    double d10 = d8 - d;
                    d6 += d10 * (d9 - d2);
                    d7 += d10 * d10;
                }
                double d11 = d6 / d7;
                double d12 = d2 - d11 * d;
                this.offsetArray.get(i).setNumber(d12);
                this.scalefactorArray.get(i).setNumber(d11);
            }
        }
        this.hasChanged(true);
    }

    private void closeButtonActionPerformed(ActionEvent actionEvent) {
        this.cleanUp();
    }

    private void hasChanged(boolean bl) {
        this.okButton.setEnabled(bl);
        this.applyButton.setEnabled(bl);
    }

    private void initComponents() {
        this.bottomPanel = new JPanel();
        this.okButton = new JButton();
        this.closeButton = new JButton();
        this.applyButton = new JButton();
        this.setPanel = new JPanel();
        this.setBiasButton = new JButton();
        this.resetButton = new JButton();
        this.calcBiasButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.valuePanel = new JPanel();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.bottomPanel.setLayout(new GridBagLayout());
        this.okButton.setText("OK");
        this.okButton.setPreferredSize(new Dimension(81, 26));
        this.okButton.addActionListener(actionEvent -> this.okButtonActionPerformed(actionEvent));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(6, 12, 12, 12);
        this.bottomPanel.add((Component)this.okButton, gridBagConstraints);
        this.closeButton.setText("Close");
        this.closeButton.setPreferredSize(new Dimension(81, 26));
        this.closeButton.addActionListener(actionEvent -> this.closeButtonActionPerformed(actionEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(6, 12, 12, 12);
        this.bottomPanel.add((Component)this.closeButton, gridBagConstraints);
        this.applyButton.setText("Apply");
        this.applyButton.setPreferredSize(new Dimension(81, 26));
        this.applyButton.addActionListener(actionEvent -> this.applyButtonActionPerformed(actionEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(6, 12, 12, 12);
        this.bottomPanel.add((Component)this.applyButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.bottomPanel, gridBagConstraints);
        this.setPanel.setBorder(BorderFactory.createEtchedBorder());
        this.setPanel.setLayout(new GridBagLayout());
        this.setBiasButton.setText("Set Bias");
        this.setBiasButton.addActionListener(actionEvent -> this.setBiasButtonActionPerformed(actionEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.setPanel.add((Component)this.setBiasButton, gridBagConstraints);
        this.resetButton.setText("Reset");
        this.resetButton.addActionListener(actionEvent -> this.resetButtonActionPerformed(actionEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.setPanel.add((Component)this.resetButton, gridBagConstraints);
        this.calcBiasButton.setText("Calc Bias");
        this.calcBiasButton.addActionListener(actionEvent -> this.calcBiasButtonActionPerformed(actionEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.setPanel.add((Component)this.calcBiasButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.setPanel, gridBagConstraints);
        this.jScrollPane1.setBorder(null);
        this.valuePanel.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.valuePanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        this.setBiasValues();
        Project_GUI project_GUI = this.plsModel.getProject_GUI();
        if (project_GUI != null) {
            project_GUI.setProjectChanged();
        }
        this.cleanUp();
    }

    private void resetButtonActionPerformed(ActionEvent actionEvent) {
        for (int i = 0; i < this.offsetArray.size(); ++i) {
            this.offsetArray.get(i).setNumber(0.0);
            this.scalefactorArray.get(i).setNumber(1.0);
        }
        this.hasChanged(true);
    }

    private void setBiasButtonActionPerformed(ActionEvent actionEvent) {
        AnalysPredictionNode analysPredictionNode = this.plsModel.getLocalPredictionNode();
        if (analysPredictionNode != null) {
            double[] dArray = this.plsModel.getOffset();
            ModelMatrix modelMatrix = (ModelMatrix)((AbstractPrediction)analysPredictionNode).getMatrixByName("Bias");
            if (modelMatrix != null) {
                DenseVector denseVector = modelMatrix.getLastRM();
                for (int i = 0; i < denseVector.size(); ++i) {
                    double d = -denseVector.get(i);
                    if (dArray != null) {
                        d += dArray[i];
                    }
                    this.offsetArray.get(i).setNumber(d);
                    this.scalefactorArray.get(i).setNumber(1.0);
                }
            }
        }
        this.hasChanged(true);
    }

    private void updateBiasPanel() {
        this.valuePanel.setLayout(new GridBagLayout());
        ModelMatrix modelMatrix = (ModelMatrix)this.plsModel.getMatrixByName("C");
        int n = modelMatrix.getK();
        String[] stringArray = new String[n];
        for (int i = 0; i < modelMatrix.getK(); ++i) {
            stringArray[i] = modelMatrix.getColumnDescription(i, 0);
        }
        double[] dArray = this.plsModel.getOffset();
        double[] dArray2 = this.plsModel.getScalefactor();
        int n2 = 0;
        int n3 = 0;
        this.valuePanel.add((Component)new JBoldLabel("Variable"), new GridBagConstraints(n3++, n2, 1, 1, 0.0, 0.0, 18, 2, new Insets(12, 12, 0, 0), 0, 0));
        this.valuePanel.add((Component)new JBoldLabel("Offset"), new GridBagConstraints(n3++, n2, 1, 1, 0.0, 0.0, 18, 2, new Insets(12, 12, 0, 0), 0, 0));
        this.valuePanel.add((Component)new JBoldLabel("Scale factor"), new GridBagConstraints(n3++, n2, 1, 1, 0.0, 0.0, 18, 2, new Insets(12, 12, 0, 0), 0, 0));
        ++n2;
        int n4 = 0;
        while (n4 < n) {
            String string = stringArray[n4];
            n3 = 0;
            this.valuePanel.add((Component)new JLabel(string), new GridBagConstraints(n3++, n2, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 12, 6, 0), 0, 0));
            JTextFieldButtonUppDown jTextFieldButtonUppDown = new JTextFieldButtonUppDown(true);
            this.offsetArray.add(jTextFieldButtonUppDown);
            jTextFieldButtonUppDown.setNumber(dArray != null ? dArray[n4] : 0.0);
            this.valuePanel.add((Component)jTextFieldButtonUppDown, new GridBagConstraints(n3++, n2, 1, 1, 1.0, 0.0, 10, 2, new Insets(6, 12, 0, 0), 0, 0));
            JTextFieldButtonUppDown jTextFieldButtonUppDown2 = new JTextFieldButtonUppDown(true);
            this.scalefactorArray.add(jTextFieldButtonUppDown2);
            jTextFieldButtonUppDown2.setNumber(dArray2 != null ? dArray2[n4] : 1.0);
            this.valuePanel.add((Component)jTextFieldButtonUppDown2, new GridBagConstraints(n3++, n2, 1, 1, 1.0, 0.0, 10, 2, new Insets(6, 12, 0, 12), 0, 0));
            jTextFieldButtonUppDown.setNumberChangedInterface(this.numberChanged);
            jTextFieldButtonUppDown2.setNumberChangedInterface(this.numberChanged);
            ++n4;
            ++n2;
        }
        this.valuePanel.add((Component)new JLabel(""), new GridBagConstraints(n3 - 1, n2, 1, 1, 1.0, 1.0, 10, 2, new Insets(6, 12, 0, 12), 0, 0));
    }

    private class NumberChangedListener
    implements JValidateNumberField.NumberChangedInterface {
        private NumberChangedListener() {
        }

        @Override
        public void NumberChanged(int n, double d) {
            BiasDialog.this.hasChanged(true);
        }
    }
}

