/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model.PLS.predictiontable;

import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.common.interaction.InteractionInterface;
import se.prediktera.map.data.AbstractDataTable;
import se.prediktera.map.data.DataInit;
import se.prediktera.map.data.DataTable;
import se.prediktera.map.data.SimpleTable;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.main.extclass.DataTreeExtLibInterface;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.main.window.AbstractWindowProperties;
import se.prediktera.map.model.AbstractPrediction;
import se.prediktera.map.model.predictiontable.SharedPredictionTable;
import se.prediktera.mda.model.PLS.PLSModel;
import se.prediktera.mda.model.PLS.PLSpredictionNode;
import se.prediktera.mda.model.PLS.predictiontable.PredictionProperties;
import se.prediktera.mda.model.PLS.predictiontable.PredictionTableModel;

public class PredictionTable
extends AbstractDataTable
implements DataTreeExtLibInterface {
    private static Color correctColor = new Color(0.4f, 1.0f, 0.4f);
    private static Color incorrectColor = new Color(1.0f, 0.4f, 0.4f);

    public PredictionTable(DataInit dataInit) {
        super(dataInit);
    }

    public PredictionTable(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
    }

    @Override
    public boolean doInteraction(InteractionInterface interactionInterface) {
        return false;
    }

    public double getCutOffHigh() {
        PredictionTableModel predictionTableModel = (PredictionTableModel)this.simpleTable.getModel();
        return predictionTableModel.getCutOffHigh();
    }

    public double getCutOffLow() {
        PredictionTableModel predictionTableModel = (PredictionTableModel)this.simpleTable.getModel();
        return predictionTableModel.getCutOffLow();
    }

    @Override
    public String getDefaultTitle() {
        return "Prediction Table";
    }

    @Override
    public ExtClassLoader.LicenseLibrary getLibrary() {
        return ExtClassLoader.LicenseLibrary.MDA;
    }

    @Override
    public String getGUI_Name() {
        if (this.dti != null) {
            return "Prediction Table (" + String.valueOf(this.dti) + ")";
        }
        return "Prediction Table";
    }

    @Override
    public String getInformation() {
        StringBuilder stringBuilder = new StringBuilder(470);
        stringBuilder.append("<HTML><BODY>");
        if (this.simpleTable != null) {
            stringBuilder.append("<B>Prediction Table - ").append(this).append("</B><br>");
            PLSModel pLSModel = this.getModel();
            if (pLSModel != null) {
                stringBuilder.append(pLSModel.getCase()).append("<br>");
            }
            stringBuilder.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
            stringBuilder.append("<TR><TD>Rows:</TD><TD>").append(this.simpleTable.getRowCount()).append("</TD></TR>");
            stringBuilder.append("<TR><TD>Columns:</TD><TD>").append(this.simpleTable.getColumnCount()).append("</TD></TR>");
            stringBuilder.append("<TR><TD>Selected rows:</TD><TD>").append(this.simpleTable.getSelectedRowCount()).append("</TD></TR>");
            stringBuilder.append("<TR><TD>Selected columns:</TD><TD>").append(this.simpleTable.getSelectedColumnCount()).append("</TD></TR>");
        }
        stringBuilder.append("</TABLE></BODY></HTML>");
        return stringBuilder.toString();
    }

    @Override
    public byte getNodeType() {
        return 5;
    }

    @Override
    public byte getTreeType() {
        return 7;
    }

    @Override
    public void prepareInteraction() {
        Object object;
        int[] nArray;
        int[] nArray2;
        byte by = this.getSelectionType();
        if (by == 3) {
            this.getInteractionArray(null, 1, 0, 0);
            this.simpleTable.clearSelection();
            return;
        }
        if (by == 1) {
            this.simpleTable.beginInteraction();
            if (this.simpleTable.getRowCount() > 0) {
                this.simpleTable.setRowSelectionInterval(0, this.simpleTable.getRowCount() - 1);
            }
            if (this.simpleTable.getColumnCount() > 0) {
                this.simpleTable.setColumnSelectionInterval(0, this.simpleTable.getColumnCount() - 1);
            }
            this.simpleTable.endInteraction();
        }
        if (by == 2) {
            Object object2;
            int n;
            nArray2 = this.getSelectedRows();
            nArray = this.getSelectedColumns();
            this.simpleTable.beginInteraction();
            if (this.simpleTable.getRowCount() > 0) {
                this.simpleTable.setRowSelectionInterval(0, this.simpleTable.getRowCount() - 1);
            }
            if (this.simpleTable.getColumnCount() > 0) {
                this.simpleTable.setColumnSelectionInterval(0, this.simpleTable.getColumnCount() - 1);
            }
            object = nArray2;
            int n2 = ((Object)object).length;
            for (n = 0; n < n2; ++n) {
                object2 = object[n];
                this.simpleTable.removeRowSelectionInterval((int)object2, (int)object2);
            }
            object = nArray;
            n2 = ((Object)object).length;
            for (n = 0; n < n2; ++n) {
                object2 = object[n];
                this.simpleTable.removeColumnSelectionInterval((int)object2, (int)object2);
            }
            this.simpleTable.endInteraction();
        }
        nArray2 = this.getSelectedRows();
        nArray = this.getSelectedColumns();
        object = (PredictionTableModel)this.simpleTable.getModel();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int n : nArray2) {
            for (int n3 : nArray) {
                List<Integer> list = ((PredictionTableModel)object).getObjects(n, n3);
                if (list == null) continue;
                arrayList.addAll(list);
            }
        }
        int n = arrayList.size() - 1;
        for (Integer n4 : arrayList) {
            if (n4 <= n) continue;
            n = n4;
        }
        InteractionArray interactionArray = this.getInteractionArray(DataTreeManager.getAncestor(this.dti), 1, ++n, 0);
        for (Integer n5 : arrayList) {
            interactionArray.set(n5);
        }
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
    }

    @Override
    public byte SendGlobalMessage(byte by, byte by2) {
        if (by == 0 && (this.dti == null || this.dti.isCleaned())) {
            this.cleanUp();
            return 2;
        }
        return 0;
    }

    public void setCutOffHigh(double d) {
        PredictionTableModel predictionTableModel = (PredictionTableModel)this.simpleTable.getModel();
        predictionTableModel.setCutOffHigh(d);
    }

    public void setCutOffLow(double d) {
        PredictionTableModel predictionTableModel = (PredictionTableModel)this.simpleTable.getModel();
        predictionTableModel.setCutOffLow(d);
    }

    protected DefaultTableCellRenderer createDefaultRenderer() {
        return new CustomTableCellRenderer();
    }

    @Override
    protected AbstractWindowProperties createProperties() {
        return new PredictionProperties(this);
    }

    @Override
    protected SimpleTable createSimpleTable() {
        SimpleTable simpleTable = super.createSimpleTable();
        simpleTable.setCellSelectionEnabled(true);
        if (this.dti instanceof PLSModel) {
            simpleTable.setModel(this.createTableModel(((PLSModel)this.dti).getLocalPredictionNode()));
        } else {
            simpleTable.setModel(this.createTableModel((AbstractPrediction)this.dti));
        }
        simpleTable.setDefaultRenderer(String.class, this.createDefaultRenderer());
        if (simpleTable instanceof DataTable) {
            ((DataTable)simpleTable).getFixedTable(1).getTable().removeColListener();
        }
        return simpleTable;
    }

    protected PredictionTableModel createTableModel(AbstractPrediction abstractPrediction) {
        return new PredictionTableModel(this, abstractPrediction);
    }

    private PLSModel getModel() {
        if (this.dti instanceof PLSModel) {
            return (PLSModel)this.dti;
        }
        if (this.dti instanceof PLSpredictionNode) {
            return (PLSModel)((PLSpredictionNode)this.dti).getModel();
        }
        return null;
    }

    private class CustomTableCellRenderer
    extends DefaultTableCellRenderer {
        private CustomTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            String string = String.valueOf(object);
            component.setForeground(Color.black);
            PredictionTableModel predictionTableModel = (PredictionTableModel)jTable.getModel();
            SharedPredictionTable<Integer> sharedPredictionTable = predictionTableModel.getPredictionTable();
            if (bl) {
                component.setBackground(jTable.getSelectionBackground());
                component.setForeground(jTable.getSelectionForeground());
            } else {
                component.setBackground(Color.white);
                if (sharedPredictionTable != null) {
                    if (sharedPredictionTable.hasActual()) {
                        if (n < sharedPredictionTable.getNumberClasses() - 1) {
                            if (n == n2 - 1) {
                                component.setBackground(correctColor);
                            } else if (n2 > 0 && string.length() > 0) {
                                component.setBackground(incorrectColor);
                            }
                        } else if (n == sharedPredictionTable.getNumberClasses()) {
                            component.setBackground(Color.orange);
                        }
                    } else {
                        component.setBackground(Color.orange);
                    }
                }
            }
            return component;
        }
    }
}

