/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model.PLS.predictiontable;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.common.wizard.AbstractInit;
import se.prediktera.map.data.DataInit;
import se.prediktera.map.data.tablegenerator.AbstractTableInfo;
import se.prediktera.map.data.tablegenerator.TableGeneratorWizard;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.main.window.AbstractWindow;
import se.prediktera.map.main.window.AbstractWindow_GUI;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.AbstractPrediction;
import se.prediktera.map.model.PredictionHelper;
import se.prediktera.mda.model.PLS.predictiontable.PredictionTable;
import se.prediktera.mda.model.PLSDA.PLSDAModel;
import se.prediktera.mda.model.SIMCA.SIMCAModel;

public class PredictionTableInfo
extends AbstractTableInfo {
    private final ImageIcon imageIcon = new ImageIcon(TableGeneratorWizard.class.getResource("images/quicktable.gif"));
    private JPanel predictionPanel = new JPanel(new GridBagLayout());
    private final JComboBox predictionComboBox = new JComboBox();

    @Override
    public void beginWizard(DataTreeInterface dataTreeInterface) {
        this.predictionComboBox.removeAllItems();
        PredictionHelper.addPredictionToComboBox(dataTreeInterface, this.predictionComboBox);
        this.predictionComboBox.setEnabled(this.predictionComboBox.getItemCount() > 1);
    }

    @Override
    public AbstractWindow createWindow(AbstractWindow_GUI abstractWindow_GUI, AbstractInit abstractInit) {
        if (this.predictionComboBox.getItemCount() == 0) {
            PredictionHelper.addPredictionToComboBox(abstractInit.getDataTreeInterface(), this.predictionComboBox);
        }
        abstractInit.setDataTreeInterface((DataTreeInterface)this.predictionComboBox.getSelectedItem());
        super.createWindow(abstractWindow_GUI, abstractInit);
        PredictionTable predictionTable = this.createTable((DataInit)abstractInit);
        this.applySettings(predictionTable);
        return predictionTable;
    }

    @Override
    public Vector<JComponent> createWizard() {
        Vector<JComponent> vector = super.createWizard();
        this.predictionPanel.setBorder(EvinceBorderFactory.createEvinceBorder("Choose prediction"));
        this.predictionPanel.add((Component)new JLabel("Prediction:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 6, 0), 0, 0));
        this.predictionPanel.add((Component)this.predictionComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(6, 6, 6, 12), 0, 0));
        vector.add(0, this.predictionPanel);
        return vector;
    }

    @Override
    public ImageIcon getWizardImage() {
        return this.imageIcon;
    }

    @Override
    public String getWizardInfo() {
        return "This is a prediction table of the chosen prediction.";
    }

    @Override
    public boolean supportData(DataTreeInterface dataTreeInterface) {
        AbstractModel abstractModel = null;
        if (dataTreeInterface instanceof AbstractModel) {
            abstractModel = (AbstractModel)dataTreeInterface;
        } else if (dataTreeInterface instanceof AbstractPrediction) {
            abstractModel = ((AbstractPrediction)dataTreeInterface).getModel();
        }
        if (abstractModel instanceof PLSDAModel || abstractModel instanceof SIMCAModel) {
            return PredictionHelper.getPredictions(dataTreeInterface).size() > 0;
        }
        return false;
    }

    @Override
    public String toString() {
        return "Prediction Table";
    }

    @Override
    protected void cleanUpChild() {
        if (this.predictionPanel != null) {
            this.predictionPanel = null;
        }
        this.predictionComboBox.removeAllItems();
    }

    protected PredictionTable createTable(DataInit dataInit) {
        return new PredictionTable(dataInit);
    }
}

