/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model.PLS.predictiontable;

import java.util.List;
import no.uib.cipr.matrix.DenseVector;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.data.SimpleTableModel;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.AbstractMVmatrix;
import se.prediktera.map.datasetcontainer.matrix.TransformedReferenceMatrix;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.AbstractPrediction;
import se.prediktera.map.model.ModelListener;
import se.prediktera.map.model.predictiontable.SharedPredictionTable;
import se.prediktera.mda.model.PLS.PLSModel;
import se.prediktera.mda.model.PLS.PLSpredictionNode;
import se.prediktera.mda.model.PLS.predictiontable.PredictionTable;
import se.prediktera.mda.model.SIMCA.SIMCApredictionNode;

public class PredictionTableModel
extends SimpleTableModel
implements ModelListener {
    protected final AbstractModel model;
    protected final AbstractPrediction predictionNode;
    private SharedPredictionTable<Integer> predictionTable;
    protected boolean showQuantification = false;
    protected double[] quantification;
    protected boolean hasNonClassifiedByUser = false;
    protected boolean hasNonClassifiedInClassTypes = false;
    protected boolean belongsToDataSet;
    protected PredictionTable table;
    protected boolean needcalculate = false;

    public PredictionTableModel(PredictionTable predictionTable, AbstractPrediction abstractPrediction) {
        super(null, 1, 1, false);
        this.table = predictionTable;
        this.predictionNode = abstractPrediction;
        this.model = abstractPrediction.getModel();
        if (this.model != null) {
            this.model.addModelListener(this);
        }
        if (abstractPrediction.getDataSet() != null) {
            abstractPrediction.getDataSet().getObsDataInfo().addListener(dataInfoEvent -> {
                if (dataInfoEvent.getType() == 7) {
                    this.calculateValues();
                }
                return true;
            });
        }
        this.needcalculate = true;
    }

    @Override
    public void cleanUpChild() {
        if (this.model != null) {
            this.model.removeModelListener(this);
        }
        super.cleanUpChild();
    }

    public double getCutOffHigh() {
        return this.model.getCutOffHigh();
    }

    public double getCutOffLow() {
        return this.model.getCutOffLow();
    }

    @Override
    public FastDecimal getDoubleAt_Transpose_Sort(int n, int n2, FastDecimal fastDecimal) {
        return null;
    }

    public AbstractModel getModel() {
        return this.model;
    }

    public List<Integer> getObjects(int n, int n2) {
        if (this.showQuantification) {
            return null;
        }
        if (this.predictionTable.hasActual()) {
            if (n < this.predictionTable.getNumberClasses() - 1 || n == this.predictionTable.getNumberClasses()) {
                return this.predictionTable.getObject(n, n2);
            }
            if (n2 == 0 && n == this.predictionTable.getNumberClasses() + 1) {
                return this.predictionTable.getCorrectlyObjects();
            }
            if (n2 == 0 && n == this.predictionTable.getNumberClasses() + 2) {
                return this.predictionTable.getIncorrectlyObjects();
            }
        } else {
            return this.predictionTable.getObject(this.predictionTable.getNumberClasses(), n2);
        }
        return null;
    }

    @Override
    public String getRowDescription(int n, int n2) {
        if (n2 == 0) {
            return "Total";
        }
        if (n2 == this.getColumnCount() - 1 && !this.hasNonClassifiedInClassTypes) {
            return "No class";
        }
        return this.getSubClassDescription(n2 - 1, n, false);
    }

    @Override
    public String getColumnDescription(int n, int n2) {
        if (this.showQuantification) {
            return this.getSubClassDescription(n, n2, true);
        }
        if (this.predictionTable != null && this.predictionTable.hasActual()) {
            if (n < this.predictionTable.getNumberClasses() - 1) {
                return this.getSubClassDescription(n, n2, true);
            }
            if (n == this.predictionTable.getNumberClasses()) {
                return "# Predicted";
            }
            if (n == this.predictionTable.getNumberClasses() + 1) {
                return " - Correctly";
            }
            if (n == this.predictionTable.getNumberClasses() + 2) {
                return " - Incorrectly";
            }
        } else {
            return "# Predicted";
        }
        return "";
    }

    @Override
    public String getRowDescriptionTitle(int n) {
        return "Classes";
    }

    @Override
    public Object getValueAt_Sort(int n, int n2) {
        if (this.needcalculate) {
            this.calculateValues();
        }
        if (this.showQuantification) {
            return NiceDataFormat.toString(this.quantification[n]);
        }
        if (this.predictionTable == null) {
            return "";
        }
        if (this.predictionTable.hasActual()) {
            if (n < this.predictionTable.getNumberClasses() - 1) {
                if (n2 == 0) {
                    return this.format(this.predictionTable.get(n), this.predictionTable.getTotal());
                }
                int n3 = this.predictionTable.get(n, n2 - 1);
                if (n3 > 0) {
                    return this.format(n3, this.predictionTable.get(n));
                }
                return "";
            }
            if (n == this.predictionTable.getNumberClasses() - 1) {
                return "";
            }
            if (n == this.predictionTable.getNumberClasses()) {
                if (n2 == 0) {
                    return this.format(this.predictionTable.getTotal(), this.predictionTable.getTotal());
                }
                return this.format(this.predictionTable.getTotal(n2 - 1), this.predictionTable.getTotal());
            }
            if (n2 == 0 && n == this.predictionTable.getNumberClasses() + 1) {
                return this.format(this.predictionTable.getCorrectly(), this.predictionTable.getTotal());
            }
            if (n2 == 0 && n == this.predictionTable.getNumberClasses() + 2) {
                return this.format(this.predictionTable.getTotal() - this.predictionTable.getCorrectly(), this.predictionTable.getTotal());
            }
        } else {
            if (n2 == 0) {
                return this.format(this.predictionTable.getTotal(), this.predictionTable.getTotal());
            }
            return this.format(this.predictionTable.getTotal(n2 - 1), this.predictionTable.getTotal());
        }
        return "";
    }

    @Override
    public void modelUpdated() {
        this.calculateValues();
    }

    public void setCutOffHigh(double d) {
        this.model.setCutOffHigh(d);
        this.needcalculate = true;
    }

    public void setCutOffLow(double d) {
        this.model.setCutOffLow(d);
        this.needcalculate = true;
    }

    @Override
    public void setValueAt_Sort(Object object, int n, int n2) {
    }

    protected boolean belongsToModelDataSet() {
        if (this.model != null) {
            return this.predictionNode.getDataSet().equals(this.model.getDataSet());
        }
        return false;
    }

    protected void calculateValues() {
        if (this.predictionNode instanceof PLSpredictionNode) {
            this.calculateValuesFromPLS();
        } else if (this.predictionNode instanceof SIMCApredictionNode) {
            this.calculateValuesFromInnerColumn();
        }
        this.needcalculate = false;
    }

    @Override
    protected int getColumnDescriptionCountInternal() {
        return 1;
    }

    @Override
    protected int getRowDescriptionCountInternal() {
        return 1;
    }

    private void calculateValuesFromInnerColumn() {
        InnerColumnClass innerColumnClass = ((SIMCApredictionNode)this.predictionNode).getInnerColumnClass();
        if (innerColumnClass == null) {
            this.rows = 0;
            this.columns = 0;
            this.table.fireTableStructureChanged();
            return;
        }
        ClassTypes classTypes = innerColumnClass.getObject();
        int n = classTypes.size();
        this.columns = n + 1;
        this.rows = 1;
        this.hasNonClassifiedByUser = false;
        this.hasNonClassifiedInClassTypes = true;
        this.belongsToDataSet = this.belongsToModelDataSet();
        InnerColumnClass innerColumnClass2 = null;
        try {
            innerColumnClass2 = this.belongsToDataSet ? this.model.getDataSet().getCategory(this.getCategoryName(innerColumnClass)) : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.predictionNode.beginCalculations();
        AbstractDataMatrix abstractDataMatrix = this.predictionNode.getDataSetMatrixToPredictInX();
        int[] nArray = abstractDataMatrix.getNref();
        this.predictionTable = new SharedPredictionTable(n + 1, n + 1);
        if (innerColumnClass2 != null) {
            int n2;
            ClassTypes classTypes2 = innerColumnClass2.getObject();
            int[] nArray2 = new int[classTypes2.size()];
            for (n2 = 0; n2 < nArray2.length; ++n2) {
                nArray2[n2] = classTypes.getTypeDescriptionIndex(classTypes2.getTypeDescription(n2));
            }
            this.rows = n + 4;
            for (n2 = 0; n2 < abstractDataMatrix.getN(); ++n2) {
                this.predictionTable.add(innerColumnClass.getValueShort(nArray[n2]), nArray2[innerColumnClass2.getValueShort(nArray[n2])], nArray[n2]);
            }
        } else {
            for (int i = 0; i < abstractDataMatrix.getN(); ++i) {
                this.predictionTable.add(innerColumnClass.getValueShort(nArray[i]), nArray[i]);
            }
        }
        this.predictionNode.endCalculations();
        this.table.fireTableStructureChanged();
    }

    private String getCategoryName(InnerColumnClass innerColumnClass) {
        int n = innerColumnClass.getName().indexOf("(");
        if (n > 0) {
            return innerColumnClass.getName().substring(n + 1, innerColumnClass.getName().length() - 1);
        }
        return "";
    }

    private void calculateValuesFromPLS() {
        boolean bl;
        PLSpredictionNode pLSpredictionNode = (PLSpredictionNode)this.predictionNode;
        if (pLSpredictionNode == null || pLSpredictionNode.isCleaned()) {
            return;
        }
        AbstractDataMatrix abstractDataMatrix = pLSpredictionNode.getDataSetMatrixToPredictInX();
        AbstractMVmatrix abstractMVmatrix = pLSpredictionNode.getYpredLastMatrix();
        if (abstractMVmatrix == null) {
            this.columns = 0;
            this.rows = 0;
            this.table.fireTableStructureChanged();
            return;
        }
        int n = abstractMVmatrix.getK();
        int n2 = abstractMVmatrix.getN();
        int n3 = n;
        this.columns = n3 + 2;
        this.rows = n3 + 4;
        this.hasNonClassifiedByUser = false;
        this.belongsToDataSet = this.belongsToModelDataSet();
        TransformedReferenceMatrix transformedReferenceMatrix = null;
        if (this.model.getDataSet() != null) {
            transformedReferenceMatrix = ((PLSModel)this.model).getTransformedMatrix((byte)3);
            transformedReferenceMatrix.beginCalculations();
        }
        this.predictionNode.beginCalculations();
        boolean bl2 = bl = transformedReferenceMatrix == null || transformedReferenceMatrix.getK() == 0;
        if (!bl) {
            for (int i = 0; i < n2; ++i) {
                int n4 = -1;
                for (int j = 0; j < transformedReferenceMatrix.getK(); ++j) {
                    if (!(transformedReferenceMatrix.getValue(i, j) > 0.0)) continue;
                    n4 = j;
                    break;
                }
                if (!this.belongsToDataSet || n4 >= 0) continue;
                this.hasNonClassifiedByUser = true;
                ++this.columns;
                break;
            }
        }
        if (bl || !this.belongsToDataSet) {
            this.rows = 1;
        }
        this.predictionTable = new SharedPredictionTable(n3 + 1, n3 + 1);
        int[] nArray = abstractDataMatrix.getNref();
        double d = this.model.getCutOffLow();
        double d2 = this.model.getCutOffHigh();
        boolean bl3 = this.model.isUseDcrit();
        double d3 = this.model.getDcritX();
        DenseVector denseVector = null;
        if (bl3 && pLSpredictionNode.getDModX() != null) {
            denseVector = pLSpredictionNode.getDModX().getLastRM();
        }
        if (bl || !this.belongsToModelDataSet()) {
            for (int i = 0; i < n2; ++i) {
                int n5 = n3;
                if (denseVector == null || denseVector.get(i) < d3) {
                    double d4 = d;
                    for (int j = 0; j < n3; ++j) {
                        double d5 = abstractMVmatrix.getValue(i, j);
                        if (!(d5 > d4) || !(d5 < d2)) continue;
                        d4 = d5;
                        n5 = j;
                    }
                }
                this.predictionTable.add(n5, nArray != null && i < nArray.length ? nArray[i] : i);
            }
        } else {
            int n6 = transformedReferenceMatrix.getK();
            for (int i = 0; i < n2; ++i) {
                int n7;
                int n8 = -1;
                for (n7 = 0; n7 < n6; ++n7) {
                    if (!(transformedReferenceMatrix.getValue(i, n7) > 0.0)) continue;
                    n8 = n7;
                    break;
                }
                if (n8 < 0) {
                    n8 = n3;
                }
                n7 = n;
                if (denseVector == null || denseVector.get(i) < d3) {
                    double d6 = d;
                    for (int j = 0; j < n; ++j) {
                        double d7 = abstractMVmatrix.getValue(i, j);
                        if (!(d7 > d6) || !(d7 < d2)) continue;
                        d6 = d7;
                        n7 = j;
                    }
                }
                this.predictionTable.add(n8, n7, nArray[i]);
            }
        }
        if (transformedReferenceMatrix != null) {
            transformedReferenceMatrix.endCalculations();
        }
        this.predictionNode.endCalculations();
        this.table.fireTableStructureChanged();
    }

    private String format(int n, int n2) {
        return n + " (" + NiceDataFormat.toPercent((double)n / (double)n2) + ")";
    }

    private String getSubClassDescription(int n, int n2, boolean bl) {
        if (this.predictionNode == null || this.predictionNode.isCleaned()) {
            return "N/A";
        }
        if (bl && this.predictionNode instanceof PLSpredictionNode) {
            AbstractMVmatrix abstractMVmatrix = ((PLSpredictionNode)this.predictionNode).getYpredLastMatrix();
            if (abstractMVmatrix != null) {
                String string = ((AbstractDataMatrix)abstractMVmatrix).getColumnDescription(n, n2);
                string = string.substring(string.indexOf(":") + 2);
                return string.substring(0, string.lastIndexOf("."));
            }
            return "N/A";
        }
        if (this.predictionNode instanceof PLSpredictionNode && this.model != null) {
            TransformedReferenceMatrix transformedReferenceMatrix = ((PLSModel)this.model).getTransformedMatrix((byte)2);
            String string = ((AbstractDataMatrix)transformedReferenceMatrix).getColumnDescription(n, n2);
            return string.substring(string.indexOf(":") + 2);
        }
        InnerColumnClass innerColumnClass = ((SIMCApredictionNode)this.predictionNode).getInnerColumnClass();
        return innerColumnClass.getObject().getTypeDescription(n);
    }

    public SharedPredictionTable<Integer> getPredictionTable() {
        return this.predictionTable;
    }
}

