/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model.PLS.predictiontable.quantification;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.cleanup.CleanUpInterface;
import se.prediktera.map.data.DataInit;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.model.AbstractPrediction;
import se.prediktera.mda.model.PLS.PLSModel;
import se.prediktera.mda.model.PLS.PLSpredictionNode;
import se.prediktera.mda.model.PLS.predictiontable.PredictionTable;
import se.prediktera.mda.model.PLS.predictiontable.PredictionTableModel;
import se.prediktera.mda.model.PLS.predictiontable.quantification.QuantificationTableModel;

public class QuantificationTable
extends PredictionTable {
    public QuantificationTable(DataInit dataInit) {
        super(dataInit);
        this.simpleTable.setColumnSelectionAllowed(false);
        this.simpleTable.setSelectionMode(0);
    }

    public QuantificationTable(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.simpleTable.setColumnSelectionAllowed(false);
        this.simpleTable.setSelectionMode(0);
    }

    @Override
    public boolean addToPopup(Project_GUI project_GUI, DataTreeInterface dataTreeInterface, Point point, JPopupMenu jPopupMenu, boolean bl) {
        CleanUpInterface cleanUpInterface;
        super.addToPopup(project_GUI, dataTreeInterface, point, jPopupMenu, bl);
        final int n = this.simpleTable.rowAtPoint(point);
        if (n >= 0 && (cleanUpInterface = this.dti) instanceof PLSpredictionNode) {
            PLSpredictionNode pLSpredictionNode = (PLSpredictionNode)cleanUpInterface;
            cleanUpInterface = (QuantificationTableModel)this.simpleTable.getModel();
            final PLSModel pLSModel = (PLSModel)pLSpredictionNode.getModel();
            final DataSet dataSet = pLSModel.getDataSet();
            final String string = ((PredictionTableModel)cleanUpInterface).getColumnDescription(n, 0);
            final double[] dArray = ((QuantificationTableModel)cleanUpInterface).getQuantification();
            jPopupMenu.addSeparator();
            jPopupMenu.add(new CMenuItem(this, "Set Scale Factor"){
                final /* synthetic */ QuantificationTable this$0;
                {
                    this.this$0 = quantificationTable;
                    super(object);
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object object;
                    double[] dArray2 = pLSModel.getScalefactor();
                    if (dArray2 == null) {
                        dArray2 = new double[dArray.length];
                        Arrays.fill(dArray2, 1.0);
                    }
                    if ((object = JOptionPane.showInputDialog(this.this$0, "Set Scale Factor for \"" + string + "\"", "Scale Factor", 3, null, null, NiceDataFormat.toString(dArray2[n]))) != null) {
                        dArray2[n] = NiceDataFormat.toNumber(object.toString());
                        pLSModel.setScalefactor(dArray2);
                        this.this$0.simpleTable.repaint();
                        if (dataSet != null) {
                            dataSet.setChangedAskApplyChanges();
                        }
                    }
                }
            });
            jPopupMenu.add(new CMenuItem(this, "Set Offset"){
                final /* synthetic */ QuantificationTable this$0;
                {
                    this.this$0 = quantificationTable;
                    super(object);
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object object;
                    double[] dArray2 = pLSModel.getOffset();
                    if (dArray2 == null) {
                        dArray2 = new double[dArray.length];
                        Arrays.fill(dArray2, 0.0);
                    }
                    if ((object = JOptionPane.showInputDialog(this.this$0, "Set Offset for \"" + string + "\"", "Offset", 3, null, null, NiceDataFormat.toString(dArray2[n]))) != null) {
                        dArray2[n] = NiceDataFormat.toNumber(object.toString());
                        pLSModel.setOffset(dArray2);
                        this.this$0.simpleTable.repaint();
                        if (dataSet != null) {
                            dataSet.setChangedAskApplyChanges();
                        }
                    }
                }
            });
            jPopupMenu.add(new CMenuItem(this, "Set Expected Quantification Value"){
                final /* synthetic */ QuantificationTable this$0;
                {
                    this.this$0 = quantificationTable;
                    super(object);
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object object;
                    double[] dArray2 = pLSModel.getScalefactor();
                    if (dArray2 == null) {
                        dArray2 = new double[dArray.length];
                        Arrays.fill(dArray2, 1.0);
                    }
                    if ((object = JOptionPane.showInputDialog(this.this$0, "Set Expected Quantification Value for \"" + string + "\"", "Expected Quantification Value", 3, null, null, NiceDataFormat.toString(dArray[n] * dArray2[n]))) != null) {
                        double d = NiceDataFormat.toNumber(object.toString());
                        dArray2[n] = d / dArray[n];
                        pLSModel.setScalefactor(dArray2);
                        this.this$0.simpleTable.repaint();
                        if (dataSet != null) {
                            dataSet.setChangedAskApplyChanges();
                        }
                    }
                }
            });
        }
        return true;
    }

    @Override
    public String getGUI_Name() {
        if (this.dti != null) {
            return "Quantification Table (" + String.valueOf(this.dti) + ")";
        }
        return "Quantification Table";
    }

    @Override
    public byte getTreeType() {
        return 17;
    }

    @Override
    public void prepareInteraction() {
    }

    @Override
    protected DefaultTableCellRenderer createDefaultRenderer() {
        return new CustomTableCellRenderer();
    }

    @Override
    protected PredictionTableModel createTableModel(AbstractPrediction abstractPrediction) {
        return new QuantificationTableModel(this, abstractPrediction);
    }

    private class CustomTableCellRenderer
    extends DefaultTableCellRenderer {
        private CustomTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            component.setForeground(Color.black);
            if (bl) {
                component.setBackground(jTable.getSelectionBackground());
                component.setForeground(jTable.getSelectionForeground());
            } else {
                component.setBackground(Color.white);
            }
            return component;
        }
    }
}

