/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model.PLS.predictiontable.quantification;

import no.uib.cipr.matrix.DenseVector;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.datasetcontainer.matrix.AbstractMVmatrix;
import se.prediktera.map.datasetcontainer.matrix.TransformedReferenceMatrix;
import se.prediktera.map.model.AbstractPrediction;
import se.prediktera.mda.model.PLS.PLSModel;
import se.prediktera.mda.model.PLS.PLSpredictionNode;
import se.prediktera.mda.model.PLS.predictiontable.PredictionTable;
import se.prediktera.mda.model.PLS.predictiontable.PredictionTableModel;
import se.prediktera.mda.model.SIMCA.SIMCApredictionNode;

public class QuantificationTableModel
extends PredictionTableModel {
    public QuantificationTableModel(PredictionTable predictionTable, AbstractPrediction abstractPrediction) {
        super(predictionTable, abstractPrediction);
    }

    public double[] getQuantification() {
        return this.quantification;
    }

    @Override
    public String getRowDescription(int n, int n2) {
        return switch (n2) {
            case 0 -> "Mean value of Prediction";
            case 1 -> "Scale factor";
            case 2 -> "Offset";
            case 3 -> "Quantification value";
            case 4 -> "Expected Concentration";
            default -> "";
        };
    }

    @Override
    public Object getValueAt_Sort(int n, int n2) {
        if (this.needcalculate) {
            this.calculateValues();
        }
        if (this.quantification == null) {
            return "N/A";
        }
        PLSpredictionNode pLSpredictionNode = (PLSpredictionNode)this.predictionNode;
        PLSModel pLSModel = (PLSModel)pLSpredictionNode.getModel();
        double[] dArray = pLSModel.getScalefactor();
        double[] dArray2 = pLSModel.getOffset();
        if (n2 == 0) {
            return NiceDataFormat.toString(this.quantification[n]);
        }
        if (n2 == 1) {
            if (dArray != null) {
                return NiceDataFormat.toString(dArray[n]);
            }
            return "1";
        }
        if (n2 == 2) {
            if (dArray2 != null) {
                return NiceDataFormat.toString(dArray2[n]);
            }
            return "0";
        }
        double d = this.quantification[n];
        if (dArray != null) {
            d *= dArray[n];
        }
        return NiceDataFormat.toString(d);
    }

    @Override
    protected void calculateValues() {
        if (this.predictionNode instanceof PLSpredictionNode) {
            this.calculateValuesFromPLSquantification();
        } else if (this.predictionNode instanceof SIMCApredictionNode) {
            // empty if block
        }
        this.needcalculate = false;
    }

    private void calculateValuesFromPLSquantification() {
        int n;
        PLSpredictionNode pLSpredictionNode = (PLSpredictionNode)this.predictionNode;
        AbstractMVmatrix abstractMVmatrix = pLSpredictionNode.getYpredLastMatrix();
        if (abstractMVmatrix == null) {
            this.columns = 0;
            this.rows = 0;
            this.table.fireTableStructureChanged();
            return;
        }
        boolean bl = pLSpredictionNode.isScaled();
        this.showQuantification = true;
        int n2 = abstractMVmatrix.getK();
        int n3 = abstractMVmatrix.getN();
        int n4 = n2;
        this.columns = 4;
        this.rows = n4;
        this.hasNonClassifiedByUser = false;
        TransformedReferenceMatrix transformedReferenceMatrix = null;
        if (this.model.getDataSet() != null) {
            transformedReferenceMatrix = ((PLSModel)this.model).getTransformedMatrix((byte)3);
            transformedReferenceMatrix.beginCalculations();
        }
        boolean bl2 = this.model.isUseDcrit();
        double d = this.model.getDcritX();
        DenseVector denseVector = null;
        if (bl2 && pLSpredictionNode.getDModX() != null) {
            denseVector = pLSpredictionNode.getDModX().getLastRM();
        }
        double[] dArray = ((PLSModel)this.model).getScalefactor();
        double[] dArray2 = ((PLSModel)this.model).getOffset();
        this.quantification = new double[this.rows];
        int n5 = 0;
        for (n = 0; n < n3; ++n) {
            if (denseVector != null && !(denseVector.get(n) < d)) continue;
            int n6 = 0;
            while (n6 < n4) {
                double d2 = abstractMVmatrix.getValue(n, n6);
                if (bl) {
                    if (dArray2 != null) {
                        d2 -= dArray2[n6];
                    }
                    if (dArray != null) {
                        d2 /= dArray[n6];
                    }
                }
                int n7 = n6++;
                this.quantification[n7] = this.quantification[n7] + d2;
            }
            ++n5;
        }
        if (n5 > 0) {
            n = 0;
            while (n < n4) {
                int n8 = n++;
                this.quantification[n8] = this.quantification[n8] / (double)n5;
            }
        }
        if (transformedReferenceMatrix != null) {
            transformedReferenceMatrix.endCalculations();
        }
        this.predictionNode.endCalculations();
        this.table.fireTableStructureChanged();
    }
}

