/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model.PLSDA;

import java.io.IOException;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import se.prediktera.map.common.CMenu;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.mda.model.AnalysPredictionNode;
import se.prediktera.mda.model.PLS.PLSModel;
import se.prediktera.mda.model.PLS.PLSpredictionNode;

public class PLSDAModel
extends PLSModel {
    private String categoryName = null;
    private double cutOffLow = 0.5;
    private double cutOffHigh = 1.5;
    private double[][] meanZeroArray;
    private double[][] stdZeroArray;
    private double[][] meanOneArray;
    private double[][] stdOneArray;

    public PLSDAModel(ProgressManager progressManager, DataSet dataSet, int[] nArray, int[] nArray2, boolean bl, String string) {
        super(progressManager, dataSet, nArray, nArray2, bl);
        this.categoryName = string;
    }

    public PLSDAModel(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.categoryName = mapProperty.getPropertyStringUTF("className");
        this.cutOffLow = mapProperty.getPropertyDouble("cutOffLow", 0.5);
        this.cutOffHigh = mapProperty.getPropertyDouble("cutOffHigh", 1.5);
    }

    @Override
    public String getClassName() {
        return this.categoryName;
    }

    @Override
    public double getCutOffHigh() {
        return this.cutOffHigh;
    }

    @Override
    public double getCutOffLow() {
        return this.cutOffLow;
    }

    public InnerColumnClass getInnerColumnClass() {
        return this.getClassByName(this.categoryName);
    }

    public double[][] getMeanOneArray() {
        return this.meanOneArray;
    }

    public double[][] getMeanZeroArray() {
        return this.meanZeroArray;
    }

    @Override
    public String getModelName() {
        return "PLS-DA";
    }

    public double[][] getStdOneArray() {
        return this.stdOneArray;
    }

    public double[][] getStdZeroArray() {
        return this.stdZeroArray;
    }

    @Override
    public byte getTreeType() {
        return 9;
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyStringUTF("className", this.categoryName);
        randomOutputStream.writePropertyDouble("cutOffLow", this.cutOffLow);
        randomOutputStream.writePropertyDouble("cutOffHigh", this.cutOffHigh);
    }

    @Override
    public void set(String string, Double d) {
        if (string.equalsIgnoreCase("cutOffLow")) {
            this.cutOffLow = d;
        } else if (string.equalsIgnoreCase("cutOffHigh")) {
            this.cutOffHigh = d;
        } else {
            super.set(string, d);
        }
    }

    @Override
    public void setCutOffHigh(double d) {
        this.cutOffHigh = d;
    }

    @Override
    public void setCutOffLow(double d) {
        this.cutOffLow = d;
    }

    @Override
    public void setDcritX(double d) {
        super.setDcritX(d);
    }

    @Override
    protected void modelCutoffChanged() {
        super.modelCutoffChanged();
        this.updatePLSDAclassification();
    }

    public void setMeanOneArray(double[][] dArray) {
        this.meanOneArray = dArray;
    }

    public void setMeanZeroArray(double[][] dArray) {
        this.meanZeroArray = dArray;
    }

    public void setStdOneArray(double[][] dArray) {
        this.stdOneArray = dArray;
    }

    public void setStdZeroArray(double[][] dArray) {
        this.stdZeroArray = dArray;
    }

    public void updatePLSDAclassification() {
        List<AnalysPredictionNode> list = this.getAllPredictionNodes();
        for (PLSpredictionNode pLSpredictionNode : list) {
            pLSpredictionNode.createPredictionClasses();
        }
        this.fireUpdatedEvent();
    }

    @Override
    protected void addModelSpecificPopupMenu(Project_GUI project_GUI, JPopupMenu jPopupMenu) {
        jPopupMenu.addSeparator();
        CMenu cMenu = this.addCommonToMenu(project_GUI, jPopupMenu);
        CMenuItem cMenuItem = new CMenuItem(false);
        cMenuItem.setText("Min Ypred");
        cMenuItem.addActionListener(actionEvent -> {
            String string = (String)JOptionPane.showInputDialog(project_GUI, "Set Minimum Ypred Cut-off:", "Minimum Ypred", 3, null, null, NiceDataFormat.toString(this.cutOffLow));
            if (string != null && NiceDataFormat.isNumber(string)) {
                this.cutOffLow = NiceDataFormat.toNumber(string);
                this.updatePLSDAclassification();
            }
        });
        cMenu.add(cMenuItem);
        CMenuItem cMenuItem2 = new CMenuItem(false);
        cMenuItem2.setText("Max Ypred");
        cMenuItem2.addActionListener(actionEvent -> {
            String string = (String)JOptionPane.showInputDialog(project_GUI, "Set Maximum Ypred Cut-off:", "Maximum Ypred", 3, null, null, NiceDataFormat.toString(this.cutOffHigh));
            if (string != null && NiceDataFormat.isNumber(string)) {
                this.cutOffHigh = NiceDataFormat.toNumber(string);
                this.updatePLSDAclassification();
            }
        });
        cMenu.add(cMenuItem2);
        jPopupMenu.add(cMenu);
    }
}

