/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model.PLSDA;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.common.wizard.AbstractInit;
import se.prediktera.map.datasetcontainer.BasicTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeClass;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.AbstractInnerColumn;
import se.prediktera.map.datasetcontainer.datainfo.IncExclude;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.datasetcontainer.datainfo.varinfo.XYclass;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.LayerMatrix;
import se.prediktera.map.datasetcontainer.transform.Transformations;
import se.prediktera.map.model.ModelHelper;
import se.prediktera.map.model.modelgenerator.ModelInit;
import se.prediktera.mda.model.AbstractCVModelInfo;
import se.prediktera.mda.model.AbstractMDAModel;
import se.prediktera.mda.model.CrossvalidationModel;
import se.prediktera.mda.model.CrossvalidationPanel;
import se.prediktera.mda.model.ModelException;
import se.prediktera.mda.model.PLSDA.PLSDAModel;

public class PLSDAModelInfo
extends AbstractCVModelInfo {
    private final JComboBox boxModelClass = new JComboBox();
    private final JCheckBox equalSizeCheckBox = new JCheckBox("", false);

    @Override
    public void beginWizard(AbstractInit abstractInit) {
        AbstractDataInfo abstractDataInfo;
        super.beginWizard(abstractInit);
        ModelInit modelInit = (ModelInit)abstractInit;
        DataSet dataSet = modelInit.getDataSet();
        this.boxModelClass.removeAllItems();
        if (dataSet.getMatrix(2).getK() > 0) {
            this.boxModelClass.addItem("Included Y");
        }
        if (dataSet != null && dataSet.getCase() != null && (abstractDataInfo = dataSet.getCase().getDataInfo(0)) != null) {
            this.boxModelClass.addItemListener(itemEvent -> {
                Object object;
                if (itemEvent.getStateChange() == 1 && (object = this.boxModelClass.getSelectedItem()) instanceof InnerColumnClass && this.commonPanel != null) {
                    CrossvalidationPanel crossvalidationPanel = this.commonPanel.getCvPanel();
                    crossvalidationPanel.setClasses(modelInit.getDataSetContainer(), (InnerColumnClass)object);
                }
            });
            ObservationInfo observationInfo = dataSet.getObsDataInfo();
            Transformations transformations = observationInfo.getTransformationNode();
            int n = transformations.getColumnCount();
            for (int i = 0; i < n; ++i) {
                if (transformations.getColumnType(i) != 4) continue;
                this.boxModelClass.addItem(transformations.getInnerColumn(i));
            }
        }
        if (this.boxModelClass.getItemCount() > 0) {
            this.boxModelClass.setSelectedIndex(this.boxModelClass.getItemCount() - 1);
        }
        this.equalSizeCheckBox.setSelected(false);
    }

    @Override
    public boolean checkCurrentDataSet(DataSet dataSet) {
        if (super.checkCurrentDataSet(dataSet)) {
            if (this.hasYData(dataSet)) {
                JOptionPane.showMessageDialog(null, "Warning! Please exclude Y-variables not belonging to any class before calculating PLS-DA model.", "Warning", 2);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Vector<JComponent> createWizard() {
        super.createWizard();
        this.commonPanel.excludeIncludeXBy();
        this.commonPanel.add((Component)new JLabel("Set Y from:"), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 18, 0, 0), 0, 0));
        this.commonPanel.add((Component)this.boxModelClass, new GridBagConstraints(1, 5, 2, 1, 1.0, 0.0, 18, 2, new Insets(6, 6, 0, 12), 0, 0));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(EvinceBorderFactory.createEvinceBorder("Options"));
        this.equalSizeCheckBox.setText("Set Equal Class Size");
        jPanel.add((Component)this.equalSizeCheckBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 6, 0, 12), 0, 0));
        this.commonPanel.add((Component)jPanel, new GridBagConstraints(1, 6, 2, 1, 1.0, 0.0, 18, 2, new Insets(6, 0, 0, 12), 0, 0));
        return this.wizard;
    }

    @Override
    public String getType() {
        return "pls-da";
    }

    @Override
    public ImageIcon getWizardImage() {
        return null;
    }

    @Override
    public String getWizardInfo() {
        return "Create new PLS-DA Model";
    }

    @Override
    public boolean supportData(DataTreeInterface dataTreeInterface) {
        if (!super.supportData(dataTreeInterface)) {
            return false;
        }
        return ModelHelper.hasModelClass(this.getDataSet(dataTreeInterface));
    }

    @Override
    public String toString() {
        return "PLS-DA Model";
    }

    @Override
    protected AbstractMDAModel createNewModel(ProgressManager progressManager, ModelInit modelInit, int[] nArray, int[] nArray2, int n, String string) {
        Object object;
        BasicTreeInterface basicTreeInterface;
        DataSet dataSet = modelInit.getDataSet();
        if (modelInit.yCategoryName == null) {
            modelInit.yCategoryName = this.getFirstClassName(dataSet);
        }
        if (modelInit.yCategoryName != null) {
            basicTreeInterface = modelInit.getClassColumn(modelInit.yCategoryName);
            object = dataSet.getResultMatrix().getIndecies(4, ((AbstractInnerColumn)basicTreeInterface).toString());
            XYclass xYclass = (XYclass)dataSet.getVarDataInfo().getGroupColumnByType(3);
            IncExclude incExclude = (IncExclude)dataSet.getVarDataInfo().getGroupColumnByType(1);
            InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)xYclass.getPrimaryColumn();
            InnerColumnBoolean innerColumnBoolean2 = (InnerColumnBoolean)incExclude.getPrimaryColumn();
            for (int i = 0; i < innerColumnBoolean.getSize(); ++i) {
                if (i >= object[0] && i < object[1]) {
                    innerColumnBoolean2.setValueBool(i, true);
                    innerColumnBoolean.setValueBool(i, false);
                    continue;
                }
                if (innerColumnBoolean.getValueBool(i)) continue;
                innerColumnBoolean2.setValueBool(i, false);
            }
            dataSet.updateReferences();
        }
        try {
            basicTreeInterface = null;
            try {
                basicTreeInterface = modelInit.getDataTreeInterface() instanceof PLSDAModel ? (PLSDAModel)modelInit.getDataTreeInterface() : new PLSDAModel(progressManager, dataSet, nArray, null, true, modelInit.yCategoryName);
            }
            catch (ModelException modelException) {
                if (!modelInit.rethrowExceptions && modelException instanceof ModelException.ModelNoDataException) {
                    progressManager.Finish();
                    JOptionPane.showMessageDialog(null, "All Y-variables excluded due to no variance. Not possible to calculate model.", "Error calculating model", 2);
                    return null;
                }
                throw modelException;
            }
            object = modelInit.getModelName();
            ((DataTreeClass)basicTreeInterface).setName((String)object);
            ((CrossvalidationModel)basicTreeInterface).setType(modelInit.typeisfull);
            ((CrossvalidationModel)basicTreeInterface).setCrossvalidation(modelInit.crossvalidationType, modelInit.nr_groups, modelInit.cvCategoryName, modelInit.hasConfidenceInterval());
            return basicTreeInterface;
        }
        catch (Exception exception) {
            ErrorHandler.logAndShowEvinceErrorDialogForException(exception);
            return null;
        }
    }

    @Override
    protected int getNumberOfComponents(DataSet dataSet) {
        int n = -1;
        if (this.commonPanel != null) {
            n = this.commonPanel.getNumberOfComponents();
        }
        if (n < 0 && dataSet.getOriginalMatrix() instanceof LayerMatrix) {
            Object object = this.boxModelClass.getSelectedItem();
            if (object instanceof InnerColumnClass) {
                InnerColumnClass innerColumnClass = (InnerColumnClass)object;
                return innerColumnClass.getObject().size();
            }
            return dataSet.getMatrix(2).getK();
        }
        return n;
    }

    @Override
    protected void setModelInitFromPanel(ModelInit modelInit, DataSet dataSet) {
        super.setModelInitFromPanel(modelInit, dataSet);
        Object object = this.boxModelClass.getSelectedItem();
        if (object instanceof InnerColumnClass) {
            InnerColumnClass innerColumnClass = (InnerColumnClass)object;
            modelInit.setIcClass(innerColumnClass);
            modelInit.yCategoryName = innerColumnClass.toString();
        }
        modelInit.setEqualsize(this.equalSizeCheckBox.isSelected());
    }

    private String getFirstClassName(DataSet dataSet) {
        ObservationInfo observationInfo = dataSet.getObsDataInfo();
        if (observationInfo != null) {
            Transformations transformations = observationInfo.getTransformationNode();
            int n = transformations.getColumnCount();
            for (int i = 0; i < n; ++i) {
                if (transformations.getColumnType(i) != 4) continue;
                InnerColumnClass innerColumnClass = (InnerColumnClass)transformations.getInnerColumn(i);
                return innerColumnClass.toString();
            }
        }
        return null;
    }
}

