/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model.SIMCA;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.dataimport.ImportHelper;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.AbstractPrediction;
import se.prediktera.map.model.ModelManager;
import se.prediktera.mda.model.AbstractMDAModel;
import se.prediktera.mda.model.AnalysPredictionNode;
import se.prediktera.mda.model.ModelContainer;
import se.prediktera.mda.model.PCA.PCAModel;
import se.prediktera.mda.model.SIMCA.SIMCApredictionNode;

public class SIMCAModel
extends ModelContainer {
    private SIMCApredictionNode trainingSetPredNode;

    public SIMCAModel(DataSet dataSet, String string, String string2) {
        super(dataSet, string, string2, -1);
    }

    public SIMCAModel(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.trainingSetPredNode = (SIMCApredictionNode)mapProperty.resolveNodeFromName(randomInputStream, "tspn");
    }

    @Override
    public void addToPopupMenu(final Project_GUI project_GUI, JPopupMenu jPopupMenu) {
        super.addToPopupMenu(project_GUI, jPopupMenu);
        jPopupMenu.addSeparator();
        CMenuItem cMenuItem = new CMenuItem("Add external model(s)", AbstractModel.modelExternalIcon);
        cMenuItem.addActionListener(actionEvent -> {
            final jopensaveDialog jopensaveDialog2 = ImportHelper.createModelDialog("Choose external model", null, true);
            if (jopensaveDialog2.openshow()) {
                ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(this){
                    final /* synthetic */ SIMCAModel this$0;
                    {
                        this.this$0 = sIMCAModel;
                    }

                    @Override
                    public Object doWork() {
                        try {
                            this.setInfoText("Loading model into SIMCA classification");
                            AbstractModel abstractModel = ModelManager.loadModel((ProgressManager)this, this.this$0.dataTreeManager, jopensaveDialog2.getSelectedFile());
                            if (abstractModel == null || !abstractModel.getModelName().equals("PCA") && !abstractModel.getModelName().equals("SIMCA")) {
                                this.Finish();
                                JOptionPane.showConfirmDialog(project_GUI, "Only models of type PCA are allowed for SIMCA classfication", "Illegal model type", -1, 1);
                                return null;
                            }
                            if (abstractModel.getModelName().equals("SIMCA")) {
                                for (int i = 0; i < abstractModel.getTreeNodeCount(); ++i) {
                                    DataTreeInterface dataTreeInterface = abstractModel.getTreeNodeAt(i);
                                    if (!(dataTreeInterface instanceof AbstractModel)) continue;
                                    AbstractModel abstractModel2 = (AbstractModel)dataTreeInterface;
                                    abstractModel2.setExternal();
                                    this.this$0.addTreeNode(abstractModel2);
                                }
                            } else {
                                abstractModel.setExternal();
                                this.this$0.addTreeNode(abstractModel);
                            }
                            this.this$0.dataSet.setChanged();
                        }
                        catch (Exception exception) {
                            ErrorHandler.logAndShowEvinceErrorDialogForException(exception);
                        }
                        return null;
                    }
                };
                progressManagerImpl.invokeNow();
            }
        });
        jPopupMenu.add(cMenuItem);
    }

    @Override
    public AbstractPrediction createPredictionLocal(ProgressManager progressManager, DataSet dataSet, Properties properties) {
        SIMCApredictionNode sIMCApredictionNode = new SIMCApredictionNode(dataSet, this, properties);
        sIMCApredictionNode.calcSIMCAprediction(progressManager);
        return sIMCApredictionNode;
    }

    @Override
    public void finishCalculation(ProgressManager progressManager) {
        super.finishCalculation(progressManager);
        try {
            SIMCApredictionNode sIMCApredictionNode = (SIMCApredictionNode)this.getLocalPredictionNode();
            if (sIMCApredictionNode == null) {
                sIMCApredictionNode = new SIMCApredictionNode(this.dataSet, this, null);
                this.addTreeNode(sIMCApredictionNode);
            }
            if (this.trainingSetPredNode == null) {
                this.trainingSetPredNode = new SIMCApredictionNode(this.dataSet, this, null, false);
                this.addTreeNode(this.trainingSetPredNode);
                this.trainingSetPredNode.setVisibleInTree(false);
                this.addShortcut(this.trainingSetPredNode.getDModX());
            }
            this.trainingSetPredNode.calcSIMCAprediction(progressManager);
            this.finishPrediction(progressManager);
        }
        catch (Exception exception) {
            ErrorHandler.logAndShowEvinceErrorDialogForException(exception);
        }
    }

    public double getDcritX(int n) {
        AbstractModel abstractModel = this.getModelAt(n);
        if (abstractModel != null) {
            return abstractModel.getDcritX();
        }
        return 0.0;
    }

    public AbstractDataMatrix getLocalDmodX() {
        if (this.trainingSetPredNode != null) {
            return this.trainingSetPredNode.getDModX();
        }
        return null;
    }

    @Override
    public AbstractPrediction getLocalTrainingPredictionNode() {
        return this.trainingSetPredNode;
    }

    @Override
    public String getModelName() {
        return "SIMCA";
    }

    @Override
    public byte getTreeType() {
        return 11;
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyNode("tspn", this.trainingSetPredNode);
    }

    public void setDcritX(int n, double d) {
        AbstractModel abstractModel = this.getModelAt(n);
        if (abstractModel instanceof PCAModel) {
            PCAModel pCAModel = (PCAModel)abstractModel;
            pCAModel.setDcritXsimca(d);
        }
        this.updateSIMCAclassification();
    }

    @Override
    public boolean supportPrediction() {
        return true;
    }

    public void updateSIMCAclassification() {
        List<AnalysPredictionNode> list = this.getAllPredictionNodes();
        for (SIMCApredictionNode sIMCApredictionNode : list) {
            sIMCApredictionNode.updateSIMCAclassification();
        }
    }

    @Override
    protected AbstractMDAModel createDefaultModel(ProgressManager progressManager, AbstractMDAModel abstractMDAModel, int[] nArray, int n) throws Exception {
        if (abstractMDAModel != null) {
            return super.createDefaultModel(progressManager, abstractMDAModel, nArray, n);
        }
        return new PCAModel(progressManager, this.dataSet, nArray, true, true);
    }
}

