/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model.SIMCA;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import no.uib.cipr.matrix.DenseVector;
import se.prediktera.map.common.cleanup.CleanUpInterface;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.BasicTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.classes.ClassSettings;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.DataInfoEvent;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.AbstractPrediction;
import se.prediktera.map.model.ModelManager;
import se.prediktera.map.model.analysis.AbstractAnalysisInfo;
import se.prediktera.mda.model.AbstractMDAModel;
import se.prediktera.mda.model.PCA.PCApredictionNode;
import se.prediktera.mda.model.SIMCA.SIMCAModel;
import se.prediktera.mda.model.SIMCA.SIMCApredictionNode;

public class SIMCAclassification
extends AbstractAnalysisInfo {
    @Override
    public Object performAnalysis(ProgressManager progressManager, Object[] objectArray, Properties properties) {
        DataSet dataSet = (DataSet)objectArray[0];
        SIMCApredictionNode sIMCApredictionNode = new SIMCApredictionNode(dataSet, null, null);
        InnerColumnClass innerColumnClass = sIMCApredictionNode.getAndResetInnerColumnClass();
        if (properties == null) {
            properties = new Properties();
        }
        properties.put("predclasses", "false");
        properties.put("optimize", "true");
        DataTreeManager dataTreeManager = new DataTreeManager(true);
        double[] dArray = new double[innerColumnClass.getSize()];
        Arrays.fill(dArray, -1.0);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (!entry.getKey().toString().startsWith("model")) continue;
            try {
                String string = (String)entry.getValue();
                AbstractModel abstractModel = ModelManager.loadModel(progressManager, dataTreeManager, string);
                this.performAnalysis(progressManager, sIMCApredictionNode, dataSet, abstractModel, properties, dArray);
                abstractModel.cleanUp();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return sIMCApredictionNode;
    }

    public Object performAnalysis(ProgressManager progressManager, SIMCApredictionNode sIMCApredictionNode, DataSet dataSet, AbstractModel abstractModel, Properties properties, double[] dArray) {
        if (abstractModel.isModelContainer()) {
            for (int i = 0; i < abstractModel.getTreeNodeCount(); ++i) {
                if (!(abstractModel.getTreeNodeAt(i) instanceof AbstractModel)) continue;
                this.predictModel(progressManager, sIMCApredictionNode, dataSet, properties, (AbstractModel)abstractModel.getTreeNodeAt(i), dArray);
            }
        } else {
            this.predictModel(progressManager, sIMCApredictionNode, dataSet, properties, abstractModel, dArray);
        }
        return null;
    }

    @Override
    public boolean supportParam(Object[] objectArray) {
        return objectArray.length == 1 && objectArray[0] instanceof DataSet;
    }

    public String toString() {
        return "SIMCA Classification";
    }

    public void updateSIMCAclassification(SIMCApredictionNode sIMCApredictionNode) {
        InnerColumnClass innerColumnClass = sIMCApredictionNode.getInnerColumnClass();
        if (innerColumnClass != null) {
            ModelMatrix modelMatrix = sIMCApredictionNode.getDModX();
            ModelMatrix modelMatrix2 = sIMCApredictionNode.getHotellingT2();
            innerColumnClass.beginUpdate();
            int n = 0;
            double[] dArray = new double[innerColumnClass.getSize()];
            Arrays.fill(dArray, -1.0);
            SIMCAModel sIMCAModel = (SIMCAModel)sIMCApredictionNode.getModel();
            for (int i = 0; i < sIMCAModel.getTreeNodeCount(); ++i) {
                DataTreeInterface dataTreeInterface = sIMCAModel.getTreeNodeAt(i);
                if (!(dataTreeInterface instanceof AbstractModel)) continue;
                AbstractModel abstractModel = (AbstractModel)dataTreeInterface;
                dataTreeInterface = modelMatrix.getRM(n);
                DenseVector denseVector = modelMatrix2 != null ? modelMatrix2.getRM(n) : null;
                this.updatePredictionClass((DenseVector)dataTreeInterface, denseVector, abstractModel, modelMatrix.getKref(), dArray, innerColumnClass, (short)(n + 1));
                n = (short)(n + 1);
            }
            innerColumnClass.endUpdate();
            AbstractDataInfo abstractDataInfo = innerColumnClass.getDataInfo();
            abstractDataInfo.triggerEvent(new DataInfoEvent(abstractDataInfo, 7, innerColumnClass.getCategory()));
        }
    }

    private boolean isLocalPredictionNode(AbstractModel abstractModel, DataSet dataSet) {
        if (abstractModel.isExternal() || !DataTreeManager.isParentTo(dataSet, abstractModel)) {
            return false;
        }
        AbstractPrediction abstractPrediction = abstractModel.getLocalPredictionNode();
        return abstractPrediction != null && abstractPrediction.getDModX() != null;
    }

    private void predictModel(ProgressManager progressManager, SIMCApredictionNode sIMCApredictionNode, DataSet dataSet, Properties properties, AbstractModel abstractModel, double[] dArray) {
        CleanUpInterface cleanUpInterface;
        BasicTreeInterface basicTreeInterface;
        InnerColumnClass innerColumnClass = sIMCApredictionNode.getInnerColumnClass();
        ClassTypes classTypes = innerColumnClass.getObject();
        String string = abstractModel.toString();
        ClassTypes classTypes2 = abstractModel.getClassTypesByName(sIMCApredictionNode.getModel().getClassName());
        ClassSettings classSettings = null;
        if (classTypes2 != null) {
            classSettings = classTypes2.getClassSettingsByName(string);
        }
        if (classSettings != null) {
            basicTreeInterface = new ClassSettings(string, classSettings.getRefindex(), classSettings.getColor());
            classTypes.add(basicTreeInterface);
        } else {
            classTypes.addStringNoEvent(string);
        }
        basicTreeInterface = null;
        boolean bl = this.isLocalPredictionNode(abstractModel, dataSet);
        boolean bl2 = true;
        if (properties != null && properties.containsKey("predtestset")) {
            bl2 = ScriptHelper.getPropertyBool(properties, "predtestset");
        }
        basicTreeInterface = bl && bl2 ? abstractModel.getLocalPredictionNode() : new PCApredictionNode(progressManager, (AbstractMDAModel)abstractModel, dataSet, properties, bl2);
        ModelMatrix modelMatrix = ((AbstractPrediction)basicTreeInterface).getDModX();
        DenseVector denseVector = modelMatrix.getLastRM();
        ModelMatrix modelMatrix2 = ((AbstractPrediction)basicTreeInterface).getHotellingT2();
        DenseVector denseVector2 = modelMatrix2 != null ? modelMatrix2.getLastRM() : null;
        short s = (short)(classTypes.size() - 1);
        if (this.updatePredictionClass(denseVector, denseVector2, abstractModel, modelMatrix.getKref(), dArray, innerColumnClass, s)) {
            cleanUpInterface = sIMCApredictionNode.getDModX();
            ((ModelMatrix)cleanUpInterface).addRow(denseVector);
            ((ModelMatrix)cleanUpInterface).addStatisticDescription(abstractModel.toString());
            ModelMatrix modelMatrix3 = sIMCApredictionNode.getHotellingT2();
            if (modelMatrix3 != null && denseVector2 != null) {
                modelMatrix3.addRow(denseVector2);
                modelMatrix3.addStatisticDescription(abstractModel.toString());
            }
        }
        if (!bl) {
            // empty if block
        }
        if ((cleanUpInterface = abstractModel.getDataTreeManager()) != null) {
            ((DataTreeManager)cleanUpInterface).ClearDataFromMemory(abstractModel, 0, Long.MAX_VALUE, progressManager);
        }
        System.gc();
    }

    private boolean updatePredictionClass(DenseVector denseVector, DenseVector denseVector2, AbstractModel abstractModel, int[] nArray, double[] dArray, InnerColumnClass innerColumnClass, short s) {
        if (denseVector != null) {
            double d = abstractModel.getDcritX();
            if (abstractModel.isUseHotelling() && denseVector2 != null) {
                double d2 = abstractModel.getHotellingt2();
                for (int i = 0; i < denseVector.size(); ++i) {
                    double d3 = denseVector.get(i);
                    double d4 = denseVector2.get(i);
                    if (d3 < d && d4 < d2 && (dArray[i] == -1.0 || dArray[i] > d3)) {
                        dArray[i] = d3;
                        innerColumnClass.setValueShort(nArray != null ? nArray[i] : i, s);
                        continue;
                    }
                    if (dArray[i] != -1.0) continue;
                    innerColumnClass.setValueShort(nArray != null ? nArray[i] : i, (short)0);
                }
            } else {
                for (int i = 0; i < denseVector.size(); ++i) {
                    double d5 = denseVector.get(i);
                    if (d5 < d && (dArray[i] == -1.0 || dArray[i] > d5)) {
                        dArray[i] = d5;
                        innerColumnClass.setValueShort(nArray != null ? nArray[i] : i, s);
                        continue;
                    }
                    if (dArray[i] != -1.0) continue;
                    innerColumnClass.setValueShort(nArray != null ? nArray[i] : i, (short)0);
                }
            }
            return true;
        }
        return false;
    }
}

