/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model.SIMCA;

import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.classes.prediction.PredictionClasses;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.main.Evince;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.mda.model.AbstractMDAModel;
import se.prediktera.mda.model.AbstractMDAResults;
import se.prediktera.mda.model.AnalysPredictionNode;
import se.prediktera.mda.model.SIMCA.SIMCAclassification;

public class SIMCApredictionNode
extends AnalysPredictionNode {
    public static String PRED_MATRIX_NAME = "Predicted distance to model";
    public static String PRED_T2_MATRIX_NAME = "Predicted Hotelling T2";
    private final ModelMatrix dmodx;
    private ModelMatrix hotellingt2;

    public SIMCApredictionNode(DataSet dataSet, AbstractMDAModel abstractMDAModel, Properties properties) {
        this(dataSet, abstractMDAModel, properties, true);
    }

    public SIMCApredictionNode(DataSet dataSet, AbstractMDAModel abstractMDAModel, Properties properties, boolean bl) {
        super(abstractMDAModel, dataSet, properties, bl);
        ObservationInfo observationInfo;
        PredictionClasses predictionClasses;
        AbstractDataMatrix abstractDataMatrix = this.getDataSetMatrixToPredictInX();
        this.dmodx = new ModelMatrix(abstractDataMatrix.getDataInfo(0));
        this.addTreeNode(this.dmodx);
        this.dmodx.resize(abstractDataMatrix);
        if (bl) {
            this.dmodx.setName(PRED_MATRIX_NAME);
        } else {
            this.dmodx.setName("ObsDMX");
            this.dmodx.setHtmlName("<html>ObsDM<b>X</b>pred</html>");
        }
        if (Evince.isHotellingT2Feature()) {
            this.addHotellingT2Matrix(bl, abstractDataMatrix);
        }
        if ((predictionClasses = (PredictionClasses)(observationInfo = dataSet.getObsDataInfo()).getGroupColumnByType(11)) == null) {
            predictionClasses = new PredictionClasses(observationInfo.getRowCount());
            observationInfo.addTreeNode(predictionClasses);
        }
        predictionClasses.getPredictionClass(abstractMDAModel, this.getColumnName());
    }

    public SIMCApredictionNode(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.dmodx = (ModelMatrix)mapProperty.resolveNodeFromName(randomInputStream, "dmodx_mtx");
        this.hotellingt2 = (ModelMatrix)mapProperty.resolveNodeFromName(randomInputStream, "hotellingt2_mtx");
    }

    private void addHotellingT2Matrix(boolean bl, AbstractDataMatrix abstractDataMatrix) {
        this.hotellingt2 = new ModelMatrix(abstractDataMatrix.getDataInfo(0));
        this.addTreeNode(this.hotellingt2);
        this.hotellingt2.resize(abstractDataMatrix);
        if (bl) {
            this.hotellingt2.setName(PRED_T2_MATRIX_NAME);
        } else {
            this.hotellingt2.setName("Hotelling T2");
            this.hotellingt2.setHtmlName("<html>Hotelling T2</html>");
        }
    }

    public void calcSIMCAprediction(ProgressManager progressManager) {
        InnerColumnClass innerColumnClass = this.getAndResetInnerColumnClass();
        if (innerColumnClass != null) {
            double[] dArray = new double[innerColumnClass.getSize()];
            Arrays.fill(dArray, -1.0);
            AbstractDataMatrix abstractDataMatrix = this.getDataSetMatrixToPredictInX();
            this.dmodx.resize(abstractDataMatrix);
            this.dmodx.clearStatisticDescription();
            if (this.hotellingt2 != null) {
                this.hotellingt2.resize(abstractDataMatrix);
                this.hotellingt2.clearStatisticDescription();
            }
            Properties properties = new Properties();
            properties.put("predclasses", "false");
            properties.put("optimize", "true");
            properties.put("predtestset", String.valueOf(this.ispredtestset));
            progressManager.setInfoText("Performing SIMCA classification");
            this.model.beginUpdateRecursive();
            SIMCAclassification sIMCAclassification = new SIMCAclassification();
            sIMCAclassification.performAnalysis(progressManager, this, this.dataSet, this.model, properties, dArray);
            this.model.endUpdateRecursive();
            innerColumnClass.endUpdate();
        }
    }

    @Override
    public boolean canCalculate() {
        return true;
    }

    @Override
    public void finishPrediction(ProgressManager progressManager) {
        this.calcSIMCAprediction(progressManager);
    }

    public InnerColumnClass getAndResetInnerColumnClass() {
        InnerColumnClass innerColumnClass = this.getInnerColumnClass();
        if (innerColumnClass != null) {
            ClassTypes classTypes = innerColumnClass.getObject();
            classTypes.clear();
            classTypes.addStringNoEvent("No class");
        }
        return innerColumnClass;
    }

    public String getColumnName() {
        return "Pred. " + (this.model != null ? this.model.toString() : this.dataSet.toString());
    }

    @Override
    public ModelMatrix getDModX() {
        return this.dmodx;
    }

    @Override
    public ModelMatrix getHotellingT2() {
        return this.hotellingt2;
    }

    @Override
    public ExtClassLoader.LicenseLibrary getLibrary() {
        return ExtClassLoader.LicenseLibrary.MDA;
    }

    public InnerColumnClass getInnerColumnClass() {
        ObservationInfo observationInfo;
        PredictionClasses predictionClasses;
        if (this.dataSet != null && (predictionClasses = (PredictionClasses)(observationInfo = this.dataSet.getObsDataInfo()).getGroupColumnByType(11)) != null) {
            InnerColumnClass innerColumnClass = (InnerColumnClass)predictionClasses.getInnerColumnByName(this.getColumnName());
            if (innerColumnClass != null) {
                return innerColumnClass;
            }
            return predictionClasses.getPredictionClass(this.model, this.getColumnName());
        }
        return null;
    }

    @Override
    public AbstractDataMatrix getMatrixByName(String string) {
        if (string.equalsIgnoreCase("dmodx")) {
            return this.dmodx;
        }
        if (string.equalsIgnoreCase("hotellingt")) {
            return this.hotellingt2;
        }
        return null;
    }

    @Override
    public byte getNodeType() {
        return 5;
    }

    @Override
    public byte getTreeType() {
        return 10;
    }

    @Override
    public boolean hasPredictions() {
        return this.dmodx != null && this.dmodx.getN() > 0;
    }

    @Override
    public AbstractMDAResults getPredictions() {
        return null;
    }

    @Override
    public boolean isVisibleInTree() {
        return super.isVisibleInTree() && this.hasPredictions();
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyNode("dmodx_mtx", this.dmodx);
        randomOutputStream.writePropertyNode("hotellingt2_mtx", this.hotellingt2);
    }

    @Override
    public String toString() {
        if (this.ispredtestset) {
            return super.toString();
        }
        return super.toString() + " (X Training)";
    }

    public void updateSIMCAclassification() {
        SIMCAclassification sIMCAclassification = new SIMCAclassification();
        sIMCAclassification.updateSIMCAclassification(this);
    }

    @Override
    protected AbstractMDAResults calcOnePrediction(ProgressManager progressManager) {
        return null;
    }

    @Override
    protected void removeOnePrediction() throws Exception {
    }

    @Override
    protected void resetPrediction() throws Exception {
    }
}

