/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model.info;

import javax.swing.ImageIcon;
import se.prediktera.map.common.wizard.AbstractInit;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.main.layer.AbstractSettingsBox;
import se.prediktera.map.main.window.AbstractWindow;
import se.prediktera.map.main.window.AbstractWindow_GUI;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.PlotAxisLayerPanel;
import se.prediktera.map.plot.axisplot.plot2D.scatter.Scatter2D;
import se.prediktera.map.plot.axisplot.plot2D.scatter.Scatter2DInfo;
import se.prediktera.mda.model.SIMCA.SIMCAModel;
import se.prediktera.mda.model.SIMCA.SIMCApredictionNode;
import se.prediktera.mda.model.info.DModXPlotInfo;

public class CoomansPlotInfo
extends Scatter2DInfo {
    private SIMCAModel model = null;
    private final ImageIcon imageIcon = new ImageIcon(DModXPlotInfo.class.getResource("images/coomans.gif"));
    private boolean localdmodx = false;

    @Override
    public void cleanUpChild() {
        super.cleanUpChild();
        this.model = null;
    }

    @Override
    public AbstractWindow createWindow(AbstractWindow_GUI abstractWindow_GUI, AbstractInit abstractInit) {
        PlotInit plotInit = (PlotInit)abstractInit;
        plotInit.autoCreateLayer = false;
        Scatter2D scatter2D = (Scatter2D)super.createWindow(abstractWindow_GUI, abstractInit);
        if (plotInit.ccolortype == 8) {
            scatter2D.getAxisPlot().setShowBorders(false);
        }
        PlotAxisLayerPanel plotAxisLayerPanel = (PlotAxisLayerPanel)scatter2D.getSettingsPanel();
        plotAxisLayerPanel.setCreated(abstractWindow_GUI, false);
        PlotInit plotInit2 = (PlotInit)abstractInit.cloneCurrent();
        AbstractAxisLayer abstractAxisLayer = plotAxisLayerPanel.addLayer(true, plotInit2, plotInit2.getDataTreeInterface().toString());
        AbstractSettingsBox abstractSettingsBox = abstractAxisLayer.getSettingsBoxMap().get((byte)13);
        abstractSettingsBox.setSelected(20, 0);
        return scatter2D;
    }

    @Override
    public String getScript() {
        if (this.localdmodx) {
            return "plot.setColor(\"category\", \"" + this.model.getClassName() + "\");plot.addLegend(\"color\");";
        }
        if (this.model != null) {
            return "plot.setColor(\"prediction category\", \"Pred. " + String.valueOf(this.model) + "\");plot.addLegend(\"color\");";
        }
        return "";
    }

    @Override
    public ImageIcon getWizardImage() {
        return this.imageIcon;
    }

    @Override
    public String getWizardInfo() {
        return "Creates a Cooman's plot from the selected SIMCA model.";
    }

    @Override
    public boolean supportData(DataTreeInterface dataTreeInterface) {
        if (dataTreeInterface instanceof ModelMatrix) {
            return (dataTreeInterface.toString().startsWith("DmodX SIMCA") || dataTreeInterface.toString().equals(SIMCApredictionNode.PRED_MATRIX_NAME)) && ((ModelMatrix)dataTreeInterface).getTreeParent() instanceof SIMCApredictionNode;
        }
        return dataTreeInterface instanceof SIMCApredictionNode || dataTreeInterface instanceof SIMCAModel;
    }

    @Override
    public String toString() {
        return "Cooman's Plot";
    }

    @Override
    protected AbstractInit createInit(DataTreeInterface dataTreeInterface) {
        AbstractDataMatrix abstractDataMatrix;
        PlotInit plotInit = (PlotInit)super.createInit(dataTreeInterface);
        SIMCApredictionNode sIMCApredictionNode = null;
        if (dataTreeInterface instanceof ModelMatrix) {
            sIMCApredictionNode = (SIMCApredictionNode)dataTreeInterface.getTreeParent();
        } else if (dataTreeInterface instanceof SIMCAModel) {
            this.localdmodx = true;
        } else {
            sIMCApredictionNode = (SIMCApredictionNode)dataTreeInterface;
        }
        if (this.localdmodx) {
            this.model = (SIMCAModel)dataTreeInterface;
            abstractDataMatrix = this.model.getLocalDmodX();
        } else {
            this.model = (SIMCAModel)sIMCApredictionNode.getModel();
            abstractDataMatrix = sIMCApredictionNode.getDModX();
        }
        plotInit.title = "$model - Coomans\n$dataset";
        plotInit.plotType = 1;
        plotInit.minmax[0][0] = 0.0;
        plotInit.minmax[0][1] = 0.0;
        plotInit.plotSettings = "protected";
        if (abstractDataMatrix.isFoldable()) {
            if (plotInit.ccolortype != 8) {
                plotInit.ccolortype = 8;
            }
            plotInit.initsize = 1;
        }
        plotInit.setDataTreeInterface(abstractDataMatrix);
        return plotInit;
    }
}

