/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model.info.statistics;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.io.IOException;
import java.util.Properties;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.components.paint.AbstractPaint;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.main.Evince;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.AbstractPrediction;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.AxisRange;
import se.prediktera.map.plot.axisplot.plot2D.FloatWindowPlot2D;
import se.prediktera.map.plot.axisplot.settings.Statistics.AbstractStatisticsInfo;

public abstract class AbstractStatisticsLineInfo
extends AbstractStatisticsInfo {
    protected AbstractAxisLayer layer;
    protected double[] axis = new double[3];
    protected double basedcrit = -1.0;
    protected boolean[] included;
    private boolean editable = true;

    public AbstractStatisticsLineInfo(boolean[] blArray) {
        this.included = blArray;
    }

    @Override
    public void adjustMinMax(AbstractAxisLayer abstractAxisLayer, int n, double[] dArray) {
        if (0 <= n && n < 3 && this.axis != null && this.included[n]) {
            this.calculate(abstractAxisLayer, abstractAxisLayer.getPlotInit().getMatrix(0), 0);
            double d = this.axis[n];
            if (dArray[0] > d) {
                dArray[0] = d;
            }
            if (dArray[1] < d) {
                dArray[1] = d;
            }
        }
        if (n == 1 && this.basedcrit > 0.0 && dArray[1] < this.basedcrit) {
            dArray[1] = this.basedcrit;
        }
    }

    @Override
    public void draw(Graphics2D graphics2D, AbstractAxisPlot abstractAxisPlot, AbstractAxisLayer abstractAxisLayer, AbstractDataMatrix abstractDataMatrix, int n, double d, double d2) {
        if (abstractAxisPlot.getLayerCount() > 0) {
            this.calculate(abstractAxisLayer, abstractDataMatrix, n);
        }
        if (abstractAxisPlot instanceof FloatWindowPlot2D) {
            String string;
            FloatWindowPlot2D floatWindowPlot2D = (FloatWindowPlot2D)abstractAxisPlot;
            Font font = graphics2D.getFont();
            graphics2D.setFont(new Font(font.getName(), 0, 12));
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            AxisRange axisRange = abstractAxisPlot.getRange(0, 0);
            AxisRange axisRange2 = abstractAxisPlot.getRange(1, 0);
            Color color = graphics2D.getColor();
            int[] nArray = new int[2];
            int[] nArray2 = new int[2];
            if (this.basedcrit > 0.0) {
                graphics2D.setColor(abstractAxisPlot.getAxisColor());
                if (this.isBaseX()) {
                    floatWindowPlot2D.translateToScreenInt(nArray, this.basedcrit, axisRange2.getMin());
                    floatWindowPlot2D.translateToScreenInt(nArray2, this.basedcrit, axisRange2.getMax());
                } else {
                    floatWindowPlot2D.translateToScreenInt(nArray, axisRange.getMin(), this.basedcrit);
                    floatWindowPlot2D.translateToScreenInt(nArray2, axisRange.getMax(), this.basedcrit);
                }
                string = String.valueOf(NiceDataFormat.toString(this.basedcrit, 4));
                String string2 = this.getName() + " 95% (" + string + ")";
                if (this.included[1]) {
                    graphics2D.drawString(string2, nArray2[0] - 3 - fontMetrics.stringWidth(string2), nArray[1] - fontMetrics.getHeight() / 2);
                }
                graphics2D.setStroke(AbstractPaint.stroke2);
                graphics2D.drawLine(nArray[0], nArray[1], nArray2[0], nArray2[1]);
            }
            graphics2D.setColor(abstractAxisPlot.getAxisColor());
            if (this.included[0] && this.axis[0] >= axisRange.getMin() && this.axis[0] <= axisRange.getMax()) {
                floatWindowPlot2D.translateToScreenInt(nArray, this.axis[0], axisRange2.getMin());
                floatWindowPlot2D.translateToScreenInt(nArray2, this.axis[0], axisRange2.getMax());
                string = String.valueOf(NiceDataFormat.toString(this.axis[0], 4));
                graphics2D.drawString(this.getName() + " (" + string + ")", nArray[0] + 3, nArray[1] - fontMetrics.getHeight() / 2);
                graphics2D.setStroke(AbstractPaint.stroke2);
                if (this.isEditable()) {
                    graphics2D.setColor(Color.red);
                } else {
                    graphics2D.setColor(abstractAxisPlot.getAxisColor());
                }
                int n2 = 3;
                if (Evince.touchscreen) {
                    n2 *= 2;
                }
                graphics2D.fillRect(nArray[0] - n2 / 2, nArray2[1], n2, nArray[1] - nArray2[1]);
            }
            graphics2D.setColor(abstractAxisPlot.getAxisColor());
            if (this.included[1] && this.axis[1] >= axisRange2.getMin() && this.axis[1] <= axisRange2.getMax()) {
                floatWindowPlot2D.translateToScreenInt(nArray, axisRange.getMin(), this.axis[1]);
                floatWindowPlot2D.translateToScreenInt(nArray2, axisRange.getMax(), this.axis[1]);
                string = String.valueOf(NiceDataFormat.toString(this.axis[1], 4));
                graphics2D.drawString(this.getName() + " (" + string + ")", nArray[0] + 3, nArray[1] - fontMetrics.getHeight() / 2);
                graphics2D.setStroke(AbstractPaint.stroke2);
                if (this.isEditable()) {
                    graphics2D.setColor(Color.red);
                } else {
                    graphics2D.setColor(abstractAxisPlot.getAxisColor());
                }
                graphics2D.drawLine(nArray[0], nArray[1], nArray2[0], nArray2[1]);
            }
            graphics2D.setStroke(AbstractPaint.stroke);
            graphics2D.setColor(color);
            graphics2D.setFont(font);
        }
    }

    protected String getName() {
        return "Dcrit";
    }

    @Override
    public void drawInBg(Graphics2D graphics2D, AbstractAxisPlot abstractAxisPlot, AbstractAxisLayer abstractAxisLayer, AbstractDataMatrix abstractDataMatrix, int n, double d, double d2) {
    }

    @Override
    public int hasStatisticAt(double d, double d2, AbstractAxisPlot abstractAxisPlot) {
        if (!this.isEditable()) {
            return -1;
        }
        int n = 5;
        if (Evince.touchscreen) {
            n *= 5;
        }
        AxisRange axisRange = abstractAxisPlot.getRange(0, 0);
        AxisRange axisRange2 = abstractAxisPlot.getRange(1, 0);
        double[] dArray = new double[2];
        if (this.included[0]) {
            abstractAxisPlot.translateToScreenDouble(dArray, this.axis[0], 0.0, axisRange, axisRange2);
            if (dArray[0] - (double)n <= d && dArray[0] + (double)n >= d) {
                return 0;
            }
        }
        if (this.included[1]) {
            abstractAxisPlot.translateToScreenDouble(dArray, 0.0, this.axis[1], axisRange, axisRange2);
            if (dArray[1] - (double)n <= d2 && dArray[1] + (double)n >= d2) {
                return 1;
            }
        }
        return -1;
    }

    @Override
    public void load(MapProperty mapProperty) throws IOException {
        this.axis = mapProperty.getPropertyDoubleArray("sdata", this.axis);
    }

    @Override
    public void save(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.writePropertyDoubleArray("sdata", this.axis);
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.layer = null;
    }

    protected AbstractModel getModelFromPlotInit() {
        PlotInit plotInit = this.layer.getPlotInit();
        DataTreeInterface dataTreeInterface = plotInit.getDataTreeInterface();
        if (dataTreeInterface instanceof ModelMatrix) {
            ModelMatrix modelMatrix = (ModelMatrix)dataTreeInterface;
            return modelMatrix.getModel();
        }
        if (dataTreeInterface instanceof AbstractModel) {
            return (AbstractModel)dataTreeInterface;
        }
        return null;
    }

    protected boolean isBaseX() {
        return false;
    }

    @Override
    public void setProperties(Properties properties) {
        if (properties != null && ScriptHelper.hasKey(properties, "editable")) {
            this.editable = ScriptHelper.getPropertyBool(properties, "editable");
        }
    }

    protected boolean isEditable() {
        if (this.editable) {
            PlotInit plotInit = this.layer.getPlotInit();
            DataTreeInterface dataTreeInterface = plotInit.getDataTreeInterface();
            if (dataTreeInterface instanceof ModelMatrix) {
                ModelMatrix modelMatrix = (ModelMatrix)dataTreeInterface;
                DataTreeInterface dataTreeInterface2 = modelMatrix.getTreeParent();
                if (dataTreeInterface2 instanceof AbstractPrediction) {
                    AbstractPrediction abstractPrediction = (AbstractPrediction)dataTreeInterface2;
                    return abstractPrediction != null;
                }
                return modelMatrix.getTreeParent() instanceof AbstractModel;
            }
            return dataTreeInterface instanceof AbstractModel;
        }
        return false;
    }
}

