/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model.info.statistics;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.io.IOException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.components.paint.AbstractPaint;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.AxisRange;
import se.prediktera.map.plot.axisplot.plot2D.serie.serie2D.FloatWindowSerie;
import se.prediktera.map.plot.axisplot.settings.AbstractSettingsPanel;
import se.prediktera.map.plot.axisplot.settings.Statistics.AbstractStatisticsInfo;

public class ConfidenceRegionInfo
extends AbstractStatisticsInfo {
    private double[] axis = new double[3];

    @Override
    public void calculate(AbstractAxisLayer abstractAxisLayer, AbstractDataMatrix abstractDataMatrix, int n) {
        int n2 = this.calculateMeanAndVariance(abstractAxisLayer);
        if (n2 <= 1) {
            this.axis[2] = 0.0;
            this.axis[1] = 0.0;
            this.axis[0] = 0.0;
            return;
        }
        this.axis[0] = this.xMean + 1.95996 * this.xVariance;
        this.axis[1] = this.yMean + 1.95996 * this.yVariance;
        this.axis[2] = this.zMean + 1.95996 * this.zVariance;
    }

    @Override
    public AbstractSettingsPanel createSettingsPanel() {
        return new AbstractSettingsPanel(){};
    }

    @Override
    public void draw(Graphics2D graphics2D, AbstractAxisPlot abstractAxisPlot, AbstractAxisLayer abstractAxisLayer, AbstractDataMatrix abstractDataMatrix, int n, double d, double d2) {
        if (abstractAxisPlot instanceof FloatWindowSerie) {
            String string;
            FloatWindowSerie floatWindowSerie = (FloatWindowSerie)abstractAxisPlot;
            if (Double.compare(this.axis[1], 0.0) == 0) {
                return;
            }
            Color color = graphics2D.getColor();
            graphics2D.setColor(Color.black);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            AxisRange axisRange = abstractAxisPlot.getRange(0, 0);
            AxisRange axisRange2 = abstractAxisPlot.getRange(1, 0);
            int[] nArray = new int[2];
            int[] nArray2 = new int[2];
            floatWindowSerie.translateToScreenInt(nArray, axisRange.getMin(), this.axis[1]);
            floatWindowSerie.translateToScreenInt(nArray2, axisRange.getMax(), -this.axis[1]);
            if (this.axis[1] > axisRange2.getMin() && this.axis[1] < axisRange2.getMax()) {
                string = String.valueOf(NiceDataFormat.toString(this.axis[1]));
                graphics2D.drawString("1.96*Std (" + string + ")", nArray[0] + 3, nArray[1] - fontMetrics.getHeight() / 2);
                graphics2D.setStroke(AbstractPaint.stroke2);
                graphics2D.drawLine(nArray[0], nArray[1], nArray2[0], nArray[1]);
            }
            if (-this.axis[1] > axisRange2.getMin() && -this.axis[1] < axisRange2.getMax()) {
                string = String.valueOf(NiceDataFormat.toString(-this.axis[1]));
                graphics2D.drawString("1.96*Std (" + string + ")", nArray[0] + 3, nArray2[1] - fontMetrics.getHeight() / 2);
                graphics2D.setStroke(AbstractPaint.stroke2);
                graphics2D.drawLine(nArray[0], nArray2[1], nArray2[0], nArray2[1]);
            }
            graphics2D.setStroke(AbstractPaint.stroke);
            graphics2D.setColor(color);
        }
    }

    @Override
    public void load(MapProperty mapProperty) throws IOException {
        this.axis = mapProperty.getPropertyDoubleArray("sdata", this.axis);
    }

    @Override
    public void save(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.writePropertyDoubleArray("sdata", this.axis);
    }

    @Override
    public boolean supportData(DataTreeInterface dataTreeInterface) {
        if (dataTreeInterface instanceof FloatWindowSerie) {
            AbstractDataMatrix abstractDataMatrix = ((FloatWindowSerie)dataTreeInterface).getPlotInit().getMatrix(0);
            return abstractDataMatrix instanceof ModelMatrix && abstractDataMatrix.toString().equals("T");
        }
        return false;
    }

    @Override
    public String toNiceString() {
        return "Confidence Region";
    }

    public String toString() {
        return "[CONFIDENCE REGION]";
    }

    @Override
    protected int getType() {
        return 17;
    }
}

