/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model.info.statistics;

import java.util.Map;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.plot2D.scatter.FloatWindowScatter;
import se.prediktera.map.plot.axisplot.settings.AbstractPlotSettingsBox;
import se.prediktera.map.plot.axisplot.settings.AbstractSettingsPanel;
import se.prediktera.mda.model.SIMCA.SIMCAModel;
import se.prediktera.mda.model.SIMCA.SIMCApredictionNode;
import se.prediktera.mda.model.info.statistics.AbstractStatisticsLineInfo;

public class CoomansStatisticsInfo
extends AbstractStatisticsLineInfo {
    public CoomansStatisticsInfo() {
        super(new boolean[]{true, true, false});
    }

    @Override
    public void calculate(AbstractAxisLayer abstractAxisLayer, AbstractDataMatrix abstractDataMatrix, int n) {
        this.layer = abstractAxisLayer;
        int n2 = this.calculateMeanAndVariance(abstractAxisLayer);
        if (n2 <= 1) {
            this.axis[2] = 0.0;
            this.axis[1] = 0.0;
            this.axis[0] = 0.0;
            return;
        }
        AbstractModel abstractModel = this.getModelFromPlotInit();
        if (abstractModel instanceof SIMCAModel) {
            SIMCAModel sIMCAModel = (SIMCAModel)abstractModel;
            Map<Byte, AbstractPlotSettingsBox> map = abstractAxisLayer.getSettingsBoxMap();
            for (int i = 0; i < this.axis.length; ++i) {
                this.axis[i] = this.getDcritX(sIMCAModel, map, i);
            }
        }
    }

    @Override
    public AbstractSettingsPanel createSettingsPanel() {
        return new AbstractSettingsPanel(){};
    }

    @Override
    public void setValue(int n, double d, double d2, boolean bl) {
        if (this.layer != null) {
            SIMCAModel sIMCAModel = (SIMCAModel)this.getModelFromPlotInit();
            Map<Byte, AbstractPlotSettingsBox> map = this.layer.getSettingsBoxMap();
            this.setDcritX(sIMCAModel, map, n, d);
        }
    }

    @Override
    public boolean supportData(DataTreeInterface dataTreeInterface) {
        AbstractDataMatrix abstractDataMatrix;
        if (dataTreeInterface instanceof FloatWindowScatter && (abstractDataMatrix = ((FloatWindowScatter)dataTreeInterface).getPlotInit().getMatrix(0)) instanceof ModelMatrix) {
            if (abstractDataMatrix.getTreeParent() instanceof SIMCApredictionNode || abstractDataMatrix.getTreeParent() instanceof SIMCAModel || abstractDataMatrix.toString().equals("obsdmx")) {
                return true;
            }
            return abstractDataMatrix.toString().startsWith("DmodX SIMCA") || abstractDataMatrix.toString().equals(SIMCApredictionNode.PRED_MATRIX_NAME);
        }
        return false;
    }

    @Override
    public String toNiceString() {
        return "Coomans";
    }

    public String toString() {
        return "[COOMANS]";
    }

    @Override
    protected AbstractModel getModelFromPlotInit() {
        PlotInit plotInit = this.layer.getPlotInit();
        DataTreeInterface dataTreeInterface = plotInit.getDataTreeInterface();
        if (dataTreeInterface instanceof AbstractModel) {
            return (AbstractModel)dataTreeInterface;
        }
        if (dataTreeInterface instanceof ModelMatrix) {
            ModelMatrix modelMatrix = (ModelMatrix)dataTreeInterface;
            DataTreeInterface dataTreeInterface2 = modelMatrix.getTreeParent();
            if (dataTreeInterface2 instanceof SIMCApredictionNode) {
                return ((SIMCApredictionNode)dataTreeInterface2).getModel();
            }
            return (AbstractModel)dataTreeInterface2;
        }
        return null;
    }

    @Override
    protected int getType() {
        return 20;
    }

    private double getDcritX(SIMCAModel sIMCAModel, Map<Byte, AbstractPlotSettingsBox> map, int n) {
        AbstractPlotSettingsBox abstractPlotSettingsBox = map.get((byte)n);
        if (sIMCAModel != null && abstractPlotSettingsBox != null) {
            return sIMCAModel.getDcritX(abstractPlotSettingsBox.getAxisIndex());
        }
        return 0.0;
    }

    private void setDcritX(SIMCAModel sIMCAModel, Map<Byte, AbstractPlotSettingsBox> map, int n, double d) {
        AbstractPlotSettingsBox abstractPlotSettingsBox = map.get((byte)n);
        if (sIMCAModel != null && abstractPlotSettingsBox != null) {
            sIMCAModel.setDcritX(abstractPlotSettingsBox.getAxisIndex(), d);
        }
    }
}

