/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model.info.statistics;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import se.prediktera.map.common.JTextFieldButtonUppDown;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.AbstractPrediction;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.plot2D.serie.serie2D.FloatWindowSerie;
import se.prediktera.map.plot.axisplot.settings.AbstractSettingsPanel;
import se.prediktera.map.plot.axisplot.settings.ComboBoxAxis;
import se.prediktera.mda.Statistics;
import se.prediktera.mda.model.info.statistics.AbstractStatisticsLineInfo;

public class CriticalDistanceInfo
extends AbstractStatisticsLineInfo {
    private boolean isX = true;
    private DcritSettingsPanel settingsPanel = new DcritSettingsPanel();

    public CriticalDistanceInfo() {
        super(new boolean[]{false, true, false});
    }

    public CriticalDistanceInfo(boolean[] blArray) {
        super(blArray);
    }

    @Override
    public void calculate(AbstractAxisLayer abstractAxisLayer, AbstractDataMatrix abstractDataMatrix, int n) {
        this.layer = abstractAxisLayer;
        ModelMatrix modelMatrix = (ModelMatrix)abstractDataMatrix;
        AbstractModel abstractModel = this.getModel(modelMatrix);
        boolean bl = true;
        if (abstractModel != null) {
            double d;
            ModelMatrix modelMatrix2 = modelMatrix.getAdditionalMatrix();
            if (modelMatrix2 != null) {
                ComboBoxAxis comboBoxAxis = (ComboBoxAxis)abstractAxisLayer.getSettingsBoxMap().get(this.getComboAxisIndex());
                if (comboBoxAxis != null) {
                    int n2 = comboBoxAxis.getAxisIndex();
                    boolean bl2 = bl = n2 == modelMatrix2.getN() - 1;
                    this.basedcrit = n2 < modelMatrix2.getN() ? modelMatrix2.getScalar(n2) : -1.0;
                }
            } else {
                this.basedcrit = -1.0;
            }
            this.settingsPanel.setModel(abstractModel);
            this.axis[1] = this.axis[2] = (d = this.isX ? abstractModel.getDcritX() : abstractModel.getDcritY());
            this.axis[0] = this.axis[2];
            this.included[this.getComboAxisIndex()] = bl && abstractModel.isUseDcrit();
            return;
        }
        int n3 = this.calculateMeanAndVariance(abstractAxisLayer);
        if (n3 <= 1) {
            this.axis[2] = 0.0;
            this.axis[1] = 0.0;
            this.axis[0] = 0.0;
            return;
        }
        double d = Statistics.getT005(n3 - 1);
        this.axis[0] = this.xMean + d * this.xVariance;
        this.axis[1] = this.yMean + d * this.yVariance;
        this.axis[2] = this.zMean + d * this.zVariance;
    }

    @Override
    public AbstractSettingsPanel createSettingsPanel() {
        return this.settingsPanel;
    }

    @Override
    public void setValue(int n, double d, double d2, boolean bl) {
        if (this.layer != null) {
            AbstractModel abstractModel = this.getModelFromPlotInit();
            if (this.isX) {
                abstractModel.setDcritX(d);
            } else {
                abstractModel.setDcritY(d);
            }
            this.axis[1] = d;
        }
    }

    @Override
    public boolean supportData(DataTreeInterface dataTreeInterface) {
        AbstractDataMatrix abstractDataMatrix;
        if (this.supportDti(dataTreeInterface) && (abstractDataMatrix = ((AbstractAxisPlot)dataTreeInterface).getPlotInit().getMatrix(0)) instanceof ModelMatrix && (abstractDataMatrix.toString().equalsIgnoreCase("ObsDMX") || abstractDataMatrix.toString().equalsIgnoreCase("ObsDMY") || abstractDataMatrix.toString().equalsIgnoreCase("ObsDMXpred") || abstractDataMatrix.toString().equalsIgnoreCase("ObsDMYpred"))) {
            if (abstractDataMatrix.toString().equalsIgnoreCase("ObsDMY") || abstractDataMatrix.toString().equalsIgnoreCase("ObsDMYpred")) {
                this.isX = false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String toNiceString() {
        return "Dcrit";
    }

    public String toString() {
        return "[DCRIT]";
    }

    protected byte getComboAxisIndex() {
        return 1;
    }

    @Override
    protected int getType() {
        return 16;
    }

    protected boolean supportDti(DataTreeInterface dataTreeInterface) {
        return dataTreeInterface instanceof FloatWindowSerie;
    }

    private AbstractModel getModel(ModelMatrix modelMatrix) {
        if (modelMatrix != null) {
            if (modelMatrix.getTreeParent() instanceof AbstractPrediction) {
                return ((AbstractPrediction)modelMatrix.getTreeParent()).getModel();
            }
            return modelMatrix.getModel();
        }
        return null;
    }

    private class DcritSettingsPanel
    extends AbstractSettingsPanel {
        private final JTextFieldButtonUppDown pText = new JTextFieldButtonUppDown();
        private final JCheckBox dmodxCheck = new JCheckBox("Enable Dcrit filtering");
        private final JLabel dcritLabel = new JLabel("Set X Model Distance(Dcrit)");
        private final JTextField dcritText = new JTextField(20);
        private final JButton setDcritButton = new JButton("set");
        private AbstractModel model;

        public DcritSettingsPanel() {
            JLabel jLabel = new JLabel("Significance level");
            this.pText.setNumber(0.05);
            this.pText.setNumberChangedInterface((n, d) -> {
                if (CriticalDistanceInfo.this.isX) {
                    this.model.setDcritP(d);
                    this.model.recalculateDcrit();
                    this.dcritText.setText(Double.toString(this.model.getDcritX()));
                } else {
                    this.model.setDcritY(d);
                }
            });
            if (this.model != null) {
                this.dmodxCheck.setSelected(this.model.isUseDcrit());
            }
            this.dmodxCheck.addActionListener(actionEvent -> this.model.setUseDcrit(this.dmodxCheck.isSelected()));
            if (this.model != null) {
                this.dcritText.setText(NiceDataFormat.toString(this.model.getDcritX()));
            }
            this.setDcritButton.addActionListener(actionEvent -> this.model.setDcritX(NiceDataFormat.toNumber(this.dcritText.getText())));
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add("West", this.dcritText);
            jPanel.add("East", this.setDcritButton);
            this.northPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 18, 1, new Insets(6, 6, 0, 6), 0, 0));
            this.northPanel.add((Component)this.pText, new GridBagConstraints(0, 1, 0, 1, 1.0, 1.0, 18, 1, new Insets(6, 6, 6, 6), 0, 0));
            this.northPanel.add((Component)this.dcritLabel, new GridBagConstraints(0, 2, 0, 1, 1.0, 1.0, 18, 1, new Insets(6, 6, 0, 6), 0, 0));
            this.northPanel.add((Component)jPanel, new GridBagConstraints(0, 3, 0, 1, 1.0, 1.0, 18, 1, new Insets(6, 6, 0, 6), 0, 0));
            this.northPanel.add((Component)this.dmodxCheck, new GridBagConstraints(0, 4, 0, 1, 1.0, 1.0, 18, 1, new Insets(6, 6, 6, 6), 0, 0));
        }

        public void setModel(AbstractModel abstractModel) {
            this.model = abstractModel;
            this.pText.setNumber(CriticalDistanceInfo.this.isX ? abstractModel.getDcritX() : abstractModel.getDcritY());
            this.dcritText.setText(NiceDataFormat.toString(abstractModel.getDcritX()));
            this.dmodxCheck.setSelected(abstractModel.isUseDcrit());
        }
    }
}

