/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model.info.statistics;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Stroke;
import java.io.IOException;
import javax.swing.JLabel;
import org.apache.commons.math3.distribution.FDistribution;
import se.prediktera.map.common.JTextFieldButtonUppDown;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.components.paint.AbstractPaint;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.plot2D.scatter.FloatWindowScatter;
import se.prediktera.map.plot.axisplot.settings.AbstractSettingsPanel;
import se.prediktera.map.plot.axisplot.settings.Statistics.AbstractStatisticsInfo;

public class HotellingStatisticsInfo
extends AbstractStatisticsInfo {
    private double[] minMax;
    private HotellingSettingsPanel settingsPanel = new HotellingSettingsPanel();

    @Override
    public void adjustMinMax(AbstractAxisLayer abstractAxisLayer, int n, double[] dArray) {
        if (0 <= n && n < 3) {
            this.calculate(abstractAxisLayer, null, 0);
            double d = this.minMax[n] - 0.1 * Math.abs(this.minMax[n]);
            double d2 = this.minMax[n + 3] + 0.1 * Math.abs(this.minMax[n + 3]);
            if (dArray[0] > d) {
                dArray[0] = d;
            }
            if (dArray[1] < d2) {
                dArray[1] = d2;
            }
        }
    }

    @Override
    public void calculate(AbstractAxisLayer abstractAxisLayer, AbstractDataMatrix abstractDataMatrix, int n) {
        double d = this.calculateMeanAndVariance(abstractAxisLayer);
        this.minMax = new double[6];
        double d2 = this.settingsPanel.getPValue();
        if (d > 1.0) {
            int n2 = (int)(d - 2.0);
            double d3 = this.getFcritical(2, n2, d2);
            double d4 = Math.sqrt(d3 * 2.0 * (d * d - 1.0) / (d * (d - 2.0)));
            this.minMax[0] = this.xMean - this.xVariance * d4;
            this.minMax[1] = this.yMean - this.yVariance * d4;
            this.minMax[2] = this.zMean - this.zVariance * d4;
            this.minMax[3] = this.xMean + this.xVariance * d4;
            this.minMax[4] = this.yMean + this.yVariance * d4;
            this.minMax[5] = this.zMean + this.zVariance * d4;
        }
    }

    @Override
    public AbstractSettingsPanel createSettingsPanel() {
        return this.settingsPanel;
    }

    @Override
    public void draw(Graphics2D graphics2D, AbstractAxisPlot abstractAxisPlot, AbstractAxisLayer abstractAxisLayer, AbstractDataMatrix abstractDataMatrix, int n, double d, double d2) {
    }

    @Override
    public void drawInBg(Graphics2D graphics2D, AbstractAxisPlot abstractAxisPlot, AbstractAxisLayer abstractAxisLayer, AbstractDataMatrix abstractDataMatrix, int n, double d, double d2) {
        if (abstractAxisPlot instanceof FloatWindowScatter) {
            FloatWindowScatter floatWindowScatter = (FloatWindowScatter)abstractAxisPlot;
            if (Double.compare(this.minMax[0], this.minMax[3]) == 0 || Double.compare(this.minMax[1], this.minMax[4]) == 0) {
                return;
            }
            Color color = graphics2D.getColor();
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setColor(abstractAxisPlot.getAxisColor());
            int[] nArray = new int[2];
            int[] nArray2 = new int[2];
            floatWindowScatter.translateToScreenInt(nArray, this.minMax[0], this.minMax[4]);
            floatWindowScatter.translateToScreenInt(nArray2, this.minMax[3], this.minMax[1]);
            nArray2[0] = nArray2[0] - nArray[0];
            nArray2[1] = nArray2[1] - nArray[1];
            graphics2D.setStroke(AbstractPaint.stroke);
            graphics2D.drawOval(nArray[0], nArray[1], nArray2[0], nArray2[1]);
            graphics2D.setColor(color);
            graphics2D.setStroke(stroke);
        }
    }

    @Override
    public void load(MapProperty mapProperty) throws IOException {
        this.minMax = mapProperty.getPropertyDoubleArray("minMax0", null);
        if (this.minMax == null) {
            this.minMax = new double[6];
            double[] dArray = mapProperty.getPropertyDoubleArray("sdata", null);
            if (dArray != null) {
                this.minMax[0] = -dArray[0];
                this.minMax[1] = -dArray[1];
                this.minMax[2] = -dArray[2];
                this.minMax[3] = dArray[0];
                this.minMax[4] = dArray[1];
                this.minMax[5] = dArray[2];
            }
        }
        this.settingsPanel.setPValue(mapProperty.getPropertyDouble("pvalue", 0.05));
    }

    @Override
    public void save(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.writePropertyDoubleArray("minMax0", this.minMax);
        randomOutputStream.writePropertyDouble("pvalue", this.settingsPanel.getPValue());
    }

    @Override
    public boolean supportData(DataTreeInterface dataTreeInterface) {
        if (dataTreeInterface instanceof FloatWindowScatter) {
            AbstractDataMatrix abstractDataMatrix = ((FloatWindowScatter)dataTreeInterface).getPlotInit().getMatrix(0);
            return abstractDataMatrix instanceof ModelMatrix && abstractDataMatrix.toString().equalsIgnoreCase("T");
        }
        return false;
    }

    @Override
    public String toNiceString() {
        return "Hotelling";
    }

    public String toString() {
        return "[HOTELLING]";
    }

    @Override
    protected int getType() {
        return 15;
    }

    private double getFcritical(int n, int n2, double d) {
        try {
            FDistribution fDistribution = new FDistribution((double)n, (double)n2);
            return fDistribution.inverseCumulativeProbability(1.0 - d);
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
            return 0.0;
        }
    }

    private class HotellingSettingsPanel
    extends AbstractSettingsPanel {
        private final JTextFieldButtonUppDown textField = new JTextFieldButtonUppDown();

        public HotellingSettingsPanel() {
            JLabel jLabel = new JLabel("Significance level");
            this.textField.setNumber(0.05);
            this.northPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 18, 1, new Insets(6, 6, 0, 6), 0, 0));
            this.northPanel.add((Component)this.textField, new GridBagConstraints(0, 1, 0, 1, 1.0, 1.0, 18, 1, new Insets(6, 6, 6, 6), 0, 0));
        }

        public double getPValue() {
            return this.textField.getNumber();
        }

        public void setPValue(double d) {
            this.textField.setNumber(d);
        }
    }
}

