/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model.info.statistics;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import se.prediktera.map.common.JTextFieldButtonUppDown;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.AbstractPrediction;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.plot2D.serie.serie2D.FloatWindowSerie;
import se.prediktera.map.plot.axisplot.settings.AbstractSettingsPanel;
import se.prediktera.map.plot.axisplot.settings.ComboBoxAxis;
import se.prediktera.mda.model.info.statistics.AbstractStatisticsLineInfo;

public class HotellingT2Info
extends AbstractStatisticsLineInfo {
    private HotellingT2SettingsPanel settingsPanel = new HotellingT2SettingsPanel();

    public HotellingT2Info() {
        super(new boolean[]{false, true, false});
    }

    public HotellingT2Info(boolean[] blArray) {
        super(blArray);
    }

    @Override
    protected String getName() {
        return "Value";
    }

    @Override
    public void calculate(AbstractAxisLayer abstractAxisLayer, AbstractDataMatrix abstractDataMatrix, int n) {
        this.layer = abstractAxisLayer;
        ModelMatrix modelMatrix = (ModelMatrix)abstractDataMatrix;
        AbstractModel abstractModel = this.getModel(modelMatrix);
        boolean bl = true;
        if (abstractModel != null) {
            ModelMatrix modelMatrix2 = modelMatrix.getAdditionalMatrix();
            if (modelMatrix2 != null) {
                ComboBoxAxis comboBoxAxis = (ComboBoxAxis)abstractAxisLayer.getSettingsBoxMap().get(this.getComboAxisIndex());
                if (comboBoxAxis != null) {
                    int n2 = comboBoxAxis.getAxisIndex();
                    boolean bl2 = bl = n2 == modelMatrix2.getN() - 1;
                    this.basedcrit = n2 < modelMatrix2.getN() ? modelMatrix2.getScalar(n2) : -1.0;
                }
            } else {
                this.basedcrit = -1.0;
            }
            this.settingsPanel.setModel(abstractModel);
            this.axis[1] = this.axis[2] = abstractModel.getHotellingt2();
            this.axis[0] = this.axis[2];
            this.included[this.getComboAxisIndex()] = bl && abstractModel.isUseHotelling();
        }
    }

    @Override
    public AbstractSettingsPanel createSettingsPanel() {
        return this.settingsPanel;
    }

    @Override
    public void setValue(int n, double d, double d2, boolean bl) {
        if (this.layer != null) {
            AbstractModel abstractModel = this.getModelFromPlotInit();
            abstractModel.setHotellingt2(d);
            this.axis[1] = d;
        }
    }

    @Override
    public boolean supportData(DataTreeInterface dataTreeInterface) {
        if (this.supportDti(dataTreeInterface)) {
            AbstractDataMatrix abstractDataMatrix = ((AbstractAxisPlot)dataTreeInterface).getPlotInit().getMatrix(0);
            String string = EvinceScriptCommands.removeSpace(abstractDataMatrix.toString());
            if (abstractDataMatrix instanceof ModelMatrix && (string.equalsIgnoreCase("HotellingT2") || string.equalsIgnoreCase("HotellingT2pred"))) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toNiceString() {
        return "Hotelling T2";
    }

    public String toString() {
        return "[HOTELLING T2]";
    }

    protected byte getComboAxisIndex() {
        return 1;
    }

    @Override
    protected int getType() {
        return 29;
    }

    protected boolean supportDti(DataTreeInterface dataTreeInterface) {
        return dataTreeInterface instanceof FloatWindowSerie;
    }

    private AbstractModel getModel(ModelMatrix modelMatrix) {
        if (modelMatrix != null) {
            if (modelMatrix.getTreeParent() instanceof AbstractPrediction) {
                return ((AbstractPrediction)modelMatrix.getTreeParent()).getModel();
            }
            return modelMatrix.getModel();
        }
        return null;
    }

    private class HotellingT2SettingsPanel
    extends AbstractSettingsPanel {
        private final JTextFieldButtonUppDown pText = new JTextFieldButtonUppDown();
        private final JCheckBox hotellingT2Check = new JCheckBox("Enable Hotelling T2");
        private final JLabel hotellingT2Label = new JLabel("Set Hotelling T2");
        private final JTextField hotellingT2Text = new JTextField(20);
        private final JButton setHotellingT2Button = new JButton("set");
        private AbstractModel model;

        public HotellingT2SettingsPanel() {
            JLabel jLabel = new JLabel("Significance level");
            this.pText.setNumber(0.05);
            this.pText.setNumberChangedInterface((n, d) -> {
                this.model.setHotellingt2P(d);
                this.model.recalculateHotellingT2();
                this.hotellingT2Text.setText(Double.toString(this.model.getHotellingt2()));
            });
            if (this.model != null) {
                this.hotellingT2Check.setSelected(this.model.isUseHotelling());
            }
            this.hotellingT2Check.addActionListener(actionEvent -> this.model.setUseHotelling(this.hotellingT2Check.isSelected()));
            if (this.model != null) {
                this.hotellingT2Text.setText(NiceDataFormat.toString(this.model.getHotellingt2()));
            }
            this.setHotellingT2Button.addActionListener(actionEvent -> this.model.setHotellingt2(NiceDataFormat.toNumber(this.hotellingT2Text.getText())));
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add("West", this.hotellingT2Text);
            jPanel.add("East", this.setHotellingT2Button);
            this.northPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 18, 1, new Insets(6, 6, 0, 6), 0, 0));
            this.northPanel.add((Component)this.pText, new GridBagConstraints(0, 1, 0, 1, 1.0, 1.0, 18, 1, new Insets(6, 6, 6, 6), 0, 0));
            this.northPanel.add((Component)this.hotellingT2Label, new GridBagConstraints(0, 2, 0, 1, 1.0, 1.0, 18, 1, new Insets(6, 6, 0, 6), 0, 0));
            this.northPanel.add((Component)jPanel, new GridBagConstraints(0, 3, 0, 1, 1.0, 1.0, 18, 1, new Insets(6, 6, 0, 6), 0, 0));
            this.northPanel.add((Component)this.hotellingT2Check, new GridBagConstraints(0, 4, 0, 1, 1.0, 1.0, 18, 1, new Insets(6, 6, 6, 6), 0, 0));
        }

        public void setModel(AbstractModel abstractModel) {
            this.model = abstractModel;
            this.pText.setNumber(abstractModel.getHotellingt2());
            this.hotellingT2Text.setText(NiceDataFormat.toString(abstractModel.getHotellingt2()));
            this.hotellingT2Check.setSelected(abstractModel.isUseHotelling());
        }
    }
}

