/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model.info.statistics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.io.IOException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.AxisRange;
import se.prediktera.map.plot.axisplot.plot2D.scatter.FloatWindowScatter;
import se.prediktera.map.plot.axisplot.settings.AbstractPlotSettingsBox;
import se.prediktera.map.plot.axisplot.settings.AbstractSettingsPanel;
import se.prediktera.map.plot.axisplot.settings.SettingsBoxInterface;
import se.prediktera.map.plot.axisplot.settings.Statistics.AbstractStatisticsInfo;
import se.prediktera.mda.model.PLS.PLSpredictionNode;
import se.prediktera.mda.model.PLSDA.PLSDAModel;

public class YvsYcalcStatisticsInfo
extends AbstractStatisticsInfo
implements SettingsBoxInterface {
    private static final BasicStroke stroke = new BasicStroke(2.0f, 0, 0);
    private PLSDAModel plsDAModel = null;
    private final double[] minmax = new double[2];
    private int comp;
    private int classIndex;
    private int yindex;

    @Override
    public void adjustMinMax(AbstractAxisLayer abstractAxisLayer, int n, double[] dArray) {
        if (this.plsDAModel == null) {
            this.setPLSDAModel(abstractAxisLayer.getPlotInit().getDataTreeInterface());
        }
        if (n == 0 && this.plsDAModel != null) {
            if (dArray[0] > this.plsDAModel.getCutOffLow()) {
                dArray[0] = this.plsDAModel.getCutOffLow();
            }
            if (dArray[1] < Math.max(1.5, this.plsDAModel.getCutOffHigh())) {
                dArray[1] = Math.max(1.5, this.plsDAModel.getCutOffHigh());
            }
        }
    }

    @Override
    public void calculate(AbstractAxisLayer abstractAxisLayer, AbstractDataMatrix abstractDataMatrix, int n) {
        this.plsDAModel = null;
        if (abstractDataMatrix.getTreeParent() instanceof PLSDAModel) {
            this.plsDAModel = (PLSDAModel)abstractDataMatrix.getTreeParent();
        }
    }

    @Override
    public AbstractSettingsPanel createSettingsPanel() {
        return new AbstractSettingsPanel(){};
    }

    @Override
    public void draw(Graphics2D graphics2D, AbstractAxisPlot abstractAxisPlot, AbstractAxisLayer abstractAxisLayer, AbstractDataMatrix abstractDataMatrix, int n, double d, double d2) {
        this.plsDAModel = null;
        this.setPLSDAModel(abstractDataMatrix);
        if (this.plsDAModel == null) {
            return;
        }
        FloatWindowScatter floatWindowScatter = (FloatWindowScatter)abstractAxisPlot;
        floatWindowScatter.setPlotGroundClip(graphics2D);
        graphics2D.setColor(Color.red);
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(YvsYcalcStatisticsInfo.stroke);
        double d3 = this.minmax[0] = this.plsDAModel.getCutOffLow();
        this.drawMinMax(graphics2D, floatWindowScatter, d3);
        double d4 = this.minmax[1] = this.plsDAModel.getCutOffHigh();
        this.drawMinMax(graphics2D, floatWindowScatter, d4);
        AbstractPlotSettingsBox abstractPlotSettingsBox = abstractAxisLayer.getComboBox((byte)0);
        int n2 = abstractPlotSettingsBox.getAxisIndex();
        AbstractPlotSettingsBox abstractPlotSettingsBox2 = abstractAxisLayer.getComboBox((byte)1);
        int n3 = abstractPlotSettingsBox2.getAxisIndex();
        double[][] dArray = this.plsDAModel.getMeanZeroArray();
        double[][] dArray2 = this.plsDAModel.getStdZeroArray();
        this.drawConfInterval(graphics2D, floatWindowScatter, dArray, dArray2, 0, n2, n3);
        double[][] dArray3 = this.plsDAModel.getMeanOneArray();
        double[][] dArray4 = this.plsDAModel.getStdOneArray();
        this.drawConfInterval(graphics2D, floatWindowScatter, dArray3, dArray4, 1, n2, n3);
        graphics2D.setStroke(stroke);
    }

    @Override
    public int hasStatisticAt(double d, double d2, AbstractAxisPlot abstractAxisPlot) {
        AxisRange axisRange = abstractAxisPlot.getRange(0, 0);
        AxisRange axisRange2 = abstractAxisPlot.getRange(1, 0);
        double[] dArray = new double[2];
        for (int i = 0; i < 2; ++i) {
            abstractAxisPlot.translateToScreenDouble(dArray, this.minmax[i], 0.0, axisRange, axisRange2);
            if (!(dArray[0] - 2.0 <= d) || !(dArray[0] + 2.0 >= d)) continue;
            this.yindex = i;
            return 0;
        }
        return -1;
    }

    @Override
    public void load(MapProperty mapProperty) throws IOException {
    }

    @Override
    public void save(RandomOutputStream randomOutputStream) throws IOException {
    }

    @Override
    public void setValue(int n, double d, double d2, boolean bl) {
        if (this.plsDAModel == null) {
            return;
        }
        if (this.yindex == 0) {
            if (this.plsDAModel.getCutOffHigh() < d2) {
                d2 = this.plsDAModel.getCutOffHigh();
            }
            this.plsDAModel.setCutOffLow(d2);
        } else {
            if (this.plsDAModel.getCutOffLow() > d2) {
                d2 = this.plsDAModel.getCutOffLow();
            }
            this.plsDAModel.setCutOffHigh(d2);
        }
        this.plsDAModel.updatePLSDAclassification();
    }

    @Override
    public boolean supportData(DataTreeInterface dataTreeInterface) {
        FloatWindowScatter floatWindowScatter;
        DataTreeInterface dataTreeInterface2;
        AbstractModel abstractModel;
        if (dataTreeInterface instanceof FloatWindowScatter && (abstractModel = (AbstractModel)DataTreeManager.getAncestorNull(dataTreeInterface2 = (floatWindowScatter = (FloatWindowScatter)dataTreeInterface).getPlotInit().getDataTreeInterface(), AbstractModel.class)) instanceof PLSDAModel) {
            String string = floatWindowScatter.getPlotInit().plotSettings;
            return string.contains("ycalc");
        }
        return false;
    }

    @Override
    public String toNiceString() {
        return "Min/max limits";
    }

    public String toString() {
        return "[MIN/MAX LIMITS]";
    }

    @Override
    protected int getType() {
        return 17;
    }

    private void drawConfInterval(Graphics2D graphics2D, FloatWindowScatter floatWindowScatter, double[][] dArray, double[][] dArray2, int n, int n2, int n3) {
        if (dArray != null && n2 - 1 < dArray.length && n3 < dArray[0].length && dArray2 != null) {
            this.comp = n2;
            this.classIndex = n3;
            double[] dArray3 = new double[2];
            double[] dArray4 = new double[2];
            double d = dArray[n2 - 1][n3];
            double d2 = dArray2[n2 - 1][n3];
            floatWindowScatter.translateToScreenDouble(dArray3, d - d2, n);
            floatWindowScatter.translateToScreenDouble(dArray4, d + d2, (double)n + 0.05);
            int n4 = (int)(dArray4[1] - dArray3[1]);
            graphics2D.drawLine((int)dArray3[0], (int)dArray3[1], (int)dArray4[0], (int)dArray3[1]);
            graphics2D.drawLine((int)dArray3[0], (int)dArray3[1] - n4, (int)dArray3[0], (int)dArray3[1] + n4);
            graphics2D.drawLine((int)dArray4[0], (int)dArray3[1] - n4, (int)dArray4[0], (int)dArray3[1] + n4);
        }
    }

    private void drawMinMax(Graphics2D graphics2D, FloatWindowScatter floatWindowScatter, double d) {
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        floatWindowScatter.translateToScreenDouble(dArray, d, -0.05);
        floatWindowScatter.translateToScreenDouble(dArray2, d, 1.05);
        graphics2D.drawLine((int)dArray[0], (int)dArray[1], (int)dArray2[0], (int)dArray2[1]);
    }

    private void setPLSDAModel(DataTreeInterface dataTreeInterface) {
        PLSpredictionNode pLSpredictionNode;
        DataTreeInterface dataTreeInterface2;
        if (dataTreeInterface.getTreeParent() instanceof PLSDAModel) {
            this.plsDAModel = (PLSDAModel)dataTreeInterface.getTreeParent();
        }
        if ((dataTreeInterface2 = dataTreeInterface.getTreeParent()) instanceof PLSpredictionNode && !(pLSpredictionNode = (PLSpredictionNode)dataTreeInterface2).isExternal()) {
            this.plsDAModel = (PLSDAModel)pLSpredictionNode.getModel();
        }
    }
}

