/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model.info.transformation;

import java.io.IOException;
import no.uib.cipr.matrix.Matrix;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.datasetcontainer.transform.AbstractDataTransform;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;
import se.prediktera.map.datasetcontainer.transform.Transformations;
import se.prediktera.map.main.extclass.DataTreeExtLibInterface;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.mda.model.AbstractMDAModel;
import se.prediktera.mda.model.info.transformation.ScoreTransformationPanel;

public class ScoreTransformation
extends AbstractDataTransform
implements DataTreeExtLibInterface {
    private final AbstractMDAModel model;

    public ScoreTransformation(AbstractDataInfo abstractDataInfo, boolean bl, AbstractMDAModel abstractMDAModel) {
        super(abstractDataInfo, bl);
        this.model = abstractMDAModel;
    }

    public ScoreTransformation(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.model = (AbstractMDAModel)mapProperty.resolveNodeFromName(randomInputStream, "model");
    }

    public ScoreTransformation(Transformations transformations, AbstractDataTransform abstractDataTransform, AbstractMDAModel abstractMDAModel) {
        super(transformations, abstractDataTransform);
        this.model = abstractMDAModel;
    }

    @Override
    public AbstractDataMatrix applyTransformationLocal(AbstractDataMatrix abstractDataMatrix, Matrix matrix, ProgressManager progressManager) throws Exception {
        int n = 0;
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)this.ic;
        for (int i = 0; i < this.ic.getSize(); ++i) {
            if (!innerColumnBoolean.getValueBool(i)) continue;
            ++n;
        }
        if (n == 0) {
            if (progressManager != null) {
                progressManager.incStep(2 * abstractDataMatrix.getN() * abstractDataMatrix.getK());
            }
            return null;
        }
        MVmatrix mVmatrix = this.isObs ? new MVmatrix(n, abstractDataMatrix.getK()) : new MVmatrix(abstractDataMatrix.getN(), n);
        mVmatrix.setName(this.toString());
        String[] stringArray = new String[n];
        int n2 = 0;
        double d = 1.0 / Math.log(10.0);
        for (int i = 0; i < this.ic.getSize(); ++i) {
            if (!innerColumnBoolean.getValueBool(i)) {
                if (progressManager == null) continue;
                progressManager.incStep(2 * (this.isObs ? abstractDataMatrix.getK() : abstractDataMatrix.getN()));
                continue;
            }
            if (this.isObs) {
                stringArray[n2] = "log " + abstractDataMatrix.getRowDescription(i, 0);
                for (var12_12 = 0; var12_12 < abstractDataMatrix.getK(); ++var12_12) {
                    var13_13 = Math.log(abstractDataMatrix.getValue(var12_12, i)) * d;
                    mVmatrix.setValueCheckMissing(n2, var12_12, var13_13);
                    if (progressManager == null) continue;
                    progressManager.incStep(2);
                }
            } else {
                stringArray[n2] = "log " + abstractDataMatrix.getColumnDescription(i, 0);
                for (var12_12 = 0; var12_12 < abstractDataMatrix.getN(); ++var12_12) {
                    var13_13 = Math.log(abstractDataMatrix.getValue(var12_12, i)) * d;
                    mVmatrix.setValueCheckMissing(var12_12, n2, var13_13);
                    if (progressManager == null) continue;
                    progressManager.incStep(2);
                }
            }
            ++n2;
        }
        if (this.isObs) {
            this.setObsDescription(mVmatrix, stringArray);
        } else {
            this.setVarDescription(mVmatrix, stringArray);
        }
        return mVmatrix;
    }

    @Override
    public AbstractTransform<Boolean> cloneThis(Transformations transformations) {
        return new ScoreTransformation(transformations, this, this.model);
    }

    @Override
    public ExtClassLoader.LicenseLibrary getLibrary() {
        return ExtClassLoader.LicenseLibrary.MDA;
    }

    @Override
    public String getName() {
        return "Scores";
    }

    @Override
    public String getShortName() {
        return "Scores";
    }

    @Override
    public AbstractTransform.Type getTransformationType() {
        return AbstractTransform.Type.localAdd;
    }

    @Override
    public byte getTreeType() {
        return 6;
    }

    @Override
    public boolean isObservation() {
        return !this.isObs;
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyNode("model", this.model);
    }

    public void setSettingsPanel(ScoreTransformationPanel scoreTransformationPanel, AbstractDataMatrix abstractDataMatrix) {
    }

    @Override
    protected byte changeEffects() {
        return 6;
    }

    @Override
    protected boolean hasResultMatrix() {
        return true;
    }

    @Override
    protected void setIcDefault() {
        ((InnerColumnBoolean)this.ic).setDefaultValue(false);
    }
}

