/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model.tSNE;

import java.util.Properties;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.wizard.AbstractInit;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.Model_GUI;
import se.prediktera.map.main.script.AbstractScriptInfo;
import se.prediktera.map.main.script.ScriptManager;
import se.prediktera.map.main.window.AbstractWindow;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.AbstractModelContainerWindow;
import se.prediktera.map.model.modelgenerator.AbstractModelInfo;
import se.prediktera.map.model.modelgenerator.ModelInit;
import se.prediktera.mda.model.tSNE.TSNEModel;
import se.prediktera.mda.model.tSNE.TSNEPanel;

public class TSNEModelInfo
extends AbstractModelInfo {
    private TSNEPanel tsnePanel;

    @Override
    public String getType() {
        return "tsne";
    }

    @Override
    public ImageIcon getWizardImage() {
        return null;
    }

    @Override
    public String getWizardInfo() {
        return "Create new t-SNE Model";
    }

    @Override
    public boolean supportData(DataTreeInterface dataTreeInterface) {
        return super.supportData(dataTreeInterface);
    }

    @Override
    public boolean supportGUI(Model_GUI model_GUI) {
        return true;
    }

    @Override
    public String toString() {
        return "t-SNE Model";
    }

    @Override
    public Vector<JComponent> createWizard() {
        this.wizard.removeAllElements();
        this.tsnePanel = new TSNEPanel(this);
        this.wizard.add(this.tsnePanel);
        return this.wizard;
    }

    @Override
    public void beginWizard(AbstractInit abstractInit) {
        ModelInit modelInit = (ModelInit)abstractInit;
        modelInit.setModelName(this.toString());
        modelInit.setModelType(this.getType());
        Vector<AbstractModelContainerWindow> vector = this.getSupportedModelWindows(modelInit.getDataContainer());
        if (this.tsnePanel != null) {
            this.tsnePanel.beginWizard(modelInit, vector, this.baseModel);
        }
    }

    @Override
    public boolean checkModel(ModelInit modelInit) {
        return true;
    }

    @Override
    public AbstractWindow createModel(ProgressManager progressManager, ModelInit modelInit) {
        boolean bl = modelInit.getDataTreeInterface() instanceof AbstractModel;
        DataSet dataSet = modelInit.getDataSet();
        progressManager.setInfoText("Preparing model");
        DataTreeManager dataTreeManager = dataSet.getDataTreeManager();
        AbstractDataMatrix abstractDataMatrix = dataSet.getOriginalMatrix();
        dataTreeManager.ClearDataFromMemoryIfExceedPercent(abstractDataMatrix, progressManager, abstractDataMatrix.getDataByteSize(), 0.5);
        this.setModelInitFromPanel(modelInit, dataSet);
        Properties properties = new Properties();
        properties.put("outputdims", String.valueOf(this.tsnePanel.getDimensions()));
        properties.put("initial_dims", "55");
        properties.put("perplexity", String.valueOf(this.tsnePanel.getPerplexity()));
        properties.put("max_iter", "1000");
        properties.put("usepca", this.tsnePanel.usePca() ? "true" : "false");
        TSNEModel tSNEModel = new TSNEModel(progressManager, dataSet, properties);
        if (tSNEModel != null) {
            String string;
            tSNEModel.setName(this.tsnePanel.getModelName(modelInit.getModelName()));
            if (abstractDataMatrix.isLoaded()) {
                dataTreeManager.ClearDataFromMemoryIfExceedPercent(abstractDataMatrix, progressManager, 0L, 0.5);
            }
            System.gc();
            if (!(modelInit.getDataTreeInterface() instanceof AbstractModel)) {
                dataSet.addTreeNode(tSNEModel);
            }
            if (bl) {
                tSNEModel.changeComponent(progressManager, -tSNEModel.getComponentsInt());
            }
            this.calcModel(progressManager, tSNEModel);
            dataTreeManager.ClearDataFromMemoryIfExceedPercent(tSNEModel, progressManager, 0L, 0.5);
            System.gc();
            AbstractScriptInfo abstractScriptInfo = this.tsnePanel.getScriptInfo(modelInit);
            if (abstractScriptInfo != null && (string = abstractScriptInfo.getScript()).length() > 0) {
                try {
                    if (!(modelInit.getDataTreeInterface() instanceof AbstractModel)) {
                        ScriptManager scriptManager = new ScriptManager(null);
                        scriptManager.addVariable(tSNEModel, "model");
                        scriptManager.evaluteScript(progressManager, string);
                    }
                }
                catch (Exception exception) {
                    ErrorHandler.logAndReportException(exception);
                }
            }
        }
        if (this.tsnePanel != null) {
            this.tsnePanel.cleanUp();
            this.tsnePanel = null;
        }
        abstractDataMatrix.exitDiskMode();
        return null;
    }

    private void calcModel(ProgressManager progressManager, TSNEModel tSNEModel) {
        long l = System.currentTimeMillis();
        tSNEModel.beginUpdateRecursive();
        progressManager.setInfoText("Loading data into memory");
        tSNEModel.beginCalculations();
        tSNEModel.doUpdateLocal(progressManager);
        tSNEModel.endCalculations();
        tSNEModel.setDuration(System.currentTimeMillis() - l);
        tSNEModel.endUpdateRecursive();
    }

    protected void setModelInitFromPanel(ModelInit modelInit, DataSet dataSet) {
        modelInit.setModelName(this.tsnePanel.getModelName(this.getDefaultName(modelInit)));
    }

    private String getDefaultName(ModelInit modelInit) {
        return "t-SNE";
    }

    @Override
    public AbstractModel createModel(ProgressManager progressManager, DataSet dataSet, int n, Properties properties) {
        return new TSNEModel(progressManager, dataSet, properties);
    }

    @Override
    public AbstractModelContainerWindow createModelContainerWindow(Case case_, DataContainer dataContainer) {
        return null;
    }
}

