/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model.tSNE;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.swing.JComboBoxCell;
import se.prediktera.map.common.wizard.AbstractWizard;
import se.prediktera.map.common.wizard.WizardPageClass;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.script.AbstractScriptInfo;
import se.prediktera.map.main.script.ScriptManager;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.modelgenerator.ModelInit;
import se.prediktera.mda.model.tSNE.TSNEModelInfo;

public class TSNEPanel
extends WizardPageClass {
    private final JTextField textModelName = new JTextField();
    private final JLabel dataSetLabel = new JLabel();
    private final JComboBoxCell comboBoxDimensions = new JComboBoxCell(false);
    private final SliderInputPanel perplexityInputPanel = new SliderInputPanel();
    private final JComboBoxCell comboBoxSource = new JComboBoxCell(false);
    private DataSet lastDataSet = null;
    private String defaultModelName;
    private final JComboBoxCell scriptComboBox = new JComboBoxCell();
    private int maxdefaultindex = 0;

    public TSNEPanel(TSNEModelInfo tSNEModelInfo) {
        JLabel jLabel = new JLabel("Model settings");
        jLabel.setFont(new Font("Dialog", 1, 12));
        this.setLayout(new GridBagLayout());
        this.add((Component)jLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 12, 0), 0, 0));
        this.add((Component)new JLabel("Model Name:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 18, 0, 0), 0, 0));
        this.add((Component)this.textModelName, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 6, 0, 12), 0, 0));
        this.add((Component)new JLabel("DataSet:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 18, 0, 0), 0, 0));
        this.add((Component)this.dataSetLabel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(6, 6, 0, 12), 0, 0));
        this.comboBoxDimensions.addItem("2");
        this.comboBoxDimensions.addItem("3");
        this.add((Component)new JLabel("Dimensions:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 18, 0, 0), 0, 0));
        this.add((Component)this.comboBoxDimensions, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(6, 6, 0, 12), 0, 0));
        this.perplexityInputPanel.setValue(30);
        this.add((Component)new JLabel("Peplexity:"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 18, 0, 0), 0, 0));
        this.add((Component)this.perplexityInputPanel, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(6, 6, 0, 12), 0, 0));
        this.comboBoxSource.addItem("X-train");
        this.comboBoxSource.addItem("PCA");
        this.add((Component)new JLabel("Data source:"), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 18, 0, 0), 0, 0));
        this.add((Component)this.comboBoxSource, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(6, 6, 0, 12), 0, 0));
        JLabel jLabel2 = new JLabel("Templates");
        jLabel2.setFont(new Font("Dialog", 1, 12));
        this.add((Component)jLabel2, new GridBagConstraints(0, 11, 2, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 12, 0), 0, 0));
        this.add((Component)new JLabel("Template:"), new GridBagConstraints(0, 12, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 18, 0, 0), 0, 0));
        this.add((Component)this.scriptComboBox, new GridBagConstraints(1, 12, 1, 1, 0.0, 0.0, 10, 2, new Insets(6, 6, 0, 12), 0, 0));
        this.add((Component)new JLabel(""), new GridBagConstraints(0, 20, 1, 1, 0.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void beginWizard(ModelInit modelInit, Vector vector, AbstractModel abstractModel) {
        this.lastDataSet = modelInit.getDataSet();
        this.defaultModelName = modelInit.getModelName();
        this.maxdefaultindex = ScriptManager.addScriptInfoComboBox(this.scriptComboBox, "model", modelInit.getModelType(), modelInit);
        this.dataSetLabel.setText(this.lastDataSet.toString());
        this.textModelName.setText(this.defaultModelName);
    }

    public String getModelName(String string) {
        String string2 = this.textModelName.getText();
        if (string2.length() == 0) {
            return string;
        }
        return string2;
    }

    public AbstractScriptInfo getScriptInfo(ModelInit modelInit) {
        Object object = this.scriptComboBox.getSelectedItem();
        if (object instanceof AbstractScriptInfo) {
            AbstractScriptInfo abstractScriptInfo = (AbstractScriptInfo)object;
            String string = "SCRIPT_MODEL_" + modelInit.getModelType() + "_DEFAULT_";
            IniManager.setScriptSettings(string.toUpperCase() + this.maxdefaultindex, abstractScriptInfo.toString());
            return abstractScriptInfo;
        }
        return null;
    }

    @Override
    public void setWizard(AbstractWizard abstractWizard) {
        super.setWizard(abstractWizard);
        abstractWizard.addNextListener(this.textModelName);
    }

    public int getDimensions() {
        return Integer.parseInt((String)this.comboBoxDimensions.getSelectedItem());
    }

    public int getPerplexity() {
        return this.perplexityInputPanel.getValue();
    }

    public boolean usePca() {
        return this.comboBoxSource.getSelectedIndex() == 1;
    }

    @Override
    protected void cleanUpChild() {
        this.lastDataSet = null;
    }

    private class SliderInputPanel
    extends JPanel {
        private final JSlider slider;
        private final JTextField textField;

        public SliderInputPanel() {
            super(new BorderLayout());
            this.slider = new JSlider(1, 100);
            this.textField = new JTextField();
            this.add((Component)this.slider, "Center");
            this.add((Component)this.textField, "East");
            this.textField.setPreferredSize(new Dimension(50, 15));
            this.textField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    SliderInputPanel.this.setSliderValueFromTextField();
                }
            });
            this.textField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        SliderInputPanel.this.setSliderValueFromTextField();
                    }
                }
            });
            this.slider.addChangeListener(changeEvent -> this.textField.setText(String.valueOf(this.slider.getValue())));
        }

        public void setValue(int n) {
            this.slider.setValue(n);
        }

        public int getValue() {
            return this.slider.getValue();
        }

        private void setSliderValueFromTextField() {
            if (NiceDataFormat.isNumber(this.textField.getText())) {
                this.slider.setValue((int)NiceDataFormat.toNumber(this.textField.getText()));
            } else {
                this.textField.setText(String.valueOf(this.slider.getValue()));
            }
        }
    }
}

