/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.selection;

import java.util.ArrayList;
import java.util.List;
import se.prediktera.mda.selection.Distribution;
import se.prediktera.mda.selection.MarengoTodeschini2;
import se.prediktera.mda.selection.MarengoTodeschiniAlgorithm;
import se.prediktera.mda.selection.MtSample;

public class Bin {
    List<MtSample> samples;
    private final ArrayList<float[]> minMaxList;
    private int[] idxArr;

    public Bin(Bin bin) {
        this.idxArr = bin.getIdxArr();
        this.minMaxList = new ArrayList();
        this.minMaxList.addAll(bin.getMinMaxList());
        this.samples = new ArrayList<MtSample>();
    }

    public Bin(Distribution[] distributionArray, int[] nArray) {
        this.idxArr = nArray;
        this.minMaxList = new ArrayList();
        for (int i = 0; i < distributionArray.length; ++i) {
            this.minMaxList.addAll(distributionArray[i].getBin(nArray[i]).getMinMaxList());
        }
        this.samples = new ArrayList<MtSample>();
    }

    public Bin(float f, float f2) {
        this.minMaxList = new ArrayList();
        this.minMaxList.add(new float[]{f, f2});
    }

    public void addSample(MtSample mtSample) {
        this.samples.add(mtSample);
        mtSample.setGridIdx(this);
    }

    public int[] getIdxArr() {
        return this.idxArr;
    }

    public float getMinDistance(MtSample mtSample, MarengoTodeschini2 marengoTodeschini2, MtSample mtSample2) {
        float f = 0.0f;
        float f2 = 3.0E8f;
        for (MtSample mtSample3 : this.samples) {
            if (mtSample3 == mtSample || mtSample3 == mtSample2 || !((f = marengoTodeschini2.getDistance(mtSample.getDistIdx(), mtSample3.getDistIdx())) < f2)) continue;
            f2 = f;
        }
        return f2;
    }

    public ArrayList<float[]> getMinMaxList() {
        return this.minMaxList;
    }

    public MtSample getRandomSample() {
        return this.samples.get(MarengoTodeschiniAlgorithm.staticRandom.nextInt(this.samples.size()));
    }

    public List<MtSample> getSamples() {
        return this.samples;
    }

    public float getShortestEdgeDist(MtSample mtSample) {
        int n = 0;
        float f = 3.0E8f;
        for (float[] fArray : this.minMaxList) {
            for (float f2 : fArray) {
                float f3 = Math.abs(f2 - mtSample.getValues()[n]);
                if (!(f3 < f)) continue;
                f = f3;
            }
            ++n;
        }
        return f;
    }

    public boolean hasMoreSamples() {
        return this.samples.size() > 0;
    }

    public boolean hasNoShorterDist(MtSample mtSample, float f) {
        int n = 0;
        for (float[] fArray : this.minMaxList) {
            for (float f2 : fArray) {
                if (!(Math.abs(f2 - mtSample.getValues()[n]) < f)) continue;
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean hasNoShorterDist(MtSample mtSample, float f, float f2) {
        return f < this.getShortestEdgeDist(mtSample) + f2;
    }

    public MtSample removeRandomSample() {
        int n = this.samples.size();
        return this.samples.remove(MarengoTodeschiniAlgorithm.staticRandom.nextInt(n));
    }

    public void removeSample(MtSample mtSample) {
        this.samples.remove(mtSample);
    }

    public void setSamples(List<MtSample> list) {
        this.samples = list;
    }
}

