/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.selection;

import java.util.ArrayList;
import se.prediktera.mda.selection.Bin;
import se.prediktera.mda.selection.MarengoTodeschini2;
import se.prediktera.mda.selection.MarengoTodeschiniAlgorithm;
import se.prediktera.mda.selection.MtSample;

public abstract class Grid {
    protected ArrayList<Bin> binList = new ArrayList();
    protected ArrayList<MtSample> samples = new ArrayList();
    protected int nrOfSamples;
    protected boolean debug = false;
    public int[] gridSizes;

    public void addSample(MtSample mtSample) {
        ++this.nrOfSamples;
        this.getBin(mtSample).addSample(mtSample);
        this.samples.add(mtSample);
    }

    public abstract Grid clone();

    public abstract void createNonEmptyBinList();

    public boolean distWithinLayer(float f) {
        return f < 3.0E8f;
    }

    public abstract Bin getBin(int[] var1);

    public Bin getBin(MtSample mtSample) {
        int[] nArray = mtSample.getGridIdx();
        return this.getBin(nArray);
    }

    public abstract float getBinWidth();

    public abstract double getDmin(MtSample var1, boolean var2, MtSample var3, MarengoTodeschini2 var4);

    public int getGridSize(int n) {
        return this.gridSizes[n];
    }

    public int getMaxStep(int[] nArray) {
        int n = 0;
        int n2 = 0;
        for (int n3 : nArray) {
            int n4 = this.getGridSize(n2) - n3;
            if (n4 > n) {
                n = n4;
            }
            ++n2;
        }
        return n;
    }

    public int getNrOfSamples() {
        return this.samples.size();
    }

    public MtSample getSample(int n) {
        return this.samples.get(n);
    }

    public ArrayList<MtSample> getSamples() {
        return this.samples;
    }

    public void initSampleList() {
        this.samples.clear();
        for (Bin bin : this.binList) {
            this.samples.addAll(bin.getSamples());
        }
    }

    public MtSample removeRandomSample() {
        if (this.binList.size() > 0) {
            int n;
            while (!this.binList.get(n = MarengoTodeschiniAlgorithm.staticRandom.nextInt(this.binList.size())).hasMoreSamples()) {
            }
            MtSample mtSample = this.binList.get(n).removeRandomSample();
            this.getBin(mtSample).removeSample(mtSample);
            this.samples.remove(mtSample);
            return mtSample;
        }
        return null;
    }

    public MtSample removeSample(int n) {
        MtSample mtSample = this.samples.remove(n);
        this.getBin(mtSample).removeSample(mtSample);
        return mtSample;
    }

    public abstract String toString();
}

