/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.selection;

import se.prediktera.mda.selection.Bin;
import se.prediktera.mda.selection.Grid;
import se.prediktera.mda.selection.MarengoTodeschini2;
import se.prediktera.mda.selection.MtSample;

public class Grid1
extends Grid {
    private final Bin[] bins;

    public Grid1(Bin[] binArray) {
        this.bins = binArray;
        this.setGridSize();
        this.createNonEmptyBinList();
        this.initSampleList();
    }

    public Grid1(Grid grid) {
        this.bins = new Bin[((Grid1)grid).getGridBins().length];
        for (int i = 0; i < this.bins.length; ++i) {
            this.bins[i] = new Bin(((Grid1)grid).getGridBins()[i]);
        }
        this.initSampleList();
        this.setGridSize();
    }

    @Override
    public Grid clone() {
        return new Grid1(this);
    }

    @Override
    public void createNonEmptyBinList() {
        for (Bin bin : this.bins) {
            if (bin.getSamples().size() <= 0) continue;
            this.binList.add(bin);
        }
    }

    @Override
    public Bin getBin(int[] nArray) {
        return this.bins[nArray[0]];
    }

    @Override
    public float getBinWidth() {
        return this.bins[0].getMinMaxList().get(0)[1] - this.bins[0].getMinMaxList().get(0)[0];
    }

    @Override
    public double getDmin(MtSample mtSample, boolean bl, MtSample mtSample2, MarengoTodeschini2 marengoTodeschini2) {
        float f = 0.0f;
        float f2 = 3.0E8f;
        float f3 = this.getBin(mtSample).getMinDistance(mtSample, marengoTodeschini2, mtSample2);
        if (bl ? this.getBin(mtSample).hasNoShorterDist(mtSample, f3) : this.distWithinLayer(f3)) {
            return f3;
        }
        int[] nArray = mtSample.getGridIdx();
        int n = this.getMaxStep(nArray);
        float f4 = this.getBinWidth();
        for (int i = 1; i <= n; ++i) {
            int n2 = i - 1;
            float f5 = (float)i * f4;
            int n3 = (int)Math.pow(2.0, i) + 1;
            for (int j = 0; j < n3; ++j) {
                int n4 = nArray[0] + j - i;
                if (n4 < 0) continue;
                if (n4 >= this.getGridSize(0)) break;
                if (Math.abs(j - i) <= n2) continue;
                int[] nArray2 = new int[]{n4};
                f = this.getBin(nArray2).getMinDistance(mtSample, marengoTodeschini2, mtSample2);
                if (!(f < f2)) continue;
                f2 = f;
            }
            if (f3 < f2) {
                return f3;
            }
            if (!(bl ? this.getBin(mtSample).hasNoShorterDist(mtSample, f2, f5) : this.distWithinLayer(f2))) continue;
            return f2;
        }
        return f2;
    }

    public Bin[] getGridBins() {
        return this.bins;
    }

    public void setGridSize() {
        this.gridSizes = new int[1];
        this.gridSizes[0] = this.bins.length;
    }

    @Override
    public String toString() {
        return "G1";
    }
}

