/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.selection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.dataset.selection.AbstractSelectionInfo;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.mda.selection.Grid;
import se.prediktera.mda.selection.MarengoTodeschini2;
import se.prediktera.mda.selection.MtSample;

public class MarengoTodeschiniAlgorithm
extends AbstractSelectionInfo {
    public static Random staticRandom = new Random(System.currentTimeMillis());

    @Override
    public int[][] getGroupLocal(ProgressManager progressManager, DataSet dataSet, AbstractModel abstractModel, int n, Properties properties) {
        if (properties != null && ScriptHelper.hasKey(properties, "randomseed")) {
            try {
                staticRandom = new Random((long)ScriptHelper.getPropertyDouble(properties, "randomseed"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (abstractModel.getModelName().equals("Model Container")) {
            ArrayList<AbstractModel> arrayList = new ArrayList<AbstractModel>();
            for (int i = 0; i < abstractModel.getTreeNodeCount(); ++i) {
                if (!(abstractModel.getTreeNodeAt(i) instanceof AbstractModel)) continue;
                arrayList.add((AbstractModel)abstractModel.getTreeNodeAt(i));
            }
            int[][] nArrayArray = new int[arrayList.size()][];
            int n2 = 0;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                nArrayArray[n2++] = this.getGroupFromModel(progressManager, dataSet, (AbstractModel)iterator.next(), n);
            }
            return nArrayArray;
        }
        return new int[][]{this.getGroupFromModel(progressManager, dataSet, abstractModel, n)};
    }

    @Override
    public boolean supportData(DataTreeInterface dataTreeInterface) {
        return true;
    }

    @Override
    public String toString() {
        return "Space Filling";
    }

    protected int getNoIterations() {
        return 100;
    }

    private int[] getGroupFromModel(ProgressManager progressManager, DataSet dataSet, AbstractModel abstractModel, int n) {
        ModelMatrix modelMatrix = abstractModel.getScores();
        n = Math.min(n, modelMatrix.getK());
        int[] nArray = modelMatrix.getKref();
        MarengoTodeschini2 marengoTodeschini2 = new MarengoTodeschini2(modelMatrix);
        Grid grid = marengoTodeschini2.selectSamples(n, this.getNoIterations());
        ArrayList<MtSample> arrayList = grid.getSamples();
        int[] nArray2 = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            nArray2[i] = nArray[arrayList.get(i).getIdx()];
        }
        return nArray2;
    }
}

