/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.statistical.manova;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.QR;
import no.uib.cipr.matrix.SVD;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.data.modeltable.AbstractTModel;
import se.prediktera.map.data.modeltable.ModelTable;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.Description;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.main.extclass.DataTreeExtLibInterface;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.statistic.AbstractStatistic;
import se.prediktera.statistical.manova.StatisticHelper;
import se.prediktera.statistical.manova.TermClass;
import se.prediktera.statistical.manova.math.Beta;

public class Manova
extends AbstractStatistic
implements DataTreeExtLibInterface {
    public static final byte NR_RESULTS = 7;
    public static final byte DF = 0;
    public static final byte EXVARSS = 1;
    public static final byte NPC = 2;
    public static final byte NBU = 3;
    public static final byte EXVARPC = 4;
    public static final byte EXVARBU = 5;
    public static final byte PVALUE = 6;
    public static final String[] RES_DESCR = new String[]{"DF", "exVarSS", "nPC", "nBu", "exVarPC", "exVarBU", "p-Value"};
    public static final String MEAN_VALUES = "Mean values";
    public static final String MEAN_SCORE_VALUES = "Mean Score values";
    private ModelMatrix[] results;
    private AbstractDataMatrix scoreValues;
    private AbstractDataMatrix loadingValues;
    private DataContainer meanValuesContainer;
    private DataContainer meanScoreValuesContainer;
    private String dataSetName;
    private boolean normalization = true;
    private List termList = null;
    private final boolean debug = false;

    public Manova(ProgressManager progressManager, String string) {
        this.dataSetName = string;
        this.results = new ModelMatrix[7];
        AbstractDataInfo abstractDataInfo = null;
        for (int i = 0; i < this.results.length; ++i) {
            this.results[i] = new ModelMatrix(abstractDataInfo, (AbstractDataMatrix)null);
            this.results[i].setName(RES_DESCR[i]);
            this.addTreeNode(this.results[i]);
        }
        this.meanValuesContainer = new DataContainer(MEAN_VALUES, -1);
        this.addTreeNode(this.meanValuesContainer);
        this.meanScoreValuesContainer = new DataContainer(MEAN_SCORE_VALUES, -1);
        this.addTreeNode(this.meanScoreValuesContainer);
    }

    public Manova(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        int n;
        int n2 = mapProperty.getPropertyInt("rs");
        this.results = new ModelMatrix[n2];
        for (n = 0; n < n2; ++n) {
            this.results[n] = (ModelMatrix)mapProperty.resolveNodeFromName(randomInputStream, "r" + n);
        }
        n = mapProperty.getPropertyInt("tsize");
        this.termList = new Vector(n);
        for (int i = 0; i < n2; ++i) {
            this.termList.add(new TermClass(this, mapProperty.getPropertyStringUTF("tname" + i)){

                @Override
                public int getRealIndex1() {
                    return 0;
                }

                @Override
                public int getValue(int n) {
                    return 0;
                }
            });
        }
        this.normalization = mapProperty.getPropertyBoolean("norm");
    }

    public void calculate(ProgressManager progressManager, DenseMatrix denseMatrix, DenseMatrix denseMatrix2, DenseMatrix denseMatrix3) {
        progressManager.setInfoText("Calculating 50-50 Manova");
        int n = denseMatrix3.numRows();
        DenseMatrix[] denseMatrixArray = this.splitX(denseMatrix);
        for (int i = 0; i < denseMatrixArray.length; ++i) {
            denseMatrixArray[i] = StatisticHelper.normalize(denseMatrixArray[i], true);
        }
        DenseMatrix[] denseMatrixArray2 = this.my_x2fx(denseMatrixArray, denseMatrix3);
        DenseMatrix[] denseMatrixArray3 = this.orth_D(denseMatrixArray2, denseMatrix3, "om");
        DenseMatrix[] denseMatrixArray4 = this.orth_D(denseMatrixArray3, denseMatrix3, "test");
        DenseMatrix denseMatrix4 = StatisticHelper.mergeMatrices(denseMatrixArray2, denseMatrixArray2[0].numRows());
        DenseMatrix denseMatrix5 = StatisticHelper.mergeMatrices(denseMatrixArray3, denseMatrixArray3[0].numRows());
        this.linregEst(denseMatrix4, denseMatrix5);
        DenseMatrix denseMatrix6 = this.linregStart(denseMatrix5);
        this.manova_5050(progressManager, denseMatrix6, denseMatrixArray4, denseMatrix2, n);
    }

    public void calculate(ProgressManager progressManager, DataSet dataSet, String string, List list, boolean bl) {
        this.name = string;
        this.termList = list;
        this.normalization = bl;
        DenseMatrix denseMatrix = this.getXMatrix(progressManager, dataSet, list);
        AbstractDataMatrix abstractDataMatrix = this.getYMatrix(dataSet);
        DenseMatrix denseMatrix2 = abstractDataMatrix.subMatrix(progressManager, null, null, null, 8).getDoubleMatrix();
        this.calculate(progressManager, denseMatrix, denseMatrix2, this.createModelMatrix(list, denseMatrix));
        if (list != null && !list.isEmpty()) {
            if (bl) {
                denseMatrix2 = StatisticHelper.normalize(denseMatrix2, true);
            }
            SVD sVD = StatisticHelper.factorize(denseMatrix2);
            DenseMatrix denseMatrix3 = sVD.getU();
            double[] dArray = sVD.getS();
            DenseMatrix denseMatrix4 = StatisticHelper.constant(denseMatrix3.numRows(), denseMatrix3.numColumns(), 0.0);
            for (int i = 0; i < dArray.length; ++i) {
                denseMatrix4.set(i, i, dArray[i]);
            }
            Description description = new Description(abstractDataMatrix.getN());
            description.addColumn("Description");
            this.addTreeNode(description);
            Description description2 = new Description(list.size());
            description2.addColumn("Term");
            this.addTreeNode(description2);
            Description description3 = new Description(abstractDataMatrix.getK());
            description3.addColumn("Scores");
            this.addTreeNode(description3);
            DenseMatrix denseMatrix5 = StatisticHelper.mult(denseMatrix3, denseMatrix4);
            denseMatrix5 = StatisticHelper.partColumnMatrices(denseMatrix5, 0, abstractDataMatrix.getK());
            this.scoreValues = new MVmatrix((Matrix)denseMatrix5, false, "Scores");
            this.scoreValues.setRowDescription(description);
            this.scoreValues.setColumnDescription(description3);
            this.scoreValues.setRowType(1);
            this.scoreValues.setColumnType(8);
            this.addTreeNode(this.scoreValues);
            Description description4 = new Description(abstractDataMatrix.getK());
            description4.addColumn("Loading");
            this.addTreeNode(description4);
            Description description5 = new Description(abstractDataMatrix.getK());
            description5.addColumn("Variables");
            this.addTreeNode(description5);
            DenseMatrix denseMatrix6 = StatisticHelper.transpose(sVD.getVt());
            this.loadingValues = new MVmatrix((Matrix)denseMatrix6, false, "Loadings");
            this.loadingValues.setRowDescription(description5);
            this.loadingValues.setColumnDescription(description4);
            this.loadingValues.setRowType(2);
            this.loadingValues.setColumnType(8);
            this.addTreeNode(this.loadingValues);
            int n = 0;
            for (TermClass termClass : list) {
                int n2 = (int)this.results[0].getValue(n, 0) + 1;
                MVmatrix mVmatrix = new MVmatrix(n2, abstractDataMatrix.getK());
                this.meanValuesContainer.addTreeNode(mVmatrix);
                mVmatrix.setName("Mean - " + termClass.toString());
                mVmatrix.setRowDescription(description2);
                mVmatrix.setColumnDescription(description5);
                mVmatrix.setRowType(1);
                mVmatrix.setColumnType(2);
                MVmatrix mVmatrix2 = new MVmatrix(n2, abstractDataMatrix.getK());
                this.meanScoreValuesContainer.addTreeNode(mVmatrix2);
                mVmatrix2.setName("Score - " + String.valueOf(termClass));
                mVmatrix2.setRowDescription(description2);
                mVmatrix2.setColumnDescription(description3);
                mVmatrix2.setRowType(1);
                mVmatrix2.setColumnType(8);
                for (int i = 0; i < n2; ++i) {
                    description2.setValue(i, 0, String.valueOf(i));
                    int n3 = 0;
                    for (int j = 0; j < abstractDataMatrix.getK(); ++j) {
                        if (i == 0) {
                            description5.setValue(j, 0, abstractDataMatrix.getColumnDescription(j, 0));
                            description3.setValue(j, 0, "t[" + (j + 1) + "]");
                            description4.setValue(j, 0, "p[" + (j + 1) + "]");
                        }
                        double d = 0.0;
                        double d2 = 0.0;
                        for (int k = 0; k < denseMatrix.numRows(); ++k) {
                            int n4;
                            if (i == 0 && j == 0) {
                                description.setValue(k, 0, String.valueOf(k + 1));
                            }
                            if ((n4 = termClass.getValue(k)) != i) continue;
                            d += abstractDataMatrix.getValue(k, j);
                            d2 += denseMatrix5.get(k, j);
                            if (j != 0) continue;
                            ++n3;
                        }
                        ((AbstractDataMatrix)mVmatrix).setValue(i, j, d / (double)n3);
                        ((AbstractDataMatrix)mVmatrix2).setValue(i, j, d2 / (double)n3);
                    }
                }
                ++n;
            }
        }
    }

    private DenseMatrix getXMatrix(ProgressManager progressManager, DataSet dataSet, List<TermClass> list) {
        TermClass termClass2;
        int n = 0;
        for (TermClass termClass2 : list) {
            if (termClass2.hasInteractionTerm()) continue;
            ++n;
        }
        AbstractDataMatrix abstractDataMatrix = dataSet.getMatrix(2);
        termClass2 = new DenseMatrix(abstractDataMatrix.getN(), n);
        int n2 = 0;
        for (TermClass termClass3 : list) {
            if (!termClass3.hasInteractionTerm()) {
                for (int i = 0; i < abstractDataMatrix.getN(); ++i) {
                    termClass2.set(i, n2, termClass3.getValue(i));
                }
            }
            ++n2;
        }
        return termClass2;
    }

    private AbstractDataMatrix getYMatrix(DataSet dataSet) {
        return dataSet.getMatrix(2);
    }

    private DenseMatrix createModelMatrix(List<TermClass> list, DenseMatrix denseMatrix) {
        if (list != null && !list.isEmpty()) {
            DenseMatrix denseMatrix2 = new DenseMatrix(list.size() + 1, denseMatrix.numColumns());
            for (int i = 0; i < list.size(); ++i) {
                TermClass termClass = list.get(i);
                denseMatrix2.set(i + 1, termClass.getRealIndex1(), 1.0);
                if (!termClass.hasInteractionTerm()) continue;
                denseMatrix2.set(i + 1, termClass.getRealIndex2(), 1.0);
            }
            return denseMatrix2;
        }
        return null;
    }

    @Override
    public AbstractTModel createTableModel() {
        return new AbstractTModel(){

            @Override
            public int getColumnCount() {
                return 9;
            }

            @Override
            public int getRowCount() {
                if (Manova.this.results != null) {
                    return Manova.this.results[0].getN() + 1;
                }
                return 0;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                if (n2 == 0) {
                    if (n == 0) {
                        return "50-50 Manova (" + Manova.this.name + ")";
                    }
                    return "";
                }
                if (n2 == 1) {
                    if (n == 0) {
                        return "Source";
                    }
                    if (Manova.this.termList != null) {
                        if (n < Manova.this.termList.size()) {
                            return Manova.this.termList.get(n - 1).toString();
                        }
                        return "Error";
                    }
                    String[] stringArray = new String[]{"a", "b", "c", "a*b", "a*c", "b*c", "Error"};
                    return stringArray[n - 1];
                }
                n2 -= 2;
                if (n == 0) {
                    return RES_DESCR[n2];
                }
                if (--n < Manova.this.results[0].getN() - 1 || n2 < 2) {
                    return NiceDataFormat.toString(Manova.this.results[n2].getValue(n, 0));
                }
                return "";
            }

            @Override
            public void prepareInteraction(ModelTable modelTable, int[] nArray) {
            }
        };
    }

    @Override
    public ExtClassLoader.LicenseLibrary getLibrary() {
        return ExtClassLoader.LicenseLibrary.STATISTICAL;
    }

    @Override
    public String getInformation() {
        StringBuilder stringBuilder = new StringBuilder(420);
        stringBuilder.append("<HTML><BODY>");
        stringBuilder.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
        stringBuilder.append("<TR><TD>Name:</TD><TD>").append(this).append("</TD></TR>");
        if (this.getCase() != null) {
            stringBuilder.append("<tr><td></td><td>").append(this.getCase()).append("</td></tr>");
        }
        stringBuilder.append("<TR><TD>DataSet:</TD><TD>").append(this.dataSetName != null ? this.dataSetName : "N/A").append("</TD></TR>");
        stringBuilder.append("<TR><TD>Terms:</TD><TD>").append(this.termList != null ? Integer.valueOf(this.termList.size()) : "N/A").append("</TD></TR>");
        stringBuilder.append("<TR><TD>Normalization:</TD><TD>").append(this.normalization ? "Standard" : "None").append("</TD></TR>");
        stringBuilder.append("</TABLE></BODY></HTML>");
        return stringBuilder.toString();
    }

    @Override
    public byte getNodeType() {
        return 5;
    }

    @Override
    public byte getTreeType() {
        return 0;
    }

    @Override
    public String toString() {
        return "50-50 Manova (" + this.name + ")";
    }

    protected DenseMatrix adjust(DenseMatrix denseMatrix, DenseMatrix denseMatrix2) {
        DenseMatrix denseMatrix3 = this.myorth(denseMatrix2);
        DenseMatrix denseMatrix4 = this.myorth(denseMatrix);
        DenseMatrix denseMatrix5 = new DenseMatrix(denseMatrix.numRows(), 0);
        DenseMatrix denseMatrix6 = this.myorth(StatisticHelper.mergeMatrices(denseMatrix4, denseMatrix3));
        double d = denseMatrix6.numColumns() - denseMatrix3.numColumns();
        if (d == 0.0) {
            return denseMatrix5;
        }
        DenseMatrix denseMatrix7 = StatisticHelper.transAmult(denseMatrix3, denseMatrix4);
        StatisticHelper.print(denseMatrix7, "r1");
        DenseMatrix denseMatrix8 = StatisticHelper.mult(denseMatrix3, denseMatrix7);
        StatisticHelper.print(denseMatrix8, "r2");
        DenseMatrix denseMatrix9 = StatisticHelper.add(denseMatrix4, denseMatrix8, -1.0);
        StatisticHelper.print(denseMatrix9, "r3");
        return this.myorth(denseMatrix9);
    }

    protected double calculateStatistics(DenseMatrix denseMatrix, int n, int n2, double d, double d2) {
        StatisticHelper.print(denseMatrix, "U");
        DenseMatrix denseMatrix2 = StatisticHelper.partRowMatrices(denseMatrix, 0, n);
        denseMatrix2 = StatisticHelper.transpose(denseMatrix2);
        StatisticHelper.print(denseMatrix2, "XtY");
        DenseMatrix denseMatrix3 = StatisticHelper.partRowMatrices(denseMatrix2, 0, n2);
        DenseMatrix denseMatrix4 = StatisticHelper.partRowMatrices(denseMatrix2, (int)((double)n2 + d), denseMatrix2.numRows());
        denseMatrix2 = StatisticHelper.mergeMatricesRows(denseMatrix3, denseMatrix4);
        StatisticHelper.print(denseMatrix2, "XtY");
        QR qR = QR.factorize((Matrix)denseMatrix2);
        denseMatrix2 = qR.getQ();
        StatisticHelper.print(denseMatrix2, "XtY");
        denseMatrix2 = StatisticHelper.partRowMatrices(denseMatrix2, 0, n2);
        StatisticHelper.print(denseMatrix2, "XtY");
        SVD sVD = StatisticHelper.factorize(denseMatrix2);
        double[] dArray = sVD.getS();
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = dArray[i] * dArray[i];
        }
        double[] dArray2 = this.multiStatistics(dArray);
        StatisticHelper.print(dArray2, "deam");
        double[] dArray3 = this.multiPvalues(dArray2[0], dArray2[1], dArray2[2], dArray2[3], d2, n, n2);
        StatisticHelper.print(dArray3, "pvalues");
        return dArray3[2];
    }

    protected void ffManovaTest(ProgressManager progressManager, DenseMatrix denseMatrix, DenseMatrix[] denseMatrixArray, String string) {
        double d;
        double d2;
        int n;
        double d3;
        Object object;
        DenseMatrix denseMatrix2 = denseMatrixArray[0];
        int n2 = denseMatrixArray[1] != null ? (int)denseMatrixArray[1].get(0, 0) : denseMatrix2.numRows();
        StatisticHelper.print(denseMatrix, "modelData term=" + string);
        StatisticHelper.print(denseMatrix2, "errorData term=" + string);
        DenseMatrix denseMatrix3 = StatisticHelper.mergeMatrices(StatisticHelper.transpose(denseMatrix), StatisticHelper.transpose(denseMatrix2));
        denseMatrix3 = StatisticHelper.transpose(denseMatrix3);
        StatisticHelper.print(denseMatrix3, "Y term=" + string);
        int n3 = denseMatrix.numRows();
        int n4 = n2 + n3;
        int n5 = Math.min(n4, denseMatrix3.numColumns());
        if (this.normalization) {
            for (int i = 0; i < denseMatrix3.numColumns(); ++i) {
                object = StatisticHelper.partColumnMatrices(denseMatrix3, i, i + 1);
                d3 = StatisticHelper.norm((DenseMatrix)object);
                if (d3 == 0.0) continue;
                for (n = 0; n < denseMatrix3.numRows(); ++n) {
                    denseMatrix3.set(n, i, denseMatrix3.get(n, i) / d3);
                }
            }
        }
        StatisticHelper.print(denseMatrix3, "Y term=" + string);
        SVD sVD = StatisticHelper.factorize(denseMatrix3);
        object = sVD.getS();
        d3 = 0.0;
        for (n = 0; n < ((double[])object).length; ++n) {
            object[n] = object[n] * object[n];
            d3 += object[n];
        }
        double[] dArray = new double[]{0.9, 0.5};
        double d4 = 0.0;
        double d5 = 1.0;
        int n6 = Math.max(1, Math.min(n4 - n3 - 3, n5));
        double d6 = 0.0;
        int n7 = 0;
        while (d4 < d5) {
            d6 = 0.0;
            for (int i = 0; i < n7 + 1; ++i) {
                d6 += object[i];
            }
            d2 = d3 - d6;
            if (n7 + 1 == n6) {
                d4 = 1000.0;
            } else {
                d = this.sumArrayCp(n7, n4, -1.0) / this.sumArrayCp(n7, n5, -1.0);
                d4 = d6 / (d6 + d * d2);
            }
            if (n7 < dArray.length) {
                d5 = dArray[n7];
            }
            ++n7;
        }
        d2 = Math.max(0.0, Math.floor(1.0001 * Math.min((double)(n5 - n7), 0.5 * (double)(n4 - n3 - n7 - 3))));
        if (d2 > 1.0E8) {
            d2 = Math.max(1.0E8, 0.0);
        }
        if (d2 < 0.0) {
            d2 = Math.min(0.0, (double)Math.max(0, Math.min(n5 - n7, n4 - n3 - n7 - 3)));
        }
        d = d6 / d3;
        double d7 = 0.0;
        for (int i = 0; (double)i < (double)n7 + d2 && i < ((double[])object).length; ++i) {
            d7 += object[i];
        }
        double d8 = d7 / d3;
        double d9 = (double)n4 - d2;
        double d10 = this.calculateStatistics(sVD.getU(), n3, n7, d2, d9);
        this.results[2].addRow(n7);
        this.results[3].addRow(d2);
        this.results[4].addRow(d);
        this.results[5].addRow(d8);
        this.results[6].addRow(d10);
    }

    protected Object[] linregEnd(DenseMatrix denseMatrix, DenseMatrix denseMatrix2) {
        DenseMatrix denseMatrix3 = StatisticHelper.transAmult(denseMatrix, denseMatrix2);
        StatisticHelper.print(denseMatrix3, "BetaU");
        DenseMatrix denseMatrix4 = StatisticHelper.mult(denseMatrix, denseMatrix3);
        StatisticHelper.print(denseMatrix4, "Yhat");
        DenseMatrix denseMatrix5 = StatisticHelper.add(denseMatrix2, denseMatrix4, -1.0);
        StatisticHelper.print(denseMatrix5, "YaddYhat");
        SVD sVD = StatisticHelper.factorize(denseMatrix5);
        double[] dArray = sVD.getS();
        DenseMatrix denseMatrix6 = this.createSMatrix(dArray);
        DenseMatrix denseMatrix7 = sVD.getVt();
        StatisticHelper.print(denseMatrix7, "Vt");
        int n = denseMatrix.numRows() - denseMatrix.numColumns();
        DenseMatrix[] denseMatrixArray = new DenseMatrix[2];
        StatisticHelper.print(denseMatrix6, "S");
        denseMatrixArray[0] = StatisticHelper.mult(denseMatrix6, denseMatrix7);
        StatisticHelper.print(denseMatrixArray[0], "errorObs");
        if (denseMatrixArray[0].numRows() > n) {
            denseMatrixArray[0] = StatisticHelper.partRowMatrices(denseMatrixArray[0], 0, n);
        }
        DenseMatrix denseMatrix8 = this.calcMsError(denseMatrixArray[0], n);
        StatisticHelper.print(denseMatrix8, "msError");
        if (denseMatrixArray[0].numRows() < n) {
            denseMatrixArray[1] = StatisticHelper.constant(denseMatrixArray[0].numRows(), 1, n);
        }
        StatisticHelper.print(denseMatrixArray, "errorObs");
        return new Object[]{denseMatrix3, denseMatrixArray, denseMatrix8};
    }

    protected DenseMatrix linregStart(DenseMatrix denseMatrix) {
        SVD sVD = StatisticHelper.factorize(denseMatrix);
        double[] dArray = sVD.getS();
        DenseMatrix denseMatrix2 = sVD.getU();
        int n = dArray.length;
        double d = (double)Math.max(denseMatrix2.numRows(), denseMatrix2.numColumns()) * dArray[0] * 1.0E-9;
        while (dArray[n - 1] < d) {
            --n;
        }
        double[] dArray2 = new double[n];
        System.arraycopy(dArray, 0, dArray2, 0, n);
        dArray = dArray2;
        return StatisticHelper.partColumnMatrices(denseMatrix2, 0, n);
    }

    protected double[] multiPvalues(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = d7;
        double d9 = d6;
        double d10 = d5 - d6;
        double d11 = Math.min(d8, d9);
        double d12 = (Math.abs(d8 - d9) - 1.0) / 2.0;
        double d13 = (d10 - d8 - 1.0) / 2.0;
        double d14 = d10 - (d8 - d9 + 1.0) / 2.0;
        double d15 = (d8 * d9 - 2.0) / 4.0;
        double d16 = 1.0;
        if (d8 * d8 + d9 * d9 - 5.0 > 0.0) {
            d16 = Math.sqrt((d8 * d8 * d9 * d9 - 4.0) / (d8 * d8 + d9 * d9 - 5.0));
        }
        double d17 = Math.max(d8, d9);
        double d18 = Math.pow(d, 1.0 / d16);
        double d19 = d18 <= 0.0 ? 1.0E100 : (1.0 - d18) / d18 * ((d14 * d16 - 2.0 * d15) / (d8 * d9));
        double d20 = this.my_pValueF(d19, d8 * d9, d14 * d16 - 2.0 * d15);
        double d21 = d2 * (d10 - d17 + d9) / d17;
        double d22 = this.my_pValueF(d21, d17, d10 - d17 + d9);
        double d23 = d3 * 2.0 * (d11 * d13 + 1.0) / (d11 * d11 * (2.0 * d12 + d11 + 1.0));
        double d24 = this.my_pValueF(d23, d11 * (2.0 * d12 + d11 + 1.0), 2.0 * (d11 * d13 + 1.0));
        double d25 = d11 - d4 <= 0.0 ? 1.0E100 : d4 / (d11 - d4) * ((2.0 * d13 + d11 + 1.0) / (2.0 * d12 + d11 + 1.0));
        double d26 = this.my_pValueF(d25, d11 * (2.0 * d12 + d11 + 1.0), d11 * (2.0 * d13 + d11 + 1.0));
        return new double[]{d20, d22, d24, d26};
    }

    protected double[] multiStatistics(double[] dArray) {
        double d = 1.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = Math.pow(2.0, -52.0);
        for (int i = 0; i < dArray.length; ++i) {
            d *= 1.0 - dArray[i];
            d3 = 1.0 - dArray[i] > 0.0 ? (d3 += dArray[i] / (1.0 - dArray[i])) : (d3 += 1.0 / d5);
            if (i == 0) {
                d2 = d3;
            }
            d4 += dArray[i];
        }
        return new double[]{d, d2, d3, d4};
    }

    protected DenseMatrix myorth(DenseMatrix denseMatrix) {
        DenseMatrix denseMatrix2;
        if (denseMatrix.numColumns() == 0) {
            return denseMatrix;
        }
        SVD sVD = StatisticHelper.factorize(denseMatrix);
        DenseMatrix denseMatrix3 = sVD.getU();
        double[] dArray = sVD.getS();
        int n = dArray.length;
        double d = (double)Math.max(denseMatrix3.numRows(), denseMatrix3.numColumns()) * dArray[0] * 1.0E-9;
        while (dArray[n - 1] < d) {
            --n;
        }
        if ((denseMatrix3 = StatisticHelper.partColumnMatrices(denseMatrix3, 0, n)).numColumns() == 1 && denseMatrix.numColumns() == 1 && (denseMatrix2 = StatisticHelper.transAmult(denseMatrix, denseMatrix3)).get(0, 0) < 0.0) {
            denseMatrix3 = StatisticHelper.mult(denseMatrix3, -1.0);
        }
        return denseMatrix3;
    }

    @Override
    protected void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        int n;
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyInt("rs", this.results.length);
        for (n = 0; n < this.results.length; ++n) {
            randomOutputStream.writePropertyNode("r" + n, this.results[n]);
        }
        if (this.termList != null) {
            randomOutputStream.writePropertyInt("tsize", this.termList.size());
            for (n = 0; n < this.termList.size(); ++n) {
                randomOutputStream.writePropertyStringUTF("tname" + n, this.termList.get(n).toString());
            }
        } else {
            randomOutputStream.writePropertyInt("tsize", 0);
        }
        randomOutputStream.writePropertyBoolean("norm", this.normalization);
    }

    private DenseMatrix calcMsError(DenseMatrix denseMatrix, double d) {
        DenseMatrix denseMatrix2 = new DenseMatrix(1, denseMatrix.numColumns());
        for (int i = 0; i < denseMatrix.numColumns(); ++i) {
            double d2 = 0.0;
            for (int j = 0; j < denseMatrix.numRows(); ++j) {
                double d3 = denseMatrix.get(j, i);
                d2 += d3 * d3;
            }
            denseMatrix2.set(0, i, d2 / d);
        }
        return denseMatrix2;
    }

    private DenseMatrix createSMatrix(double[] dArray) {
        DenseMatrix denseMatrix = StatisticHelper.constant(dArray.length, dArray.length, 0.0);
        for (int i = 0; i < dArray.length; ++i) {
            denseMatrix.set(i, i, dArray[i]);
        }
        return denseMatrix;
    }

    private void linregEst(DenseMatrix denseMatrix, DenseMatrix denseMatrix2) {
        DenseMatrix denseMatrix3 = this.linregStart(denseMatrix);
        this.linregEnd(denseMatrix3, denseMatrix2);
    }

    private void manova_5050(ProgressManager progressManager, DenseMatrix denseMatrix, DenseMatrix[] denseMatrixArray, DenseMatrix denseMatrix2, int n) {
        if (this.normalization) {
            denseMatrix2 = StatisticHelper.normalize(denseMatrix2, false);
        }
        Object[] objectArray = this.xy_Obj(denseMatrix, denseMatrixArray, denseMatrix2);
        DenseMatrix[] denseMatrixArray2 = (DenseMatrix[])objectArray[0];
        DenseMatrix[] denseMatrixArray3 = (DenseMatrix[])objectArray[1];
        double d = (Double)objectArray[2];
        double[] dArray = (double[])objectArray[3];
        double d2 = denseMatrix.numRows() - denseMatrix.numColumns();
        double[] dArray2 = new double[dArray.length + 1];
        for (int i = 0; i < denseMatrixArray.length; ++i) {
            dArray2[i] = denseMatrixArray[i].numColumns();
        }
        dArray2[denseMatrixArray.length] = d2;
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i] = dArray[i] / d;
        }
        System.out.println("Source\tDF\texVarSS\tnPC\tnBu\texVarPC\texVarBU\tp-Value");
        String[] stringArray = new String[]{"a", "b", "c", "a*b", "a*c", "b*c", "Error"};
        if (this.termList != null && !this.termList.isEmpty()) {
            stringArray = new String[this.termList.size() + 1];
            for (int i = 0; i < this.termList.size(); ++i) {
                stringArray[i] = this.termList.get(i).toString();
            }
            stringArray[stringArray.length - 1] = "Error";
        }
        double d3 = StatisticHelper.norm(denseMatrix2);
        for (int i = 0; i < n; ++i) {
            if (i < n - 1) {
                DenseMatrix denseMatrix3 = denseMatrixArray2[i + 1];
                double d4 = this.normABtranspose(denseMatrixArray3[0], denseMatrix3);
                if (d3 < 1.0E-250 || d4 / d3 < 1.0E-12) {
                    this.ffManovaTest(progressManager, denseMatrix3, denseMatrixArray3, stringArray[i]);
                } else {
                    this.ffManovaTest(progressManager, denseMatrix3, denseMatrixArray3, stringArray[i]);
                }
            }
            this.results[0].addRow(dArray2[i + 1]);
            this.results[1].addRow(dArray3[i + 1]);
            if (i < n - 1) {
                System.out.println(stringArray[i] + "\t" + NiceDataFormat.toString(this.results[0].getScalar(i)) + "\t" + NiceDataFormat.toString(this.results[1].getScalar(i)) + "\t" + this.results[2].getScalar(i) + "\t" + this.results[3].getScalar(i) + "\t" + NiceDataFormat.toString(this.results[4].getScalar(i)) + "\t" + NiceDataFormat.toString(this.results[5].getScalar(i)) + "\t" + NiceDataFormat.toString(this.results[6].getScalar(i)));
                continue;
            }
            System.out.println(stringArray[i] + "\t" + NiceDataFormat.toString(this.results[0].getScalar(i)) + "\t" + NiceDataFormat.toString(this.results[1].getScalar(i)) + "\t- STANDARDIZATION ON  ------------");
        }
    }

    private double my_pValueF(double d, double d2, double d3) {
        double d4 = 100.0;
        if (d > 0.0 && d2 > 0.9 && d3 > 0.9) {
            d4 = d < 1.0E-13 ? 1.0 : Beta.incompleteBeta(d3 / (d3 + d2 * d), d3 / 2.0, d2 / 2.0);
        }
        return d4;
    }

    private DenseMatrix[] my_x2fx(DenseMatrix[] denseMatrixArray, DenseMatrix denseMatrix) {
        DenseMatrix[] denseMatrixArray2 = new DenseMatrix[denseMatrix.numRows()];
        for (int i = 0; i < denseMatrix.numRows(); ++i) {
            DenseMatrix denseMatrix2 = StatisticHelper.constant(denseMatrixArray[0].numRows(), 1, 1.0);
            for (int j = 0; j < denseMatrix.numColumns(); ++j) {
                int n = 0;
                while ((double)n < denseMatrix.get(i, j)) {
                    denseMatrix2 = StatisticHelper.multMerge(denseMatrix2, denseMatrixArray[j]);
                    ++n;
                }
            }
            denseMatrixArray2[i] = denseMatrix2;
        }
        return denseMatrixArray2;
    }

    private double normABtranspose(DenseMatrix denseMatrix, DenseMatrix denseMatrix2) {
        DenseMatrix denseMatrix3 = StatisticHelper.transpose(denseMatrix);
        DenseMatrix denseMatrix4 = StatisticHelper.transpose(denseMatrix2);
        DenseMatrix denseMatrix5 = StatisticHelper.mergeMatrices(denseMatrix3, denseMatrix4);
        return StatisticHelper.norm(denseMatrix5);
    }

    private DenseMatrix[] orth_D(DenseMatrix[] denseMatrixArray, DenseMatrix denseMatrix, String string) {
        DenseMatrix[] denseMatrixArray2 = new DenseMatrix[denseMatrix.numRows()];
        for (int i = 0; i < denseMatrix.numRows(); ++i) {
            DenseMatrix denseMatrix2 = denseMatrixArray[i];
            ArrayList<DenseMatrix> arrayList = new ArrayList<DenseMatrix>();
            for (int j = 0; j < denseMatrix.numRows(); ++j) {
                if (string.equals("test")) {
                    if (!(this.rowSubMin(denseMatrix, j, i) < 0.0)) continue;
                    arrayList.add(denseMatrixArray[j]);
                    continue;
                }
                if (!string.equals("om") || !(this.rowSubMin(denseMatrix, j, i) < 0.0) || !(this.rowSubMax(denseMatrix, j, i) <= 0.0)) continue;
                arrayList.add(denseMatrixArray[j]);
            }
            DenseMatrix denseMatrix3 = StatisticHelper.mergeMatrices(arrayList, denseMatrix2.numRows());
            denseMatrixArray2[i] = this.adjust(denseMatrix2, denseMatrix3);
        }
        return denseMatrixArray2;
    }

    private double rowSubMax(DenseMatrix denseMatrix, int n, int n2) {
        double d = 0.0;
        for (int i = 0; i < denseMatrix.numColumns(); ++i) {
            d = Math.max(d, denseMatrix.get(n, i) - denseMatrix.get(n2, i));
        }
        return d;
    }

    private double rowSubMin(DenseMatrix denseMatrix, int n, int n2) {
        double d = Double.MAX_VALUE;
        for (int i = 0; i < denseMatrix.numColumns(); ++i) {
            d = Math.min(d, denseMatrix.get(n, i) - denseMatrix.get(n2, i));
        }
        return d;
    }

    private DenseMatrix[] splitX(DenseMatrix denseMatrix) {
        DenseMatrix[] denseMatrixArray = new DenseMatrix[denseMatrix.numColumns()];
        for (int i = 0; i < denseMatrix.numColumns(); ++i) {
            int n;
            int n2 = denseMatrix.numRows();
            ArrayList<Double> arrayList = new ArrayList<Double>();
            for (n = 0; n < n2; ++n) {
                double d = denseMatrix.get(n, i);
                if (arrayList.contains(d)) continue;
                arrayList.add(d);
            }
            Collections.sort(arrayList);
            n = arrayList.size();
            DenseMatrix denseMatrix2 = new DenseMatrix(n2, n);
            for (int j = 0; j < n; ++j) {
                double d = (Double)arrayList.get(j);
                for (int k = 0; k < n2; ++k) {
                    denseMatrix2.set(k, j, denseMatrix.get(k, i) == d ? 1.0 : 0.0);
                }
            }
            denseMatrixArray[i] = denseMatrix2;
        }
        return denseMatrixArray;
    }

    private double sumArrayCp(int n, int n2, double d) {
        double d2 = 0.0;
        for (int i = n + 2; i <= n2; ++i) {
            d2 += Math.pow(i, d);
        }
        return d2;
    }

    private Object[] xy_Obj(DenseMatrix denseMatrix, DenseMatrix[] denseMatrixArray, DenseMatrix denseMatrix2) {
        StatisticHelper.print(denseMatrix);
        Object[] objectArray = this.linregEnd(denseMatrix, denseMatrix2);
        DenseMatrix[] denseMatrixArray2 = (DenseMatrix[])objectArray[1];
        DenseMatrix denseMatrix3 = (DenseMatrix)objectArray[2];
        double[] dArray = new double[denseMatrixArray.length + 1];
        DenseMatrix[] denseMatrixArray3 = new DenseMatrix[denseMatrixArray.length];
        for (int i = 0; i < denseMatrixArray.length; ++i) {
            DenseMatrix denseMatrix4 = StatisticHelper.transAmult(denseMatrixArray[i], denseMatrix2);
            StatisticHelper.print(denseMatrix4, "hObs");
            denseMatrixArray3[i] = denseMatrix4;
            dArray[i] = StatisticHelper.sumSumSquare(denseMatrix4, false);
        }
        dArray[i] = denseMatrixArray2[1] != null ? denseMatrixArray2[1].get(0, 0) * StatisticHelper.sumSum(denseMatrix3) : (double)denseMatrixArray2[0].numRows() * StatisticHelper.sumSum(denseMatrix3);
        StatisticHelper.print(dArray, "ss");
        StatisticHelper.print(denseMatrix2, "Y");
        double d = StatisticHelper.sumSumSquare(denseMatrix2, true);
        return new Object[]{denseMatrixArray3, denseMatrixArray2, d, dArray};
    }

    public ModelMatrix[] getResults() {
        return this.results;
    }

    public static String[] getResDescr() {
        return RES_DESCR;
    }
}

