/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.statistical.manova;

import javax.swing.ImageIcon;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.wizard.AbstractInit;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeClass;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.NormalizedModelMatrix;
import se.prediktera.map.main.Plot_GUI;
import se.prediktera.map.main.window.AbstractWindow;
import se.prediktera.map.main.window.AbstractWindow_GUI;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisPlotInfo;
import se.prediktera.map.plot.axisplot.PlotAxisLayerPanel;
import se.prediktera.map.plot.axisplot.plot2D.scatter.biplot.Scatter2DBiPlot;
import se.prediktera.map.plot.axisplot.settings.Color.PerfectSpread;
import se.prediktera.statistical.manova.Manova;

public class ManovaBiPlotInfo
extends AbstractAxisPlotInfo {
    private static final ImageIcon wizardIcon = new ImageIcon(ManovaBiPlotInfo.class.getResource("images/biplot.gif"));

    @Override
    public AbstractWindow createWindow(AbstractWindow_GUI abstractWindow_GUI, AbstractInit abstractInit) {
        try {
            DataTreeClass dataTreeClass;
            DataTreeInterface dataTreeInterface = abstractInit.getDataTreeInterface();
            AbstractDataMatrix abstractDataMatrix = null;
            Manova manova = null;
            if (dataTreeInterface instanceof Manova) {
                manova = (Manova)dataTreeInterface;
                dataTreeClass = (DataContainer)manova.get("Mean Score values");
                abstractDataMatrix = (AbstractDataMatrix)dataTreeClass.getTreeNodeAt(0);
            } else {
                manova = (Manova)dataTreeInterface.getTreeParent().getTreeParent();
                abstractDataMatrix = (AbstractDataMatrix)dataTreeInterface;
            }
            dataTreeClass = (AbstractDataMatrix)manova.get("Loadings");
            String string = dataTreeClass.toString();
            PlotInit plotInit = new PlotInit(dataTreeClass);
            plotInit.plotType = 1;
            plotInit.autoCreateLayer = false;
            plotInit.title = "50-50 Manova - Normalized Bi-plot\n" + abstractDataMatrix.toString();
            super.createWindow(abstractWindow_GUI, abstractInit);
            Scatter2DBiPlot scatter2DBiPlot = new Scatter2DBiPlot((Plot_GUI)abstractWindow_GUI, plotInit);
            this.applySettings(scatter2DBiPlot);
            PlotAxisLayerPanel plotAxisLayerPanel = (PlotAxisLayerPanel)scatter2DBiPlot.getSettingsPanel();
            plotAxisLayerPanel.setCreated(abstractWindow_GUI, false);
            plotInit.setAllMatrix((AbstractDataMatrix)dataTreeClass);
            PlotInit plotInit2 = new PlotInit(dataTreeClass);
            plotInit2.setAllMatrix((AbstractDataMatrix)dataTreeClass);
            plotInit2.plotType = 1;
            plotInit2.filterRoot = manova;
            plotInit2.initshape = 0;
            plotInit2.initcolor = PerfectSpread.generateColor(0);
            plotInit2.description = 5;
            plotInit2.initsize = 5;
            plotAxisLayerPanel.addLayer(true, plotInit2, string);
            AbstractDataMatrix abstractDataMatrix2 = (AbstractDataMatrix)manova.get("Scores");
            NormalizedModelMatrix normalizedModelMatrix = new NormalizedModelMatrix(abstractDataMatrix2, (AbstractDataMatrix)dataTreeClass, false);
            normalizedModelMatrix.setVisibleInTree(false);
            scatter2DBiPlot.addTreeNode(normalizedModelMatrix);
            PlotInit plotInit3 = new PlotInit(normalizedModelMatrix);
            plotInit3.setAllMatrix(normalizedModelMatrix);
            plotInit3.plotType = 1;
            plotInit3.filterRoot = manova;
            plotInit3.initshape = 0;
            plotInit3.initcolor = PerfectSpread.generateColor(1);
            plotInit3.initsize = 5;
            plotAxisLayerPanel.addLayer(true, plotInit3, "Scores");
            NormalizedModelMatrix normalizedModelMatrix2 = new NormalizedModelMatrix(abstractDataMatrix, (AbstractDataMatrix)dataTreeClass, false);
            normalizedModelMatrix2.setVisibleInTree(false);
            scatter2DBiPlot.addTreeNode(normalizedModelMatrix2);
            PlotInit plotInit4 = new PlotInit(normalizedModelMatrix2);
            plotInit4.setAllMatrix(normalizedModelMatrix2);
            plotInit4.plotType = 1;
            plotInit4.filterRoot = manova;
            plotInit4.initshape = 5;
            plotInit4.initcolor = PerfectSpread.generateColor(2);
            plotInit4.description = 5;
            plotInit4.initsize = 12;
            plotAxisLayerPanel.addLayer(true, plotInit4, abstractDataMatrix.toString());
            return scatter2DBiPlot;
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
            return null;
        }
    }

    @Override
    public int getAxisNumber() {
        return 2;
    }

    @Override
    public String getScript() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("layer = plot.getLayer(1);");
        stringBuilder.append("layer.setColor(\"index\", {\"colorscheme=hsv\"});");
        stringBuilder.append("plot.addLegend(\"color\", {\"title=Terms\"});");
        return stringBuilder.toString();
    }

    @Override
    public ImageIcon getWizardImage() {
        return wizardIcon;
    }

    @Override
    public String getWizardInfo() {
        return "Creates a Bi-plot from the selected 50-50 Manova. The Bi-plot shows normalized scores and loadings in the same plot";
    }

    @Override
    public boolean supportData(DataTreeInterface dataTreeInterface) {
        if (dataTreeInterface instanceof AbstractDataMatrix) {
            return dataTreeInterface.getTreeParent() != null && dataTreeInterface.getTreeParent().getTreeParent() instanceof Manova && dataTreeInterface.getTreeParent().toString().equals("Mean Score values");
        }
        return dataTreeInterface instanceof Manova;
    }

    @Override
    public String toString() {
        return "50-50 Manova - Bi-plot";
    }
}

