/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.statistical.manova;

import java.awt.Window;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.statistic.AbstractStatistic;
import se.prediktera.map.statistic.AbstractStatisticInfo;
import se.prediktera.statistical.manova.Manova;
import se.prediktera.statistical.manova.ManovaPanel;

public class ManovaInfo
extends AbstractStatisticInfo {
    private ManovaPanel manovaPanel = null;

    @Override
    public void beginWizard(DataTreeInterface dataTreeInterface) {
        super.beginWizard(dataTreeInterface);
        if (this.manovaPanel != null) {
            this.manovaPanel.setDataSet((DataSet)dataTreeInterface);
        }
    }

    @Override
    public boolean checkStatistic(DataSet dataSet) {
        AbstractDataMatrix abstractDataMatrix = dataSet.getMatrix(2);
        int n = abstractDataMatrix.getK();
        if (n == 0) {
            Window window;
            Window window2 = IniManager.getMainFrame();
            if (ProgressManagerImpl.getProgressManager() != null && (window = ProgressManagerImpl.getProgressManager().getWindow()) != null) {
                window2 = window;
            }
            JOptionPane.showConfirmDialog(window2, "Y matrix dimension cannot be Zero", "Cannot calculate " + String.valueOf(this), -1, 0, null);
            return false;
        }
        return true;
    }

    @Override
    public AbstractStatistic createStatistic(ProgressManager progressManager, DataSet dataSet, Properties properties) throws Exception {
        Manova manova = new Manova(progressManager, dataSet.getName());
        manova.calculate(progressManager, dataSet, this.manovaPanel.getManovaName(), this.manovaPanel.getTermVector(), this.manovaPanel.isNormalization());
        return manova;
    }

    @Override
    public Vector<JComponent> createWizard() {
        Vector<JComponent> vector = new Vector<JComponent>();
        if (this.manovaPanel == null) {
            this.manovaPanel = new ManovaPanel();
        }
        vector.add(this.manovaPanel);
        return vector;
    }

    @Override
    public String getScript() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("createTable(\"manovatable\", statistic);");
        stringBuilder.append("biplot = createPlot(\"50-50manova-bi-plot\", statistic);");
        stringBuilder.append("layer = biplot.getLayer(1);");
        stringBuilder.append("layer.setColor(\"index\", {\"colorscheme=hsv\"});");
        stringBuilder.append("biplot.addLegend(\"color\", {\"title=Terms\"});");
        stringBuilder.append("line = createPlot(\"50-50manova-line\", statistic);");
        stringBuilder.append("line.setColor(\"vector\", {\"colorscheme=hsv\"});");
        stringBuilder.append("line.setAxisLabel(\"identifier\");");
        stringBuilder.append("line.addLegend(\"color\", {\"title=Terms\"});");
        return stringBuilder.toString();
    }

    @Override
    public String getType() {
        return "manova";
    }

    @Override
    public ImageIcon getWizardImage() {
        return null;
    }

    @Override
    public String getWizardInfo() {
        return "Create new 50-50 Manova statistical test";
    }

    @Override
    public boolean supportData(DataTreeInterface dataTreeInterface) {
        if (!super.supportData(dataTreeInterface)) {
            return false;
        }
        DataSet dataSet = null;
        if (dataTreeInterface instanceof DataSet) {
            dataSet = (DataSet)dataTreeInterface;
        } else if (dataTreeInterface instanceof AbstractModel) {
            dataSet = ((AbstractModel)dataTreeInterface).getDataSet();
        }
        if (dataSet != null) {
            return !ManovaPanel.getAvailableNormalTerms(dataSet).isEmpty();
        }
        return false;
    }

    @Override
    public String toString() {
        return "50-50 Manova";
    }
}

