/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.statistical.manova;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import se.prediktera.map.common.wizard.WizardPageClass;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.statistical.manova.TermClass;

public class ManovaPanel
extends WizardPageClass {
    private final Vector availableVector = new Vector();
    private final Vector termVector = new Vector();
    private final TermComparator termComparator = new TermComparator();
    private JButton addAllButton;
    private JButton addSelectedButton;
    private JList availableList;
    private JScrollPane availableScrollPane;
    private JPanel jPanel1;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JComboBox normalizationComboBox;
    private JLabel normalizationLabel;
    private JButton removeAllButton;
    private JButton removeSelectedButton;
    private JList termList;
    private JScrollPane termScrollPane;

    public ManovaPanel() {
        this.initComponents();
        this.normalizationComboBox.addItem("None");
        this.normalizationComboBox.addItem("Standard");
        this.normalizationComboBox.setSelectedIndex(1);
    }

    @Override
    public boolean canNext() {
        return !this.termVector.isEmpty();
    }

    public String getManovaName() {
        return this.nameTextField.getText();
    }

    public Vector getTermVector() {
        return this.termVector;
    }

    public boolean isNormalization() {
        return this.normalizationComboBox.getSelectedIndex() == 1;
    }

    @Override
    public void pageShown() {
        super.pageShown();
        SwingUtilities.invokeLater(() -> {
            this.nameTextField.requestFocus();
            this.nameTextField.selectAll();
        });
    }

    public void setDataSet(DataSet dataSet) {
        this.nameTextField.setText(dataSet.toString());
        ManovaPanel.addAvailableAndInteractionTerms(dataSet, this.availableVector);
        this.updateList();
    }

    private void addAllButtonActionPerformed(ActionEvent actionEvent) {
        this.termVector.addAll(this.availableVector);
        this.availableVector.clear();
        this.updateList();
    }

    private void addSelectedButtonActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.availableList.getSelectedIndices();
        for (int i = nArray.length - 1; i >= 0; --i) {
            this.termVector.add(this.availableVector.remove(nArray[i]));
        }
        this.updateList();
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.availableScrollPane = new JScrollPane();
        this.availableList = new JList();
        this.termScrollPane = new JScrollPane();
        this.termList = new JList();
        this.addAllButton = new JButton();
        this.addSelectedButton = new JButton();
        this.removeSelectedButton = new JButton();
        this.removeAllButton = new JButton();
        this.normalizationLabel = new JLabel();
        this.normalizationComboBox = new JComboBox();
        this.nameTextField = new JTextField();
        this.setLayout(new GridBagLayout());
        this.nameLabel.setText("Name:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.nameLabel, gridBagConstraints);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Terms"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.availableScrollPane.setViewportView(this.availableList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.availableScrollPane, gridBagConstraints);
        this.termScrollPane.setViewportView(this.termList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.termScrollPane, gridBagConstraints);
        this.addAllButton.setText(">>");
        this.addAllButton.addActionListener(actionEvent -> this.addAllButtonActionPerformed(actionEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.jPanel1.add((Component)this.addAllButton, gridBagConstraints);
        this.addSelectedButton.setText(">");
        this.addSelectedButton.addActionListener(actionEvent -> this.addSelectedButtonActionPerformed(actionEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(12, 6, 0, 6);
        this.jPanel1.add((Component)this.addSelectedButton, gridBagConstraints);
        this.removeSelectedButton.setText("<");
        this.removeSelectedButton.addActionListener(actionEvent -> this.removeSelectedButtonActionPerformed(actionEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(12, 6, 0, 6);
        this.jPanel1.add((Component)this.removeSelectedButton, gridBagConstraints);
        this.removeAllButton.setText("<<");
        this.removeAllButton.addActionListener(actionEvent -> this.removeAllButtonActionPerformed(actionEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 6, 6);
        this.jPanel1.add((Component)this.removeAllButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.normalizationLabel.setText("Normalization:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.add((Component)this.normalizationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.normalizationComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.nameTextField, gridBagConstraints);
    }

    private void removeAllButtonActionPerformed(ActionEvent actionEvent) {
        this.availableVector.addAll(this.termVector);
        this.termVector.clear();
        this.updateList();
    }

    private void removeSelectedButtonActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.termList.getSelectedIndices();
        for (int i = nArray.length - 1; i >= 0; --i) {
            this.availableVector.add(this.termVector.remove(nArray[i]));
        }
        this.updateList();
    }

    private void updateList() {
        Collections.sort(this.availableVector, this.termComparator);
        this.availableList.setListData(this.availableVector);
        Collections.sort(this.termVector, this.termComparator);
        this.termList.setListData(this.termVector);
        this.wizard.updateButtons();
    }

    public static List getAvailableNormalTerms(DataSet dataSet) {
        ArrayList<TermClass> arrayList = new ArrayList<TermClass>();
        AbstractDataMatrix abstractDataMatrix = dataSet.getMatrix(0);
        for (int i = 0; i < abstractDataMatrix.getK(); ++i) {
            arrayList.add(new TermClass.TermXtr(abstractDataMatrix, i, arrayList.size()));
        }
        for (InnerColumnClass innerColumnClass : dataSet.getCategories(dataSet.getObsDataInfo())) {
            arrayList.add(new TermClass.TermCategory(innerColumnClass, arrayList.size()));
        }
        return arrayList;
    }

    public static void addAvailableAndInteractionTerms(DataSet dataSet, List<TermClass> list) {
        List list2 = ManovaPanel.getAvailableNormalTerms(dataSet);
        list.clear();
        list.addAll(list2);
        for (int i = 0; i < list2.size(); ++i) {
            for (int j = i + 1; j < list2.size(); ++j) {
                list.add(new TermClass.TermInteraction(list.get(i), list.get(j)));
            }
        }
    }

    private static class TermComparator
    implements Comparator<TermClass> {
        private TermComparator() {
        }

        @Override
        public int compare(TermClass termClass, TermClass termClass2) {
            if (termClass.getRealIndex2() == -1 && termClass2.getRealIndex2() != -1) {
                return -1;
            }
            if (termClass.getRealIndex2() != -1 && termClass2.getRealIndex2() == -1) {
                return 1;
            }
            if (termClass.getRealIndex2() == -1 && termClass2.getRealIndex2() == -1 || termClass.getRealIndex1() != termClass.getRealIndex2()) {
                return Float.compare(termClass.getRealIndex1(), termClass2.getRealIndex1());
            }
            return Float.compare(termClass.getRealIndex2(), termClass2.getRealIndex2());
        }
    }
}

