/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.statistical.manova;

import java.util.ArrayList;
import java.util.Collections;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.NotConvergedException;
import no.uib.cipr.matrix.SVD;

public class StatisticHelper {
    public static boolean doprint = false;

    public static DenseMatrix add(DenseMatrix denseMatrix, DenseMatrix denseMatrix2, double d) {
        DenseMatrix denseMatrix3 = new DenseMatrix(denseMatrix.numRows(), denseMatrix.numColumns());
        for (int i = 0; i < denseMatrix.numRows(); ++i) {
            for (int j = 0; j < denseMatrix.numColumns(); ++j) {
                denseMatrix3.set(i, j, denseMatrix.get(i, j) + d * denseMatrix2.get(i, j));
            }
        }
        return denseMatrix3;
    }

    public static DenseMatrix constant(int n, int n2, double d) {
        DenseMatrix denseMatrix = new DenseMatrix(n, n2);
        int n3 = denseMatrix.numRows();
        int n4 = denseMatrix.numColumns();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                denseMatrix.set(i, j, d);
            }
        }
        return denseMatrix;
    }

    public static DenseMatrix mergeMatrices(ArrayList<DenseMatrix> arrayList, int n) {
        int n2 = 0;
        for (DenseMatrix denseMatrix : arrayList) {
            n = denseMatrix.numRows();
            n2 += denseMatrix.numColumns();
        }
        DenseMatrix denseMatrix = new DenseMatrix(n, n2);
        int n3 = 0;
        for (DenseMatrix denseMatrix2 : arrayList) {
            int n4 = 0;
            while (n4 < denseMatrix2.numColumns()) {
                for (int i = 0; i < n; ++i) {
                    denseMatrix.set(i, n3, denseMatrix2.get(i, n4));
                }
                ++n4;
                ++n3;
            }
        }
        return denseMatrix;
    }

    public static DenseMatrix mergeMatrices(DenseMatrix denseMatrix, DenseMatrix denseMatrix2) {
        int n = denseMatrix.numRows();
        int n2 = denseMatrix.numColumns();
        int n3 = n2 + denseMatrix2.numColumns();
        DenseMatrix denseMatrix3 = new DenseMatrix(n, n3);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n3; ++j) {
                if (j < n2) {
                    denseMatrix3.set(i, j, denseMatrix.get(i, j));
                    continue;
                }
                denseMatrix3.set(i, j, denseMatrix2.get(i, j - n2));
            }
        }
        return denseMatrix3;
    }

    public static DenseMatrix mergeMatrices(DenseMatrix[] denseMatrixArray, int n) {
        ArrayList<DenseMatrix> arrayList = new ArrayList<DenseMatrix>();
        Collections.addAll(arrayList, denseMatrixArray);
        return StatisticHelper.mergeMatrices(arrayList, n);
    }

    public static DenseMatrix mergeMatricesRows(DenseMatrix denseMatrix, DenseMatrix denseMatrix2) {
        int n = denseMatrix.numRows();
        int n2 = n + denseMatrix2.numRows();
        int n3 = denseMatrix.numColumns();
        DenseMatrix denseMatrix3 = new DenseMatrix(n2, n3);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                if (i < n) {
                    denseMatrix3.set(i, j, denseMatrix.get(i, j));
                    continue;
                }
                denseMatrix3.set(i, j, denseMatrix2.get(i - n, j));
            }
        }
        return denseMatrix3;
    }

    public static DenseMatrix mult(DenseMatrix denseMatrix, DenseMatrix denseMatrix2) {
        DenseMatrix denseMatrix3 = new DenseMatrix(denseMatrix.numRows(), denseMatrix2.numColumns());
        denseMatrix.mult((Matrix)denseMatrix2, (Matrix)denseMatrix3);
        return denseMatrix3;
    }

    public static DenseMatrix mult(DenseMatrix denseMatrix, double d) {
        DenseMatrix denseMatrix2 = new DenseMatrix(denseMatrix.numRows(), denseMatrix.numColumns());
        for (int i = 0; i < denseMatrix2.numColumns(); ++i) {
            for (int j = 0; j < denseMatrix2.numRows(); ++j) {
                denseMatrix2.set(j, i, denseMatrix.get(j, i) * d);
            }
        }
        return denseMatrix2;
    }

    public static DenseMatrix multMerge(DenseMatrix denseMatrix, DenseMatrix denseMatrix2) {
        DenseMatrix denseMatrix3 = StatisticHelper.constant(denseMatrix.numRows(), denseMatrix.numColumns() * denseMatrix2.numColumns(), 0.0);
        for (int i = 0; i < denseMatrix.numRows(); ++i) {
            int n = 0;
            for (int j = 0; j < denseMatrix.numColumns(); ++j) {
                for (int k = 0; k < denseMatrix2.numColumns(); ++k) {
                    denseMatrix3.set(i, n++, denseMatrix.get(i, j) * denseMatrix2.get(i, k));
                }
            }
        }
        return denseMatrix3;
    }

    public static double norm(DenseMatrix denseMatrix) {
        if (denseMatrix.numRows() == 0 || denseMatrix.numColumns() == 0) {
            return 0.0;
        }
        SVD sVD = StatisticHelper.factorize(denseMatrix);
        return sVD.getS()[0];
    }

    public static DenseMatrix normalize(DenseMatrix denseMatrix, boolean bl) {
        DenseMatrix denseMatrix2 = denseMatrix.copy();
        int n = denseMatrix.numRows();
        int n2 = denseMatrix.numColumns();
        for (int i = 0; i < n2; ++i) {
            double d = 0.0;
            for (int j = 0; j < n; ++j) {
                d += denseMatrix.get(j, i);
            }
            d /= (double)n;
            double d2 = 0.0;
            for (int j = 0; j < n; ++j) {
                double d3 = d - denseMatrix.get(j, i);
                d2 += d3 * d3;
            }
            double d4 = Math.sqrt(d2 / (double)(n - 1));
            if (d4 == 0.0) {
                d4 = 1.0;
                if (d > 0.0) {
                    d -= 1.0;
                }
            }
            if (!bl) {
                d = 0.0;
            }
            for (int j = 0; j < n; ++j) {
                denseMatrix2.set(j, i, (denseMatrix.get(j, i) - d) / d4);
            }
        }
        return denseMatrix2;
    }

    public static DenseMatrix partColumnMatrices(DenseMatrix denseMatrix, int n, int n2) {
        DenseMatrix denseMatrix2 = new DenseMatrix(denseMatrix.numRows(), n2 - n);
        int n3 = 0;
        int n4 = n;
        while (n4 < n2) {
            for (int i = 0; i < denseMatrix.numRows(); ++i) {
                denseMatrix2.set(i, n3, denseMatrix.get(i, n4));
            }
            ++n4;
            ++n3;
        }
        return denseMatrix2;
    }

    public static DenseMatrix partRowMatrices(DenseMatrix denseMatrix, int n, int n2) {
        DenseMatrix denseMatrix2 = new DenseMatrix(n2 - n, denseMatrix.numColumns());
        int n3 = 0;
        int n4 = n;
        while (n4 < n2) {
            for (int i = 0; i < denseMatrix.numColumns(); ++i) {
                denseMatrix2.set(n3, i, denseMatrix.get(n4, i));
            }
            ++n4;
            ++n3;
        }
        return denseMatrix2;
    }

    public static void print(DenseMatrix denseMatrix) {
        StatisticHelper.print(denseMatrix, "N/A");
    }

    public static void print(DenseMatrix[] denseMatrixArray, String string) {
        for (int i = 0; i < denseMatrixArray.length; ++i) {
            StatisticHelper.print(denseMatrixArray[i], string + " " + (i + 1));
        }
    }

    public static void print(DenseMatrix denseMatrix, String string) {
        if (!doprint) {
            return;
        }
        System.out.println("--------- Printing matrix (" + string + " [" + denseMatrix.numRows() + " x " + denseMatrix.numColumns() + "]) ---------");
        int n = denseMatrix.numRows();
        int n2 = denseMatrix.numColumns();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                System.out.print(denseMatrix.get(i, j));
                if (j >= n2 - 1) continue;
                System.out.print(", ");
            }
            System.out.println("");
        }
    }

    public static void print(double[] dArray, String string) {
        if (!doprint) {
            return;
        }
        System.out.println("--------- Printing array (" + string + " [" + dArray.length + "]) ---------");
        for (int i = 0; i < dArray.length; ++i) {
            System.out.print(dArray[i]);
            if (i >= dArray.length - 1) continue;
            System.out.print(", ");
        }
        System.out.println("");
    }

    public static double sumSum(DenseMatrix denseMatrix) {
        double d = 0.0;
        for (int i = 0; i < denseMatrix.numColumns(); ++i) {
            for (int j = 0; j < denseMatrix.numRows(); ++j) {
                d += denseMatrix.get(j, i);
            }
        }
        return d;
    }

    public static double sumSumSquare(DenseMatrix denseMatrix, boolean bl) {
        double d = 0.0;
        for (int i = 0; i < denseMatrix.numColumns(); ++i) {
            int n;
            double d2 = 0.0;
            if (bl) {
                for (n = 0; n < denseMatrix.numRows(); ++n) {
                    d2 += denseMatrix.get(n, i);
                }
                d2 /= (double)denseMatrix.numRows();
            }
            for (n = 0; n < denseMatrix.numRows(); ++n) {
                double d3 = denseMatrix.get(n, i) - d2;
                d += d3 * d3;
            }
        }
        return d;
    }

    public static DenseMatrix transAmult(DenseMatrix denseMatrix, DenseMatrix denseMatrix2) {
        DenseMatrix denseMatrix3 = new DenseMatrix(denseMatrix.numColumns(), denseMatrix2.numColumns());
        denseMatrix.transAmult((Matrix)denseMatrix2, (Matrix)denseMatrix3);
        return denseMatrix3;
    }

    public static DenseMatrix transBmult(DenseMatrix denseMatrix, DenseMatrix denseMatrix2) {
        DenseMatrix denseMatrix3 = new DenseMatrix(denseMatrix.numColumns(), denseMatrix2.numColumns());
        denseMatrix.transBmult((Matrix)denseMatrix2, (Matrix)denseMatrix3);
        return denseMatrix3;
    }

    public static DenseMatrix transpose(DenseMatrix denseMatrix) {
        DenseMatrix denseMatrix2 = new DenseMatrix(denseMatrix.numColumns(), denseMatrix.numRows());
        denseMatrix.transpose((Matrix)denseMatrix2);
        return denseMatrix2;
    }

    public static SVD factorize(DenseMatrix denseMatrix) {
        try {
            return SVD.factorize((Matrix)denseMatrix);
        }
        catch (NotConvergedException notConvergedException) {
            throw new RuntimeException(notConvergedException);
        }
    }
}

