/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.statistical.manova;

import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;

public abstract class TermClass {
    private final String name;

    public TermClass(String string) {
        this.name = string;
    }

    public abstract int getRealIndex1();

    public abstract int getValue(int var1);

    public int getRealIndex2() {
        return -1;
    }

    public boolean hasInteractionTerm() {
        return false;
    }

    public String toString() {
        return this.name;
    }

    public static class TermInteraction
    extends TermClass {
        private final TermClass t1;
        private final TermClass t2;

        public TermInteraction(TermClass termClass, TermClass termClass2) {
            super(termClass.name + " x " + termClass2.name);
            this.t1 = termClass;
            this.t2 = termClass2;
        }

        @Override
        public int getValue(int n) {
            return this.t1.getValue(n) * this.t2.getValue(n);
        }

        @Override
        public int getRealIndex1() {
            return this.t1.getRealIndex1();
        }

        @Override
        public int getRealIndex2() {
            return this.t2.getRealIndex1();
        }

        @Override
        public boolean hasInteractionTerm() {
            return true;
        }
    }

    public static class TermCategory
    extends TermClass {
        private final InnerColumnClass icc;
        private final int index;

        public TermCategory(InnerColumnClass innerColumnClass, int n) {
            super(innerColumnClass.getName());
            this.icc = innerColumnClass;
            this.index = n;
        }

        @Override
        public int getRealIndex1() {
            return this.index;
        }

        @Override
        public int getValue(int n) {
            return this.icc.getValueShort(n);
        }
    }

    public static class TermXtr
    extends TermClass {
        private final AbstractDataMatrix XTr;
        private final int columnIndex;
        private final int index;

        public TermXtr(AbstractDataMatrix abstractDataMatrix, int n, int n2) {
            super(abstractDataMatrix.getColumnDescription(n, 0));
            this.XTr = abstractDataMatrix;
            this.columnIndex = n;
            this.index = n2;
        }

        @Override
        public int getRealIndex1() {
            return this.index;
        }

        @Override
        public int getValue(int n) {
            return (int)this.XTr.getValue(n, this.columnIndex);
        }
    }
}

