/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.statistical.manova.math;

import se.prediktera.statistical.manova.math.Constants;
import se.prediktera.statistical.manova.math.Factorial;
import se.prediktera.statistical.manova.math.Polynomial;
import se.prediktera.statistical.manova.math.SplitDouble;

public class ArithUtils {
    public static final double EPSILON_SMALL = Constants.MACHEPS / 2.0;
    public static final double EPSILON_LARGE = Constants.MACHEPS;
    private static final double[] COT_COEF = new double[]{0.2402591609829563, -0.016533031601500228, -4.299839193172402E-5, -1.5928322332754105E-7, -6.191093135129349E-10, -2.430197415072646E-12, -9.56093675880008E-15, -3.763537981945806E-17, -1.4816657464674657E-19};
    private static final double[] SINH_COEF = new double[]{0.1730421940471796, 0.08759422192276048, 0.00107947777456713, 6.37484926075E-6, 2.202366404E-8, 4.98794E-11, 7.973E-14, 9.0E-17};
    private static final double[] TANH_COEF = new double[]{-0.2582875664363471, -0.11836106330053497, 0.009869442648006398, -8.35798662344582E-4, 7.0904321198943E-5, -6.01642431812E-6, 5.105241908E-7, -4.3320729077E-8, 3.675999055E-9, -3.11928496E-10, 2.6468828E-11, -2.246023E-12, 1.90587E-13, -1.6172E-14, 1.372E-15, -1.16E-16, 9.0E-18};
    private static final double[] ASINH_COEF = new double[]{-0.12820039911738187, -0.05881176118995177, 0.004727465432212481, -4.938363162653618E-4, 5.850620705855741E-5, -7.466998328931368E-6, 1.00116935835582E-6, -1.3903543858708333E-7, 1.9823169483172795E-8, -2.8847468417848845E-9, 4.2672965467159937E-10, -6.397608465436636E-11, 9.699168608906471E-12, -1.4844276972043772E-12, 2.290373793902745E-13, -3.5588395132732646E-14, 5.563969408005679E-15, -8.746250959962468E-16, 1.381524884452669E-16, -2.1916688282900364E-17, 3.490465852482756E-18};
    private static final double[] ATANH_COEF = new double[]{0.0943951023931955, 0.04919843705578616, 0.002102593522455433, 1.0735544497761166E-4, 5.978267249293031E-6, 3.505062030889135E-7, 2.1263743437653402E-8, 1.3216945357155272E-9, 8.36587550117807E-11, 5.370503749311002E-12, 3.4866594701571077E-13, 2.284549509603433E-14, 1.508407105944793E-15, 1.0024188168041091E-16, 6.69867473816507E-18, 4.497954546494931E-19};

    public static double acosh(double d) {
        double d2 = Double.isNaN(d) || d < 1.0 ? Double.NaN : (d < 9.490626562E7 ? ArithUtils.safeLog(d + Math.sqrt(d * d - 1.0)) : 0.6931471805599453 + ArithUtils.safeLog(d));
        return d2;
    }

    public static boolean areEqual(double d, double d2) {
        return ArithUtils.areEqual(d, d2, Constants.MACHEPS);
    }

    public static boolean areEqual(double d, double d2, double d3) {
        boolean bl;
        boolean bl2 = bl = d == d2;
        if (!bl) {
            bl = d == 0.0 ? Math.abs(d2) <= d3 : (d2 == 0.0 ? Math.abs(d) <= d3 : ArithUtils.fuzzyCompare(d, d2, d3) == 0);
        }
        return bl;
    }

    public static double asinh(double d) {
        double d2 = Math.abs(d);
        double d3 = Double.isNaN(d) ? Double.NaN : (d2 <= 1.05367E-8 ? d : (d2 <= 1.0 ? d * (1.0 + Polynomial.evaluateChebyschev(ASINH_COEF, 2.0 * d * d - 1.0)) : (d2 < 9.490626562E7 ? ArithUtils.safeLog(d2 + Math.sqrt(d2 * d2 + 1.0)) : 0.6931471805599453 + ArithUtils.safeLog(d2))));
        if (d < 0.0) {
            d3 = -d3;
        }
        return d3;
    }

    public static double atanh(double d) {
        double d2 = Math.abs(d);
        double d3 = Double.isNaN(d) ? Double.NaN : (d2 < 1.82501E-8 ? d : (d2 <= 0.5 ? d * (1.0 + Polynomial.evaluateChebyschev(ATANH_COEF, 8.0 * d * d - 1.0)) : (d2 < 1.0 ? 0.5 * ArithUtils.safeLog((1.0 + d) / (1.0 - d)) : (d2 == 1.0 ? d * Double.POSITIVE_INFINITY : Double.NaN))));
        return d3;
    }

    public static double binomial(double d, long l) {
        if (l < 0L) {
            return 0.0;
        }
        if (l == 0L) {
            return 1.0;
        }
        if (l == 1L) {
            return d;
        }
        double d2 = d - (double)l + 1.0;
        double d3 = 1.0;
        double d4 = 1.0;
        long l2 = l;
        while (l2-- > 0L) {
            double d5 = d2;
            d2 = d5 + 1.0;
            double d6 = d3;
            d3 = d6 + 1.0;
            d4 *= d5 / d6;
        }
        return d4;
    }

    public static double binomial(long l, long l2) {
        if (l2 < 0L) {
            return 0.0;
        }
        if (l2 == 0L || l2 == l) {
            return 1.0;
        }
        if (l2 == 1L || l2 == l - 1L) {
            return l;
        }
        if (l > l2) {
            int n = Factorial.longFactorials.length + Factorial.doubleFactorials.length;
            if (l < (long)n) {
                double d = Factorial.factorial((int)l);
                double d2 = Factorial.factorial((int)l2);
                double d3 = Factorial.factorial((int)(l - l2));
                double d4 = d3 * d2;
                if (d4 != Double.POSITIVE_INFINITY) {
                    return d / d4;
                }
            }
            if (l2 > l / 2L) {
                l2 = l - l2;
            }
        }
        long l3 = l - l2 + 1L;
        long l4 = 1L;
        double d = 1.0;
        long l5 = l2;
        while (l5-- > 0L) {
            d *= (double)l3++ / (double)l4++;
        }
        return d;
    }

    public static double cosh(double d) {
        double d2 = Math.exp(Math.abs(d));
        double d3 = Double.isNaN(d) ? Double.NaN : (Double.isInfinite(d) ? d : (d2 < 9.490626562E7 ? 0.5 * (d2 + 1.0 / d2) : 0.5 * d2));
        return d3;
    }

    public static double cot(double d) {
        double d2;
        double d3 = Math.abs(d);
        if (d3 > 4.5036E15) {
            return Double.NaN;
        }
        double d4 = (int)d3;
        double d5 = d3 - d4;
        double d6 = 0.625 * d4;
        d4 = (int)d6;
        d3 = d6 - d4 + 0.625 * d5 + d3 * 0.011619772367581343;
        double d7 = (int)d3;
        d3 -= d7;
        int n = (int)((d4 += d7) % 2.0);
        if (n == 1) {
            d3 = 1.0 - d3;
        }
        if (d3 == 0.0) {
            d2 = Double.POSITIVE_INFINITY;
        } else if (d3 <= 1.82501E-8) {
            d2 = 1.0 / d3;
        } else if (d3 <= 0.25) {
            d2 = (0.5 + Polynomial.evaluateChebyschev(COT_COEF, 32.0 * d3 * d3 - 1.0)) / d3;
        } else if (d3 <= 0.5) {
            d2 = (0.5 + Polynomial.evaluateChebyschev(COT_COEF, 8.0 * d3 * d3 - 1.0)) / (0.5 * d3);
            d2 = (d2 * d2 - 1.0) * 0.5 / d2;
        } else {
            d2 = (0.5 + Polynomial.evaluateChebyschev(COT_COEF, 2.0 * d3 * d3 - 1.0)) / (0.25 * d3);
            d2 = (d2 * d2 - 1.0) * 0.5 / d2;
            d2 = (d2 * d2 - 1.0) * 0.5 / d2;
        }
        if (d != 0.0) {
            d2 = ArithUtils.sign(d2, d);
        }
        if (n == 1) {
            d2 = -d2;
        }
        return d2;
    }

    public static int fuzzyCompare(double d, double d2, double d3) {
        if (d == d2) {
            return 0;
        }
        double d4 = d - d2;
        double d5 = Math.max(Math.abs(d), Math.abs(d2));
        int n = new SplitDouble((double)d5).exponent;
        double d6 = d3 * Math.pow(2.0, n);
        int n2 = 0;
        if (d4 > d6) {
            n2 = 1;
        } else if (d4 < -d6) {
            n2 = -1;
        }
        return n2;
    }

    public static double hypot(double d, double d2) {
        double d3;
        if (Math.abs(d) > Math.abs(d2)) {
            d3 = d2 / d;
            d3 = Math.abs(d) * Math.sqrt(1.0 + d3 * d3);
        } else if (d2 != 0.0) {
            d3 = d / d2;
            d3 = Math.abs(d2) * Math.sqrt(1.0 + d3 * d3);
        } else {
            d3 = 0.0;
        }
        return d3;
    }

    public static boolean isNegativeZero(double d) {
        return d == 0.0 && 1.0 / d < 0.0;
    }

    public static double log10(double d) {
        double d2 = 0.0;
        if (d > 0.0) {
            d2 = ArithUtils.safeLog(d) * 0.4342944819032518;
        }
        return d2;
    }

    public static double log2(double d) {
        double d2 = 0.0;
        if (d > 0.0) {
            d2 = ArithUtils.safeLog(d) * Constants.LN2INV;
        }
        return d2;
    }

    public static double round(double d, int n) {
        double d2 = Math.pow(10.0, n);
        return (double)Math.round(d * d2) / d2;
    }

    public static double safeLog(double d) {
        if (d == 0.0) {
            return 0.0;
        }
        return Math.log(d);
    }

    public static int sign(double d) {
        if (d > 0.0) {
            return 1;
        }
        if (d < 0.0) {
            return -1;
        }
        return 0;
    }

    public static double sign(double d, double d2) {
        double d3 = d < 0.0 ? -d : d;
        return d2 < 0.0 ? -d3 : d3;
    }

    public static int sign(int n) {
        if (n > 0) {
            return 1;
        }
        if (n < 0) {
            return -1;
        }
        return 0;
    }

    public static double sinh(double d) {
        double d2;
        double d3 = Math.abs(d);
        if (Double.isNaN(d)) {
            d2 = Double.NaN;
        } else {
            if (Double.isInfinite(d3)) {
                return d;
            }
            d2 = d3 < 2.58096E-8 ? d : (d3 <= 1.0 ? d * (1.0 + Polynomial.evaluateChebyschev(SINH_COEF, 2.0 * d * d - 1.0)) : ((d3 = Math.exp(d3)) >= 9.490626562E7 ? ArithUtils.sign(0.5 * d3, d) : ArithUtils.sign(0.5 * (d3 - 1.0 / d3), d)));
        }
        return d2;
    }

    public static double tanh(double d) {
        double d2;
        double d3 = Math.abs(d);
        if (Double.isNaN(d)) {
            d2 = Double.NaN;
        } else if (d3 < 1.82501E-8) {
            d2 = d;
        } else if (d3 <= 1.0) {
            d2 = d * (1.0 + Polynomial.evaluateChebyschev(TANH_COEF, 2.0 * d * d - 1.0));
        } else if (d3 < 7.977294885) {
            d3 = Math.exp(d3);
            d2 = ArithUtils.sign((d3 - 1.0 / d3) / (d3 + 1.0 / d3), d);
        } else {
            d2 = ArithUtils.sign(1.0, d);
        }
        return d2;
    }

    public static double trunc(double d) {
        return (long)d;
    }

    protected ArithUtils() {
    }
}

