/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.statistical.manova.math;

import se.prediktera.statistical.manova.math.BracketRoot;
import se.prediktera.statistical.manova.math.Brent;
import se.prediktera.statistical.manova.math.Constants;
import se.prediktera.statistical.manova.math.Gamma;
import se.prediktera.statistical.manova.math.MonadicFunction;

public class Beta {
    public static double beta(double d, double d2) throws ArithmeticException {
        double d3 = 1.0;
        double d4 = Gamma.gamma(d + d2);
        if (d4 == 0.0) {
            return d3;
        }
        if (d > d2) {
            d3 = Gamma.gamma(d) / d4;
            d3 *= Gamma.gamma(d2);
        } else {
            d3 = Gamma.gamma(d2) / d4;
            d3 *= Gamma.gamma(d);
        }
        return d3;
    }

    public static double incompleteBeta(double d, double d2, double d3) throws IllegalArgumentException {
        return Beta.incompleteBeta(d, d2, d3, Constants.MAXPREC);
    }

    public static double incompleteBeta(double d, double d2, double d3, int n) throws IllegalArgumentException {
        double d4;
        if (n > Constants.MAXPREC) {
            n = Constants.MAXPREC;
        } else if (n <= 0) {
            n = 1;
        }
        double d5 = Math.pow(10.0, -n);
        double d6 = d2;
        double d7 = d3;
        boolean bl = false;
        double d8 = -1.0;
        int n2 = 200;
        if (d <= 0.0) {
            throw new IllegalArgumentException("x <= 0.0");
        }
        if (d6 <= 0.0) {
            throw new IllegalArgumentException("a <= 0.0");
        }
        if (d7 <= 0.0) {
            throw new IllegalArgumentException("b <= 0.0");
        }
        d8 = 1.0;
        if (d >= 1.0) {
            return d8;
        }
        if (d > d6 / (d6 + d7)) {
            d = 1.0 - d;
            d6 = d3;
            d7 = d2;
            bl = true;
        }
        if (d != d6 && d != d7 && d6 != d7 * d / (1.0 - d) && !(Math.abs(d6 - d * (d6 + d7)) <= d5)) {
            double d9 = Gamma.logGamma(d6 + d7) + d6 * Math.log(d) + d7 * Math.log(1.0 - d) - Gamma.logGamma(d6) - Gamma.logGamma(d7) - Math.log(d6 - d * (d6 + d7));
            if (d9 < -36.0 && bl) {
                return d8;
            }
            d8 = 0.0;
            if (d9 < -180.0) {
                return d8;
            }
        }
        double d10 = d6 + d7;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 1.0;
        double d14 = 1.0;
        double d15 = 1.0;
        double d16 = 1.0;
        double d17 = d4 = Math.exp(Gamma.logGamma(d10) + d6 * Math.log(d) + d7 * Math.log(1.0 - d) - Gamma.logGamma(d6 + 1.0) - Gamma.logGamma(d7));
        int n3 = 0;
        boolean bl2 = false;
        do {
            double d18 = d17;
            double d19 = d11;
            double d20 = d6 + (d11 += 1.0) + d19;
            double d21 = -(d6 + d19) * (d10 + d19) * d / d20 / (d20 - 1.0);
            double d22 = d11 * (d7 - d11) * d / d20 / (d20 + 1.0);
            d12 = d14 * d4 + d21 * d12;
            d16 = d14 * d15 + d21 * d16;
            d4 = d13 * d12 + d22 * d4;
            if (Math.abs(d15 = d13 * d16 + d22 * d15) < Double.MIN_VALUE) {
                d15 = 0.0;
            }
            if (d15 == 0.0) continue;
            d17 = d4 / d15;
            boolean bl3 = bl2 = Math.abs((d17 - d18) / d17) < d5;
        } while (++n3 <= n2 && !bl2);
        d8 = bl ? 1.0 - d17 : d17;
        return d8;
    }

    public static double incompleteBetaInverse(double d, double d2, double d3) throws IllegalArgumentException {
        MonadicFunction monadicFunction;
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("alpha<=0");
        }
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("beta<=0");
        }
        if (d > 1.0 || d < 0.0) {
            throw new IllegalArgumentException("p < 0 or p > 1");
        }
        if (d == 0.0 || d == 1.0) {
            return 0.0;
        }
        double d5 = Math.pow(10.0, -2 * Constants.MAXPREC);
        double[] dArray = new double[]{d5, 1.0 - d5};
        if (BracketRoot.bracketRoot(dArray, monadicFunction = d4 -> d - Beta.incompleteBeta(d4, d2, d3), 100, 1.6)) {
            return Brent.brent(dArray[0], dArray[1], d5, 100, monadicFunction);
        }
        throw new ArithmeticException("Unable to bracket value");
    }

    public static double logBeta(double d, double d2) {
        return Gamma.logGamma(d) + Gamma.logGamma(d2) - Gamma.logGamma(d + d2);
    }

    protected Beta() {
    }
}

