/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.statistical.manova.math;

import se.prediktera.statistical.manova.math.BracketRoot;
import se.prediktera.statistical.manova.math.Constants;
import se.prediktera.statistical.manova.math.MonadicFunction;
import se.prediktera.statistical.manova.math.MonadicFunctionRootFinder;
import se.prediktera.statistical.manova.math.RootFinderConvergenceTest;
import se.prediktera.statistical.manova.math.RootFinderIterationInformation;
import se.prediktera.statistical.manova.math.StandardRootFinderConvergenceTest;

public class Brent
implements MonadicFunctionRootFinder {
    public static double brent(double d, double d2, double d3, int n, MonadicFunction monadicFunction) throws IllegalArgumentException {
        return Brent.brent(d, d2, d3, n, monadicFunction, new StandardRootFinderConvergenceTest(), null);
    }

    public static double brent(double d, double d2, double d3, int n, MonadicFunction monadicFunction, RootFinderConvergenceTest rootFinderConvergenceTest, RootFinderIterationInformation rootFinderIterationInformation) throws IllegalArgumentException {
        double d4 = Constants.MACHEPS / 2.0;
        double d5 = d;
        double d6 = d2;
        double d7 = d2;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = monadicFunction.f(d5);
        double d11 = monadicFunction.f(d6);
        if (d10 > 0.0 && d11 > 0.0 || d10 < 0.0 && d11 < 0.0) {
            double[] dArray = new double[]{d5, d6};
            if (!BracketRoot.bracketRoot(dArray, monadicFunction, n, 1.6)) {
                throw new IllegalArgumentException("Cannot expand interval [x0,x1] to contain root.");
            }
            d5 = dArray[0];
            d6 = dArray[1];
            d10 = monadicFunction.f(d5);
            d11 = monadicFunction.f(d6);
        }
        double d12 = d11;
        for (int i = 1; i <= n; ++i) {
            double d13;
            double d14;
            if (d11 > 0.0 && d12 > 0.0 || d11 < 0.0 && d12 < 0.0) {
                d7 = d5;
                d12 = d10;
                d9 = d8 = d6 - d5;
            }
            if (Math.abs(d12) < Math.abs(d11)) {
                d5 = d6;
                d6 = d7;
                d7 = d5;
                d10 = d11;
                d11 = d12;
                d12 = d10;
            }
            if (rootFinderIterationInformation != null) {
                rootFinderIterationInformation.iterationInformation(d6, d11, Double.NaN, i);
            }
            if (rootFinderConvergenceTest.converged(d14 = 0.5 * (d7 - d6), 0.0, d11, d13 = 2.0 * d4 * Math.abs(d6) + 0.5 * d3, 0.0)) {
                return d6;
            }
            if (Math.abs(d9) >= d13 && Math.abs(d10) > Math.abs(d11)) {
                double d15;
                double d16;
                double d17;
                double d18 = d11 / d10;
                if (d5 == d7) {
                    d17 = 2.0 * d14 * d18;
                    d16 = 1.0 - d18;
                } else {
                    d16 = d10 / d12;
                    double d19 = d11 / d12;
                    d17 = d18 * (2.0 * d14 * d16 * (d16 - d19) - (d6 - d5) * (d19 - 1.0));
                    d16 = (d16 - 1.0) * (d19 - 1.0) * (d18 - 1.0);
                }
                if (d17 > 0.0) {
                    d16 = -d16;
                }
                d17 = Math.abs(d17);
                double d20 = 3.0 * d14 * d16 - Math.abs(d13 * d16);
                double d21 = d20 < (d15 = Math.abs(d9 * d16)) ? d20 : d15;
                if (2.0 * d17 < d21) {
                    d9 = d8;
                    d8 = d17 / d16;
                } else {
                    d9 = d8 = d14;
                }
            } else {
                d9 = d8 = d14;
            }
            d5 = d6;
            d10 = d11;
            d6 = Math.abs(d8) > d13 ? (d6 += d8) : (d6 += d14 > 0.0 ? d13 : -d13);
            d11 = monadicFunction.f(d6);
        }
        return d6;
    }

    public static double brent(double d, double d2, MonadicFunction monadicFunction) throws IllegalArgumentException {
        return Brent.brent(d, d2, Constants.MACHEPS, 100, monadicFunction, new StandardRootFinderConvergenceTest(), null);
    }

    @Override
    public double findRoot(double d, double d2, double d3, int n, MonadicFunction monadicFunction, MonadicFunction monadicFunction2, RootFinderConvergenceTest rootFinderConvergenceTest, RootFinderIterationInformation rootFinderIterationInformation) throws IllegalArgumentException {
        return Brent.brent(d, d2, d3, n, monadicFunction, rootFinderConvergenceTest, rootFinderIterationInformation);
    }
}

