/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.statistical.manova.math;

import se.prediktera.statistical.manova.math.ArithUtils;

public class Constants {
    public static final double MACHEPS = Constants.determineMachineEpsilon();
    public static final int MAXPREC = Constants.determineMaximumPrecision();
    public static final double MAXLOG = 709.782712893384;
    public static final double MINLOG = -745.1332191019412;
    public static final double SQRT2 = Math.sqrt(2.0);
    public static final double SQRT2DIV2 = SQRT2 / 2.0;
    public static final double SQRTPI = Math.sqrt(Math.PI);
    public static final double LNPI = Math.log(Math.PI);
    public static final double LN10 = Math.log(10.0);
    public static final double LN10INV = 0.4342944819032518;
    public static final double LN2 = Math.log(2.0);
    public static final double LN2INV = 1.0 / LN2;
    public static final double LNSQRT2PI = Math.log(Math.sqrt(Math.PI * 2));

    public static double determineMachineEpsilon() {
        double d = 0.0;
        while (d == 0.0) {
            double d2 = 0.9999999999999998;
            d = Math.abs(d2 - 1.0);
        }
        return d;
    }

    public static int determineMaximumPrecision() {
        double d = Constants.determineMachineEpsilon();
        double d2 = ArithUtils.trunc(Math.log(d) / Math.log(10.0));
        return -Long.valueOf(Math.round(d2)).intValue();
    }

    protected Constants() {
    }
}

