/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.statistical.manova.math;

import se.prediktera.statistical.manova.math.Constants;

public class Gamma {
    public static final double MAXGAM = 171.6243769563027;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double gamma(double d) {
        double d2;
        double d3;
        double[] dArray = new double[]{-1.716185138865495, 24.76565080557592, -379.80425647094563, 629.3311553128184, 866.9662027904133, -31451.272968848367, -36144.413418691176, 66456.14382024054};
        double[] dArray2 = new double[]{-30.840230011973897, 315.35062697960416, -1015.1563674902192, -3107.771671572311, 22538.11842098015, 4755.846277527881, -134659.9598649693, -115132.25967555349};
        double[] dArray3 = new double[]{-0.001910444077728, 8.4171387781295E-4, -5.952379913043012E-4, 7.936507935003503E-4, -0.0027777777777776816, 0.08333333333333333, 0.0057083835261};
        if (Double.isNaN(d)) {
            return d;
        }
        boolean bl = false;
        double d4 = 1.0;
        int n = 0;
        double d5 = d;
        if (d5 <= 0.0) {
            d5 = -d;
            d3 = (int)d5;
            d2 = d5 - d3;
            if (d2 == 0.0) return Double.POSITIVE_INFINITY;
            if (d3 != (double)((int)(d3 * 0.5)) * 2.0) {
                bl = true;
            }
            d4 = -Math.PI / Math.sin(Math.PI * d2);
            d5 += 1.0;
        }
        if (d5 < Constants.MACHEPS) {
            if (!(d5 >= 2.23E-308)) return Double.POSITIVE_INFINITY;
            d2 = 1.0 / d5;
        } else if (d5 < 12.0) {
            int n2;
            double d6;
            d3 = d5;
            if (d5 < 1.0) {
                d6 = d5;
                d5 += 1.0;
            } else {
                n = (int)(d5 - 1.0);
                d6 = (d5 -= (double)n) - 1.0;
            }
            double d7 = 0.0;
            double d8 = 1.0;
            for (n2 = 0; n2 < 8; ++n2) {
                d7 = (d7 + dArray[n2]) * d6;
                d8 = d8 * d6 + dArray2[n2];
            }
            d2 = d7 / d8 + 1.0;
            if (d3 < d5) {
                d2 /= d3;
            } else if (d3 > d5) {
                for (n2 = 1; n2 <= n; ++n2) {
                    d2 *= d5;
                    d5 += 1.0;
                }
            }
        } else {
            if (!(d5 <= 171.624)) return Double.POSITIVE_INFINITY;
            double d9 = d5 * d5;
            double d10 = dArray3[6];
            for (int i = 0; i < 6; ++i) {
                d10 = d10 / d9 + dArray3[i];
            }
            d10 = d10 / d5 - d5 + Constants.LNSQRT2PI;
            d2 = Math.exp(d10 += (d5 - 0.5) * Math.log(d5));
        }
        if (bl) {
            d2 = -d2;
        }
        if (d4 == 1.0) return d2;
        return d4 / d2;
    }

    public static double incompleteGamma(double d, double d2) throws IllegalArgumentException {
        return Gamma.incompleteGamma(d, d2, Constants.MAXPREC, 1000);
    }

    public static double incompleteGamma(double d, double d2, int n, int n2) throws IllegalArgumentException {
        double d3;
        double[] dArray = new double[6];
        if (d == 0.0) {
            return 0.0;
        }
        if (d < 0.0 || d2 <= 0.0) {
            throw new IllegalArgumentException("x<0 or alpha<=0");
        }
        double d4 = d2 * Math.log(d) - d - Gamma.logGamma(d2);
        d4 = Math.exp(d4);
        if (n > Constants.MAXPREC) {
            n = Constants.MAXPREC;
        } else if (n <= 0) {
            n = 1;
        }
        double d5 = Math.pow(10.0, -n);
        if (d > 1.0 && d >= d2) {
            double d6 = 1.0 - d2;
            double d7 = d6 + d + 1.0;
            double d8 = 0.0;
            dArray[0] = 1.0;
            dArray[1] = d;
            dArray[2] = d + 1.0;
            dArray[3] = d * d7;
            d3 = dArray[2] / dArray[3];
            int n3 = 0;
            do {
                ++n3;
                double d9 = (d6 += 1.0) * (d8 += 1.0);
                dArray[4] = (d7 += 2.0) * dArray[2] - d9 * dArray[0];
                dArray[5] = d7 * dArray[3] - d9 * dArray[1];
                if (dArray[5] != 0.0) {
                    double d10 = dArray[4] / dArray[5];
                    double d11 = Math.abs(d3 - d10);
                    if (d11 <= d5 && d11 <= d5 * d10) break;
                    d3 = d10;
                }
                dArray[0] = dArray[2];
                dArray[1] = dArray[3];
                dArray[2] = dArray[4];
                dArray[3] = dArray[5];
                if (!(Math.abs(dArray[4]) >= 1.0E37)) continue;
                dArray[0] = dArray[0] / 1.0E37;
                dArray[1] = dArray[1] / 1.0E37;
                dArray[2] = dArray[2] / 1.0E37;
                dArray[3] = dArray[3] / 1.0E37;
            } while (n3 <= n2);
            d3 = 1.0 - d4 * d3;
        } else {
            d3 = 1.0;
            double d12 = 1.0;
            double d13 = d2;
            while (0 <= n2 && d12 / (d3 += (d12 *= d / (d13 += 1.0))) > d5) {
            }
            d3 *= d4 / d2;
        }
        return d3;
    }

    public static double logGamma(double d) {
        double d2;
        double[] dArray = new double[]{4.945235359296727, 201.8112620856775, 2290.8383738313464, 11319.672059033808, 28557.246356716354, 38484.962284437934, 26377.487876241954, 7225.813979700288};
        double[] dArray2 = new double[]{67.48212550303778, 1113.3323938571993, 7738.757056935398, 27639.870744033407, 54993.102062261576, 61611.22180066002, 36351.2759150194, 8785.536302431014};
        double[] dArray3 = new double[]{4.974607845568932, 542.4138599891071, 15506.93864978365, 184793.29044456323, 1088204.7694688288, 3338152.96798703, 5106661.678927353, 3074109.0548505397};
        double[] dArray4 = new double[]{183.03283993705926, 7765.049321445006, 133190.38279660742, 1136705.8213219696, 5267964.117437947, 1.3467014543111017E7, 1.7827365303532742E7, 9533095.591844354};
        double[] dArray5 = new double[]{14745.0216605994, 2426813.3694867045, 1.2147555740450932E8, 2.663432449630977E9, 2.940378956634554E10, 1.702665737765399E11, 4.926125793377431E11, 5.606251856223951E11};
        double[] dArray6 = new double[]{2690.5301758708993, 639388.5654300093, 4.135599930241388E7, 1.120872109616148E9, 1.4886137286788137E10, 1.0168035862724382E11, 3.4174763455073773E11, 4.463158187419713E11};
        double[] dArray7 = new double[]{-0.001910444077728, 8.4171387781295E-4, -5.952379913043012E-4, 7.936507935003503E-4, -0.0027777777777776816, 0.08333333333333333, 0.0057083835261};
        if (Double.isNaN(d)) {
            return d;
        }
        if (d > 0.0 && d <= 2.5E305) {
            if (d <= Constants.MACHEPS) {
                d2 = -Math.log(d);
            } else if (d <= 1.5) {
                double d3;
                double d4;
                if (d < 0.6796875) {
                    d4 = -Math.log(d);
                    d3 = d;
                } else {
                    d4 = 0.0;
                    d3 = d - 0.5 - 0.5;
                }
                if (d <= 0.5 || d >= 0.6796875) {
                    double d5 = 1.0;
                    double d6 = 0.0;
                    for (int i = 0; i < 8; ++i) {
                        d6 = d6 * d3 + dArray[i];
                        d5 = d5 * d3 + dArray2[i];
                    }
                    d2 = d4 + d3 * (-0.5772156649015329 + d3 * (d6 / d5));
                } else {
                    double d7 = d - 0.5 - 0.5;
                    double d8 = 1.0;
                    double d9 = 0.0;
                    for (int i = 0; i < 8; ++i) {
                        d9 = d9 * d7 + dArray3[i];
                        d8 = d8 * d7 + dArray4[i];
                    }
                    d2 = d4 + d3 * (0.42278433509846713 + d7 * (d9 / d8));
                }
            } else if (d <= 4.0) {
                double d10 = d - 2.0;
                double d11 = 1.0;
                double d12 = 0.0;
                for (int i = 0; i < 8; ++i) {
                    d12 = d12 * d10 + dArray3[i];
                    d11 = d11 * d10 + dArray4[i];
                }
                d2 = d10 * (0.42278433509846713 + d10 * (d12 / d11));
            } else if (d <= 12.0) {
                double d13 = d - 4.0;
                double d14 = -1.0;
                double d15 = 0.0;
                for (int i = 0; i < 8; ++i) {
                    d15 = d15 * d13 + dArray5[i];
                    d14 = d14 * d13 + dArray6[i];
                }
                d2 = 1.791759469228055 + d13 * (d15 / d14);
            } else {
                d2 = 0.0;
                if (d <= 2.25E76) {
                    d2 = dArray7[6];
                    double d16 = d * d;
                    for (int i = 0; i < 6; ++i) {
                        d2 = d2 / d16 + dArray7[i];
                    }
                }
                d2 /= d;
                double d17 = Math.log(d);
                d2 = d2 + Constants.LNSQRT2PI - 0.5 * d17;
                d2 += d * (d17 - 1.0);
            }
        } else {
            d2 = Double.POSITIVE_INFINITY;
        }
        return d2;
    }

    protected Gamma() {
    }
}

