/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jfilechooserbookmarks.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;

public class GUIHelper {
    public static final String EMPTY_ICON = "empty.gif";

    public static boolean hasImageFile(String name) {
        return GUIHelper.getImageFilename(name) != null;
    }

    public static String getImageFilename(String name) {
        String result = null;
        String dir = "com/googlecode/jfilechooserbookmarks/images/";
        try {
            URL url = ClassLoader.getSystemClassLoader().getResource(dir + name);
            if (url != null) {
                result = dir + name;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    public static ImageIcon getIcon(Class cls) {
        if (GUIHelper.hasImageFile(cls.getName() + ".gif")) {
            return GUIHelper.getIcon(cls.getName() + ".gif");
        }
        if (GUIHelper.hasImageFile(cls.getName() + ".png")) {
            return GUIHelper.getIcon(cls.getName() + ".png");
        }
        if (GUIHelper.hasImageFile(cls.getName() + ".jpg")) {
            return GUIHelper.getIcon(cls.getName() + ".jpg");
        }
        return null;
    }

    public static ImageIcon getIcon(String name) {
        String filename = GUIHelper.getImageFilename(name);
        if (filename != null) {
            return new ImageIcon(ClassLoader.getSystemClassLoader().getResource(filename));
        }
        return null;
    }

    public static ImageIcon getExternalIcon(String filename) {
        ImageIcon result;
        try {
            result = new ImageIcon(ClassLoader.getSystemClassLoader().getResource(filename));
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public static ImageIcon getEmptyIcon() {
        return GUIHelper.getIcon(EMPTY_ICON);
    }

    public static Object getParent(Container cont, Class parentClass) {
        Container result = null;
        for (Container parent = cont; parent != null; parent = parent.getParent()) {
            if (!parentClass.isInstance(parent)) continue;
            result = parent;
            break;
        }
        return result;
    }

    public static Frame getParentFrame(Container cont) {
        return (Frame)GUIHelper.getParent(cont, Frame.class);
    }

    public static Frame getParentFrame(Component comp) {
        if (comp instanceof Container) {
            return (Frame)GUIHelper.getParent((Container)comp, Frame.class);
        }
        return null;
    }

    public static Dialog getParentDialog(Container cont) {
        return (Dialog)GUIHelper.getParent(cont, Dialog.class);
    }

    public static Dialog getParentDialog(Component comp) {
        if (comp instanceof Container) {
            return (Dialog)GUIHelper.getParent((Container)comp, Dialog.class);
        }
        return null;
    }

    public static JInternalFrame getParentInternalFrame(Container cont) {
        return (JInternalFrame)GUIHelper.getParent(cont, JInternalFrame.class);
    }

    public static JInternalFrame getParentInternalFrame(Component comp) {
        if (comp instanceof Container) {
            return (JInternalFrame)GUIHelper.getParent((Container)comp, JInternalFrame.class);
        }
        return null;
    }

    public static Component getParentComponent(Component comp) {
        if (comp == null) {
            return null;
        }
        if (!(comp instanceof Container)) {
            return null;
        }
        Container cont = (Container)comp;
        Window result = GUIHelper.getParentDialog(cont);
        if (result == null) {
            result = GUIHelper.getParentFrame(cont);
        }
        return result;
    }

    public static void closeParent(Container cont) {
        if (GUIHelper.getParentDialog(cont) != null) {
            Dialog dialog = GUIHelper.getParentDialog(cont);
            dialog.setVisible(false);
        } else if (GUIHelper.getParentFrame(cont) != null) {
            JInternalFrame jintframe = GUIHelper.getParentInternalFrame(cont);
            if (jintframe != null) {
                jintframe.doDefaultCloseAction();
            } else {
                Frame frame = GUIHelper.getParentFrame(cont);
                if (frame instanceof JFrame) {
                    JFrame jframe = (JFrame)frame;
                    if (jframe.getDefaultCloseOperation() == 1) {
                        jframe.setVisible(false);
                    } else if (jframe.getDefaultCloseOperation() == 2) {
                        jframe.dispose();
                    } else if (jframe.getDefaultCloseOperation() == 3) {
                        System.exit(0);
                    }
                    WindowListener[] listeners = jframe.getWindowListeners();
                    WindowEvent event = new WindowEvent(jframe, 202);
                    for (int i = 0; i < listeners.length; ++i) {
                        listeners[i].windowClosed(event);
                    }
                } else {
                    frame.dispose();
                }
            }
        }
    }
}

