/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.jpos.service.scanner;

import com.zebra.jpos.service.scanner.ScanEventQueueEntry;
import com.zebra.jpos.service.scanner.ScanEventSink;
import com.zebra.log.scanner.JCoreLogger;

class ScanEventQueue
extends Thread {
    private ScanEventQueueEntry _seqeHead;
    private ScanEventQueueEntry _seqeTail;
    private ScanEventSink _ses;
    protected int _iNumEvents;
    protected int _iDataEvents;
    protected int _iErrorEvents;
    protected boolean _fStopThread;
    protected boolean _fEnabled;
    protected boolean _fDataEventEnabled;
    protected boolean _fFreezeEvents;
    public static boolean isHealthCheck = false;

    protected ScanEventQueue(ScanEventSink scanEventSink) {
        this._ses = scanEventSink;
        this._seqeHead = null;
        this._seqeTail = null;
        this._iNumEvents = 0;
        this._iDataEvents = 0;
        this._iErrorEvents = 0;
        this._fStopThread = true;
        this._fEnabled = false;
        this._fDataEventEnabled = false;
        this._fFreezeEvents = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            int n = 5000;
            while (!this._fStopThread) {
                ScanEventQueue scanEventQueue = this;
                // MONITORENTER : scanEventQueue
                this.wait(n);
                // MONITOREXIT : scanEventQueue
                if (this._fStopThread) {
                    return;
                }
                n = 5000;
                if (this._fFreezeEvents) continue;
                ScanEventQueueEntry scanEventQueueEntry = this._seqeHead;
                boolean bl = false;
                ScanEventQueue scanEventQueue2 = this;
                // MONITORENTER : scanEventQueue2
                boolean bl2 = bl = scanEventQueueEntry != null && (this._fDataEventEnabled || scanEventQueueEntry._iEventType != 0);
                if (scanEventQueueEntry != null && scanEventQueueEntry._iEventType == 0) {
                    this._fDataEventEnabled = false;
                }
                // MONITOREXIT : scanEventQueue2
                if (!bl) continue;
                this.RemoveHead();
                JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"BarcodeEventDispatch before");
                this._ses.ScanEventHandler(scanEventQueueEntry);
                JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"BarcodeEventDispatch after");
                scanEventQueueEntry = null;
                scanEventQueue2 = this;
                // MONITORENTER : scanEventQueue2
                if (!this._fFreezeEvents && this._fDataEventEnabled && this._seqeHead != null) {
                    n = 1;
                }
                // MONITOREXIT : scanEventQueue2
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            interruptedException.getMessage();
            return;
        }
        catch (Exception exception) {
            exception.getMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void AddTail(ScanEventQueueEntry scanEventQueueEntry) {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[]{scanEventQueueEntry});
        if (scanEventQueueEntry == null) {
            JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[0]);
            return;
        }
        ScanEventQueue scanEventQueue = this;
        synchronized (scanEventQueue) {
            if (isHealthCheck) {
                this._ses.ScanEventHandlerHealthCheck(scanEventQueueEntry);
            } else {
                if (scanEventQueueEntry._iEventType == 0) {
                    if (!this._fEnabled) {
                        // empty if block
                    }
                    this._ses.ScanDataReceived();
                }
                scanEventQueueEntry._seqeNext = null;
                if (this._seqeTail == null) {
                    this._seqeHead = scanEventQueueEntry;
                    scanEventQueueEntry._seqePrev = null;
                } else {
                    scanEventQueueEntry._seqePrev = this._seqeTail;
                    this._seqeTail._seqeNext = scanEventQueueEntry;
                }
                this._seqeTail = scanEventQueueEntry;
                ++this._iNumEvents;
                if (scanEventQueueEntry._iEventType == 0) {
                    ++this._iDataEvents;
                } else if (scanEventQueueEntry._iEventType == 2) {
                    ++this._iErrorEvents;
                }
                if (!this._fFreezeEvents) {
                    this.notify();
                }
            }
        }
        JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScanEventQueueEntry RemoveHead() {
        ScanEventQueueEntry scanEventQueueEntry;
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[0]);
        ScanEventQueue scanEventQueue = this;
        synchronized (scanEventQueue) {
            scanEventQueueEntry = this._seqeHead;
            if (scanEventQueueEntry != null) {
                this._seqeHead = scanEventQueueEntry._seqeNext;
                scanEventQueueEntry._seqeNext = null;
                if (this._seqeHead == null) {
                    this._seqeTail = null;
                } else {
                    this._seqeHead._seqePrev = null;
                }
                --this._iNumEvents;
                if (scanEventQueueEntry._iEventType == 0) {
                    --this._iDataEvents;
                } else if (scanEventQueueEntry._iEventType == 2) {
                    --this._iErrorEvents;
                }
            }
        }
        JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[0]);
        return scanEventQueueEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void Clear() {
        ScanEventQueue scanEventQueue = this;
        synchronized (scanEventQueue) {
            while (this.RemoveHead() != null) {
            }
        }
    }
}

