/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.jpos.service.scanner;

import com.zebra.log.scanner.JCoreLogger;
import com.zebra.log.scanner.JCoreLoggerProperty;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import jpos.JposException;
import jpos.Scanner;

public class ScannerCimPropertyLogger {
    private static JCoreLoggerProperty loggerProperty;
    private static boolean cimLogEnabled;
    private static boolean cimLogFileCreated;
    private static final String CIM_LOG_FILE_PATH = "/var/log/zebra-scanner/jpos/jpos_cim_properties.log";
    private static Scanner scannerObj;
    private static String controlVersion;

    private ScannerCimPropertyLogger() {
    }

    private static void createCimPropertyLogFile() {
        try {
            File file = new File(CIM_LOG_FILE_PATH);
            file.createNewFile();
            cimLogFileCreated = true;
        }
        catch (IOException iOException) {
            try {
                JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)("createCimPropertyLogFile() : Failed to create CIM property log file : " + iOException.getMessage()));
            }
            catch (JposException jposException) {
                // empty catch block
            }
        }
    }

    public static void logPowerStateControlServiceVersion(int n, int n2) {
        if (cimLogEnabled && cimLogFileCreated) {
            try {
                String string = Integer.toString(n2 / 1000);
                string = string.replace("0", ".") + ".0";
                FileWriter fileWriter = new FileWriter(CIM_LOG_FILE_PATH);
                fileWriter.write(n + ":" + controlVersion + ":" + string);
                fileWriter.close();
            }
            catch (IOException iOException) {
                try {
                    JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)("logPowerStateControlServiceVersion() : Failed to log CIM properties : " + iOException.getMessage()));
                }
                catch (JposException jposException) {
                    // empty catch block
                }
            }
        }
    }

    static {
        cimLogEnabled = false;
        cimLogFileCreated = false;
        loggerProperty = new JCoreLoggerProperty();
        if (loggerProperty.GetEnableCimPropertyFile() == 1) {
            cimLogEnabled = true;
            ScannerCimPropertyLogger.createCimPropertyLogFile();
            scannerObj = new Scanner();
            controlVersion = Integer.toString(scannerObj.getDeviceControlVersion() / 1000);
            controlVersion = controlVersion.replace("0", ".") + ".0";
        }
    }
}

