/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.jpos.service.scanner;

import com.zebra.jpos.service.scanner.ScannerService12Impl;
import com.zebra.jpos.service.scanner.USBScannerWin32;
import com.zebra.log.scanner.JCoreLogger;
import jpos.JposException;
import jpos.services.ScannerService13;

public abstract class ScannerService13Impl
extends ScannerService12Impl
implements ScannerService13 {
    public int getCapPowerReporting() throws JposException {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[0]);
        if (!this._fOpened) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_ERROR, (int)101, (String)"Service is not open");
        }
        JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[]{"getCapPowerReporting : " + _iCapPowerReporting});
        return _iCapPowerReporting;
    }

    public int getPowerNotify() throws JposException {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[0]);
        if (!this._fOpened) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_ERROR, (int)101, (String)"Service is not open");
        }
        JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[]{"getPowerNotify : " + this._iPowerNotify});
        return this._iPowerNotify;
    }

    public void setPowerNotify(int n) throws JposException {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        if (n != 1 && n != 0) {
            throw new JposException(106, "Invalid state");
        }
        if (!this._fOpened) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_ERROR, (int)101, (String)"Service is not open");
        } else if (this._seqEvents._fEnabled) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_ERROR, (int)106, (String)"Device is already enabled");
        } else if (_iCapPowerReporting == 0 && n != 0) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_ERROR, (int)106, (String)"Service does not support power notifications");
        } else {
            this._iPowerNotify = n;
            this._statusEvents.powNotificationEnabled = n == 1;
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)("setPowerNotify : " + (n == 1)));
        }
        JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[0]);
    }

    public int getPowerState() throws JposException {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[0]);
        if (this._iPowerNotify == 0 || !this._fClaimed || !this._seqEvents._fEnabled) {
            return 2000;
        }
        int n = 2004;
        if (this._scnDvc != null) {
            USBScannerWin32 uSBScannerWin32 = (USBScannerWin32)this._scnDvc;
            if (uSBScannerWin32.AllScanners != null && uSBScannerWin32.AllScanners.size() != 0) {
                n = 2001;
            }
        }
        JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[]{"getPowerState : " + this.getPowerStateText(n)});
        return n;
    }

    private String getPowerStateText(int n) {
        switch (n) {
            case 2001: {
                return "JPOS_PS_ONLINE";
            }
            case 2004: {
                return "JPOS_PS_OFF_OFFLINE";
            }
            case 2000: {
                return "JPOS_PS_UNKNOWN";
            }
        }
        return "";
    }
}

