/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.jpos.service.scanner;

import com.zebra.jpos.service.scanner.ScannerData;
import com.zebra.jpos.service.scanner.ScannerService17Impl;
import com.zebra.jpos.service.scanner.SymScannerSvc;
import com.zebra.jpos.service.scanner.USBScannerWin32;
import com.zebra.log.scanner.JCoreLogger;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import jpos.JposException;
import jpos.services.ScannerService18;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ScannerService18Impl
extends ScannerService17Impl
implements ScannerService18 {
    private static final String NEED_ALL_STATS = "";
    private static final String NEED_MANUFACTURE_DEFINED_STATS = "M_";
    private static final String NEED_UPOS_DEFINED_STATS = "U_";
    private static final String GOOD_SCAN_COUNT = "GoodScanCount";
    private static final DateFormat uposDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final File scannerJposJarPath = new File("/usr/lib/zebra-scanner/javapos/jpos/JposServiceScanner.jar");
    private static final int MODEL_NAME_RSM = 533;
    private static final int SERIAL_NO_RSM = 534;
    private static final int MANUFAC_DATE_RSM = 535;
    private static final int MECHAN_REV_RSM = 20013;
    private static final int FIRMWARE_VER_RSM = 20004;
    private static final int INSTALLATION_DATE_RSM = 614;
    private static final int GOOD_SCAN_COUNT_RSM = 15109;
    private static final int AUX_GOOD_SCAN_COUNT_RSM = 15107;
    private static final int DEVICE_CLASS_RSM = 20007;
    private static final int RESET_GIVEN_STAT_RSM = 5006;
    private static final String USB = "USB";
    private static final String SERIAL = "SERIAL";
    private static final String BT = "Bluetooth";
    private static final String CRADLE = "Cradle";
    private static int goodScanCount = 0;

    public boolean getCapStatisticsReporting() throws JposException {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[0]);
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"ScannerService18Impl:: getCapStatisticsReporting started.");
        if (!this._fOpened) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_ERROR, (int)101, (String)"ScannerService18Impl:: getCapStatisticsReporting Service is not open.");
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_ERROR, (int)101, (String)"Service is not open");
        }
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)("ScannerService18Impl:: getCapStatisticsReporting returns " + this._fCapStatsReporting));
        JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[]{this._fCapStatsReporting});
        return this._fCapStatsReporting;
    }

    public boolean getCapUpdateStatistics() throws JposException {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[0]);
        if (!this._fOpened) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_ERROR, (int)101, (String)"Service is not open");
        }
        JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[]{"getCapUpdateStatistics : " + this._fCapUpdateStats});
        return this._fCapUpdateStats;
    }

    public void resetStatistics(String string) throws JposException {
        String[] stringArray;
        String string2 = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string2, (boolean)false, (Object[])new Object[]{string});
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"Reset Statistics");
        if (!this._fCapUpdateStats) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_ERROR, (int)106, (String)"Statistics Reset not supported");
            JposException jposException = new JposException(106, "Statistics Reset not supported");
            JCoreLogger.Log((char)'*', (String)string2, (boolean)false, (Object[])new Object[]{jposException.getMessage()});
            throw jposException;
        }
        if (!this._fOpened) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_ERROR, (int)101, (String)"ScannerService18Impl:: updateStatistics Device is not open.");
            JposException jposException = new JposException(101, "Device not opened");
            JCoreLogger.Log((char)'*', (String)string2, (boolean)false, (Object[])new Object[]{jposException.getMessage()});
            throw jposException;
        }
        if (!this._fClaimed) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_ERROR, (int)103, (String)"ScannerService18Impl:: updateStatistics Device is not claimed.");
            JposException jposException = new JposException(103, "Device is not claimed");
            JCoreLogger.Log((char)'*', (String)string2, (boolean)false, (Object[])new Object[]{jposException.getMessage()});
            throw jposException;
        }
        if (this._iState == 107) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_ERROR, (int)107, (String)"ScannerService18Impl:: updateStatistics Device not connected.");
            JposException jposException = new JposException(107, "Device not connected");
            JCoreLogger.Log((char)'*', (String)string2, (boolean)false, (Object[])new Object[]{jposException.getMessage()});
            throw jposException;
        }
        if (!this._scnDvc.getEnabled()) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_ERROR, (int)105, (String)"ScannerService18Impl:: updateStatistics Device is disabled.");
            JposException jposException = new JposException(105, "Device is disabled");
            JCoreLogger.Log((char)'*', (String)string2, (boolean)false, (Object[])new Object[]{jposException.getMessage()});
            throw jposException;
        }
        if (this._scnDvc != null) {
            stringArray = (String[])this._scnDvc;
            if (stringArray.AllScanners.size() == 1 && ((ScannerData)stringArray.AllScanners.get((int)0)).scanType.equals(SymScannerSvc.VDIScanType)) {
                JposException jposException = new JposException(106, "ResetStatistics is not supported for VDI host mode");
                JCoreLogger.Log((char)'*', (String)string2, (boolean)false, (Object[])new Object[]{jposException.getMessage()});
                throw jposException;
            }
        }
        if (string.equals(NEED_ALL_STATS)) {
            this.resetGoodScanCountStatistic();
        } else {
            int n;
            stringArray = string.split(",");
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals(NEED_UPOS_DEFINED_STATS) || stringArray[n].equals(NEED_MANUFACTURE_DEFINED_STATS) || stringArray[n].equals(GOOD_SCAN_COUNT)) continue;
                JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_ERROR, (int)114, (String)"Failed to reset statistics");
                JposException jposException = new JposException(114, 280, "Failed to reset statistics");
                JCoreLogger.Log((char)'*', (String)string2, (boolean)false, (Object[])new Object[]{jposException.getMessage()});
                throw jposException;
            }
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals(NEED_UPOS_DEFINED_STATS)) {
                    this.resetGoodScanCountStatistic();
                    continue;
                }
                if (stringArray[n].equals(NEED_MANUFACTURE_DEFINED_STATS) || !stringArray[n].equals(GOOD_SCAN_COUNT)) continue;
                this.resetGoodScanCountStatistic();
            }
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"ScannerService18Impl:: resetStatistics completed.");
        }
        JCoreLogger.Log((char)'-', (String)string2, (boolean)false, (Object[])new Object[0]);
    }

    public void retrieveStatistics(String[] stringArray) throws JposException {
        Object object;
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])stringArray);
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"ScannerService18Impl:: retrieveStatistics started.");
        if (!this._fCapStatsReporting) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_ERROR, (int)106, (String)"ScannerService18Impl:: retrieveStatistics Statistics Reporting not supported.");
            JposException jposException = new JposException(106, "Statistics Reporting not supported");
            JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException.getMessage()});
            throw jposException;
        }
        if (stringArray.length != 1) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_ERROR, (int)106, (String)"ScannerService18Impl:: retrieveStatistics Invalid input parameters.");
            JposException jposException = new JposException(106, "Invalid input parameters");
            JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException.getMessage()});
            throw jposException;
        }
        if (!this._fOpened) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_ERROR, (int)101, (String)"ScannerService18Impl:: retrieveStatistics Device is not open.");
            JposException jposException = new JposException(101, "Device not opened");
            JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException.getMessage()});
            throw jposException;
        }
        if (!this._fClaimed) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_ERROR, (int)103, (String)"ScannerService18Impl:: retrieveStatistics Device is not claimed.");
            JposException jposException = new JposException(103, "Device is not claimed");
            JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException.getMessage()});
            throw jposException;
        }
        if (this._iState == 107) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_ERROR, (int)107, (String)"ScannerService18Impl:: retrieveStatistics Device not connected.");
            JposException jposException = new JposException(107, "Device not connected");
            JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException.getMessage()});
            throw jposException;
        }
        if (!this._scnDvc.getEnabled()) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_ERROR, (int)105, (String)"ScannerService18Impl:: retrieveStatistics Device is disabled.");
            JposException jposException = new JposException(105, "Device is disabled");
            JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException.getMessage()});
            throw jposException;
        }
        if (this._scnDvc != null) {
            object = (USBScannerWin32)this._scnDvc;
            if (((USBScannerWin32)object).AllScanners.size() == 1 && ((ScannerData)((USBScannerWin32)object).AllScanners.get((int)0)).scanType.equals(SymScannerSvc.VDIScanType)) {
                JposException jposException = new JposException(106, "RetrieveStatistics is not supported for VDI host mode");
                JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException.getMessage()});
                throw jposException;
            }
        }
        object = stringArray[0];
        stringArray[0] = NEED_ALL_STATS;
        stringArray[0] = this.createStatisticsXML((String)object);
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"Name: GoodScanCount");
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)("Value: " + goodScanCount));
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"ScannerService18Impl:: retrieveStatistics completed.");
        JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[0]);
    }

    public void updateStatistics(String string) throws JposException {
        String string2 = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string2, (boolean)false, (Object[])new Object[]{string});
        if (!this._fCapUpdateStats) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_ERROR, (int)106, (String)"Statistics Update not supported");
            JposException jposException = new JposException(106, "Statistics Update not supported");
            JCoreLogger.Log((char)'*', (String)string2, (boolean)false, (Object[])new Object[]{jposException.getMessage()});
            throw jposException;
        }
        JposException jposException = new JposException(111, "Failed to do Statistics Update in the device");
        JCoreLogger.Log((char)'*', (String)string2, (boolean)false, (Object[])new Object[]{jposException.getMessage()});
        throw jposException;
    }

    private String createStatisticsXML(String string) throws JposException {
        try {
            LinkedList<String> linkedList = new LinkedList<String>();
            StringWriter stringWriter = new StringWriter();
            XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
            XMLStreamWriter xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter(stringWriter);
            xMLStreamWriter.writeStartDocument();
            xMLStreamWriter.writeStartElement("UPOSStat");
            xMLStreamWriter.writeStartElement("Event");
            String[] stringArray = string.split(",");
            for (String string2 : stringArray) {
                if (!(string2.matches("^[a-zA-Z0-9]*$") || string2.equals(NEED_UPOS_DEFINED_STATS) || string2.equals(NEED_MANUFACTURE_DEFINED_STATS))) {
                    throw new JposException(2, "Invalid statistic");
                }
                if (string2.equals(NEED_ALL_STATS)) {
                    this.addGoodScanCountTag(xMLStreamWriter);
                    continue;
                }
                if (string2.equals(NEED_UPOS_DEFINED_STATS)) {
                    this.addGoodScanCountTag(xMLStreamWriter);
                    continue;
                }
                if (string2.equals(NEED_MANUFACTURE_DEFINED_STATS)) continue;
                linkedList.add(string2);
            }
            for (String string3 : linkedList) {
                if (string3.equals(GOOD_SCAN_COUNT)) {
                    this.addGoodScanCountTag(xMLStreamWriter);
                    continue;
                }
                this.addNonSupportedTag(xMLStreamWriter, string3);
            }
            xMLStreamWriter.writeEndElement();
            this.addStatEquipmentTag(xMLStreamWriter);
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.flush();
            xMLStreamWriter.close();
            String string4 = stringWriter.getBuffer().toString();
            stringWriter.close();
            return string4;
        }
        catch (XMLStreamException xMLStreamException) {
            throw new JposException(111, "XML Parser error");
        }
        catch (IOException iOException) {
            throw new JposException(111, "Unable to close the XML StringWriter");
        }
    }

    private void addGoodScanCountTag(XMLStreamWriter xMLStreamWriter) throws XMLStreamException, JposException {
        String string = "15109,15107,20007";
        int n = this.getTotalGoodScanCount(string);
        xMLStreamWriter.writeStartElement("Parameter");
        xMLStreamWriter.writeStartElement("Name");
        xMLStreamWriter.writeCharacters(GOOD_SCAN_COUNT);
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("Value");
        xMLStreamWriter.writeCharacters(String.valueOf(n));
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
    }

    private void addNonSupportedTag(XMLStreamWriter xMLStreamWriter, String string) throws XMLStreamException {
        xMLStreamWriter.writeStartElement("Parameter");
        xMLStreamWriter.writeStartElement("Name");
        xMLStreamWriter.writeCharacters(string);
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("Value");
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
    }

    private void addStatEquipmentTag(XMLStreamWriter xMLStreamWriter) throws JposException, XMLStreamException {
        xMLStreamWriter.writeStartElement("Equipment");
        xMLStreamWriter.writeStartElement("UnifiedPOSVersion");
        xMLStreamWriter.writeCharacters("1.14");
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("DeviceCategory");
        xMLStreamWriter.writeAttribute("UPOS", "Scanner");
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("ManufacturerName");
        xMLStreamWriter.writeCharacters("Zebra");
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("ModelName");
        xMLStreamWriter.writeCharacters(this.getRsmAttributeValues(533));
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("SerialNumber");
        xMLStreamWriter.writeCharacters(this.getRsmAttributeValues(534));
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("ManufactureDate");
        xMLStreamWriter.writeCharacters(this.getRsmAttributeValues(535));
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("MechanicalRevision");
        xMLStreamWriter.writeCharacters(this.getRsmAttributeValues(20013));
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("FirmwareRevision");
        xMLStreamWriter.writeCharacters(this.getRsmAttributeValues(20004));
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("Interface");
        xMLStreamWriter.writeCharacters(this.getScannerInterfaces());
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("InstallationDate");
        xMLStreamWriter.writeCharacters(this.getRsmAttributeValues(614));
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
    }

    private String getUposServiceVersionText(int n) {
        int n2 = n / 1000000;
        int n3 = (n - 1000000) / 1000;
        int n4 = (n - 1000000 - n3 * 1000) / 10;
        return n2 + "." + n3 + "." + n4;
    }

    private String getRsmAttributeValues(int n) {
        USBScannerWin32 uSBScannerWin32 = (USBScannerWin32)this._scnDvc;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 5001;
        int[] nArray = new int[]{-1};
        for (int i = 0; i < uSBScannerWin32.AllScanners.size(); ++i) {
            if (((ScannerData)uSBScannerWin32.AllScanners.get((int)i)).scanType.equals(SymScannerSvc.VDIScanType)) continue;
            StringBuffer stringBuffer = new StringBuffer();
            String string = ((ScannerData)uSBScannerWin32.AllScanners.get((int)i)).scanId;
            stringBuffer.append("<inArgs> <scannerID>" + string + "</scannerID> <cmdArgs>  <arg-xml>   <attrib_list>" + n + "</attrib_list>  </arg-xml> </cmdArgs></inArgs>");
            try {
                this.directIO(n2, nArray, stringBuffer);
                Map<String, String> map = this.getRsmValueFromOutXml(stringBuffer);
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(map.get(String.valueOf(n)));
                continue;
            }
            catch (JposException jposException) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(NEED_ALL_STATS);
            }
        }
        return stringBuilder.toString();
    }

    private int getTotalGoodScanCount(String string) throws JposException {
        USBScannerWin32 uSBScannerWin32 = (USBScannerWin32)this._scnDvc;
        int n = 0;
        int n2 = 5001;
        int[] nArray = new int[]{-1};
        for (int i = 0; i < uSBScannerWin32.AllScanners.size(); ++i) {
            if (((ScannerData)uSBScannerWin32.AllScanners.get((int)i)).scanType.equals(SymScannerSvc.VDIScanType)) continue;
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = ((ScannerData)uSBScannerWin32.AllScanners.get((int)i)).scanId;
            stringBuffer.append("<inArgs> <scannerID>" + string2 + "</scannerID> <cmdArgs>  <arg-xml>   <attrib_list>" + string + "</attrib_list>  </arg-xml> </cmdArgs></inArgs>");
            this.directIO(n2, nArray, stringBuffer);
            Map<String, String> map = this.getRsmValueFromOutXml(stringBuffer);
            try {
                if (map.containsKey(String.valueOf(15109))) {
                    n += Integer.parseInt(map.get(String.valueOf(15109)));
                }
                if (!map.containsKey(String.valueOf(15107))) continue;
                n -= Integer.parseInt(map.get(String.valueOf(15107)));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_ERROR, (int)111, (String)"Device doesn't support GoodScanCount");
            }
        }
        goodScanCount = n > 0 ? n : 0;
        return n;
    }

    private void resetGoodScanCountStatistic() throws JposException {
        USBScannerWin32 uSBScannerWin32 = (USBScannerWin32)this._scnDvc;
        int n = 5004;
        int[] nArray = new int[]{-1};
        for (int i = 0; i < uSBScannerWin32.AllScanners.size(); ++i) {
            if (((ScannerData)uSBScannerWin32.AllScanners.get((int)i)).scanType.equals(SymScannerSvc.VDIScanType)) continue;
            StringBuffer stringBuffer = new StringBuffer();
            String string = ((ScannerData)uSBScannerWin32.AllScanners.get((int)i)).scanId;
            stringBuffer.append("<inArgs> <scannerID>" + string + "</scannerID> <cmdArgs>  <arg-xml>   <attrib_list>     <attribute>       <id>" + 5006 + "</id>       <datatype>W</datatype>       <value>" + 15109 + "</value>     </attribute>     <attribute>       <id>" + 5006 + "</id>       <datatype>W</datatype>       <value>" + 15107 + "</value>     </attribute>   </attrib_list>  </arg-xml> </cmdArgs></inArgs>");
            try {
                this.directIO(n, nArray, stringBuffer);
                continue;
            }
            catch (JposException jposException) {
                JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_ERROR, (int)280, (String)"Failed to reset statistics");
                throw new JposException(280, "Failed to reset statistics");
            }
        }
    }

    private String getScannerInterfaces() {
        USBScannerWin32 uSBScannerWin32 = (USBScannerWin32)this._scnDvc;
        StringBuilder stringBuilder = new StringBuilder();
        int n = 1;
        int[] nArray = new int[]{-1};
        for (int i = 0; i < uSBScannerWin32.AllScanners.size(); ++i) {
            if (((ScannerData)uSBScannerWin32.AllScanners.get((int)i)).scanType.equals(SymScannerSvc.VDIScanType)) continue;
            StringBuffer stringBuffer = new StringBuffer();
            try {
                this.directIO(n, nArray, stringBuffer);
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                InputSource inputSource = new InputSource();
                inputSource.setCharacterStream(new StringReader(stringBuffer.toString()));
                Document document = documentBuilder.parse(inputSource);
                NodeList nodeList = document.getElementsByTagName("scanner");
                for (int j = 0; j < nodeList.getLength(); ++j) {
                    Element element = (Element)nodeList.item(j);
                    String string = element.getAttribute("type");
                    if (string.equals("USBIBMHID") || string.equals("USBIBMTT") || string.equals("SNAPI") || string.equals("USBOPOS")) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(",");
                        }
                        stringBuilder.append(USB);
                        continue;
                    }
                    if (string.equals("NIXMODB") || string.equals("SSI_SERIAL")) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(",");
                        }
                        stringBuilder.append(SERIAL);
                        continue;
                    }
                    if (!string.equals("SSI_BT")) continue;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(BT);
                }
                continue;
            }
            catch (JposException jposException) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(NEED_ALL_STATS);
                continue;
            }
            catch (Exception exception) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(NEED_ALL_STATS);
            }
        }
        return stringBuilder.toString();
    }

    private Map<String, String> getRsmValueFromOutXml(StringBuffer stringBuffer) throws JposException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource();
            inputSource.setCharacterStream(new StringReader(stringBuffer.toString()));
            Document document = documentBuilder.parse(inputSource);
            document.getDocumentElement().normalize();
            XPath xPath = XPathFactory.newInstance().newXPath();
            String string = "/outArgs/arg-xml/response/attrib_list/attribute";
            NodeList nodeList = (NodeList)xPath.compile(string).evaluate(document, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                String string2 = element.getElementsByTagName("id").item(0).getTextContent();
                String string3 = element.getElementsByTagName("value").item(0).getTextContent();
                hashMap.put(string2, string3);
            }
            return hashMap;
        }
        catch (Exception exception) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_ERROR, (int)111, (String)"Failed to pass the XML");
            return hashMap;
        }
    }

    private static String join(String string, String[] stringArray) {
        if (stringArray == null || stringArray.length <= 0) {
            return NEED_ALL_STATS;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
            if (i == stringArray.length - 1) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }
}

