/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.jpos.service.scanner;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ScannerSettings {
    public int propID;
    public String propVal;
    public String propType;
    public String propDesc;
    public String propName;
    public String defaultValue;
    public static Map paramGroups = new HashMap();
    public static final String SCANNER_ATTRIB_DEF_FILE = "rsm-id.xml";
    public static final String WIN_RESOURCES_FILE_PATH = "C:\\Program Files\\Zebra Technologies\\Barcode Scanners\\Scanner SDK\\JPOS\\bin\\";
    public static final String LINUX_RESOURCES_FILE_PATH = "/usr/share/zebra-scanner/javapos/config/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LoadSettings(String string) throws Exception {
        InputStream inputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException sAXParseException) throws SAXException {
                    sAXParseException.printStackTrace();
                }

                @Override
                public void fatalError(SAXParseException sAXParseException) throws SAXException {
                    sAXParseException.printStackTrace();
                }

                @Override
                public void warning(SAXParseException sAXParseException) throws SAXException {
                    sAXParseException.printStackTrace();
                }
            });
            String string2 = System.getProperty("os.name");
            inputStream = string2.toLowerCase().startsWith("win") ? new FileInputStream(WIN_RESOURCES_FILE_PATH + string) : new FileInputStream(LINUX_RESOURCES_FILE_PATH + string);
            filterInputStream = new DataInputStream(inputStream);
            String string3 = "";
            StringBuffer stringBuffer = new StringBuffer();
            while ((string3 = ((DataInputStream)filterInputStream).readLine()) != null) {
                stringBuffer.append(string3);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stringBuffer.toString().getBytes());
            Document document = documentBuilder.parse(byteArrayInputStream);
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("RsmConfigEntries");
            paramGroups.clear();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                NodeList nodeList2 = node.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node2 = nodeList2.item(j);
                    if (node2.getNodeType() != 1) continue;
                    Element element = (Element)node2;
                    String string4 = element.getAttribute("name");
                    String[] stringArray = string4.split(",");
                    for (int k = 0; k < stringArray.length; ++k) {
                        HashMap<String, ScannerSettings> hashMap = new HashMap<String, ScannerSettings>();
                        NodeList nodeList3 = node2.getChildNodes();
                        for (int i2 = 0; i2 < nodeList3.getLength(); ++i2) {
                            Node node3 = nodeList3.item(i2);
                            if (node3.getNodeType() != 1) continue;
                            ScannerSettings scannerSettings = new ScannerSettings();
                            Element element2 = (Element)node3;
                            scannerSettings.propName = element2.getAttribute("name");
                            scannerSettings.propType = element2.getAttribute("type");
                            scannerSettings.propID = Integer.parseInt(element2.getAttribute("id"));
                            scannerSettings.defaultValue = element2.getAttribute("default_value");
                            hashMap.put(scannerSettings.propName, scannerSettings);
                        }
                        paramGroups.put(stringArray[k].toUpperCase(), hashMap);
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        finally {
            filterInputStream.close();
            inputStream.close();
        }
    }
}

