/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.jpos.service.scanner;

import com.zebra.jpos.service.scanner.ScannerCimPropertyLogger;
import com.zebra.jpos.service.scanner.ScannerStatusEventQueueEntry;
import com.zebra.jpos.service.scanner.ScannerStatusEventSink;
import com.zebra.log.scanner.JCoreLogger;
import jpos.events.JposEvent;
import jpos.events.StatusUpdateEvent;

public class ScannerStatusEventQueue
extends Thread {
    protected boolean stopThread = true;
    private ScannerStatusEventSink statusEventSink;
    protected boolean powNotificationEnabled;
    protected boolean deviceEnabled;
    protected boolean deviceClaimed;
    private ScannerStatusEventQueueEntry eventSeqHead;
    private ScannerStatusEventQueueEntry eventSeqTail;
    protected int numEvents;
    protected int pnpStatusEvents;

    protected ScannerStatusEventQueue(ScannerStatusEventSink scannerStatusEventSink) {
        this.statusEventSink = scannerStatusEventSink;
        this.powNotificationEnabled = false;
        this.deviceEnabled = false;
        this.eventSeqHead = null;
        this.eventSeqTail = null;
        this.numEvents = 0;
        this.pnpStatusEvents = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!this.stopThread) {
                ScannerStatusEventQueue scannerStatusEventQueue = this;
                synchronized (scannerStatusEventQueue) {
                    this.wait(100L);
                }
                ScannerStatusEventQueueEntry scannerStatusEventQueueEntry = this.eventSeqHead;
                if (!this.powNotificationEnabled || scannerStatusEventQueueEntry == null) continue;
                this.RemoveHead();
                this.statusEventSink.PowerNotificationEventHandler(scannerStatusEventQueueEntry);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void AddTail(Object object, int n) {
        ScannerStatusEventQueue scannerStatusEventQueue;
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[]{object, n});
        if (!this.powNotificationEnabled || !this.deviceClaimed) {
            JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[0]);
            return;
        }
        ScannerStatusEventQueueEntry scannerStatusEventQueueEntry = null;
        if (n == 0) {
            if (this.deviceEnabled) {
                scannerStatusEventQueue = new StatusUpdateEvent(object, 2001);
                scannerStatusEventQueueEntry = new ScannerStatusEventQueueEntry((JposEvent)scannerStatusEventQueue, 3, 2001);
                ScannerCimPropertyLogger.logPowerStateControlServiceVersion(2001, 1012000);
            }
        } else if (n == 1 && this.deviceEnabled) {
            scannerStatusEventQueue = new StatusUpdateEvent(object, 2004);
            scannerStatusEventQueueEntry = new ScannerStatusEventQueueEntry((JposEvent)scannerStatusEventQueue, 3, 2004);
            ScannerCimPropertyLogger.logPowerStateControlServiceVersion(2004, 1012000);
        }
        scannerStatusEventQueue = this;
        synchronized (scannerStatusEventQueue) {
            if (scannerStatusEventQueueEntry != null) {
                scannerStatusEventQueueEntry.entrySeqNext = null;
                if (this.eventSeqTail == null) {
                    this.eventSeqHead = scannerStatusEventQueueEntry;
                    scannerStatusEventQueueEntry.entrySeqPrevious = null;
                } else {
                    scannerStatusEventQueueEntry.entrySeqPrevious = this.eventSeqTail;
                    this.eventSeqTail.entrySeqNext = scannerStatusEventQueueEntry;
                }
                this.eventSeqTail = scannerStatusEventQueueEntry;
                ++this.numEvents;
                if (scannerStatusEventQueueEntry.eventType == 3) {
                    ++this.pnpStatusEvents;
                }
            }
        }
        JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScannerStatusEventQueueEntry RemoveHead() {
        ScannerStatusEventQueueEntry scannerStatusEventQueueEntry;
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[0]);
        ScannerStatusEventQueue scannerStatusEventQueue = this;
        synchronized (scannerStatusEventQueue) {
            scannerStatusEventQueueEntry = this.eventSeqHead;
            if (scannerStatusEventQueueEntry != null) {
                this.eventSeqHead = scannerStatusEventQueueEntry.entrySeqNext;
                scannerStatusEventQueueEntry.entrySeqNext = null;
                if (this.eventSeqHead == null) {
                    this.eventSeqTail = null;
                } else {
                    this.eventSeqHead.entrySeqPrevious = null;
                }
                --this.numEvents;
                if (scannerStatusEventQueueEntry.eventType == 3) {
                    --this.pnpStatusEvents;
                }
            }
        }
        JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[]{"ScannerStatusEventQueueEntry", " powState=" + this.getPowerStateText(scannerStatusEventQueueEntry.powState), " eventType=" + scannerStatusEventQueueEntry.eventType});
        return scannerStatusEventQueueEntry;
    }

    private String getPowerStateText(int n) {
        switch (n) {
            case 2001: {
                return "JPOS_PS_ONLINE";
            }
            case 2004: {
                return "JPOS_PS_OFF_OFFLINE";
            }
            case 2000: {
                return "JPOS_PS_UNKNOWN";
            }
        }
        return "";
    }
}

