/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.jpos.service.scanner;

import com.zebra.jpos.jniscanner.ArgStruct;
import com.zebra.jpos.jniscanner.EvtStruct;
import com.zebra.jpos.jniscanner.GetScannerArgStruct;
import com.zebra.jpos.jniscanner.JCoreScanner;
import com.zebra.jpos.jniscanner.OpenArgStruct;
import com.zebra.jpos.service.scanner.ScanEventQueue;
import com.zebra.jpos.service.scanner.ScanEventQueueEntry;
import com.zebra.jpos.service.scanner.ScanEventSink;
import com.zebra.jpos.service.scanner.ScannerBarcodeType;
import com.zebra.jpos.service.scanner.ScannerCimPropertyLogger;
import com.zebra.jpos.service.scanner.ScannerConfig;
import com.zebra.jpos.service.scanner.ScannerData;
import com.zebra.jpos.service.scanner.ScannerDirectIOEventQueue;
import com.zebra.jpos.service.scanner.ScannerDirectIOEventQueueEntry;
import com.zebra.jpos.service.scanner.ScannerDirectIOEventSink;
import com.zebra.jpos.service.scanner.ScannerDvc;
import com.zebra.jpos.service.scanner.ScannerLabelIdData;
import com.zebra.jpos.service.scanner.ScannerSettings;
import com.zebra.jpos.service.scanner.ScannerStatusEventQueue;
import com.zebra.jpos.service.scanner.ScannerStatusEventQueueEntry;
import com.zebra.jpos.service.scanner.ScannerStatusEventSink;
import com.zebra.jpos.service.scanner.USBScannerWin32;
import com.zebra.jpos.serviceonscanner.SvcDirectIO;
import com.zebra.jpos.serviceonscanner.directio.DirectIOData;
import com.zebra.log.scale.JCoreLogger;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import jpos.JposConst;
import jpos.JposException;
import jpos.config.JposEntry;
import jpos.events.DataEvent;
import jpos.events.DirectIOEvent;
import jpos.events.ErrorEvent;
import jpos.events.StatusUpdateEvent;
import jpos.loader.JposServiceLoader;
import jpos.services.EventCallbacks;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SymScannerSvc
implements JposConst,
ScanEventSink,
ScannerStatusEventSink,
ScannerDirectIOEventSink {
    public static final String JPOS_XML_SCANNER_TYPE_ALL = "ALL";
    public static final String JPOS_XML_SCANNER_TYPE_UNKNOWN = "0";
    public static final String JPOS_XML_SCANNER_TYPE_IBMTT = "USBIBMTT";
    public static final String JPOS_XML_SCANNER_TYPE_IBMHID_1 = "USBIBMHID";
    public static final String JPOS_XML_SCANNER_TYPE_IBMHID_2 = "USBIBMHID";
    public static final String JPOS_XML_SCANNER_TYPE_SNAPI = "SNAPI";
    public static final String JPOS_XML_SCANNER_TYPE_SSI = "SSI_SERIAL";
    public static final String JPOS_XML_SCANNER_TYPE_USB_OPOS = "USBOPOS";
    public static final String JPOS_XML_SCANNER_TYPE_NIXMODB = "NIXMODB";
    public static final String JPOS_XML_SCANNER_TYPE_SSI_BT = "SSI_BT";
    public static final String JPOS_XML_SCANNER_TYPE_VDI = "VDI";
    public static final String JPOS_XML_SCANNER_MODEL = "ScannerModel";
    public static final String JPOS_XML_SCANNER_SERIAL = "SerialNumber";
    public static final String JPOS_XML_EXCLUSIVE_CLAIM_LEVEL = "ExclusiveClaimLevel";
    public static final String NCR_SCAN_NOF_PATTERN = "NcrScanNOFPattern";
    public static final String NCR_BEEP_ONCE_TONE_PATTERN = "NcrBeepOnceScanTonePattern";
    public static final String NCR_ENABLE_BEEP_TONE_PATTERN = "NcrEnableBeepScanTonePattern";
    public static final String NCR_DISABLE_BEEP_TONE_PATTERN = "NcrDisableBeepScanTonePattern";
    public static final String DIO_SCANNER_NOT_ON_FILE = "DioScannerNotOnFile";
    public static final String DIO_SCANNER_DIO_NOF = "DioScannerDioNof";
    public static final String SCAN_DATA_LABEL_ID = "ScanDataLabelId";
    public static final String BEEP_ON_VDI_EVENT = "BeepOnVDIEvent";
    public static final String JPOS_XML_REPORT_MISSING_SCANNERS_ON_ENABLE = "ReportMissingScannersOnEnable";
    public static final String JPOS_XML_CLEAR_QUEUE_ON_RELEASE = "ClearQueueOnRelease";
    public static final int IBM_LABEL = 0;
    public static final int NCR_LABEL = 1;
    public static final int NO_LABEL = 2;
    public static final int NCR_1D_ONLY = 3;
    public static final int NCR_2D_ONLY = 4;
    public static final int ZEBRA_LABEL = 9999;
    public static final int ENABLE_BEEP = 1002;
    public static final int DISABLE_BEEP = 1003;
    public static final int BEEP_ONCE = 1001;
    protected static int REBOOT_TIMEOUT = 30000;
    public static final String RESET_TIMEOUT = "ResetTimeout";
    protected static int STATUS_SUCCESS = 0;
    protected static int STATUS_FAILURE = 1;
    protected static int beepOnVDIEvent = 0;
    protected static String VDIScanID = "";
    protected static String VDIScaleID = "";
    protected static boolean VDIScaleSeen = false;
    protected static String VDIScanType = "VDI";
    protected static final int _iServiceVer = 1012000;
    protected boolean _fClaimed = false;
    protected boolean _fAutoDisable = false;
    protected boolean _fCapCompareFWVer = false;
    protected boolean _fCapStatsReporting = true;
    protected boolean _fCapUpdateFW = false;
    protected boolean _fCapUpdateStats = false;
    protected boolean _fDecodeData = false;
    protected boolean _fDeviceOwner = false;
    protected boolean _fDeviceOwnerAvailable = false;
    protected boolean _fOpened = false;
    protected String _strHealthText = "";
    protected String physicalDeviceDescription = null;
    protected String physicalDeviceName = null;
    protected String _strServiceDesc = "UnifiedPOS Compatible Serial/USB Scanner Service Driver, \u00a9 2024 Zebra Technologies Corp. and/or its affiliates. All rights reserved. ";
    protected byte[] _abScanData = new byte[0];
    protected byte[] _abScanDataLabel = new byte[0];
    protected int _iState = 1;
    protected static int _iCapPowerReporting = 0;
    protected int _iPowerNotify = 0;
    protected int _iScanDataType = 0;
    protected int _iScanZebraSymbologyType = 0;
    protected ScanEventQueue _seqEvents = null;
    protected ScannerStatusEventQueue _statusEvents = null;
    protected ScannerDirectIOEventQueue _directIOEvents = null;
    protected JposEntry _jpe = null;
    protected EventCallbacks _ecbs = null;
    protected ScannerDvc _scnDvc = null;
    protected ScannerConfig _scnCfg = null;
    private Set<ScannerSettings> _configProp = null;
    protected static Map<ScannerData, Boolean> scannerUFList = new HashMap<ScannerData, Boolean>();
    private int ncrScanNOFPattern = 7;
    private int ncrScanBeepOnceTonePattern = 10;
    private int ncrScanEnableBeepTonePattern = 10;
    private int ncrScanDisableBeepTonePattern = 10;
    private int dioScannerNotOnFile = 7;
    private int dioScannerDioNof = 7;
    private int clearScannerQueueOnRelease = 0;
    private int VDIScanBeepPattern = 10;
    private int scanDataLabelId = 9999;
    private int healthCheckBeepPattern = 12;
    byte deviceEnableDisableFlag = (byte)2;
    int goodScanCount = 0;
    ScannerLabelIdData[] scannerLblIdDataList = new ScannerLabelIdData[14];
    Thread t;
    private EvtStruct argStruct;
    JTextField scanDataTxt;
    JTextField scanDataTypeTxt;
    JButton yesBtn;
    JButton noBtn;

    public SymScannerSvc() {
        this._seqEvents = new ScanEventQueue(this);
        this._statusEvents = new ScannerStatusEventQueue(this);
        this._directIOEvents = new ScannerDirectIOEventQueue(this);
        this._scnCfg = new ScannerConfig("COM1:", 9600, 8, 1, 1);
        this._configProp = new HashSet<ScannerSettings>();
        this.loadScannerDataLblDataList();
        this.argStruct = new EvtStruct();
    }

    public String getCheckHealthText() throws JposException {
        if (!this._fOpened) {
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)101, (String)"Service is not open");
        }
        if (!this._strHealthText.isEmpty()) {
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_NOTICE, (int)0, (String)("CheckHealth: " + this._strHealthText));
        }
        return this._strHealthText;
    }

    public boolean getClaimed() throws JposException {
        com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_NOTICE, (int)0, (String)("scannner.getClaimed : " + this._fClaimed));
        if (!this._fOpened) {
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)101, (String)"Service is not open");
        }
        return this._fClaimed;
    }

    public boolean getDeviceEnabled() throws JposException {
        com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_NOTICE, (int)0, (String)"getDeviceEnabled");
        if (!this._fOpened) {
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)101, (String)"Service is not open");
        }
        return this._seqEvents._fEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeviceEnabled(boolean bl) throws JposException {
        com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_NOTICE, (int)0, (String)("setDeviceEnabled fEnable:" + bl));
        if (!this._fOpened) {
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)101, (String)"Service is not open");
        } else if (!this._fDeviceOwner) {
            if (!this._fClaimed) {
                com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)103, (String)"Device is not claimed");
            } else {
                com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)102, (String)"Device is already claimed by another control instance");
            }
        }
        ScanEventQueue scanEventQueue = this._seqEvents;
        synchronized (scanEventQueue) {
            if (this._scnDvc != null) {
                com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_NOTICE, (int)0, (String)"_scnDvc is not null");
                if (bl) {
                    if (this._scnDvc.setEnabled(bl)) {
                        this._seqEvents._fEnabled = bl;
                        this._statusEvents.deviceEnabled = bl;
                        this._statusEvents.AddTail(this._ecbs.getEventSource(), 0);
                        this._directIOEvents.deviceEnabled = bl;
                    }
                } else if (this._scnDvc.setEnabled(bl)) {
                    this._seqEvents._fEnabled = bl;
                    this._statusEvents.deviceEnabled = bl;
                    int n = 2004;
                    ScannerCimPropertyLogger.logPowerStateControlServiceVersion(n, 1012000);
                    this._directIOEvents.deviceEnabled = bl;
                }
            } else {
                com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_NOTICE, (int)0, (String)"_scnDvc is null");
            }
        }
    }

    public String getDeviceServiceDescription() throws JposException {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        com.zebra.log.scanner.JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[]{"getDeviceServiceDescription : " + this._strServiceDesc});
        if (!this._fOpened) {
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)101, (String)"Service is not open");
        }
        return this._strServiceDesc;
    }

    public int getDeviceServiceVersion() throws JposException {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        com.zebra.log.scanner.JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[]{"getDeviceServiceVersion : 1012000"});
        if (!this._fOpened) {
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)101, (String)"Service is not open");
        }
        return 1012000;
    }

    public boolean getFreezeEvents() throws JposException {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        com.zebra.log.scanner.JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[]{"getFreezeEvents : " + this._seqEvents._fFreezeEvents});
        if (!this._fOpened) {
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)101, (String)"Service is not open");
        }
        return this._seqEvents._fFreezeEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFreezeEvents(boolean bl) throws JposException {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        com.zebra.log.scanner.JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[]{"setFreezeEvents : " + bl});
        if (!this._fOpened) {
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)101, (String)"Service is not open");
        }
        ScanEventQueue scanEventQueue = this._seqEvents;
        synchronized (scanEventQueue) {
            if (bl != this._seqEvents._fFreezeEvents) {
                this._seqEvents._fFreezeEvents = bl;
                this._seqEvents.notify();
            }
        }
    }

    public String getPhysicalDeviceDescription() throws JposException {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        com.zebra.log.scanner.JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[]{"getPhysicalDeviceDescription : " + this.physicalDeviceDescription});
        if (!this._fOpened) {
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)101, (String)"Service is not open");
        }
        return this.physicalDeviceDescription;
    }

    public String getPhysicalDeviceName() throws JposException {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        com.zebra.log.scanner.JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[]{"getPhysicalDeviceName : " + this.physicalDeviceName});
        if (!this._fOpened) {
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)101, (String)"Service is not open");
        }
        return this.physicalDeviceName;
    }

    public int getState() throws JposException {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        com.zebra.log.scanner.JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[]{"getState : " + this._iState});
        return this._iState;
    }

    public void checkHealth(int n) throws JposException {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        if (!this._fOpened) {
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)101, (String)"Service is not open");
            throw new JposException(101, "Device is closed");
        }
        if (!this._fDeviceOwner) {
            if (!this._fClaimed) {
                this._strHealthText = "Device Not claimed";
                com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)103, (String)"Device is not claimed");
                throw new JposException(103, "Device is not claimed");
            }
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)101, (String)"Service is not open");
            throw new JposException(103, "Service is not open");
        }
        if (!this._fClaimed) {
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)102, (String)"Device is not claimed");
            throw new JposException(103, "Device is not claimed");
        }
        if (!this._seqEvents._fEnabled) {
            this._strHealthText = "Device Not Enabled";
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)105, (String)"Device is not enabled");
            throw new JposException(105, "Device is disabled.");
        }
        if (!this.findScanner()) {
            this._strHealthText = "No Hardware";
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)107, (String)"No Device Detected");
            throw new JposException(107, "No Device Detected.");
        }
        if (n == 1) {
            this._strHealthText = "Internal HCheck: Successful";
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_NOTICE, (int)0, (String)"CheckHealth: Internal HCheck: Successful");
        } else if (n == 2) {
            Object object;
            if (this._scnDvc != null) {
                object = (USBScannerWin32)this._scnDvc;
                if (object.AllScanners.size() == 1 && ((ScannerData)object.AllScanners.get((int)0)).scanType.equals(VDIScanType)) {
                    JposException jposException = new JposException(106, "External Health Check is not supported for VDI host mode");
                    com.zebra.log.scanner.JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException.getMessage()});
                    throw jposException;
                }
            }
            object = new int[1];
            this.executeNcrBeepCommnad(this.healthCheckBeepPattern, (int[])object);
            if (object[0] == 0 && this.isExternalHealthCheckSuccess()) {
                this._strHealthText = "External HCheck: Successful";
                com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_NOTICE, (int)0, (String)"CheckHealth: External HCheck: Successful");
            } else {
                this._strHealthText = "External HCheck: Failed";
                com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)0, (String)"CheckHealth: External HCheck: failed");
            }
        } else if (n == 3) {
            ScanEventQueue.isHealthCheck = true;
            this.showInteractiveHealthcheckPopup();
        } else {
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)106, (String)"Health check level not supported");
            throw new JposException(106, "Health check level not supported");
        }
    }

    private boolean findScanner() {
        if (this._scnDvc != null) {
            USBScannerWin32 uSBScannerWin32 = (USBScannerWin32)this._scnDvc;
            return uSBScannerWin32.AllScanners != null && !uSBScannerWin32.AllScanners.isEmpty();
        }
        return false;
    }

    private boolean isExternalHealthCheckSuccess() {
        USBScannerWin32 uSBScannerWin32 = (USBScannerWin32)this._scnDvc;
        int n = 5001;
        int[] nArray = new int[]{-1};
        for (int i = 0; i < uSBScannerWin32.AllScanners.size(); ++i) {
            if (((ScannerData)uSBScannerWin32.AllScanners.get((int)i)).scanType.equals(VDIScanType)) continue;
            StringBuffer stringBuffer = new StringBuffer();
            String string = ((ScannerData)uSBScannerWin32.AllScanners.get((int)i)).scanId;
            stringBuffer.append("<inArgs> <scannerID>" + string + "</scannerID> <cmdArgs>  <arg-xml>   <attrib_list>8</attrib_list>  </arg-xml> </cmdArgs></inArgs>");
            try {
                this.directIO(n, nArray, stringBuffer);
            }
            catch (JposException jposException) {
                return false;
            }
            if (nArray[0] == 0) continue;
            return false;
        }
        return nArray[0] == 0;
    }

    private void showInteractiveHealthcheckPopup() {
        final JDialog jDialog = new JDialog(null, "Interactive Health Check", Dialog.ModalityType.APPLICATION_MODAL);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        this.scanDataTxt = new JTextField();
        this.scanDataTypeTxt = new JTextField();
        this.noBtn = new JButton();
        JLabel jLabel4 = new JLabel();
        this.yesBtn = new JButton();
        JButton jButton = new JButton();
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        jLabel.setText("To perform the health check, scan any barcode");
        jLabel2.setText("Scan Data:");
        jLabel3.setText("Scan Data Type:");
        this.scanDataTxt.setEditable(false);
        this.scanDataTxt.setForeground(Color.BLACK);
        this.scanDataTypeTxt.setEditable(false);
        this.scanDataTypeTxt.setForeground(Color.BLACK);
        this.noBtn.setText("No");
        this.noBtn.setEnabled(false);
        this.noBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    SymScannerSvc.this._strHealthText = "Interactive HCheck: Failed";
                    ScanEventQueue cfr_ignored_0 = SymScannerSvc.this._seqEvents;
                    ScanEventQueue.isHealthCheck = false;
                    com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)0, (String)"CheckHealth: Interactive HCheck: failed");
                    jDialog.dispose();
                }
                catch (JposException jposException) {
                    Logger.getLogger(SymScannerSvc.class.getName()).log(Level.SEVERE, null, jposException);
                }
            }
        });
        jLabel4.setText("Do you see the correct decode data and scan data type?");
        this.yesBtn.setText("Yes");
        this.yesBtn.setEnabled(false);
        this.yesBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    SymScannerSvc.this._strHealthText = "Interactive HCheck: Successful";
                    ScanEventQueue cfr_ignored_0 = SymScannerSvc.this._seqEvents;
                    ScanEventQueue.isHealthCheck = false;
                    com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_NOTICE, (int)0, (String)"CheckHealth: Interactive HCheck: Successful");
                    jDialog.dispose();
                }
                catch (JposException jposException) {
                    Logger.getLogger(SymScannerSvc.class.getName()).log(Level.SEVERE, null, jposException);
                }
            }
        });
        jButton.setText("Cancel");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SymScannerSvc.this._strHealthText = "";
                ScanEventQueue cfr_ignored_0 = SymScannerSvc.this._seqEvents;
                ScanEventQueue.isHealthCheck = false;
                jDialog.dispose();
            }
        });
        GroupLayout groupLayout = new GroupLayout(jPanel2);
        jPanel2.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel).addComponent(jLabel4)).addGap(0, 106, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel3).addComponent(jLabel2)).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scanDataTxt).addComponent(this.scanDataTypeTxt))).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.yesBtn, -2, 76, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.noBtn, -2, 76, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jButton, -2, 76, -2))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(jLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.scanDataTypeTxt, -2, -1, -2).addComponent(jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel2).addComponent(this.scanDataTxt, -2, -1, -2)).addGap(18, 18, 18).addComponent(jLabel4).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jButton).addComponent(this.noBtn).addComponent(this.yesBtn)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout groupLayout2 = new GroupLayout(jPanel);
        jPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(jPanel2, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                super.windowClosing(windowEvent);
                SymScannerSvc.this._strHealthText = "";
                ScanEventQueue cfr_ignored_0 = SymScannerSvc.this._seqEvents;
                ScanEventQueue.isHealthCheck = false;
            }
        });
        jDialog.setSize(new Dimension(507, 219));
        jDialog.add(jPanel);
        jDialog.setLocationRelativeTo(null);
        jDialog.pack();
        jDialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void claim(int n) throws JposException {
        com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_NOTICE, (int)0, (String)"claim");
        if (this._fClaimed) {
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)102, (String)"Device is already claimed");
            throw new JposException(102, "Device is already claimed");
        }
        if (n < -1) {
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)106, (String)"Invalid timeout value");
        }
        ScanEventQueue scanEventQueue = this._seqEvents;
        synchronized (scanEventQueue) {
            if (!this._fOpened) {
                com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)101, (String)"Service is not open");
            }
            long l = System.currentTimeMillis();
            USBScannerWin32 uSBScannerWin32 = (USBScannerWin32)this._scnDvc;
            while (n == -1 || System.currentTimeMillis() - l <= (long)n) {
                if (this._scnDvc != null && this._scnDvc.open() && !uSBScannerWin32.AllScanners.isEmpty()) {
                    ArrayList<ScannerData> arrayList = uSBScannerWin32.getOpenedScannerList();
                    for (ScannerData scannerData : arrayList) {
                        if (!this._scnDvc.getSerialNumber().contains(scannerData.serialNumber)) continue;
                        if (scannerData.isNonExclusivelyClaimed() && (scannerData.getExclusiveClaimLevel() == 1 || this._scnCfg._jposXmlXclusivClaimLevel == 1)) {
                            for (ScannerData scannerData2 : arrayList) {
                                if (!uSBScannerWin32.jposXmlPropLogicalName.equals(scannerData2.getLogicalDeviceName())) continue;
                                scannerData2.setNonExclusivelyClaimed(false);
                                scannerData2.setExclusivelyClaimed(false);
                            }
                            this._fClaimed = false;
                            this._fDeviceOwner = false;
                            this._fDeviceOwnerAvailable = false;
                            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)101, (String)("Scanner SN:" + scannerData.serialNumber + " claimed by other instance"));
                            return;
                        }
                        if (scannerData.getExclusiveClaimLevel() == 1) {
                            if (scannerData.isExclusivelyClaimed()) {
                                for (ScannerData scannerData3 : arrayList) {
                                    if (!uSBScannerWin32.AllScanners.contains(scannerData3)) continue;
                                    scannerData3.setNonExclusivelyClaimed(false);
                                    scannerData3.setExclusivelyClaimed(false);
                                }
                                this._fClaimed = false;
                                this._fDeviceOwner = false;
                                this._fDeviceOwnerAvailable = false;
                                com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)101, (String)("Scanner SN:" + scannerData.serialNumber + " is exclusively claimed by other instance"));
                                return;
                            }
                            if (!uSBScannerWin32.jposXmlPropLogicalName.equals(scannerData.getLogicalDeviceName())) continue;
                            this._fClaimed = true;
                            this._fDeviceOwner = true;
                            this._fDeviceOwnerAvailable = true;
                            this._scnDvc.SetParam(this._configProp);
                            this._statusEvents.deviceClaimed = this._fClaimed;
                            this._directIOEvents.deviceClaimed = this._fClaimed;
                            scannerData.setExclusivelyClaimed(true);
                            scannerData.setNonExclusivelyClaimed(false);
                            continue;
                        }
                        this._fClaimed = true;
                        this._fDeviceOwner = true;
                        this._fDeviceOwnerAvailable = true;
                        this._scnDvc.SetParam(this._configProp);
                        this._statusEvents.deviceClaimed = this._fClaimed;
                        this._directIOEvents.deviceClaimed = this._fClaimed;
                        scannerData.setNonExclusivelyClaimed(true);
                    }
                    break;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (!this._fDeviceOwnerAvailable) {
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)112, (String)"Device has been claimed or does not exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JposException {
        com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_NOTICE, (int)0, (String)"Close");
        if (!this._fOpened) {
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)101, (String)"Service is not open");
        }
        Thread thread = this._statusEvents;
        synchronized (thread) {
            this._statusEvents.stopThread = true;
            this._statusEvents.notify();
        }
        thread = this._directIOEvents;
        synchronized (thread) {
            this._directIOEvents.stopThread = true;
            this._directIOEvents.notify();
        }
        thread = this._seqEvents;
        synchronized (thread) {
            this._seqEvents._fStopThread = true;
            this._seqEvents.notify();
            try {
                if (this._seqEvents._fEnabled) {
                    this.setDeviceEnabled(false);
                }
                if (this._fDeviceOwner) {
                    this.release();
                }
                if (this._scnDvc != null) {
                    this._scnDvc.close();
                    this._scnDvc = null;
                }
            }
            catch (JposException jposException) {
                // empty catch block
            }
            this._seqEvents.Clear();
            this._fOpened = false;
            this._iState = 1;
            int n = this.getPowerState();
            ScannerCimPropertyLogger.logPowerStateControlServiceVersion(n, 1012000);
        }
    }

    private int getPowerState() {
        int n = 2004;
        if (this._scnDvc != null) {
            USBScannerWin32 uSBScannerWin32 = (USBScannerWin32)this._scnDvc;
            if (uSBScannerWin32.AllScanners != null && uSBScannerWin32.AllScanners.size() != 0) {
                n = 2001;
            }
        }
        return n;
    }

    public void directIO(int n, int[] nArray, Object object) throws JposException {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        if (nArray == null || nArray.length == 0) {
            com.zebra.log.scanner.JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[]{n, object});
        } else {
            com.zebra.log.scanner.JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[]{n, nArray[0], object});
        }
        if (!this._fOpened) {
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)101, (String)"Service is not open");
        }
        if (this._scnDvc != null) {
            if (n == 501) {
                if (nArray[0] == 1002) {
                    this.executeNcrBeepCommnad(this.ncrScanEnableBeepTonePattern);
                } else if (nArray[0] == 1003) {
                    this.executeNcrBeepCommnad(this.ncrScanDisableBeepTonePattern);
                } else if (nArray[0] == 1001) {
                    this.executeNcrBeepCommnad(this.ncrScanBeepOnceTonePattern);
                }
            } else if (n == 508) {
                this.executeNcrBeepCommnad(this.ncrScanNOFPattern);
                if (this._seqEvents._fEnabled) {
                    this.setDeviceEnabled(false);
                }
            } else if (n == 4) {
                this.executeNcrBeepCommnad(this.dioScannerNotOnFile, nArray);
                if (this._seqEvents._fEnabled) {
                    this.setDeviceEnabled(false);
                }
            } else if (n == 12) {
                this.executeNcrBeepCommnad(this.dioScannerDioNof, nArray);
                if (this._seqEvents._fEnabled) {
                    this.setDeviceEnabled(false);
                }
            } else if (n == 502) {
                this.executeResetCommnad(nArray);
            } else if (n == 503) {
                byte[] byArray = new byte[]{4, 8, 1, 0};
                if (this._seqEvents._fEnabled) {
                    byArray[2] = (byte)(byArray[2] | this.deviceEnableDisableFlag);
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (byte by : byArray) {
                    stringBuilder.append(String.format("%02X ", by));
                }
                if (object instanceof StringBuffer) {
                    Object object2 = (StringBuffer)object;
                    ((StringBuffer)object2).append((CharSequence)stringBuilder);
                    object = object2;
                } else {
                    object = stringBuilder.toString();
                }
                nArray[0] = 0;
            } else if (n == 507) {
                if (object instanceof StringBuffer) {
                    int n2 = this.getElementValueFromXml(object.toString(), "/inArgs");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(this.removeElementFromXml(object.toString(), "/inArgs/opcode"));
                    ((StringBuffer)object).delete(0, ((StringBuffer)object).length()).append(stringBuffer);
                    SvcDirectIO.directIO((int)n2, (int[])nArray, (Object)object);
                    if (n2 == 5000 || n2 == 5001 || n2 == 5002) {
                        nArray[0] = 1;
                    } else if (n2 == 5004 || n2 == 5005) {
                        nArray[0] = 0;
                    }
                } else {
                    DirectIOData directIOData = (DirectIOData)object;
                    int n3 = this.getElementValueFromXml(directIOData.inXML, "/inArgs");
                    directIOData.inXML = this.removeElementFromXml(directIOData.inXML, "/inArgs/opcode");
                    object = directIOData;
                    SvcDirectIO.directIO((int)n3, (int[])nArray, (Object)object);
                    if (n3 == 5000 || n3 == 5001 || n3 == 5002) {
                        nArray[0] = 1;
                    } else if (n3 == 5004 || n3 == 5005) {
                        nArray[0] = 0;
                    }
                }
            } else {
                SvcDirectIO.directIO((int)n, (int[])nArray, (Object)object);
            }
            com.zebra.log.scanner.JCoreLogger.Log((char)'#', (String)string, (boolean)false, (Object[])new Object[]{"Calling Direct IO : " + this.directIOToString(n), object});
        }
        com.zebra.log.scanner.JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[0]);
    }

    private String directIOToString(int n) {
        switch (n) {
            case 1: {
                return "GET_SCANNERS";
            }
            case 5000: {
                return "RSM_ATTR_GETALL";
            }
            case 5001: {
                return "RSM_ATTR_GET";
            }
            case 5002: {
                return "RSM_ATTR_GETNEXT";
            }
            case 5004: {
                return "RSM_ATTR_SET";
            }
            case 5005: {
                return "RSM_ATTR_STORE";
            }
            case 508: {
                return "DIO_NCR_SCANNER_NOF";
            }
            case 501: {
                return "DIO_NCR_SCAN_TONE";
            }
            case 4: {
                return "DIO_SCANNER_NOT_ON_FILE";
            }
            case 12: {
                return "DIO_SCANNER_DIO_NOF";
            }
            case 502: {
                return "NCRDIO_SCAN_RESET";
            }
            case 503: {
                return "NCRDIO_SCAN_STATUS";
            }
            case 507: {
                return "NCRDIO_SCAN_DIRECT";
            }
            case 5200: {
                return "RETRIEVE_CRADLE_CONTACT_STATE_OF_HEALTH";
            }
            case 5500: {
                return "CMD_RTA_SUPPORTED_GET";
            }
            case 5501: {
                return "CMD_RTA_REGISTER";
            }
            case 5502: {
                return "CMD_RTA_UNREGISTER";
            }
            case 5503: {
                return "CMD_RTA_ALERT_STATUS_GET";
            }
            case 5504: {
                return "CMD_RTA_ALERT_STATUS_SET";
            }
            case 5505: {
                return "CMD_RTA_SUSPEND";
            }
            case 5506: {
                return "CMD_RTA_STATE";
            }
        }
        return "UNKNOWN_DIO";
    }

    private int getElementValueFromXml(String string, String string2) throws JposException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource();
            inputSource.setCharacterStream(new StringReader(string));
            Document document = documentBuilder.parse(inputSource);
            document.getDocumentElement().normalize();
            XPath xPath = XPathFactory.newInstance().newXPath();
            NodeList nodeList = (NodeList)xPath.compile(string2).evaluate(document, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                return Integer.parseInt(element.getElementsByTagName("opcode").item(0).getTextContent().trim());
            }
            throw new JposException(106, "Opcode not found in inXml");
        }
        catch (Exception exception) {
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)111, (String)"Failed to pass the XML");
            throw new JposException(106, "Failed to pass the XML");
        }
    }

    private String removeElementFromXml(String string, String string2) throws JposException {
        try {
            Object object;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource();
            inputSource.setCharacterStream(new StringReader(string));
            Document document = documentBuilder.parse(inputSource);
            document.getDocumentElement().normalize();
            XPath xPath = XPathFactory.newInstance().newXPath();
            String string3 = "/inArgs/opcode";
            NodeList nodeList = (NodeList)xPath.compile(string2).evaluate(document, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                object = nodeList.item(i);
                if (!object.getNodeName().equals("opcode")) continue;
                object.getParentNode().removeChild((Node)object);
                break;
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            object = transformerFactory.newTransformer();
            StringWriter stringWriter = new StringWriter();
            ((Transformer)object).transform(new DOMSource(document), new StreamResult(stringWriter));
            return stringWriter.toString();
        }
        catch (Exception exception) {
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)111, (String)"Failed to pass the XML");
            return "";
        }
    }

    private void executeNcrBeepCommnad(int n) {
        this.executeNcrBeepCommnad(n, null);
    }

    private void executeNcrBeepCommnad(int n, int[] nArray) {
        USBScannerWin32 uSBScannerWin32 = (USBScannerWin32)this._scnDvc;
        if (nArray != null) {
            nArray[0] = 0;
        }
        for (int i = 0; i < uSBScannerWin32.AllScanners.size(); ++i) {
            if (((ScannerData)uSBScannerWin32.AllScanners.get((int)i)).scanType.equals(VDIScanType)) continue;
            String string = ((ScannerData)uSBScannerWin32.AllScanners.get((int)i)).scanId;
            String string2 = "<inArgs><scannerID>" + string + "</scannerID><cmdArgs><arg-xml><attrib_list><attribute><id>6000</id><datatype>X</datatype><value>" + n + "</value></attribute></attrib_list></arg-xml></cmdArgs></inArgs>";
            ArgStruct argStruct = new ArgStruct();
            argStruct.status = 0L;
            argStruct.inXml = string2;
            argStruct.opcode = 5004;
            JCoreScanner.jcoreScanner.ExecCommand(argStruct);
        }
    }

    private void launchUpdatedFirmware() {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        for (Map.Entry<ScannerData, Boolean> entry : scannerUFList.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            String string2 = "<inArgs><scannerID>" + entry.getKey().scanId + "</scannerID></inArgs>";
            ArgStruct argStruct = new ArgStruct();
            argStruct.status = 0L;
            argStruct.inXml = string2;
            argStruct.opcode = ArgStruct.START_NEW_FIRMWARE;
            try {
                JCoreScanner.jcoreScanner.ExecCommand(argStruct);
                if (argStruct.status == 0L) {
                    entry.setValue(true);
                    com.zebra.log.scanner.JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[]{"launchUpdatedFirmware success for scannerId : " + entry.getKey().scanId});
                    continue;
                }
                com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)111, (String)("launchUpdatedFirmware failed for scannerId : " + entry.getKey().scanId));
                scannerUFList.remove(entry.getKey());
            }
            catch (Exception exception) {
                scannerUFList.remove(entry.getKey());
                exception.printStackTrace();
            }
        }
    }

    private void executeResetCommnad(int[] nArray) throws JposException {
        try {
            boolean bl;
            int n;
            USBScannerWin32 uSBScannerWin32 = (USBScannerWin32)this._scnDvc;
            String[] stringArray = new String[uSBScannerWin32.AllScanners.size()];
            int n2 = uSBScannerWin32.AllScanners.size();
            int n3 = 0;
            uSBScannerWin32.rebootedScannerIdsList.clear();
            uSBScannerWin32.pnpWaitNotify.resetTimeout();
            for (n = 0; n < n2; ++n) {
                String string = null;
                try {
                    string = ((ScannerData)uSBScannerWin32.AllScanners.get((int)n)).scanId;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                String string2 = "<inArgs><scannerID>" + string + "</scannerID></inArgs>";
                ArgStruct argStruct = new ArgStruct();
                argStruct.status = 0L;
                argStruct.inXml = string2;
                argStruct.opcode = ArgStruct.REBOOT_SCANNER;
                JCoreScanner.jcoreScanner.ExecCommand(argStruct);
                if (argStruct.status != 0L) continue;
                stringArray[n] = string;
                ++n3;
            }
            if (n3 == 0) {
                com.zebra.log.scanner.JCoreLogger.Log((boolean)false, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)111, (String)"Direct IO RESET: Failed to send reboot command to scanner(s)");
                throw new JposException(111, "Direct IO RESET: Failed to send reboot command to scanner(s)");
            }
            n = 0;
            long l = 100L;
            block8: while (n3 > 0) {
                int n4 = 0;
                uSBScannerWin32.pnpWaitNotify.doWait(l, REBOOT_TIMEOUT);
                if (uSBScannerWin32.pnpWaitNotify.isTimeoutReached) break;
                try {
                    n4 = uSBScannerWin32.rebootedScannerIdsList.remove(0);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    indexOutOfBoundsException.printStackTrace();
                    continue;
                }
                for (int i = 0; i < n2; ++i) {
                    String string = stringArray[i];
                    if (!string.equals(String.valueOf(n4))) continue;
                    --n3;
                    continue block8;
                }
            }
            if (uSBScannerWin32.pnpWaitNotify.isTimeoutReached) {
                uSBScannerWin32.pnpWaitNotify.resetTimeout();
                GetScannerArgStruct getScannerArgStruct = new GetScannerArgStruct();
                JCoreScanner.jcoreScanner.GetScanners(getScannerArgStruct);
                nArray[0] = (int)getScannerArgStruct.status;
                for (int i = 0; i < n2; ++i) {
                    boolean bl2 = false;
                    String string = stringArray[i];
                    for (int j = 0; j < getScannerArgStruct.scannerCount; ++j) {
                        if (!string.equals(String.valueOf(getScannerArgStruct.scannerIDs[j]))) continue;
                        bl2 = true;
                        --n3;
                        break;
                    }
                    if (bl2) continue;
                    nArray[0] = STATUS_FAILURE;
                    com.zebra.log.scanner.JCoreLogger.Log((boolean)false, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)111, (String)"Failed to get all scanners after Direct IO RESET");
                    throw new JposException(111, "Failed to get all scanners after Direct IO RESET");
                }
            }
            if (n3 == 0) {
                nArray[0] = STATUS_SUCCESS;
                com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_NOTICE, (int)0, (String)"Scanner DIO RESET success");
            }
            if (!(bl = this.getDeviceEnabled()) && this._fClaimed) {
                this.setDeviceEnabled(true);
            }
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(String string, EventCallbacks eventCallbacks) throws JposException {
        com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_NOTICE, (int)0, (String)("Open " + string));
        ScanEventQueue scanEventQueue = this._seqEvents;
        synchronized (scanEventQueue) {
            try {
                this._jpe = JposServiceLoader.getManager().getEntryRegistry().getJposEntry(string);
                if (this._jpe == null) {
                    throw new JposException(109, "Logical device could not be found");
                }
                com.zebra.log.scanner.JCoreLogger.SetLogEntries((JposEntry)this._jpe);
                if (this._fOpened) {
                    com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)106, (String)"Service is already open");
                }
                this._ecbs = eventCallbacks;
                this._seqEvents._fEnabled = false;
                this._seqEvents._fDataEventEnabled = false;
                this._seqEvents._fFreezeEvents = false;
                this._fAutoDisable = false;
                this._fCapCompareFWVer = false;
                this._fCapStatsReporting = true;
                this._fCapUpdateFW = false;
                this._fCapUpdateStats = true;
                this._fDecodeData = false;
                this._fDeviceOwner = false;
                this._strHealthText = "";
                this._abScanData = new byte[0];
                this._abScanDataLabel = new byte[0];
                _iCapPowerReporting = 1;
                this._iPowerNotify = 0;
                this._iScanDataType = 0;
                this.physicalDeviceDescription = "";
                JposEntry.Prop prop = this._jpe.getProp("productDescription");
                if (prop != null) {
                    this.physicalDeviceDescription = prop.getValueAsString();
                }
                if (this.physicalDeviceDescription == "") {
                    this.physicalDeviceDescription = "Symbol Serial/USB Scanner";
                }
                this.physicalDeviceName = "";
                prop = this._jpe.getProp("productName");
                if (prop != null) {
                    this.physicalDeviceName = prop.getValueAsString();
                }
                if (this.physicalDeviceName == "") {
                    this.physicalDeviceName = "Symbol Scanner";
                }
                this._scnCfg._logicalDeviceName = this._jpe.getLogicalName();
                this.LoadProperties();
                prop = this._jpe.getProp("ScannerType");
                if (prop != null) {
                    String string2 = prop.getValueAsString();
                    com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_NOTICE, (int)0, (String)("Open: scannerType =  " + string2));
                    if (string2.equals(JPOS_XML_SCANNER_TYPE_ALL) || string2.equals(JPOS_XML_SCANNER_TYPE_UNKNOWN)) {
                        this._scnCfg._iScannerType = OpenArgStruct.SCANNER_TYPES_ALL;
                    } else if (string2.equals(JPOS_XML_SCANNER_TYPE_IBMTT)) {
                        this._scnCfg._iScannerType = OpenArgStruct.SCANNER_TYPE_IBMTT;
                    } else if (string2.equals("USBIBMHID") || string2.equals("USBIBMHID")) {
                        this._scnCfg._iScannerType = OpenArgStruct.SCANNER_TYPE_IBMHID;
                    } else if (string2.equals(JPOS_XML_SCANNER_TYPE_SNAPI)) {
                        this._scnCfg._iScannerType = OpenArgStruct.SCANNER_TYPE_SNAPI;
                    } else if (string2.equals(JPOS_XML_SCANNER_TYPE_SSI)) {
                        this._scnCfg._iScannerType = OpenArgStruct.SCANNER_TYPE_SSI;
                    } else if (string2.equals(JPOS_XML_SCANNER_TYPE_USB_OPOS)) {
                        this._scnCfg._iScannerType = OpenArgStruct.SCANNER_TYPE_USBOPOS;
                    } else if (string2.equals(JPOS_XML_SCANNER_TYPE_NIXMODB)) {
                        this._scnCfg._iScannerType = OpenArgStruct.SCANNER_TYPE_NIXMODB;
                    } else if (string2.equals(JPOS_XML_SCANNER_TYPE_SSI_BT)) {
                        this._scnCfg._iScannerType = OpenArgStruct.SCANNER_TYPE_SSI_BT;
                    } else if (string2.equals(JPOS_XML_SCANNER_TYPE_VDI)) {
                        this._scnCfg._iScannerType = OpenArgStruct.SCANNER_TYPE_VDI;
                    }
                } else {
                    this._scnCfg._iScannerType = OpenArgStruct.SCANNER_TYPES_ALL;
                }
                com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_NOTICE, (int)0, (String)("Open:  _scnCfg._iScannerType =  " + this._scnCfg._iScannerType));
                this._scnCfg._strPortName = "";
                prop = this._jpe.getProp("port");
                this._scnCfg._strPortName = prop != null ? prop.getValueAsString() : JPOS_XML_SCANNER_TYPE_ALL;
                this._seqEvents._fStopThread = false;
                this._seqEvents.start();
                this._statusEvents.stopThread = false;
                this._statusEvents.start();
                this._directIOEvents.stopThread = false;
                this._directIOEvents.start();
                this._fOpened = true;
                this._iState = 2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_NOTICE, (int)0, (String)"[debug][open] creating SvcPnpEventHandle()..");
        try {
            this._scnCfg._jposXmlPropScannerModel = this._jpe.getProp(JPOS_XML_SCANNER_MODEL).getValueAsString();
        }
        catch (NullPointerException nullPointerException) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"ScannerModel is not defined. Proceeding with the default value");
        }
        try {
            this._scnCfg._JposXmlPropSerialNumner = this._jpe.getProp(JPOS_XML_SCANNER_SERIAL).getValueAsString();
        }
        catch (NullPointerException nullPointerException) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"SerialNumber is not defined. Proceeding with the default value");
        }
        try {
            this._scnCfg._jposXmlXclusivClaimLevel = Integer.valueOf(this._jpe.getProp(JPOS_XML_EXCLUSIVE_CLAIM_LEVEL).getValueAsString());
        }
        catch (NullPointerException nullPointerException) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"ExclusiveClaimLevel is not defined. Proceeding with the default value");
        }
        catch (ClassCastException classCastException) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"Invalid value in Jpos property exclusive claimable. Proceeding with the default value");
        }
        try {
            this.ncrScanNOFPattern = Integer.parseInt(this._jpe.getProp(NCR_SCAN_NOF_PATTERN).getValueAsString());
        }
        catch (NumberFormatException numberFormatException) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"Invalid ncrScanNOFPattern value. Proceeding with the default value");
        }
        catch (NullPointerException nullPointerException) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"ncrScanNOFPattern is not defined. Proceeding with the default value");
        }
        try {
            this.dioScannerNotOnFile = Integer.parseInt(this._jpe.getProp(DIO_SCANNER_NOT_ON_FILE).getValueAsString());
        }
        catch (NumberFormatException numberFormatException) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"Invalid dioScannerNotOnFile value. Proceeding with the default value");
        }
        catch (NullPointerException nullPointerException) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"dioScannerNotOnFile is not defined. Proceeding with the default value");
        }
        try {
            this.dioScannerDioNof = Integer.parseInt(this._jpe.getProp(DIO_SCANNER_DIO_NOF).getValueAsString());
        }
        catch (NumberFormatException numberFormatException) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"Invalid dioScannerDioNof value. Proceeding with the default value");
        }
        catch (NullPointerException nullPointerException) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"dioScannerDioNof is not defined. Proceeding with the default value");
        }
        try {
            this.ncrScanEnableBeepTonePattern = Integer.parseInt(this._jpe.getProp(NCR_ENABLE_BEEP_TONE_PATTERN).getValueAsString());
        }
        catch (NumberFormatException numberFormatException) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"Invalid NcrScanToneEnableBeepPattern value. Proceeding with the default value");
        }
        catch (NullPointerException nullPointerException) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"NcrScanToneEnableBeepPattern is not defined. Proceeding with the default value");
        }
        try {
            this.ncrScanDisableBeepTonePattern = Integer.parseInt(this._jpe.getProp(NCR_DISABLE_BEEP_TONE_PATTERN).getValueAsString());
        }
        catch (NumberFormatException numberFormatException) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"Invalid NcrScanToneDisableBeepPattern value. Proceeding with the default value");
        }
        catch (NullPointerException nullPointerException) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"NcrScanToneDableBeepPattern is not defined. Proceeding with the default value");
        }
        try {
            this.ncrScanBeepOnceTonePattern = Integer.parseInt(this._jpe.getProp(NCR_BEEP_ONCE_TONE_PATTERN).getValueAsString());
        }
        catch (NumberFormatException numberFormatException) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"Invalid NcrScanToneBeepOncePattern value. Proceeding with the default value");
        }
        catch (NullPointerException nullPointerException) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"NcrScanToneBeepOncePattern or NcrScanTonePattern is not defined. Proceeding with the default value");
        }
        try {
            this.scanDataLabelId = Integer.parseInt(this._jpe.getProp(SCAN_DATA_LABEL_ID).getValueAsString());
            if (this.scanDataLabelId != 0 && this.scanDataLabelId != 1 && this.scanDataLabelId != 2 && this.scanDataLabelId != 3 && this.scanDataLabelId != 4 && this.scanDataLabelId != 9999) {
                this.scanDataLabelId = 9999;
                JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"Invalid ScanDataLabelId value. Proceeding with the default value");
            }
        }
        catch (NumberFormatException numberFormatException) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"Invalid ScanDataLabelId value. Proceeding with the default value");
        }
        catch (NullPointerException nullPointerException) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"ScanDataLabelId is not defined. Proceeding with the default value");
        }
        try {
            REBOOT_TIMEOUT = Integer.parseInt(this._jpe.getProp(RESET_TIMEOUT).getValueAsString());
        }
        catch (NumberFormatException numberFormatException) {
            REBOOT_TIMEOUT = 30000;
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"Invalid ResetTimeout value. Proceeding with the default value");
        }
        catch (NullPointerException nullPointerException) {
            REBOOT_TIMEOUT = 30000;
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"ResetTimeout is not defined. Proceeding with the default value");
        }
        try {
            this._scnCfg._jposXmlReportmissingScannersOnEnable = Integer.valueOf(this._jpe.getProp(JPOS_XML_REPORT_MISSING_SCANNERS_ON_ENABLE).getValueAsString());
            if (this._scnCfg._jposXmlReportmissingScannersOnEnable > 1) {
                this._scnCfg._jposXmlReportmissingScannersOnEnable = 1;
            }
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_NOTICE, (int)0, (String)("Value of ReportMissingScannersOnEnable =  " + this._scnCfg._jposXmlReportmissingScannersOnEnable));
        }
        catch (NullPointerException nullPointerException) {
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_NOTICE, (int)0, (String)"ReportMissingScannersOnEnable is not defined. Proceeding with the default value.");
        }
        catch (ClassCastException classCastException) {
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_NOTICE, (int)0, (String)"Invalid value in ReportMissingScannersOnEnable. Proceeding with the default value.");
        }
        try {
            this.clearScannerQueueOnRelease = Integer.parseInt(this._jpe.getProp(JPOS_XML_CLEAR_QUEUE_ON_RELEASE).getValueAsString());
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_NOTICE, (int)0, (String)("Value of ClearQueueOnRelease =  " + this.clearScannerQueueOnRelease));
        }
        catch (NullPointerException nullPointerException) {
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_NOTICE, (int)0, (String)"ClearQueueOnRelease is not defined. Proceeding with the default value");
        }
        catch (NumberFormatException numberFormatException) {
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_NOTICE, (int)0, (String)"ClearQueueOnRelease is not valid. Proceeding with the default value");
        }
        try {
            beepOnVDIEvent = Integer.parseInt(this._jpe.getProp(BEEP_ON_VDI_EVENT).getValueAsString());
            if (beepOnVDIEvent != 0 && beepOnVDIEvent != 1) {
                beepOnVDIEvent = 0;
                com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_NOTICE, (int)0, (String)"Invalid BeepOnVDIEvent value. Proceeding with the default value");
            }
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_NOTICE, (int)0, (String)("Value of BeepOnVDIEvent =  " + beepOnVDIEvent));
        }
        catch (NumberFormatException numberFormatException) {
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_NOTICE, (int)0, (String)"Invalid BeepOnVDIEvent value. Proceeding with the default value");
        }
        catch (NullPointerException nullPointerException) {
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_NOTICE, (int)0, (String)"BeepOnVDIEvent is not defined. Proceeding with the default value");
        }
        this.initializeCoreScanner();
        int n = this.getPowerState();
        ScannerCimPropertyLogger.logPowerStateControlServiceVersion(n, 1012000);
    }

    private void initializeCoreScanner() throws JposException {
        int n = 10000;
        long l = System.currentTimeMillis();
        boolean bl = false;
        int n2 = 0;
        if (!this._fClaimed) {
            while (!bl) {
                this._scnDvc = new USBScannerWin32(this._scnCfg, this._seqEvents, this._statusEvents, this._directIOEvents, this._ecbs.getEventSource());
                if (this._scnDvc != null && this._scnDvc.open()) {
                    bl = true;
                    this._scnDvc.SetParam(this._configProp);
                    this._fOpened = true;
                    break;
                }
                this._fOpened = false;
                if (this._scnDvc != null) {
                    this._scnDvc.close();
                }
                if ((n2 = this._scnDvc.getScannerCount()) <= 0) {
                    throw new JposException(107, "No Device Detected");
                }
                if (n >= 0 && System.currentTimeMillis() - l > (long)n) break;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws JposException {
        com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_NOTICE, (int)0, (String)"release");
        if (!this._fOpened) {
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)101, (String)"Service is not open");
        } else if (!this._fDeviceOwner) {
            if (!this._fClaimed) {
                com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)103, (String)"Device is not claimed");
            } else {
                com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)103, (String)"Device is already claimed by another control instance");
            }
        }
        ScanEventQueue scanEventQueue = this._seqEvents;
        synchronized (scanEventQueue) {
            if (this._seqEvents._fEnabled) {
                this.setDeviceEnabled(false);
            }
            USBScannerWin32 uSBScannerWin32 = (USBScannerWin32)this._scnDvc;
            for (ScannerData scannerData : uSBScannerWin32.getOpenedScannerList()) {
                if (!uSBScannerWin32.jposXmlPropLogicalName.equals(scannerData.getLogicalDeviceName())) continue;
                scannerData.setExclusivelyClaimed(false);
                scannerData.setNonExclusivelyClaimed(false);
            }
            this._fDeviceOwner = false;
            this._fDeviceOwnerAvailable = false;
            this._fClaimed = false;
            int n = this.getPowerState();
            ScannerCimPropertyLogger.logPowerStateControlServiceVersion(n, 1012000);
        }
        if (this.clearScannerQueueOnRelease == 1 && this._seqEvents != null) {
            this._seqEvents.Clear();
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_NOTICE, (int)0, (String)"Queue is cleared");
        }
    }

    public void deleteInstance() throws JposException {
    }

    @Override
    public void ScanDataReceived() {
        if (this._fAutoDisable) {
            try {
                this.setDeviceEnabled(false);
            }
            catch (JposException jposException) {
                // empty catch block
            }
        }
    }

    @Override
    public void ScanEventHandlerHealthCheck(ScanEventQueueEntry scanEventQueueEntry) {
        if (scanEventQueueEntry._iEventType == 0) {
            int n;
            byte[] byArray;
            int n2 = scanEventQueueEntry._iDataLength;
            int n3 = scanEventQueueEntry._iTypeLength <= 0 ? -scanEventQueueEntry._iTypeLength : 0;
            if (scanEventQueueEntry._iScanType == 104 && n2 == 10) {
                byArray = new byte[n2 += 3];
                byArray[0] = 57;
                byArray[1] = 55;
                byArray[2] = 56;
                n = 3;
            } else {
                byArray = new byte[n2];
                n = 0;
            }
            while (n < n2) {
                byArray[n] = scanEventQueueEntry._abScanData[n3];
                if (scanEventQueueEntry._fIsBCD && byArray[n] < 32) {
                    int n4 = n;
                    byArray[n4] = (byte)(byArray[n4] + 48);
                }
                ++n;
                ++n3;
            }
            if (this.scanDataTypeTxt != null) {
                this.scanDataTypeTxt.setText(String.valueOf(scanEventQueueEntry._iScanType) + " (" + ScannerBarcodeType.getBarcodeTypeName(scanEventQueueEntry._iScanType) + ")");
            }
            if (this.scanDataTxt != null) {
                this._iScanDataType = scanEventQueueEntry._iScanType;
                this.scanDataTxt.setText(new String(this.addNcrLabelIdToScanData(byArray, scanEventQueueEntry._iScanZebraSymbologyType)));
            }
            if (this.noBtn != null) {
                this.noBtn.setEnabled(true);
            }
            if (this.yesBtn != null) {
                this.yesBtn.setEnabled(true);
            }
        }
    }

    @Override
    public void ScanEventHandler(ScanEventQueueEntry scanEventQueueEntry) {
        EventCallbacks eventCallbacks = this._ecbs;
        if (eventCallbacks != null) {
            switch (scanEventQueueEntry._iEventType) {
                case 0: {
                    if (this._fDecodeData) {
                        int n;
                        this._iScanDataType = scanEventQueueEntry._iScanType;
                        int n2 = scanEventQueueEntry._iDataLength;
                        this._abScanData = new byte[0];
                        int n3 = scanEventQueueEntry._iTypeLength <= 0 ? -scanEventQueueEntry._iTypeLength : 0;
                        if (this._iScanDataType == 104 && n2 == 10) {
                            this._abScanDataLabel = new byte[n2 += 3];
                            this._abScanDataLabel[0] = 57;
                            this._abScanDataLabel[1] = 55;
                            this._abScanDataLabel[2] = 56;
                            n = 3;
                        } else {
                            this._abScanDataLabel = new byte[n2];
                            n = 0;
                        }
                        while (n < n2) {
                            this._abScanDataLabel[n] = scanEventQueueEntry._abScanData[n3];
                            if (scanEventQueueEntry._fIsBCD && this._abScanDataLabel[n] < 32) {
                                int n4 = n;
                                this._abScanDataLabel[n4] = (byte)(this._abScanDataLabel[n4] + 48);
                            }
                            ++n;
                            ++n3;
                        }
                        n2 = scanEventQueueEntry._abScanData.length;
                        this._abScanData = new byte[n2];
                        for (n = 0; n < n2; ++n) {
                            this._abScanData[n] = scanEventQueueEntry._abScanData[n];
                            if (!scanEventQueueEntry._fIsBCD || this._abScanData[n] >= 32) continue;
                            int n5 = n;
                            this._abScanData[n5] = (byte)(this._abScanData[n5] + 48);
                        }
                    } else {
                        this._iScanDataType = 0;
                        this._abScanDataLabel = new byte[0];
                        int n = scanEventQueueEntry._abScanData.length;
                        this._abScanData = new byte[n];
                        for (int i = 0; i < n; ++i) {
                            this._abScanData[i] = scanEventQueueEntry._abScanData[i];
                            if (!scanEventQueueEntry._fIsBCD || this._abScanData[i] >= 32) continue;
                            int n6 = i;
                            this._abScanData[n6] = (byte)(this._abScanData[n6] + 48);
                        }
                    }
                    this._iScanZebraSymbologyType = scanEventQueueEntry._iScanZebraSymbologyType;
                    this._abScanData = this.addNcrLabelIdToScanData(this._abScanData, scanEventQueueEntry._iScanZebraSymbologyType);
                    ++this.goodScanCount;
                    if (VDIScaleSeen && scanEventQueueEntry._iScannerID.equals(VDIScanID)) {
                        this.BeepOnVDIDataEvent();
                    }
                    eventCallbacks.fireDataEvent((DataEvent)scanEventQueueEntry._jpe);
                    break;
                }
                case 1: {
                    eventCallbacks.fireDirectIOEvent((DirectIOEvent)scanEventQueueEntry._jpe);
                    break;
                }
                case 2: {
                    eventCallbacks.fireErrorEvent((ErrorEvent)scanEventQueueEntry._jpe);
                    break;
                }
                case 3: {
                    eventCallbacks.fireStatusUpdateEvent((StatusUpdateEvent)scanEventQueueEntry._jpe);
                    break;
                }
            }
        }
    }

    private ScannerLabelIdData getScannerLblIdDataByType(int n) {
        for (int i = 0; i < this.scannerLblIdDataList.length; ++i) {
            if (this.scannerLblIdDataList[i].scanDataType != n) continue;
            return this.scannerLblIdDataList[i];
        }
        return null;
    }

    private byte[] addNcrLabelIdToScanData(byte[] byArray, int n) {
        byte[] byArray2 = null;
        if (this.scanDataLabelId == 2 || this.scanDataLabelId == 9999) {
            return byArray;
        }
        ScannerLabelIdData scannerLabelIdData = null;
        scannerLabelIdData = this.getScannerLblIdDataByType(n);
        if (scannerLabelIdData != null) {
            switch (this.scanDataLabelId) {
                case 0: {
                    byArray2 = this.appendDataLabelID(byArray, scannerLabelIdData.ibmLabelValue);
                    break;
                }
                case 1: {
                    byArray2 = this.prependDataLabelID(byArray, scannerLabelIdData.ncrLabelValue);
                    break;
                }
                case 3: {
                    if (scannerLabelIdData.is2D) {
                        byArray2 = this.appendDataLabelID(byArray, scannerLabelIdData.ncr1DonlyLabelValue);
                        break;
                    }
                    byArray2 = this.prependDataLabelID(byArray, scannerLabelIdData.ncr1DonlyLabelValue);
                    break;
                }
                case 4: {
                    byArray2 = scannerLabelIdData.is2D ? this.prependDataLabelID(byArray, scannerLabelIdData.ncr2DonlyLabelValue) : this.appendDataLabelID(byArray, scannerLabelIdData.ncr2DonlyLabelValue);
                }
            }
        } else {
            byArray2 = byArray;
        }
        return byArray2;
    }

    private void loadScannerDataLblDataList() {
        this.scannerLblIdDataList = new ScannerLabelIdData[38];
        this.scannerLblIdDataList[0] = new ScannerLabelIdData(8, new byte[]{65}, new byte[]{13}, new byte[]{65}, new byte[]{13}, false);
        this.scannerLblIdDataList[1] = new ScannerLabelIdData(9, new byte[]{69}, new byte[]{10}, new byte[]{69}, new byte[]{10}, false);
        this.scannerLblIdDataList[2] = new ScannerLabelIdData(16, new byte[]{69}, new byte[]{10}, new byte[]{69}, new byte[]{10}, false);
        this.scannerLblIdDataList[3] = new ScannerLabelIdData(10, new byte[]{70, 70}, new byte[]{12}, new byte[]{70, 70}, new byte[]{12}, false);
        this.scannerLblIdDataList[4] = new ScannerLabelIdData(11, new byte[]{70}, new byte[]{22}, new byte[]{70}, new byte[]{22}, false);
        this.scannerLblIdDataList[5] = new ScannerLabelIdData(54, new byte[]{70}, new byte[]{22}, new byte[]{70}, new byte[]{22}, false);
        this.scannerLblIdDataList[6] = new ScannerLabelIdData(1, new byte[]{66, 49}, new byte[]{0, 10, 11}, new byte[]{66, 49}, new byte[]{0, 10, 11}, false);
        this.scannerLblIdDataList[7] = new ScannerLabelIdData(19, new byte[]{66, 49}, new byte[]{0, 10, 11}, new byte[]{66, 49}, new byte[]{0, 10, 11}, false);
        this.scannerLblIdDataList[8] = new ScannerLabelIdData(6, new byte[]{66, 50}, new byte[]{0, 13, 11}, new byte[]{66, 50}, new byte[]{0, 13, 11}, false);
        this.scannerLblIdDataList[9] = new ScannerLabelIdData(3, new byte[]{66, 51}, new byte[]{0, 24, 11}, new byte[]{66, 51}, new byte[]{0, 24, 11}, false);
        this.scannerLblIdDataList[10] = new ScannerLabelIdData(48, new byte[]{93, 101, 48}, new byte[]{0, 42, 11}, new byte[]{93, 101, 48}, new byte[]{0, 42, 11}, false);
        this.scannerLblIdDataList[11] = new ScannerLabelIdData(50, new byte[]{93, 101, 48}, new byte[]{0, 43, 11}, new byte[]{93, 101, 48}, new byte[]{0, 43, 11}, false);
        this.scannerLblIdDataList[12] = new ScannerLabelIdData(17, new byte[]{93, 76, 48}, new byte[]{0, 46, 11}, new byte[]{0, 46, 11}, new byte[]{93, 76, 48}, true);
        this.scannerLblIdDataList[13] = new ScannerLabelIdData(2, new byte[]{78}, new byte[]{0, 14, 11}, new byte[]{78}, new byte[]{0, 14, 11}, false);
        this.scannerLblIdDataList[14] = new ScannerLabelIdData(27, new byte[]{93, 100, 48}, new byte[]{0, 50, 11}, new byte[]{0, 50, 11}, new byte[]{93, 100, 48}, true);
        this.scannerLblIdDataList[15] = new ScannerLabelIdData(45, new byte[]{93, 122, 48}, new byte[]{0, 52, 11}, new byte[]{0, 52, 11}, new byte[]{93, 122, 48}, true);
        this.scannerLblIdDataList[16] = new ScannerLabelIdData(37, new byte[]{93, 85, 48}, new byte[]{0, 47, 11}, new byte[]{0, 47, 11}, new byte[]{93, 85, 48}, true);
        this.scannerLblIdDataList[17] = new ScannerLabelIdData(28, new byte[]{93, 81, 49}, new byte[]{0, 51, 11}, new byte[]{0, 51, 11}, new byte[]{93, 81, 49}, true);
        this.scannerLblIdDataList[18] = new ScannerLabelIdData(20, new byte[]{68, 49}, new byte[]{0, 17}, new byte[]{68, 49}, new byte[]{0, 17}, false);
        this.scannerLblIdDataList[19] = new ScannerLabelIdData(4, new byte[]{93, 83, 48}, new byte[]{0, 12, 11}, new byte[]{93, 83, 48}, new byte[]{0, 12, 11}, false);
        this.scannerLblIdDataList[20] = new ScannerLabelIdData(7, new byte[]{93, 71, 48}, new byte[]{0, 25, 11}, new byte[]{93, 71, 48}, new byte[]{0, 25, 11}, false);
        this.scannerLblIdDataList[21] = new ScannerLabelIdData(15, new byte[]{93, 67, 49}, new byte[]{0, 37, 11}, new byte[]{93, 67, 49}, new byte[]{0, 37, 11}, false);
        this.scannerLblIdDataList[22] = new ScannerLabelIdData(13, new byte[]{93, 84, 48}, new byte[]{0, 53, 11}, new byte[]{93, 84, 48}, new byte[]{0, 53, 11}, false);
        this.scannerLblIdDataList[23] = new ScannerLabelIdData(193, new byte[]{93, 100, 50}, new byte[]{0, 54, 11}, new byte[]{0, 54, 11}, new byte[]{93, 100, 50}, true);
        this.scannerLblIdDataList[24] = new ScannerLabelIdData(194, new byte[]{93, 81, 51}, new byte[]{0, 55, 11}, new byte[]{0, 55, 11}, new byte[]{93, 81, 51}, true);
        this.scannerLblIdDataList[25] = new ScannerLabelIdData(26, new byte[]{93, 76, 51}, new byte[]{0, 56, 11}, new byte[]{0, 56, 11}, new byte[]{93, 76, 51}, true);
        this.scannerLblIdDataList[26] = new ScannerLabelIdData(44, new byte[]{93, 81, 53}, new byte[]{0, 57, 11}, new byte[]{0, 57, 11}, new byte[]{93, 81, 53}, true);
        this.scannerLblIdDataList[27] = new ScannerLabelIdData(72, new byte[]{65}, new byte[]{0, 22, 11}, new byte[]{65}, new byte[]{22}, false);
        this.scannerLblIdDataList[28] = new ScannerLabelIdData(136, new byte[]{65}, new byte[]{0, 17, 11}, new byte[]{65}, new byte[]{17}, false);
        this.scannerLblIdDataList[29] = new ScannerLabelIdData(73, new byte[]{69}, new byte[]{0, 18, 11}, new byte[]{69}, new byte[]{18}, false);
        this.scannerLblIdDataList[30] = new ScannerLabelIdData(137, new byte[]{69}, new byte[]{0, 20, 11}, new byte[]{69}, new byte[]{20}, false);
        this.scannerLblIdDataList[31] = new ScannerLabelIdData(80, new byte[]{69}, new byte[]{0, 18, 11}, new byte[]{69}, new byte[]{18}, false);
        this.scannerLblIdDataList[32] = new ScannerLabelIdData(144, new byte[]{69}, new byte[]{0, 20, 11}, new byte[]{69}, new byte[]{20}, false);
        this.scannerLblIdDataList[33] = new ScannerLabelIdData(75, new byte[]{70}, new byte[]{0, 19, 11}, new byte[]{70}, new byte[]{19}, false);
        this.scannerLblIdDataList[34] = new ScannerLabelIdData(139, new byte[]{70}, new byte[]{0, 21, 11}, new byte[]{70}, new byte[]{21}, false);
        this.scannerLblIdDataList[35] = new ScannerLabelIdData(22, new byte[]{70}, new byte[]{22}, new byte[]{70}, new byte[]{22}, false);
        this.scannerLblIdDataList[36] = new ScannerLabelIdData(74, new byte[]{70, 70}, new byte[]{0, 23, 11}, new byte[]{70, 70}, new byte[]{23}, false);
        this.scannerLblIdDataList[37] = new ScannerLabelIdData(138, new byte[]{70, 70}, new byte[]{0, 29, 11}, new byte[]{70, 70}, new byte[]{29}, false);
    }

    private byte[] appendDataLabelID(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    private byte[] prependDataLabelID(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(byArray, 0, byArray3, byArray2.length, byArray.length);
        return byArray3;
    }

    private void LoadProperties() {
        try {
            this._configProp.clear();
            Iterator iterator = this._jpe.getProps();
            while (iterator.hasNext()) {
                JposEntry.Prop prop = (JposEntry.Prop)iterator.next();
                if (prop == null) continue;
                ScannerSettings scannerSettings = new ScannerSettings();
                scannerSettings.propName = prop.getName();
                scannerSettings.propType = prop.getType().toString();
                scannerSettings.propVal = prop.getValueAsString().toLowerCase();
                this._configProp.add(scannerSettings);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private int GetIntProp(String string, int n) {
        int n2 = n;
        JposEntry.Prop prop = this._jpe.getProp(string);
        if (prop != null) {
            try {
                n2 = Integer.parseInt(prop.getValueAsString());
            }
            catch (Exception exception) {
                n2 = n;
            }
        }
        return n2;
    }

    @Override
    public void PowerNotificationEventHandler(ScannerStatusEventQueueEntry scannerStatusEventQueueEntry) {
        try {
            if (this._ecbs != null) {
                this._ecbs.fireStatusUpdateEvent((StatusUpdateEvent)scannerStatusEventQueueEntry.jposEvent);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void DirectIOEventHandler(ScannerDirectIOEventQueueEntry scannerDirectIOEventQueueEntry) {
        try {
            if (this._ecbs != null) {
                this._ecbs.fireDirectIOEvent((DirectIOEvent)scannerDirectIOEventQueueEntry.jposEvent);
                if (!scannerUFList.isEmpty()) {
                    this.launchUpdatedFirmware();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void BeepOnVDIDataEvent() {
        String string = "<inArgs><scannerID>" + VDIScaleID + "</scannerID><cmdArgs><arg-int>" + this.VDIScanBeepPattern + "</arg-int></cmdArgs></inArgs>";
        ArgStruct argStruct = new ArgStruct();
        argStruct.status = 0L;
        argStruct.inXml = string;
        argStruct.opcode = ArgStruct.SET_ACTION;
        JCoreScanner.jcoreScanner.ExecCommand(argStruct);
    }
}

