/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.jpos.service.scanner;

import com.zebra.jpos.jniscanner.ArgStruct;
import com.zebra.jpos.jniscanner.GetScannerArgStruct;
import com.zebra.jpos.jniscanner.ICSEvents;
import com.zebra.jpos.jniscanner.JCoreScanner;
import com.zebra.jpos.jniscanner.JniXmlElement;
import com.zebra.jpos.jniscanner.OpenArgStruct;
import com.zebra.jpos.service.scanner.PnpWaitNotify;
import com.zebra.jpos.service.scanner.ScanEventQueue;
import com.zebra.jpos.service.scanner.ScanEventQueueEntry;
import com.zebra.jpos.service.scanner.ScannerCimPropertyLogger;
import com.zebra.jpos.service.scanner.ScannerConfig;
import com.zebra.jpos.service.scanner.ScannerData;
import com.zebra.jpos.service.scanner.ScannerDirectIOEventQueue;
import com.zebra.jpos.service.scanner.ScannerDvc;
import com.zebra.jpos.service.scanner.ScannerSettings;
import com.zebra.jpos.service.scanner.ScannerStatusEventQueue;
import com.zebra.jpos.service.scanner.SymScannerSvc;
import com.zebra.jpos.service.scanner.ZebraScannerSymbologies;
import com.zebra.log.scanner.JCoreLogger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jpos.JposException;
import jpos.events.DataEvent;
import jpos.events.JposEvent;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class USBScannerWin32
implements ScannerDvc,
ICSEvents {
    PnpWaitNotify pnpWaitNotify = new PnpWaitNotify();
    ScannerData scannerdata;
    OpenArgStruct openArgStruct;
    ArgStruct ArgStrcuObj;
    private ScanEventQueue _seq;
    private ScannerStatusEventQueue _statusEvents;
    private ScannerDirectIOEventQueue _directIOEvents;
    public Object _evtSrc;
    public boolean _fClose;
    private boolean _fEnabled;
    private boolean _fRunning;
    private int _iDvcHandle;
    private int _ScannersAvailable;
    private int _iScannerType;
    private int jposXmlPropxclusiveClaimLevel = 0;
    private int jposXmlReportmissingScannersOnEnable = 1;
    private String jposXmlPropScannerModel;
    private String JposXmlPropSerialNumner;
    public String jposXmlPropLogicalName;
    byte[] _bScanData = new byte[4096];
    int _bScanDataLength = 0;
    static int SUBSCRIBE_BARCODE = 1;
    static int SUBSCRIBE_RMD = 8;
    static int SUBSCRIBE_PNP = 16;
    String[][] scannerId = new String[50][2];
    String scannerEventId = null;
    List<Object> AllScanners = new ArrayList<Object>();
    List<Object> openedDetachedScannerList = new ArrayList<Object>();
    int scannerCount = 0;
    int scannerCountEvent = 0;
    String JPOSXMLPort = "";
    int scannerTypeVal = 0;
    int baudrate = 0;
    int parityBit = 0;
    int databit = 0;
    int stopbit = 0;
    int flowcontrol = 0;
    int SerialCount = 0;
    int connectStatus = -1;
    List<Integer> rebootedScannerIdsList = new ArrayList<Integer>();
    List<ScannerData> pnpScannerList = new ArrayList<ScannerData>();
    static final int STATUS_ATTACH = 0;
    static final int STATUS_DETACH = 1;
    static final int STATUS_NOTIFICATION = 2;
    static final int RTA_EVENT_TYPE = 2000;
    private static final int SCANNER_UF_SESS_START = 11;
    private static final int SCANNER_UF_DL_START = 12;
    private static final int SCANNER_UF_DL_PROGRESS = 13;
    private static final int SCANNER_UF_DL_END = 14;
    private static final int SCANNER_UF_SESS_END = 15;
    private static final int SCANNER_UF_STATUS = 16;
    private static final int CONFIG_LOAD_START = 17;
    private static final int CONFIG_LOAD_PROGRESS = 18;
    private static final int CONFIG_LOAD_END = 19;
    private String RMDEventScannerId = null;
    StringBuilder modelNumbers;
    StringBuilder serialNumbers;
    StringBuilder firmwareVersions;
    static final String DEVICE_CONFIG_SPLITTER = ":";
    static final String SCANNER_TYPE_STR_ALL = "ALL";
    static final String SCANNER_TYPE_STR_SNAPI = "SNAPI";
    static final String SCANNER_TYPE_STR_IBMHH = "USBIBMHID";
    static final String SCANNER_TYPE_STR_IBMHH_LINUX = "IBMHID";
    static final String SCANNER_TYPE_STR_IBMTT = "USBIBMTT";
    static final String SCANNER_TYPE_STR_IBMTT_LINUX = "IBMTT";
    static final String SCANNER_TYPE_STR_OPOS = "USBOPOS";
    static final String SCANNER_TYPE_STR_SSI = "SSI";
    static final String SCANNER_TYPE_STR_SSI_SERIAL = "SSI_SERIAL";
    static final String SCANNER_TYPE_STR_SSI_BT = "SSI_BT";
    static final String SCANNER_TYPE_STR_NIXMODB = "NIXMODB";
    static final String SCANNER_TYPE_STR_VDI = "VDI";
    static boolean corescannerOpened = false;
    static int jposInstanceCount = 0;
    public static ArrayList<ScannerData> openedScannerList;

    protected USBScannerWin32(ScannerConfig scannerConfig, ScanEventQueue scanEventQueue, ScannerStatusEventQueue scannerStatusEventQueue, ScannerDirectIOEventQueue scannerDirectIOEventQueue, Object object) {
        this._seq = scanEventQueue;
        this._statusEvents = scannerStatusEventQueue;
        this._directIOEvents = scannerDirectIOEventQueue;
        this._evtSrc = object;
        this._iDvcHandle = 0;
        this._fClose = true;
        this._fEnabled = false;
        this.openArgStruct = new OpenArgStruct();
        this.ArgStrcuObj = new ArgStruct();
        this._ScannersAvailable = 0;
        this._iScannerType = scannerConfig._iScannerType;
        this.JPOSXMLPort = scannerConfig._strPortName.trim();
        this.openArgStruct.ScannerTypes = new short[8];
        this.openArgStruct.ScannerTypes[0] = OpenArgStruct.SCANNER_TYPES_ALL;
        this.openArgStruct.lengthOfArray = 1;
        this.baudrate = scannerConfig._iBaudRate;
        this.parityBit = scannerConfig._iParity;
        this.databit = scannerConfig._iDataBits;
        this.stopbit = scannerConfig._iStopBits;
        this.flowcontrol = 0;
        this.jposXmlPropScannerModel = scannerConfig._jposXmlPropScannerModel;
        this.JposXmlPropSerialNumner = scannerConfig._JposXmlPropSerialNumner;
        this.jposXmlPropxclusiveClaimLevel = scannerConfig._jposXmlXclusivClaimLevel;
        this.jposXmlPropLogicalName = scannerConfig._logicalDeviceName;
        this.jposXmlReportmissingScannersOnEnable = scannerConfig._jposXmlReportmissingScannersOnEnable;
    }

    private boolean compareScannerTypeInt2String(int n, String string) {
        short s = 0;
        if (string.equals(SCANNER_TYPE_STR_IBMHH) || string.equals(SCANNER_TYPE_STR_IBMHH_LINUX)) {
            s = OpenArgStruct.SCANNER_TYPE_IBMHID;
        } else if (string.equals(SCANNER_TYPE_STR_SNAPI)) {
            s = OpenArgStruct.SCANNER_TYPE_SNAPI;
        } else if (string.equals(SCANNER_TYPE_STR_IBMTT) || string.equals(SCANNER_TYPE_STR_IBMTT_LINUX)) {
            s = OpenArgStruct.SCANNER_TYPE_IBMTT;
        } else if (string.equals(SCANNER_TYPE_STR_OPOS)) {
            s = OpenArgStruct.SCANNER_TYPE_USBOPOS;
        } else if (string.equals(SCANNER_TYPE_STR_SSI_SERIAL) || string.equals(SCANNER_TYPE_STR_SSI)) {
            s = OpenArgStruct.SCANNER_TYPE_SSI;
        } else if (string.equals(SCANNER_TYPE_STR_SSI_BT)) {
            s = OpenArgStruct.SCANNER_TYPE_SSI_BT;
        } else if (string.equals(SCANNER_TYPE_STR_NIXMODB)) {
            s = OpenArgStruct.SCANNER_TYPE_NIXMODB;
        } else if (string.equals(SCANNER_TYPE_STR_VDI)) {
            s = OpenArgStruct.SCANNER_TYPE_VDI;
        }
        return s == n || n == 0;
    }

    private void processGetScannersXML(String string) throws Exception {
        try {
            this.modelNumbers = new StringBuilder();
            this.serialNumbers = new StringBuilder();
            this.firmwareVersions = new StringBuilder();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            Document document = documentBuilder.parse(byteArrayInputStream);
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("scanner");
            int n = nodeList.getLength();
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = "";
            String string6 = "";
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() == 1) {
                    Object object;
                    Element element = (Element)node;
                    string2 = element.getAttribute("type");
                    if (!this.compareScannerTypeInt2String(this._iScannerType, string2)) continue;
                    NodeList nodeList2 = element.getElementsByTagName("scannerID");
                    Element element2 = (Element)nodeList2.item(0);
                    NodeList nodeList3 = element2.getChildNodes();
                    string3 = nodeList3.item(0).getNodeValue().trim();
                    NodeList nodeList4 = element.getElementsByTagName("port");
                    if (nodeList4 != null && (object = (Element)nodeList4.item(0)) != null) {
                        NodeList nodeList5 = object.getChildNodes();
                        string4 = nodeList5.item(0).getNodeValue().trim();
                    }
                    string5 = this.extractModel(element);
                    if (this.modelNumbers.length() != 0) {
                        this.modelNumbers.append(",");
                    }
                    this.modelNumbers.append(string5);
                    if (this.jposXmlPropScannerModel != null && !this.jposXmlPropScannerModel.isEmpty() && !string5.startsWith(this.jposXmlPropScannerModel)) continue;
                    string6 = this.extractSerialNumber(element);
                    if (this.serialNumbers.length() != 0) {
                        this.serialNumbers.append(",");
                    }
                    this.serialNumbers.append(string6);
                    if (this.JposXmlPropSerialNumner != null && !this.JposXmlPropSerialNumner.isEmpty() && !string6.startsWith(this.JposXmlPropSerialNumner)) continue;
                    object = this.extractFirmwareVersion(element);
                    if (this.firmwareVersions.length() != 0) {
                        this.firmwareVersions.append(",");
                    }
                    this.firmwareVersions.append((String)object);
                }
                if (SymScannerSvc.beepOnVDIEvent == 1) {
                    if (string2.equals(SCANNER_TYPE_STR_VDI) && string3 != null && !string3.isEmpty()) {
                        SymScannerSvc.VDIScanID = string3;
                    }
                    if (!SymScannerSvc.VDIScaleSeen && (string5.startsWith("MP7") || string5.startsWith("7895")) && string3 != null && !string3.isEmpty()) {
                        SymScannerSvc.VDIScaleID = string3;
                        SymScannerSvc.VDIScaleSeen = true;
                    }
                }
                if (string3 != null && string2 != null && string4 != null) {
                    this.scannerdata = new ScannerData(string3, string2, string4, string5, string6);
                    this.scannerdata.setExclusiveClaimLevel(this.jposXmlPropxclusiveClaimLevel);
                    this.scannerdata.setLogicalDeviceName(this.jposXmlPropLogicalName);
                    this.AllScanners.add(n2++, this.scannerdata);
                    this.insertIntoOpenedScannerList(this.scannerdata);
                    continue;
                }
                string4 = "no port";
                this.scannerdata = new ScannerData(string3, string2, string4, string5, string6);
                this.scannerdata.setExclusiveClaimLevel(this.jposXmlPropxclusiveClaimLevel);
                this.scannerdata.setLogicalDeviceName(this.jposXmlPropLogicalName);
                this.AllScanners.add(n2++, this.scannerdata);
                this.insertIntoOpenedScannerList(this.scannerdata);
            }
            this.scannerCount = n2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertIntoOpenedScannerList(ScannerData scannerData) {
        try {
            USBScannerWin32 uSBScannerWin32 = this;
            synchronized (uSBScannerWin32) {
                if (openedScannerList == null) {
                    openedScannerList = new ArrayList();
                }
                for (ScannerData scannerData2 : openedScannerList) {
                    if (!scannerData2.equals(scannerData)) continue;
                    return;
                }
                openedScannerList.add(this.scannerdata);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromopenedScannerList(ScannerData scannerData) {
        try {
            USBScannerWin32 uSBScannerWin32 = this;
            synchronized (uSBScannerWin32) {
                if (openedScannerList == null || openedScannerList.isEmpty()) {
                    JCoreLogger.Log((char)'-', (String)"removeFromopenedScannerList", (boolean)false, (Object[])new Object[]{true, "No opened scanners"});
                    return;
                }
                if (scannerData != null) {
                    openedScannerList.remove(scannerData);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ArrayList<ScannerData> getOpenedScannerList() {
        return openedScannerList;
    }

    private String extractModel(Element element) throws DOMException {
        return this.extractTagValue(element, "modelnumber");
    }

    private String createScannerInfoJsonString(ScannerData scannerData) {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[0]);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        try {
            stringBuilder.append("\"type\":\"" + scannerData.scanType + "\", ");
            stringBuilder.append("\"model\":\"" + scannerData.scannerModel + "\", ");
            stringBuilder.append("\"serial\":\"" + scannerData.serialNumber + "\" ");
        }
        catch (Exception exception) {
            JCoreLogger.Log((char)'#', (String)string, (boolean)false, (Object[])new Object[]{"scannerId: " + this.scannerId});
            exception.printStackTrace();
        }
        stringBuilder.append("}");
        JCoreLogger.Log((char)'#', (String)string, (boolean)false, (Object[])new Object[]{"JSON String: " + stringBuilder.toString()});
        return stringBuilder.toString();
    }

    private String createMissingScannerInfoJsonString() {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[0]);
        JCoreLogger.Log((char)'#', (String)string, (boolean)false, (Object[])new Object[]{"openedDetachedScannerList.size: " + this.openedDetachedScannerList.size()});
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        try {
            for (int i = 0; i < this.openedDetachedScannerList.size(); ++i) {
                String string2 = ((ScannerData)this.openedDetachedScannerList.get((int)i)).scanType;
                String string3 = ((ScannerData)this.openedDetachedScannerList.get((int)i)).scannerModel;
                String string4 = ((ScannerData)this.openedDetachedScannerList.get((int)i)).serialNumber;
                stringBuilder.append("\"type\":\"" + string2 + "\", ");
                stringBuilder.append("\"model\":\"" + string3 + "\", ");
                stringBuilder.append("\"serial\":\"" + string4 + "\" ");
                if (i >= this.openedDetachedScannerList.size() - 1) continue;
                stringBuilder.append("}, {");
            }
        }
        catch (Exception exception) {
            JCoreLogger.Log((char)'#', (String)string, (boolean)false, (Object[])new Object[]{"Exception openedDetachedScannerList.size: " + this.openedDetachedScannerList.size()});
            exception.printStackTrace();
        }
        stringBuilder.append("}");
        JCoreLogger.Log((char)'#', (String)string, (boolean)false, (Object[])new Object[]{"JSON String: " + stringBuilder.toString()});
        return stringBuilder.toString();
    }

    private String extractSerialNumber(Element element) throws DOMException {
        return this.extractTagValue(element, "serialnumber");
    }

    private String extractFirmwareVersion(Element element) throws DOMException {
        return this.extractTagValue(element, "firmware");
    }

    private String extractTagValue(Element element, String string) throws DOMException {
        Node node;
        String string2 = "";
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() > 0 && (node = nodeList.item(0).getChildNodes().item(0)) != null) {
            string2 = node.getNodeValue().trim();
        }
        return string2;
    }

    private void extractScannerIdsFromPnpEventXml(String string) throws Exception {
        try {
            string = string.replace("</scanner></scanner></scanner>", "</scanner></scanner>");
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            Document document = documentBuilder.parse(byteArrayInputStream);
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("scanner");
            NodeList nodeList2 = document.getElementsByTagName("status");
            Element element = (Element)nodeList2.item(0);
            NodeList nodeList3 = element.getChildNodes();
            String string2 = nodeList3.item(0).getNodeValue().trim();
            this.connectStatus = Integer.parseInt(string2);
            int n = nodeList.getLength();
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            String string9 = "1";
            for (int i = 0; i < n; ++i) {
                Element element2;
                NodeList nodeList4;
                Element element3;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element4 = (Element)node;
                NodeList nodeList5 = element4.getElementsByTagName("pnp");
                if (nodeList5.getLength() == 0) {
                    string5 = "";
                } else {
                    element3 = (Element)nodeList5.item(0);
                    nodeList4 = element3.getChildNodes();
                    string5 = nodeList4.item(0).getNodeValue().trim();
                }
                if (!string5.isEmpty() && !string5.equals(string9)) continue;
                NodeList nodeList6 = element4.getElementsByTagName("scannerID");
                element3 = (Element)nodeList6.item(0);
                nodeList4 = element3.getChildNodes();
                string4 = nodeList4.item(0).getNodeValue().trim();
                string3 = element4.getAttribute("type");
                string8 = element4.getAttribute("serialnumber");
                NodeList nodeList7 = element4.getElementsByTagName("port");
                if (nodeList7 != null && (element2 = (Element)nodeList7.item(0)) != null) {
                    NodeList nodeList8 = element2.getChildNodes();
                    string6 = nodeList8.item(0).getFirstChild().getNodeValue().trim();
                }
                string7 = this.extractModel(element4);
                this.pnpScannerList.add(new ScannerData(string4, string3, string6, string7, string8));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void idExtractionforEventReceiveXML(String string) throws Exception {
        try {
            int n;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            Document document = documentBuilder.parse(byteArrayInputStream);
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("outArgs");
            this.scannerCountEvent = n = nodeList.getLength();
            String string2 = null;
            String string3 = null;
            Object var10_11 = null;
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() == 1) {
                    Element element = (Element)node;
                    string2 = element.getAttribute("type");
                    NodeList nodeList2 = element.getElementsByTagName("scannerID");
                    Element element2 = (Element)nodeList2.item(0);
                    NodeList nodeList3 = element2.getChildNodes();
                    string3 = nodeList3.item(0).getNodeValue().trim();
                }
                if (string3 == null) continue;
                this.scannerEventId = string3;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void idExtractionforRMDEventReceiveXML(String string) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        Document document = documentBuilder.parse(byteArrayInputStream);
        document.getDocumentElement().normalize();
        NodeList nodeList = document.getElementsByTagName("outArgs");
        int n = nodeList.getLength();
        String string2 = null;
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                NodeList nodeList2 = element.getElementsByTagName("scannerID");
                Element element2 = (Element)nodeList2.item(0);
                string2 = element2.getTextContent().trim();
            }
            if (string2 == null) continue;
            this.RMDEventScannerId = string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean open() {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[0]);
        boolean bl = false;
        USBScannerWin32 uSBScannerWin32 = this;
        synchronized (uSBScannerWin32) {
            if (this._iDvcHandle != 0) {
                JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[]{true, "Already open"});
                return true;
            }
            try {
                JCoreScanner.csevents.add(this);
                if (JCoreScanner.isWndowsSystem) {
                    if (!corescannerOpened) {
                        JCoreScanner.jcoreScanner.Initiate();
                    }
                } else {
                    JCoreScanner.jcoreScanner.Initiate();
                }
                if (!corescannerOpened) {
                    int n = JCoreScanner.jcoreScanner.Open(this.openArgStruct);
                    if (this.openArgStruct.status != 0L) {
                        JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[]{false, "openArgStruct status != 0"});
                        return false;
                    }
                    corescannerOpened = true;
                }
                ++jposInstanceCount;
                this._iDvcHandle = 1;
                GetScannerArgStruct getScannerArgStruct = new GetScannerArgStruct();
                JCoreScanner.jcoreScanner.GetScanners(getScannerArgStruct);
                if (getScannerArgStruct.status != 0L) {
                    JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[]{false, "getScnArgStruct status != 0"});
                    return false;
                }
                this._ScannersAvailable = getScannerArgStruct.scannerCount;
                try {
                    this.processGetScannersXML(getScannerArgStruct.outXml);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (this.scannerCount == 0) {
                    JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[]{false, "scannerCount == 0"});
                    return false;
                }
                if (this._iDvcHandle != 0 && this._ScannersAvailable != 0) {
                    this.setEnabled(false);
                    this._fClose = false;
                    this._fRunning = true;
                    if (!JCoreScanner.isRegistered) {
                        String string2 = "<inArgs><cmdArgs><arg-int>6</arg-int><arg-int>1,2,4,8,16,32</arg-int></cmdArgs></inArgs>";
                        ArgStruct argStruct = new ArgStruct();
                        argStruct.inXml = string2;
                        argStruct.opcode = ArgStruct.REGISTER_FOR_EVENTS;
                        JCoreScanner.jcoreScanner.ExecCommand(argStruct);
                        JCoreScanner.isRegistered = true;
                    }
                    bl = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!bl) {
                this.close();
            }
        }
        JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[]{bl});
        return bl;
    }

    @Override
    public void setPowerState() {
        int n;
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[0]);
        for (n = 0; n < this.scannerCount; ++n) {
            String string2 = null;
            try {
                string2 = ((ScannerData)this.AllScanners.get((int)n)).scanId;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<inArgs>");
            stringBuilder.append("<scannerID>" + string2 + "</scannerID>");
            stringBuilder.append("<cmdArgs><arg-xml><attrib_list>20001</attrib_list></arg-xml></cmdArgs>");
            stringBuilder.append("</inArgs>");
            ArgStruct argStruct = new ArgStruct();
            argStruct.inXml = stringBuilder.toString();
            argStruct.opcode = ArgStruct.RSM_ATTR_GET;
            try {
                JCoreScanner.jcoreScanner.ExecCommand(argStruct);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (argStruct.status == 0L) continue;
            JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[0]);
            ScannerCimPropertyLogger.logPowerStateControlServiceVersion(2002, 1012000);
            return;
        }
        n = this.getPowerState();
        ScannerCimPropertyLogger.logPowerStateControlServiceVersion(n, 1012000);
    }

    private int getPowerState() {
        int n = 2004;
        if (this.AllScanners != null && this.AllScanners.size() != 0) {
            n = 2001;
        }
        return n;
    }

    @Override
    public int getScannerCount() {
        return this.scannerCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[0]);
        Object object = this;
        synchronized (object) {
            this._fClose = true;
            if (this._iDvcHandle != 0 && jposInstanceCount <= 1) {
                JCoreScanner.jcoreScanner.Close(this.ArgStrcuObj);
                JCoreScanner.isRegistered = false;
                this.removeFromopenedScannerList(this.scannerdata);
                corescannerOpened = false;
                this._iDvcHandle = 0;
            }
            --jposInstanceCount;
        }
        object = JCoreScanner.class;
        synchronized (JCoreScanner.class) {
            JCoreScanner.csevents.remove(this);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            object = this;
            synchronized (object) {
                this._fEnabled = false;
            }
            this.openedDetachedScannerList.clear();
            JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[0]);
            return;
        }
    }

    @Override
    public boolean getEnabled() {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[0]);
        JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[]{this._fEnabled});
        return this._fEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setEnabled(boolean bl) throws JposException {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[]{bl});
        boolean bl2 = false;
        USBScannerWin32 uSBScannerWin32 = this;
        synchronized (uSBScannerWin32) {
            if (bl) {
                this._fEnabled = bl;
                if (this._iDvcHandle != 0) {
                    JCoreLogger.Log((char)'#', (String)string, (boolean)false, (Object[])new Object[]{"scanner count: " + this.scannerCount});
                    JCoreLogger.Log((char)'#', (String)string, (boolean)false, (Object[])new Object[]{"AllScanners size: " + this.AllScanners.size()});
                    for (int i = 0; i < this.scannerCount; ++i) {
                        StringBuilder stringBuilder;
                        GetScannerArgStruct getScannerArgStruct;
                        String string2 = null;
                        String string3 = null;
                        JCoreLogger.Log((char)'#', (String)string, (boolean)false, (Object[])new Object[]{"scannerCount index: ", i});
                        try {
                            string2 = ((ScannerData)this.AllScanners.get((int)i)).scanId;
                            string3 = ((ScannerData)this.AllScanners.get((int)i)).scanType;
                            JCoreLogger.Log((char)'#', (String)string, (boolean)false, (Object[])new Object[]{"Scanner id: " + string2, "  Scanner type: " + string3});
                        }
                        catch (Exception exception) {
                            try {
                                JCoreLogger.Log((char)'#', (String)string, (boolean)false, (Object[])new Object[]{"Executing getscanner command on device enable failure"});
                                getScannerArgStruct = new GetScannerArgStruct();
                                Thread.sleep(100L);
                                JCoreScanner.jcoreScanner.GetScanners(getScannerArgStruct);
                                JCoreLogger.Log((char)'#', (String)string, (boolean)false, (Object[])new Object[]{"Retrying scanenable on Scanner id: " + string2, "  Scanner type: " + string3});
                                try {
                                    string2 = ((ScannerData)this.AllScanners.get((int)i)).scanId;
                                    string3 = ((ScannerData)this.AllScanners.get((int)i)).scanType;
                                    JCoreLogger.Log((char)'#', (String)string, (boolean)false, (Object[])new Object[]{"Scanner id: " + string2, "  Scanner type: " + string3});
                                }
                                catch (Exception exception2) {
                                    String string4 = this.createMissingScannerInfoJsonString();
                                    JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{"Device not available { \"devices\": [" + string4 + "] }"});
                                    if (this.jposXmlReportmissingScannersOnEnable != 1) continue;
                                    throw new JposException(107, "Device Not Available { \"devices\": [" + string4 + "] }");
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                        }
                        if (this._iScannerType != 1) {
                            stringBuilder = new StringBuilder();
                            stringBuilder.append("<inArgs>");
                            if (string2 == null) break;
                            stringBuilder.append("<scannerID>" + string2 + "</scannerID>");
                            if (string3 == null) break;
                            stringBuilder.append("</inArgs>");
                            getScannerArgStruct = new ArgStruct();
                            getScannerArgStruct.inXml = stringBuilder.toString();
                            getScannerArgStruct.opcode = ArgStruct.DEVICE_SCAN_ENABLE;
                            try {
                                bl2 = JCoreScanner.jcoreScanner.ExecCommand((ArgStruct)getScannerArgStruct) == 0;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            if (getScannerArgStruct.status == 0L) continue;
                        }
                        stringBuilder = new StringBuilder();
                        stringBuilder.append("<inArgs>");
                        stringBuilder.append("<scannerID>" + string2 + "</scannerID>");
                        if (string3.equals(SCANNER_TYPE_STR_NIXMODB)) {
                            stringBuilder.append("<cmdArgs><arg-int>5</arg-int><arg-int>" + this.baudrate + "," + this.databit + "," + this.parityBit + "," + this.stopbit + "," + this.flowcontrol + "</arg-int>\t</cmdArgs>");
                        }
                        stringBuilder.append("</inArgs>");
                        getScannerArgStruct = new ArgStruct();
                        getScannerArgStruct.inXml = stringBuilder.toString();
                        getScannerArgStruct.opcode = ArgStruct.DEVICE_SCAN_ENABLE;
                        try {
                            bl2 = JCoreScanner.jcoreScanner.ExecCommand((ArgStruct)getScannerArgStruct) == 0;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (getScannerArgStruct.status == 0L) continue;
                    }
                }
            } else {
                this._fEnabled = bl;
                if (this._iDvcHandle != 0) {
                    for (int i = 0; i < this.AllScanners.size(); ++i) {
                        Object object;
                        ScannerData scannerData2;
                        String string5 = null;
                        String string6 = null;
                        String string7 = null;
                        try {
                            string5 = ((ScannerData)this.AllScanners.get((int)i)).scanId;
                            string6 = ((ScannerData)this.AllScanners.get((int)i)).scanType;
                            string7 = ((ScannerData)this.AllScanners.get((int)i)).serialNumber;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        boolean bl3 = false;
                        for (ScannerData scannerData2 : openedScannerList) {
                            if (!scannerData2.serialNumber.equals(string7) || !scannerData2.isExclusivelyClaimed() || scannerData2.getLogicalDeviceName().equals(this.jposXmlPropLogicalName)) continue;
                            bl3 = true;
                            break;
                        }
                        if (bl3) continue;
                        if (this._iScannerType != 1) {
                            object = new StringBuilder();
                            ((StringBuilder)object).append("<inArgs>");
                            if (string5 == null) break;
                            ((StringBuilder)object).append("<scannerID>" + string5 + "</scannerID>");
                            if (string6 == null) break;
                            ((StringBuilder)object).append("</inArgs>");
                            scannerData2 = new ArgStruct();
                            ((ArgStruct)scannerData2).inXml = ((StringBuilder)object).toString();
                            ((ArgStruct)scannerData2).opcode = ArgStruct.DEVICE_SCAN_DISABLE;
                            try {
                                bl2 = JCoreScanner.jcoreScanner.ExecCommand((ArgStruct)scannerData2) == 0;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            if (((ArgStruct)scannerData2).status == 0L) continue;
                        }
                        object = new StringBuilder();
                        ((StringBuilder)object).append("<inArgs>");
                        ((StringBuilder)object).append("<scannerID>" + string5 + "</scannerID>");
                        if (string6.equals(SCANNER_TYPE_STR_NIXMODB)) {
                            ((StringBuilder)object).append("<cmdArgs><arg-int>5</arg-int><arg-int>" + this.baudrate + "," + this.databit + "," + this.parityBit + "," + this.stopbit + "," + this.flowcontrol + "</arg-int>\t</cmdArgs>");
                        }
                        ((StringBuilder)object).append("</inArgs>");
                        scannerData2 = new ArgStruct();
                        ((ArgStruct)scannerData2).inXml = ((StringBuilder)object).toString();
                        ((ArgStruct)scannerData2).opcode = ArgStruct.DEVICE_SCAN_DISABLE;
                        try {
                            bl2 = JCoreScanner.jcoreScanner.ExecCommand((ArgStruct)scannerData2) == 0;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (((ArgStruct)scannerData2).status == 0L) continue;
                    }
                }
            }
        }
        JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[]{bl2});
        return bl2;
    }

    public void SendRSMCommnad(ArgStruct argStruct) {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[]{argStruct});
        try {
            JCoreScanner.jcoreScanner.ExecCommand(argStruct);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[0]);
    }

    @Override
    public void SetParam(Set set) {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[]{set});
        for (int i = 0; i < this.scannerCount; ++i) {
            String string2 = null;
            String string3 = "";
            try {
                string2 = ((ScannerData)this.AllScanners.get((int)i)).scanId;
                string3 = ((ScannerData)this.AllScanners.get((int)i)).scannerModel;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            for (ScannerSettings scannerSettings : set) {
                String[] stringArray;
                String[] stringArray2 = scannerSettings.propName.split(DEVICE_CONFIG_SPLITTER);
                if (!stringArray2[0].equals("SetAttribute")) continue;
                if (stringArray2.length == 3) {
                    if (!string3.matches("^" + stringArray2[2] + ".*$") || (stringArray = scannerSettings.propVal.split(DEVICE_CONFIG_SPLITTER)).length != 2) continue;
                    this.setToDevice(string2, stringArray2[1], stringArray[0], stringArray[1]);
                    continue;
                }
                if (stringArray2.length != 2) continue;
                stringArray = scannerSettings.propVal.split(DEVICE_CONFIG_SPLITTER);
                this.setToDevice(string2, stringArray2[1], stringArray[0], stringArray[1]);
            }
        }
        JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[0]);
    }

    private void setToDevice(String string, String string2, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(JniXmlElement.ELEMENT_INARGS);
        stringBuilder.append(JniXmlElement.ELEMENT_SCANNER_ID + string + JniXmlElement.ELEMENT_SCANNER_ID_E);
        stringBuilder.append(JniXmlElement.ELEMENT_CMDARGS);
        stringBuilder.append(JniXmlElement.ELEMENT_ARGXML);
        stringBuilder.append(JniXmlElement.ELEMENT_ATTR_LIST);
        stringBuilder.append(JniXmlElement.ELEMENT_ATTR);
        stringBuilder.append(JniXmlElement.ELEMENT_ATTR_ID);
        stringBuilder.append(string2);
        stringBuilder.append(JniXmlElement.ELEMENT_ATTR_ID_E);
        stringBuilder.append(JniXmlElement.ELEMENT_DATATYPE);
        stringBuilder.append(string3.toUpperCase());
        stringBuilder.append(JniXmlElement.ELEMENT_ATTR_DATATYPE_E);
        stringBuilder.append(JniXmlElement.ELEMENT_ATTR_VALUE);
        stringBuilder.append(string4);
        stringBuilder.append(JniXmlElement.ELEMENT_ATTR_VALUE_E);
        stringBuilder.append(JniXmlElement.ELEMENT_ATTR_E);
        stringBuilder.append(JniXmlElement.ELEMENT_ATTR_LIST_E);
        stringBuilder.append(JniXmlElement.ELEMENT_ARGXML_E);
        stringBuilder.append(JniXmlElement.ELEMENT_CMDARGS_E);
        stringBuilder.append(JniXmlElement.ELEMENT_INARGS_E);
        ArgStruct argStruct = new ArgStruct();
        argStruct.inXml = stringBuilder.toString();
        argStruct.opcode = 5004;
        try {
            JCoreScanner.jcoreScanner.ExecCommand(argStruct);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public String getModelNumber() {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[0]);
        JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[]{this.modelNumbers.toString()});
        return this.modelNumbers.toString();
    }

    @Override
    public String getSerialNumber() {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[0]);
        JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[]{this.serialNumbers.toString()});
        return this.serialNumbers.toString();
    }

    @Override
    public String getFirmwareVersion() {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[0]);
        JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[]{this.firmwareVersions.toString()});
        return this.firmwareVersions.toString();
    }

    public void onPnpEvent(int n, String string) {
        String string2 = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string2, (boolean)false, (Object[])new Object[]{n, string});
        this.pnpScannerList.clear();
        try {
            this.extractScannerIdsFromPnpEventXml(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        StringBuilder stringBuilder = new StringBuilder();
        block2: for (int i = 0; i < this.pnpScannerList.size(); ++i) {
            String string3 = this.pnpScannerList.get((int)i).scanId;
            JCoreLogger.Log((char)'-', (String)string2, (boolean)false, (Object[])new Object[]{"pnpScannerId: ", string3});
            stringBuilder.setLength(0);
            if (n == 0) {
                if (this.pnpWaitNotify.isWaiting) {
                    this.rebootedScannerIdsList.add(Integer.parseInt(string3));
                    this.pnpWaitNotify.doNotify();
                }
                for (int j = 0; j < this.openedDetachedScannerList.size(); ++j) {
                    if (!((ScannerData)this.openedDetachedScannerList.get((int)j)).scanId.equals(string3)) continue;
                    this._statusEvents.AddTail(this._evtSrc, n);
                    stringBuilder.append("{ \"devices\": [");
                    stringBuilder.append(this.createScannerInfoJsonString((ScannerData)this.openedDetachedScannerList.get(j)));
                    stringBuilder.append("]}");
                    this._directIOEvents.AddTail(this._evtSrc, n, stringBuilder.toString());
                    JCoreLogger.Log((char)'-', (String)string2, (boolean)false, (Object[])new Object[]{"Adding scannerId: ", string3});
                    this.AllScanners.add(this.openedDetachedScannerList.remove(j));
                    break;
                }
                for (Map.Entry<ScannerData, Boolean> entry : SymScannerSvc.scannerUFList.entrySet()) {
                    if (!entry.getKey().scanId.equals(string3)) continue;
                    if (!entry.getKey().scanType.equals(SCANNER_TYPE_STR_SNAPI) && !entry.getKey().isSwitchHostMode()) {
                        JCoreLogger.Log((char)'-', (String)string2, (boolean)false, (Object[])new Object[]{"Switch back to SNAPI mode for ScannerId: " + string3});
                        this.switchHostMode(SCANNER_TYPE_STR_SNAPI, entry.getKey().scanId);
                        entry.getKey().setSwitchHostMode(true);
                        continue block2;
                    }
                    JCoreLogger.Log((char)'-', (String)string2, (boolean)false, (Object[])new Object[]{"Switch back to " + entry.getKey().scanType + " for ScannerId: " + string3});
                    this.switchHostMode(entry.getKey().scanType, entry.getKey().scanId);
                    SymScannerSvc.scannerUFList.remove(entry.getKey());
                    continue block2;
                }
                continue;
            }
            if (n != 1) continue;
            for (int j = 0; j < this.AllScanners.size(); ++j) {
                if (!((ScannerData)this.AllScanners.get((int)j)).scanId.equals(string3)) continue;
                JCoreLogger.Log((char)'-', (String)string2, (boolean)false, (Object[])new Object[]{"Removing scannerId: ", string3});
                stringBuilder.append("{ \"devices\": [");
                stringBuilder.append(this.createScannerInfoJsonString((ScannerData)this.AllScanners.get(j)));
                stringBuilder.append("]}");
                this._directIOEvents.AddTail(this._evtSrc, n, stringBuilder.toString());
                this.openedDetachedScannerList.add(this.AllScanners.remove(j));
                if (this.AllScanners.size() != 0) continue block2;
                this._statusEvents.AddTail(this._evtSrc, n);
                continue block2;
            }
        }
        JCoreLogger.Log((char)'-', (String)string2, (boolean)false, (Object[])new Object[0]);
    }

    public void OnScannerNotificationEvent(int n, String string) {
        String string2 = Thread.currentThread().getStackTrace()[1].getMethodName();
        if (n != 2000) {
            JCoreLogger.Log((char)'-', (String)string2, (boolean)false, (Object[])new Object[]{"Not a RTA event"});
            return;
        }
        try {
            JCoreLogger.Log((char)'+', (String)string2, (boolean)true, (Object[])new Object[]{n, string});
            this.validateOutXmlFormat(string);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{ \"RTA Event\": [");
            stringBuilder.append(string);
            stringBuilder.append("]}");
            this._directIOEvents.AddEventToTail(this._evtSrc, n, stringBuilder.toString());
        }
        catch (Exception exception) {
            JCoreLogger.Log((char)'-', (String)string2, (boolean)false, (Object[])new Object[]{exception.getMessage()});
        }
    }

    private void validateOutXmlFormat(String string) throws Exception {
        String string2 = Thread.currentThread().getStackTrace()[1].getMethodName();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(string.getBytes()));
            document.getDocumentElement().normalize();
            this.checkElementExists(document.getDocumentElement(), "scannerID");
            this.checkElementExists(document.getDocumentElement(), "modelnumber");
            this.checkElementExists(document.getDocumentElement(), "serialnumber");
            this.checkElementExists(document.getDocumentElement(), "rta");
            NodeList nodeList = document.getElementsByTagName("rta");
            if (nodeList.getLength() > 0) {
                Element element = (Element)nodeList.item(0);
                this.checkElementExists(element, "id");
                this.checkElementExists(element, "type");
                this.checkElementExists(element, "data-1");
                this.checkElementExists(element, "data-2");
                this.checkElementExists(element, "raw-data");
            } else {
                JCoreLogger.Log((char)'-', (String)string2, (boolean)false, (Object[])new Object[]{"Missing <rta> element."});
            }
        }
        catch (Exception exception) {
            JCoreLogger.Log((char)'-', (String)string2, (boolean)false, (Object[])new Object[]{"XML format is invalid: " + exception.getMessage()});
        }
    }

    private void checkElementExists(Element element, String string) throws Exception {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() == 0) {
            throw new Exception("Missing <" + string + "> element.");
        }
    }

    public void onScannerRMDEvent(int n, String string) {
        String string2 = Thread.currentThread().getStackTrace()[1].getMethodName();
        this.RMDEventScannerId = "";
        try {
            this.idExtractionforRMDEventReceiveXML(string);
        }
        catch (Exception exception) {
            JCoreLogger.Log((char)'-', (String)string2, (boolean)false, (Object[])new Object[]{exception});
            return;
        }
        for (int i = 0; i < this.AllScanners.size(); ++i) {
            if (!((ScannerData)this.AllScanners.get((int)i)).scanId.equals(this.RMDEventScannerId)) continue;
            JCoreLogger.Log((char)'+', (String)string2, (boolean)true, (Object[])new Object[]{n, string});
            if (n >= 11 && n <= 16) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("{ \"Firmware Load Event\": [");
                stringBuilder.append(string);
                stringBuilder.append("]}");
                this._directIOEvents.AddEventToTail(this._evtSrc, n, stringBuilder.toString());
                if (n != 15) break;
                SymScannerSvc.scannerUFList.put((ScannerData)this.AllScanners.get(i), false);
                break;
            }
            if (n >= 17 && n <= 19) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("{ \"Config Load Event\": [");
                stringBuilder.append(string);
                stringBuilder.append("]}");
                this._directIOEvents.AddEventToTail(this._evtSrc, n, stringBuilder.toString());
                break;
            }
            JCoreLogger.Log((char)'-', (String)string2, (boolean)false, (Object[])new Object[]{"Not a valid RMD event"});
            break;
        }
    }

    public void onDecodeDataEvent(int n, String string) {
        Object object;
        String string2 = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string2, (boolean)true, (Object[])new Object[]{n, string});
        if (!this._fEnabled) {
            return;
        }
        try {
            this.idExtractionforEventReceiveXML(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl = false;
        for (int i = 0; i < this.AllScanners.size(); ++i) {
            object = null;
            try {
                object = ((ScannerData)this.AllScanners.get((int)i)).scanId;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (!((String)object).equals(this.scannerEventId)) continue;
            bl = true;
            break;
        }
        if (bl) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                object = documentBuilderFactory.newDocumentBuilder();
                ByteArrayInputStream byteArrayInputStream = null;
                try {
                    byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                Document document = null;
                try {
                    document = ((DocumentBuilder)object).parse(byteArrayInputStream);
                }
                catch (SAXException sAXException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Element element = document.getDocumentElement();
                NodeList nodeList = element.getElementsByTagName("datalabel");
                NodeList nodeList2 = element.getElementsByTagName("datatype");
                NodeList nodeList3 = nodeList.item(0).getChildNodes();
                String string3 = nodeList3.item(0).getNodeValue();
                NodeList nodeList4 = nodeList2.item(0).getChildNodes();
                String string4 = nodeList4.item(0).getNodeValue().trim();
                int n2 = 6000;
                try {
                    int n3 = Integer.parseInt(string4);
                    n2 = ZebraScannerSymbologies.getUPOSSymbology(n3);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.out.println(exception.toString());
                }
                String string5 = n2 + "";
                DataEvent dataEvent = new DataEvent(this._evtSrc, 0);
                ScanEventQueueEntry scanEventQueueEntry = new ScanEventQueueEntry((JposEvent)dataEvent, 0);
                String string6 = this.GetDataString(string3);
                scanEventQueueEntry._iDataLength = string6.length();
                scanEventQueueEntry._iTypeLength = 1;
                scanEventQueueEntry._fIsBCD = false;
                try {
                    scanEventQueueEntry._iScanType = Integer.parseInt(string5.trim());
                    scanEventQueueEntry._iScanZebraSymbologyType = Integer.parseInt(string4);
                }
                catch (Exception exception) {
                    scanEventQueueEntry._iScanType = 211;
                }
                scanEventQueueEntry._abScanData = new byte[string6.length()];
                for (int i = 0; i < string6.length(); ++i) {
                    scanEventQueueEntry._abScanData[i] = (byte)string6.charAt(i);
                }
                scanEventQueueEntry._iScannerID = this.scannerEventId != null ? this.scannerEventId : "";
                this._seq.AddTail(scanEventQueueEntry);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
        }
        JCoreLogger.Log((char)'-', (String)string2, (boolean)false, (Object[])new Object[0]);
    }

    public String GetDataString(String string) {
        String string2 = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string2, (boolean)true, (Object[])new Object[]{string});
        String string3 = "";
        String string4 = System.getProperty("os.name");
        if (string4.toLowerCase().startsWith("win")) {
            int n = 0;
            while ((n = string.indexOf("0x", n)) >= 0) {
                int n2 = Integer.parseInt(string.substring(n + 2, n + 4), 16);
                string3 = string3 + (char)n2;
                if ((n += 4) > 0) continue;
                break;
            }
        } else {
            String[] stringArray = string.split("\\s");
            for (int i = 0; i < Array.getLength(stringArray); ++i) {
                int n = Integer.parseInt(stringArray[i], 16);
                string3 = string3 + (char)n;
            }
        }
        JCoreLogger.Log((char)'-', (String)string2, (boolean)true, (Object[])new Object[]{string3});
        return string3;
    }

    private void switchHostMode(String string, String string2) {
        String string3 = Thread.currentThread().getStackTrace()[1].getMethodName();
        String string4 = "";
        if (string.equals(SCANNER_TYPE_STR_SNAPI)) {
            string4 = "XUA-45001-9";
        } else if (string.equals(SCANNER_TYPE_STR_IBMHH)) {
            string4 = "XUA-45001-1";
        } else if (string.equals(SCANNER_TYPE_STR_IBMTT)) {
            string4 = "XUA-45001-2";
        } else if (string.equals(SCANNER_TYPE_STR_OPOS)) {
            string4 = "XUA-45001-8";
        }
        String string5 = "<inArgs><scannerID>" + string2 + "</scannerID><cmdArgs><arg-string>" + string4 + "</arg-string><arg-bool>FALSE</arg-bool><arg-bool>TRUE</arg-bool></cmdArgs></inArgs>";
        ArgStruct argStruct = new ArgStruct();
        argStruct.status = 0L;
        argStruct.inXml = string5;
        argStruct.opcode = ArgStruct.DEVICE_SWITCH_HOST_MODE;
        try {
            JCoreScanner.jcoreScanner.ExecCommand(argStruct);
            if (argStruct.status == 0L) {
                JCoreLogger.Log((char)'+', (String)string3, (boolean)false, (Object[])new Object[]{"switchHostMode is success for scannerId : " + string2 + " and host mode : " + string});
            } else {
                JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_ERROR, (int)111, (String)("switchHostMode is failed for scannerId : " + string2 + " and host mode : " + string));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

